BABYDU ; #######################################################
 ; THIS 500-BAUD DUBBING ROUTINE REWRITES THE TAPE
 ; READING ROUTINE TO LOAD TAPES WHICH ARE UNREADABLE
 ; BY UNMODIFIED (NO XRX) TRS-80'S.  PROMPT ADDITIONS
 ; AND SOME PROGRAM RESEQUENCING WAS PERFORMED BY JACK
 ; DECKER OF SAULT STE. MARIE, MICHIGAN.
 ; #######################################################
 	ORG 4300H		; BEGIN IN LOW MEMORY
 BGN	LD DE,(40B1H)		; GET TOP OF MEMORY
 	PUSH DE			; SAVE VALUE FOR LATER
 BEGIN	CALL 01C9H		; CLEAR SCREEN FROM ROM
 CASOFF	XOR A			; CLEAR OUT ACCUMULATOR
 	CALL 01F8H		; TURN OFF TAPE RECORDER
 	LD HL,START		; GET FIRST INFORMATION
 	CALL 28A7H		; DISPLAY IT ON SCREEN
 SCANKE	CALL 0049H		; GET SINGLE KEY VALUE
 	CP 'B'			; IS IT A "B" (BASIC)
 	JP Z,06CCH		; GO TO BASIC IF A B
 	CP 'L'			; IS IT AN "L" (LOAD)
 	JR Z,STLOAD		; GO TO STARTLOAD IF L
 	CP 'V'			; IF IT A "V" (VERIFY)
 	JR Z,STLOAD		; GO TO STARTLOAD ANYWAY
 	CP 'D'			; IS IT A "D" (DUMP)
 	JR NZ,SCANKE		; NO VALID CMND; GO BACK
 	LD HL,ENDER		; GET DUMPING PROMPT
 	CALL 28A7H		; DISPLAY IT THRU ROM
 SCAN	LD A,(3810H)		; GET KEYBOARD ROW
 	SRL A			; SHIFT LEFT ACCUM ONCE
 	JR C,BEGIN		; CARRY SET IF "ENTER"
 	JR Z,SCAN		; IF ZERO, THEN NO KEY
 	EX AF,AF'		; SAVE THIS STUFF
 	CALL 1C9H		; CLEAR THE SCREEN AGAIN
 	LD A,'1'		; GET ASCII "1" IN PLACE
 	LD (3C3FH),A		; DISPLAY AT TOP CORNER
 DUMPLP	POP DE			; RESTORE VALUE TO DE
 	PUSH DE			; AND SAVE IT AGAIN
 	LD HL,(40B1H)		; GET TOP OF MEMORY
 	RST 18H			; HL-DE, Z SET IF EQUAL
 	JR Z,BEGIN		; GO TO START IF ZERO SET
 	XOR A			; CLEAR VALUE FROM ACCUM.
 	CALL 0212H		; DEFINE DRIVE NUMBER 0
 	CALL 0287H		; TAPE ON, WRITE LEADER
 	LD A,H			; GET VALUE FROM H
 	SUB D			; START HOW-MUCH-MEM TEST
 	LD B,A			; SAVE VALUE IN B
 	LD A,L			; GET VALUE FROM L
 	SUB E			; END HOW-MUCH-MEM TEST
 	LD C,A			; SAVE VALUE IN C
 OUTLP	LD A,(HL)		; GET BYTE TO WRITE
 	CALL 0264H		; WRITE THAT BYTE TO TAPE
 	DEC HL			; NEXT VALUE FROM MEMORY
 	DEC BC			; MEMCOUNT = MEMCOUNT - 1
 	LD A,B			; GET HIGH BYTE INTO A
 	OR C			; SET UP TEST FOR BC=0000
 	JR NZ,OUTLP		; STILL MORE TO DO YET...
 	EX AF,AF'		; GET OLD VALUE BACK TO A
 	SRL A			; SHIFT THAT LEFT TO TEST
 	JR Z,BEGIN		; IF ZERO, BACK TO BEGIN.
 	EX AF,AF'		; SAVE IT ALTERNATELY 
 	LD B,30H		; GET DELAY VALUE INTO B
 PBC	PUSH BC			; SAVE THIS VALUE FOR USE
 	CALL 0060H		; DELAY SOME FOR A WHILE
 	POP BC			; GET VALUE BACK TO BC
 	DJNZ PBC		; DELAY LOTSA TIMES
 	LD A,(3C3FH)		; GET VALUE FROM SCREEN
 	INC A			; INCREMENT TO NEXT DUMP
 	LD (3C3FH),A		; DISPLAY NEW VALUE NOW
 	JR DUMPLP		; BACK TO DUMP LOOP TEST
 ENDBIT	POP AF			; GET VALUE BACK TO AF
 	POP BC			; STACK CLEARING POP
 	POP BC			; AND CLEAR SOME MORE
 	POP HL			; AND CLEAR SOME MORE
 	POP HL			; TILL THE STACK IS EMPTY
 	EX AF,AF'		; GET VALUE BACK TO AF
 	CP 'V'			; IS IT "V" (VERIFY)
 	JR Z,VRCHK		; IF SO, THEN TO ROUTINE
 	PUSH DE			; SAVE DE VALUE FOR LATER
 BEGIN2	JR BEGIN		; BACK TO MENU FROM HERE
 VRCHK	PUSH HL			; SAVE RESTORED DE IN HL
 	PUSH BC			; SAVE BC REGISTER
 	RST 18H			; HL-DE, Z SET IF EQUAL
 	POP HL			; CLEAR STACK INTO HL
 	JR Z,BEGIN2		; BACK TO MENU IF DONE
 	JR VERROR		; VERIFY ERROR IF NOT Z
 STLOAD	EX AF,AF'		; SAVE CURRENT AF VALUE
 	CALL 01C9H		; ROM CLEAR THE SCREEN
 	XOR A			; CLEAR ACCUMULATOR
 	CALL 0212H		; CASSETTE PLAYER ON
 	CALL 296H		; READ LEADER & SYNC
 	LD DE,(40B1H)		; GET TOP OF MEMORY
 DISPLD	LD HL,3C00H		; GET START OF SCREEN
 	LD BC,3FFH		; GET SCREEN CHAR COUNT
 DISPLY	PUSH BC			; SAVE DISPLAY COUNT
 	PUSH HL			; SAVE SCREEN POSITION
 	LD B,8			; GET NUMBER TO COUNT
 REDOIT	PUSH BC			; SAVE 8 VALUE ON STACK
 	PUSH AF			; SAVE CURRENT A VALUE
 	LD HL,0FFFFH		; VALUE TO COUNT DOWN
 DLYLP	DEC HL			; DELAY EACH DECREMENT
 	LD A,H			; GET HIGH BYTE TO A
 	OR L			; CHECK AGAINST LOW BYTE
 	JR Z,ENDBIT		; GO OUT IF DELAY DONE
 	IN A,(0FFH)		; GET VALUE FROM CASSETTE
 	RLA			; ROTATE DATA BIT LEFT
 	JR NC,DLYLP		; IF NO BIT THEN DELAY
 	LD B,41H		; BIT TIME DELAY VALUE
 	DJNZ $			; AND PERFORM THE DELAY
 	CALL 021EH		; RESET INSIG FLIP-FLOP
 	LD B,50H		; BIT TIME DELAY VALUE
 	DJNZ $			; AND PERFORM THE DELAY
 	LD B,14H		; BIT TIME DELAY VALUE
 INLP	IN A,(0FFH)		; CHECK DATA AT CASSETTE
 	DJNZ INLP		; AND WAIT THROUGH TIMING
 	LD B,A			; SAVE FOUND VALUE IN B
 	POP AF			; RESTORE ORIGINAL A
 	RL B			; ROTATE B INTO FLAG
 	RLA			; AND ROTATE FLAG INTO A
 	PUSH AF			; AND SAVE THE VALUE
 	CALL 21EH		; RESET INSIG FLIP-FLOP
 	POP AF			; RESTORE FOUND VALUE
 	POP BC			; RESTORE LOOP VALUE
 	DJNZ REDOIT		; DO IT FOR FULL 8 BITS
 	POP HL			; RESTORE SCREEN VALUE
 	POP BC			; RESTORE MEMORY VALUE
 	LD (HL),A		; STORE VALUE INTO SCREEN
 	EX AF,AF'		; RESTORE ORIGINAL AF
 	CP 'L'			; CHECK IF LOAD OR VERIFY
 	JR Z,CONT		; CONTINUE IF A LOAD
 	EX AF,AF'		; OTHERWISE SWITCH REGS.
 	EX DE,HL		; EXCHANGE DE & HL 
 	CP (HL)			; COMPARE AGAINST MEMORY
 	EX DE,HL		; EXCHANGE REGISTERS BACK
 	JR Z,CONT2		; AND THEN GO ON WITH IT
 VERROR	LD (4020H),HL		; STUFF CURSOR POS'N IN
 	LD HL,BADMSG		; GET BAD MESSAGE TEXT
 	CALL 28A7H		; AND DISPLAY ON SCREEN
 	JP CASOFF		; AND TURN CASSETTE OFF
 CONT	EX AF,AF'		; RESTORE VALUES TO AF
 	LD (DE),A		; AND STASH IT IN MEMORY
 CONT2	INC HL			; GET NEXT SCREEN LOC'N
 	DEC DE			; AND NEXT MEMORY LOC'N
 	DEC BC			; AND DEC. SCREEN CNTR.
 	LD A,B			; GET MSB OF COUNTER
 	OR C			; AND COMPARE AGAINST LSB
 	JR NZ,DISPLY		; CONTINUE DISPLAY IF NZ
 	JR DISPLD		; ELSE RESET TO 3C00
 START	DEFM '(L)OAD, (V)ERIFY,'; INITIAL PROMPT DISPLAY
 	DEFM ' (D)UMP, OR (B)ASIC?'
 	DEFB 1FH		; CLEAR TO END OF FRAME
 	DEFB 0			; END MESSAGE KEY
 BADMSG	DEFB 1FH		; CLEAR TO END OF FRAME
 	DEFB 0DH		; CARRIAGE RETURN
 	DEFB 0DH		; CARRIAGE RETURN
 	DEFM '* VERIFY ERROR *'	; ERROR MESSAGE TEXT
 	DEFB 0DH		; CARRIAGE RETURN
 	DEFB 0DH		; CARRIAGE RETURN
 	DEFB 0			; END OF MESSAGE KEY
 ENDER	DEFB 1CH		; HOME CURSOR COMMAND
 	DEFM 'HOW MANY DUMPS?'  ; DUMPING MESSAGE PROMPT
 	DEFB 1FH		; CLEAR TO END OF FRAME
 	DEFB 0			; END OF MESSAGE KEY
 	END BGN			; END ENTRY POINT
