TAPEWR ;TAPWR/ASM
 ;*****
 ;	routine to punch a SYSTEM tape
 ;*****
 CTOFF	EQU	1F8H
 CTON	EQU	212H
 CSTAR	EQU	22CH
 WRLDR	EQU	287H
 WRBYT	EQU	264H
 CPNCH	CALL	RDYCAS		;your prompting routine
 	LD	IX,FILNAM	;point to 6-char filename
 	LD	HL,(VAR2)	;point to end of prog
 	LD	DE,(VAR1)	;point to start of prog
 	XOR	A
 	SBC	HL,DE		;calculate length
 	INC	HL
 	XOR	A
 	CALL	CTON		;turn on casette
 	CALL	WRLDR		;gen the leader
 	LD	A,55H
 	CALL	WRBYT		;start of header
 	LD	B,6		;output the filename
 CPN2	LD	A,(IX)		;all chars (buffer with
 	CALL	WRBYT		;blanks if needed)
 	INC	IX
 	DJNZ	CPN2
 BGNBLK	DEC	H		;another full block?
 	JP	M,LSTBLK	;jump if not
 	LD	A,3CH		;start of block
 	CALL	WRBYT
 	XOR	A		;block length = 256
 	CALL	WRBYT
 	CALL	BLKWRT		;write the block
 	JR	BGNBLK		;loop
 LSTBLK	XOR	A		;no partial block if
 	CP	L		;even multiple of 256
 	JR	Z,WRTEND
 	LD	A,3CH		;start of block
 	CALL	WRBYT
 	LD	A,L		;block length
 	CALL	WRBYT
 	CALL	BLKWRT		;write the block
 WRTEND	LD	A,78H		;end of tape
 	CALL	WRBYT
 	LD	A,(VAR3)	;p/u transfer address
 	CALL	WRBYT
 	LD	A,(VAR3+1)
 	CALL	WRBYT
 	CALL	CTOFF		;turn off cassette
 	RET
 BLKWRT	PUSH	AF		;save block length
 	CALL	CSTAR		;flash the asterisk
 	POP	AF		;xfer length to reg B
 	LD	B,A
 	LD	A,E		;output load address
 	CALL	WRBYT
 	LD	A,D
 	CALL	WRBYT
 	ADD	A,E		;calculate checksum
 	LD	C,A
 NXTBYT	LD	A,(DE)		;p/u block byte
 	CALL	WRBYT		;& send it
 	ADD	A,C		;checksum again
 	LD	C,A
 	INC	DE		;pt to next byte
 	DJNZ	NXTBYT		;loop until exhausted
 	LD	A,C		;now output the checksum
 	CALL	WRBYT
 	RET
 VAR1	DEFS	2		;space for start address
 VAR2	DEFS	2		;space for end address
 VAR3	DEFS	2		;space for transfer address
 FILNAM	DEFS	6		;filename storage
