LLIST/ ;****************************************************
 ;** LLIST/CMD  BY JAMES CROCKER 80US NOV/DEC P47   **
 ;**  OUTPUTS PRINTED LISTINGS WITH SPACES AND FIXED *
 ;**  LENGTH . UP-ARROW GIVES DEFAULT VALUES        **
 ;**    DEFAULTS: 5 SPACES 64 CHAR/LINE             **
 ;****************************************************
 	ORG	8000H		;A CONVENIENT PLACE
 START	LD	HL,(4026H)	;INITIALIZATION
 	LD	(DRIVER+1),HL	;	"
 	LD	(DRIV2+1),HL	;	"
 	LD	(ENDIT+1),HL	;	"
 	LD	HL,LLIST	;	"
 	LD	(4026H),HL	;	"
 	LD	SP,START	;STORE STACK POINTER
 	LD	HL,MSG1		;PRINT MESSAGE ONE
 	CALL	PRINT		;	"
 	CALL	INPUT		;GET KEYBOARD INPUT
 	JR	C,QUIT		;NO FURTHER ACTION NEEDED
 	CALL	1E5AH		;CONVERT TO HEX
 	LD	A,E		;HEX IN DE, WE NEED E
 	LD	(MAXLEN+1),A	;STORE IT
 LP1	LD	HL,MSG2		;PRINT MESSAGE TWO
 	CALL	PRINT		; 	"
 	CALL	INPUT		;GET KEYBOARD INPUT
 	JR	C,QUIT		;IN CASE OF UP-ARROW
 	CALL	1E5AH		;CONVERT TO HEX
 	LD	A,(MAXLEN+1)	;GET LINE LENGTH
 	CP	E		;COMPARE TO # OF SPACES
 	JR	C,LP1		;TOO MANY SPACES
 	LD	A,E		;GET HEX IN A
 	LD	(NUMSPC+1),A	; STORE IT
 QUIT	JP	402DH		;DONE,RETURN TO DOS
 PRINT	LD	A,(HL)		;GET CHARACTER
 	OR	A		;ZERO?
 	RET	Z		;YES,DONE
 	CALL	33H		;PRINT IT
 	INC	HL		;BUMP POINTER
 	JR	PRINT		;NEXT CHARACTER
 INPUT	LD	HL,BUFF		;HL=>BUFFER
 LP2	CALL	2BH		;GET KEY PRESSED
 	OR	A		;WAS THERE ONE?
 	JR	Z,LP2		;NO,TRY AGAIN
 	CP	5BH		;UP-ARROW?
 	JR	NZ,CONT		;NO
 	SCF			;SET CARRY FLAG
 	RET
 CONT	CP	0DH		;CR?
 	JR	Z,TERM		;YES,TERMINATE
 	CP	5FH		;BACKSPACE?
 	JR	Z,BCKSPC	;YES,HANDLE IT
 	LD	(HL),A		;ELSE STORE IT
 	INC	HL		;BUMP POINTER
 	JR	PRTIT		;PRINT CHAR AND CONTINUE
 TERM	LD	(HL),A		;TERMINATOR
 	LD	HL,BUFF		;HL=>BUFFER AGAIN
 	RET
 BCKSPC	DEC	HL		;DEC POINTER
 	LD	A,08		;BACKSPACE CHARACTER
 PRTIT	CALL	33H		;PRINT CHARACTER
 	JR	LP2		;GET NEXT ONE
 BUFF	DEFS	20		;SHOULD BE ENOUGH ROOM
 MSG1	DEFM	'ENTER MAX LINE LENGH '
 	DEFB	0
 MSG2	DEFB	0DH
 	DEFM	'ENTER NUMBER OF SPACES '
 	DEFB	0
 	ORG	0FFACH		;FOR 48K
 LLIST	LD	A,C		;CHARACTER IN C
 	CP	0DH		;CARRIAGE RETURN?
 	JR	Z,OUTCR		;YES,HANDLE IT
 	CP	0CH		;TOP OF FORM?
 	JR	Z,OUTCR		;YES, SAME AS CR
 	PUSH	HL		;SAVE HL
 	LD	HL,TEMP		;TEMP KEEPS COUNT
 	INC	(HL)		;OF # OF WORDS SENT
 	LD	A,(HL)		;GET COUNT IN A
 MAXLEN	CP	64		;64 SENT?
 	JR	Z,CRLF		;YES,SEND A CR/LF
 	POP	HL		;ELSE GET BACK HL
 	JR	ENDIT		;AND CONTINUE
 OUTCR	PUSH	HL		;SAVE HL
 	LD	HL,TEMP		;GET TEMP'S ADDRESS IN HL
 	LD	(HL),0		;AND RESET TO ZERO
 	POP	HL		;GET HL BACK
 	JR	ENDIT		;AND PROCEED
 CRLF	PUSH	BC		;MUST SAVE BC
 	LD	C,0DH		;SEND CR TO PRINTER
 	LD	(HL),1		;RESET COUNTER TO ONE
 DRIVER	CALL	$-$		;SEND IT
 NUMSPC	LD	B,5		;NUMBER OF SPACES TO SEND
 LOOP	LD	C,20H		;20=SPACE
 DRIV2	CALL	$-$		;SEND IT
 	INC	(HL)		;BUMP COUNTER
 	DJNZ	LOOP		;REPEAT 4 TIMES
 	POP	BC		;GET BC BACK
 	POP	HL		;AND HL,TOO
 ENDIT	JP	$-$		;AND QUIT
 TEMP	DEFB	0		;COUNTER
 THEEND	EQU	$
 	END	START
;20=SPACE
 DRIV2	CALL	$-$		;SEND IT
 	INC	(HL)		;BUMP COUNTER
 	DJNZ	LOOP		;REPEAT 4 TIMES
 	POP	BC		;GET BC BACK
 	POP	HL		;AND HL,TOO
 ENDIT	JP	$-$		;AND QUIT
 TEMP	DEFB	0		;COUNTER
