ALDATE ;*****  ALDATE/ASM  -  by Jack Decker
 ;Version 1.0 - creation date 9/18/84.
 
 ;This program is designed to work with the ALLWRITE! word
 ;processing system by Prosoft.  It is NOT a stand-alone
 ;program, but is designed to be patched into ALK/CMD (the
 ;keyboard driver program provided by Prosoft).  Whenever
 ;ALK/CMD is executed (after being patched with this
 ;program), it will first read the system date (the date
 ;entered at power-up or whenever the DOS DATE command is
 ;executed), convert it to a text string of the format:
 ;month, day, year (example:  December 31, 1985) and then
 ;output it to a file named DATE/TXT on drive zero.  This
 ;file can then be used by "boilerplate" letters and/or
 ;letterheads by using the ALLWRITE! command:
 ;		;IM DATE/TXT
 ;This command will "imbed" the text of DATE/TXT within
 ;body of the document being created.  Note that the ;IM
 ;command does not cause a "control break", but must be
 ;the last command on a multi-command screen line.
 
 ;If the system date stored in memory appears to be
 ;invalid, this program will terminate with an error
 ;message and the DATE/TXT file will be killed (if it
 ;existed previously).
 
 ;There are several ways to combine this program with the
 ;ALK/CMD program.  This version of this program assumes
 ;that ALK/CMD loads from 7000H through 752EH and that the
 ;normal entry point is 7443H (this program uses an entry
 ;point of 7444H, skipping a PUSH HL instruction which has
 ;already been done at the start of the code below).
 ;One method of combining the programs is to use TASMON to
 ;load ALK/CMD (make sure the entry point address is 7443H
 ;in the version you have), load the object code produced
 ;by this program, and then write to disk using the
 ;ALK/CMD start address and this program's ending and
 ;entry point addresses.  The CMDFILE/CMD program
 ;(supplied with LDOS) could also be used, or as a last
 ;resort, you could use the DOS LOAD command to bring
 ;ALK/CMD into memory, and then execute this program.
 
 ;I suggest using the SETDATE/CMD program (available on
 ;TAS Public Domain Library Disk # 001) to set the date
 ;easily when booting your DOS, unless you have a hardware
 ;clock module and appropriate software to do this for
 ;you.
 
 ;This program will only work correctly during the 20th
 ;century (change line 1640 after the year 1999).
 
 ;It would be easy to modify this program to output the
 ;date in a different format (such as date, month, year)
 ;but that will be left up to the individual.  Should you
 ;need a such a specialized version of this program and
 ;not feel capable of doing it yourself, I will consider
 ;producing customized versions of this program for a
 ;nominal fee.
 
 ;Questions or comments MUST be accompanied by a self-
 ;addressed stamped envelope if you live in the U.S.A. or
 ;Canada (Canadian postage is O.K.) and wish a reply.
 
 ;		Jack Decker
 ;		1804 West 18th Street   Lot # 155
 ;		Sault Ste. Marie, Michigan  49783
 
 
 	ORG	7600H		;MUST end with 00H
 
 ;String and date storage area used by program
 
 TABLE	DEFW	JAN		;Table of string pointers
 	DEFW	FEB		;  point to strings
 	DEFW	MAR		;  containing months of
 	DEFW	APR		;  the year
 	DEFW	MAY
 	DEFW	JUN
 	DEFW	JUL
 	DEFW	AUG
 	DEFW	SEP
 	DEFW	OCT
 	DEFW	NOV
 	DEFW	DEC
 JAN	DEFM	'Januar'	;Strings containing
 	DEFB	'y'+80H		;  months of year
 FEB	DEFM	'Februar'
 	DEFB	'y'+80H
 MAR	DEFM	'Marc'
 	DEFB	'h'+80H
 APR	DEFM	'Apri'
 	DEFB	'l'+80H
 MAY	DEFM	'Ma'
 	DEFB	'y'+80H
 JUN	DEFM	'Jun'
 	DEFB	'e'+80H
 JUL	DEFM	'Jul'
 	DEFB	'y'+80H
 AUG	DEFM	'Augus'
 	DEFB	't'+80H
 SEP	DEFM	'Septembe'
 	DEFB	'r'+80H
 OCT	DEFM	'Octobe'
 	DEFB	'r'+80H
 NOV	DEFM	'Novembe'
 	DEFB	'r'+80H
 DEC	DEFM	'Decembe'
 	DEFB	'r'+80H
 ERRMSG	DEFM	'ERROR WHILE CREATING/UPDATING FILE: DATE/TXT:0'
 	DEFB	0DH
 INVALD	DEFM	'INVALID DATE IN MEMORY - KILLING DATE/TXT:0'
 	DEFB	0DH
 
 ;Start of actual machine-language program
 
 START	PUSH	HL		;Save input buffer pointr
 	LD	B,0		;Logical Record Lngth=256
 	LD	DE,FCB		;File Control Block pntr
 	LD	HL,FILBUF	;File I/O Buffer pntr
 	CALL	4420H		;DOS INIT routine
 	JR	NZ,ERREXT	;Go if error
 	CALL	GETBFR		;Get loc memory date stor
 	LD	A,(BC)		;Get year from memory
 	CP	100D		;Is it in range 00 - 99?
 	JR	NC,NODATE	;Go if invalid year
 	INC	BC		;Point to day in memory
 	LD	A,(BC)		;Get day from memory
 	DEC	A		;Adjust valid to 0 - 30
 	CP	31D		;Is day 1 - 31 in memory?
 	JR	NC,NODATE	;Go if invalid month
 	INC	BC		;Point to month in memory
 	LD	A,(BC)		;Get month from memory
 	DEC	A		;Adjust valid to 0 - 11
 	CP	12D		;Is month 1 - 12 in mem?
 	JR	C,CONT		;Go if memory date valid
 NODATE	LD	HL,INVALD	;Point to invalid dt msg
 	CALL	4467H		;Display it on video
 	CALL	442CH		;Kill DATE/TXT:0
 	JR	Z,EXIT		;Go if no error
 	JR	ERREXT		;Use error exit
 CONT	CALL	OUTSTR		;Output month string
 	CALL	PRTSPC		;Print space character
 	DEC	BC		;Point to day byte
 	LD	A,(BC)		;Get day (1 - 31)
 	LD	L,A		;Put day in L
 	LD	H,0		;HL = day
 	PUSH	BC		;Save date storage pntr
 	CALL	PRTNUM		;Print day
 	POP	BC		;Restore date storage ptr
 	CALL	PRTCOM		;Print comma and space
 	DEC	BC		;Point to year byte
 	LD	A,(BC)		;Get year (0 - 99)
 	LD	C,A		;Put year in C
 	LD	B,0		;BC = last 2 digits year
 	LD	HL,1900D	;Get century offset
 	ADD	HL,BC		;HL = Year (all 4 digits)
 	CALL	PRTNUM		;Print year
 	CALL	4428H		;CLOSE file
 	JR	Z,EXIT		;Go if no error
 ERREXT	OR	80H		;Set bit 7 to ret to pgm
 	CALL	4409H		;Display DOS error msg
 	LD	HL,ERRMSG	;Point to additonal msg
 	CALL	4467H		;Display it on video
 EXIT	JP	7444H		;Go to ALK initialization
 PRTCOM	LD	A,','		;Comma character in A
 	CALL	1BH		;Output it to file
 PRTSPC	LD	A,' '		;Space character in A
 	JP	1BH		;Output to file & RET
 PRTNUM	PUSH	DE		;Save FCB pointer
 	CALL	0A9AH		;Number in HL to ACCUM
 	CALL	0FBDH		;Convert # to string
 	POP	DE		;Restore FCB pointer
 	INC	HL		;Skip leading space char
 	JR	OUTTXT		;Display converted number
 OUTSTR	RLCA			;A=A*2 (2 byte pointers)
 	LD	L,A		;L=LSB string table addr
 	LD	H,TABLE<-8	;H=MSB string table addr
 	LD	A,(HL)		;A=LSB actual string addr
 	INC	HL		;Point to MSB string addr
 	LD	H,(HL)		;H=MSB actual string addr
 	LD	L,A		;HL=string location addr
 OUTTXT	LD	A,(HL)		;Get byte to output
 	OR	A		;See if zero terminator
 	RET	Z		;Finished if zero byte
 	PUSH	AF		;Save sign flag status
 	AND	7FH		;Mask off bit 7
 	CALL	1BH		;Output it to file
 	POP	AF		;Restore sign flag
 	RET	M		;Finished if bit 7 set
 	INC	HL		;Advance string pointer
 	JR	OUTTXT		;Go print next byte
 GETBFR	LD	BC,4044H	;BC=Mod I date storage
 	LD	A,(54H)		;Check which model TRS-80
 	DEC	A		;A will be 0 on Model I
 	RET	Z		;Return if Model I
 	LD	BC,421AH	;BC=Mod III date storage
 	RET			;Pointing to Mod III date
 FCB	DEFM	'DATE/TXT:0'	;File Control Block area
 	DEFB	3		;  with program filename
 	DEFS	21D		;  (total 32 bytes)
 FILBUF	DEFS	100H		;File I/O buffer area
 	END	START
(+ T08͚
ͷa % "~!(I(!HO(!HE(!R(!D],bͮ` ͏cUͷa ~#^PF ')yʗ
+| #}(O4:d(E]M ]˙ˑ{I(5I U(F ͏c(ͷa]
|](Q]SWC Wi!ͩc(!VC"ω((~#(!͢^Ua8
 h(3þ]_͢^i!կW!V*@Ha]  B " J($
(<  R $, B C
 B (w#(3OͧVZ(" ͧV O(,(
 y
(ͧV
(>2WEDEb p+h(la                                                           Rned to be patched into ALK/CMD (the
 ;keyboard driver program provided by Prosoft).  Whenever
 ;ALK/CMD is executed (after being patched with this
 ;program), it will first read the system date (the date
 ;entered at power-up or wheneve