#include "stdio"

#define  MAXARGS   15
#define  ETX       3

char    *_iob[MAXFILES];

_initio(stdfiles)
int     stdfiles;                /*stdfiles = 1: opens standard files*/
{
    char    *STDIN;
    char    *STDOUT;
    char    *STDERR;
    char    console[] = ":C";
    char    mode[] = "w";
    char    *argv[MAXARGS];      /*pointers to command line arguments*/
    char    ch;
    char    oldstate;
    char    *cmdline;
    char    *cptr;
    int     argc;                /*number of command line arguments*/
    int     count;
    int     fopen();
    int     main();
    int     exit();
    void    _ioerr();
    void    _hperr();
    void    _cmdline();

    for (count=0; count < MAXFILES; count++) _iob[count] = NULL;
    oldstate = 1;
    ch = 0;
    /*$NO CONVERT*/            /* turn off parameter type conversion */
    _hperr(ch,&oldstate);      /* same routine as hp$error in TRSLIB */
    _ioerr(ch,&oldstate);      /* same routine as io$error in TRSLIB */
    /*$CONVERT*/               /* turn on parameter type conversion */
    _cmdline(&cptr,&cmdline);
    argv[0] = cmdline;
    cptr = cmdline;
    argc = 0;
    count = 0;
    STDIN = STDOUT = STDERR = console;
    while (*cptr != '\r' && *cptr != ETX) {
       count++;
       cptr++;
       }
    if (count) {
       loop:
          while (*cmdline == ' ' && count) {
             count--;
             cmdline++;
             }
          if (count) {
             if (*cmdline == '<') {
                count--;
                STDIN = ++cmdline;
                }
             else if (*cmdline == '>') {
                 count--;
                 ++cmdline;
                 if (*cmdline == '>') {
                    count--;
                    cmdline++;
                    mode[0] = 'a';
                    }
                 STDOUT = cmdline;
                 }
             else {
                argv[argc] = cmdline;
                argc++;
                }
             while (*cmdline != ' ' && count) {
                count--;
                cmdline++;
                }
             *cmdline = NULL;
             count--;
             cmdline++;
             }
       if (count>0 && argc < MAXARGS) goto loop;
       }
   if (stdfiles == 1) {
      fopen(STDIN,"r");
      fopen(STDOUT,mode);
      fopen(STDERR,"w");
      }
   main(argc,argv);
   exit(0);
}

_atoi(ptr)                          /* decode an integer */
char    **ptr;                      /* pointer to addr of 1st digit */
{
    int     n;
    int     isdigit();
    n = 0;

    while (isdigit(*(*ptr))) n = 10 * n + *(*ptr)++ - '0';
    return n;
}

_itoa(n, bufptr, base)              /* integer encode routine */
unsigned    n;                      /* unsigned integer */
char        **bufptr;               /* pointer to the buffer pointer */
int         base;                   /* number base */
{
    if (n < base) {
        *(*bufptr)++ = (n < 10) ? n + '0' : n + 55;
        return;
    }
    _itoa(n/base, bufptr, base);
    _itoa(n%base, bufptr, base);
}

atoi(s)                          /* decode an integer */
char    *s;                      /* pointer to integer string */
{
    int     n;
    int     sflag;
    int     isspace();
    int     _atoi();
    n = 0;
    sflag = 0;
    while (isspace(*s)) ++s;
    if (*s == '+' || *s == '-')
        if (*s++ == '-') ++sflag;
    return _atoi(&s);
}

itoa(n, s)
int     n;
char    *s;
{
    int _itoa();
    if (n < 0) {
       if (n == -32768) {
          strcpy(s, "-32768");
          return;
       }
       *s++ = '-';
       n = -n;
    }
    _itoa(n, &s, 10);
    *s = '\0';
}

ungetc(c,fp)
int     c;
FILE    *fp;
{
   if (c != EOF) --fp->file[12];
}

fopen(name,mode)
char   name[];
char   *mode;
{
    int  len;
    int  i;
    char id[8];
    FILE *fp,*calloc();
    void _setname();
    void _openr();
    void _openw();
    void _opena();
    i = 0;
    while (i < MAXFILES && _iob[i] != NULL) i++;
    if (i >= MAXFILES) return NULL;
    len = 0;
    id[0] = 'F';
    while (name[len] != '\0') {
       if (len < 7) id[len+1] = name[len];
       len++;
       }
    _iob[i] = calloc(1,sizeof(FILE));
    if ((fp = _iob[i]) == NULL) return NULL;
    fp->fd = i;
    _setname(fp->file, name, len, id);
    if (*mode == 'W' || *mode == 'w') _openw(fp->file);
    else if (*mode == 'A' || *mode == 'a') _opena(fp->file);
       else _openr(fp->file);
    if (fp->file[17] == '\0') return NULL;
    return fp;
}

fclose(fp)
FILE    *fp;
{
   int  i;
   void _close();
   i = 0;
   while (i < MAXFILES && _iob[i] != fp) i++;
   if (i >= MAXFILES || fp == NULL) return -1;
   _close(fp->file);
   if (fp->file[17] != '\0') return -1;
   cfree(fp);
   _iob[i] = NULL;
   return 0;
}

exit(status)
int status;
{
   int  i;
   int  _exit();
   void _close();
   i = 0;
   while (i < MAXFILES) {
      if (_iob[i] != NULL) _close(_iob[i]->file);
      i++;
      }
   _exit(status);
}

isalpha(c)                      /* returns c is alphabetic */
int     c;                      /*    else returns 0       */
{
    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') return 1;
    else return 0;
}

isdigit(c)
int     c;
{
    if (c >= '0' && c <= '9') return 1;
    else return 0;
}

isspace(c)
int     c;
{
    if (c == ' ' || c == '\t' || c == '\n') return 1;
    else return 0;
}

islower(c)
int     c;
{
    if (c >= 'a' && c <= 'z') return 1;
    else return 0;
}

isupper(c)
int     c;
{
    if (c >= 'A' && c <= 'Z') return 1;
    else return 0;
}

toupper(c)
int     c;
{
    if (c >= 'a' && c <= 'z') c -= 32;
    return c;
}

tolower(c)
int     c;
{
    if (c >= 'A' && c <= 'Z') c += 32;
    return c;
}

strcpy(to_ptr, from_ptr)
char    *to_ptr;
char    *from_ptr;
{
   while (*to_ptr++ = *from_ptr++);
}

strcmp(first, second)
char    *first;
char    *second;
{
    while (*first == *second) {
       if (*first == '\0') return 0;
       else {
          first++;
          second++;
       }
    }
    return *first - *second;
}

strcat(first, second)
char    *first;
char    *second;
{
    while (*first != '\0') first++;
    while ((*first++ = *second++) != '\0');
}

char *strsave(s)
char    *s;
{
    char    *ptr;
    char    *calloc();
    if ((ptr = calloc(1,strlen(s)+1)) != NULL) strcpy(ptr,s);
    return(ptr);
}

char *gets(s)                       /* reads one line from stdin */
char    *s;                         /*      into string s        */
                                    /* newline replaced by '\0'  */
{
    int     _fgets();
    char    c;
    if (_fgets(stdin, s, &c, '\n', 32767) > 0 || c == '\n')
        return s;
    else return NULL;
}

char *fgets(s, n, fp)               /* read a line from fp */
char    *s;                         /*      into s         */
int     n;                          /* maximum characters  */
FILE    *fp;                        /*      is n-1         */
{
    int     _fgets();
    int     count;
    char    c;
    if (n > 1) {
        count = _fgets(fp, s, &c, '\n', n);
        if (c == '\n') {
            *(s+count++) = c;
            *(s+count) = NULL;
        }
        else if (count < 1) return NULL;
    }
    else *s = NULL;
    return s;
}

char *puts(s)                   /* write s to stdout */
char    *s;
{
    int     _write();
    int     strlen();
    _write(stdout, s, strlen(s));
    if (putc('\n', stdout) != EOF) return s;
    else return EOF;
}

char *fputs(s, fp)              /* write s to fp */
char    *s;
FILE    *fp;
{
    int     _write();
    int     strlen();
    if (_write(fp, s, strlen(s)) < 0) return EOF;
    else return s;
}

STRING *stods(s)                    /* convert string to dynamic string */
char    *s;                         /* s is a normal C string */
{
   int    length;
   int    i;
   char   *ds;
   STRING *ptr;
   STRING *calloc();
   int    strlen();                 /* get length of string */
   length = strlen(s);
   ptr = calloc(1, sizeof(int) + length);
   if (ptr != NULL) {
      ptr->length = length;
      ds = ptr->string;
      while (*s) *ds++ = *s++;
   }
   return ptr;
}

dstos(ptr,s)                 /* convert dynamic string into normal C string */
STRING  *ptr;                /* pointer to dynamic string */
char    *s;                  /* normal string */
{
   int  length;
   char *ds;
   length = ptr->length;
   ds = ptr->string;
   while (length--) *s++ = *ds++;
   *s = '\0';
}
