 ;	*********************************
 ;	*				*
 ;	*     THREE-D  TIC-TAC-TOE	*
 ;	*				*
 ;	*********************************
 
 	ORG	6000H
 BOARD	DEFS	41H
 
 REFTBL	DEFB	00,01,02,03	;Possible four-in-a-rows
 	DEFB	04,05,06,07
 	DEFB	08,09,10,11
 	DEFB	12,13,14,15
 	DEFB	16,17,18,19
 	DEFB	20,21,22,23
 	DEFB	24,25,26,27
 	DEFB	28,29,30,31
 	DEFB	32,33,34,35
 	DEFB	36,37,38,39
 	DEFB	40,41,42,43
 	DEFB	44,45,46,47
 	DEFB	48,49,50,51
 	DEFB	52,53,54,55
 	DEFB	56,57,58,59
 	DEFB	60,61,62,63
 	DEFB	00,04,08,12
 	DEFB	01,05,09,13
 	DEFB	02,06,10,14
 	DEFB	03,07,11,15
 	DEFB	16,20,24,28
 	DEFB	17,21,25,29
 	DEFB	18,22,26,30
 	DEFB	19,23,27,31
 	DEFB	32,36,40,44
 	DEFB	33,37,41,45
 	DEFB	34,38,42,46
 	DEFB	35,39,43,47
 	DEFB	48,52,56,60
 	DEFB	49,53,57,61
 	DEFB	50,54,58,62
 	DEFB	51,55,59,63
 	DEFB	00,16,32,48
 	DEFB	01,17,33,49
 	DEFB	02,18,34,50
 	DEFB	03,19,35,51
 	DEFB	04,20,36,52
 	DEFB	05,21,37,53
 	DEFB	06,22,38,54
 	DEFB	07,23,39,55
 	DEFB	08,24,40,56
 	DEFB	09,25,41,57
 	DEFB	10,26,42,58
 	DEFB	11,27,43,59
 	DEFB	12,28,44,60
 	DEFB	13,29,45,61
 	DEFB	14,30,46,62
 	DEFB	15,31,47,63
 	DEFB	00,05,10,15
 	DEFB	16,21,26,31
 	DEFB	32,37,42,47
 	DEFB	48,53,58,63
 	DEFB	03,06,09,12
 	DEFB	19,22,25,28
 	DEFB	35,38,41,44
 	DEFB	51,54,57,60
 	DEFB	15,30,45,60
 	DEFB	11,26,41,56
 	DEFB	07,22,37,52
 	DEFB	03,18,33,48
 	DEFB	12,29,46,63
 	DEFB	08,25,42,59
 	DEFB	04,21,38,55
 	DEFB	00,17,34,51
 	DEFB	15,27,39,51
 	DEFB	14,26,38,50
 	DEFB	13,25,37,49
 	DEFB	12,24,36,48
 	DEFB	03,23,43,63
 	DEFB	02,22,42,62
 	DEFB	01,21,41,61
 	DEFB	00,20,40,60
 	DEFB	00,21,42,63
 	DEFB	15,26,37,48
 	DEFB	03,22,41,60
 	DEFB	12,25,38,51
 
 ;	These are the 3 x 3 graphic "cells"
 
 FIGMAT	DEFB	191,159,143,191,128,128,128,128,128
 	DEFB	143,191,188,128,130,191,128,128,191
 	DEFB	188,191,143,191,129,128,191,128,128
 	DEFB	143,175,191,128,128,191,128,128,128
 	DEFB	128,128,128,128,128,128,128,128,128
 	DEFB	128,128,191,128,170,191,128,170,191
 	DEFB	191,128,128,191,149,128,191,149,128
 	DEFB	128,170,191,128,170,191,128,191,191
 	DEFB	191,149,128,191,149,128,191,191,128
 	DEFB	128,191,191,170,191,191,191,191,191
 	DEFB	191,191,128,191,191,149,191,191,191
 	DEFB	128,128,128,104,101,128,128,128,128
 	DEFB	128,191,191,128,128,191,128,170,149
 	DEFB	191,191,128,191,128,128,170,149,128
 	DEFB	128,191,128,170,149,128,191,128,128
 	DEFB	128,191,128,128,170,149,128,128,191
 	DEFB	128,128,170,128,128,191,128,170,149
 	DEFB	149,128,128,128,128,128,128,128,128
 	DEFB	128,128,170,128,128,128,128,128,128
 	DEFB	149,128,128,191,128,128,170,149,128
 	DEFB	128,191,140,170,149,108,191,191,128
 	DEFB	140,140,140,116,101,114,128,128,128
 	DEFB	140,140,140,110,097,116,128,128,128
 	DEFB	140,191,128,101,170,149,128,191,191
 	DEFB	128,128,160,128,186,135,168,151,128
 	DEFB	188,143,143,128,128,128,128,128,128
 	DEFB	143,143,188,128,128,128,128,128,128
 	DEFB	144,128,128,139,180,191,128,130,175
 	DEFB	191,128,128,139,188,176,128,128,131
 	DEFB	128,128,128,128,128,128,143,188,180
 	DEFB	128,128,128,128,128,128,176,128,128
 	DEFB	128,128,131,128,128,128,128,128,128
 	DEFB	139,143,188,128,128,128,128,128,128
 	DEFB	176,128,128,131,143,180,128,128,191
 	DEFB	189,144,128,191,139,180,128,128,130
 	DEFB	128,128,128,111,117,114,143,188,188
 	DEFB	128,128,128,099,101,128,188,188,143
 	DEFB	128,186,133,184,151,128,129,128,128
 	DEFB	055,048,052,076,097,110,128,128,128
 	DEFB	032,128,078,115,105,110,128,128,128
 	DEFB	032,080,101,103,044,128,128,052,056
 	DEFB	110,110,046,077,073,046,057,048,054
 	DEFB	128,128,128,053,049,055,053,049,055
 	DEFB	128,128,128,032,052,056,032,052,056
 	DEFB	128,128,128,050,045,084,050,045,084
 	DEFB	128,128,128,065,083,048,065,083,049
 	DEFB	128,176,188,191,131,128,128,128,128
 	DEFB	188,188,188,128,128,128,128,128,128
 	DEFB	188,188,188,128,128,128,176,176,176
 	DEFB	188,176,128,128,131,191,184,142,129
 	DEFB	176,128,128,143,188,176,128,128,131
 	DEFB	128,128,128,176,176,176,131,131,179
 	DEFB	128,128,128,176,176,176,179,131,131
 	DEFB	130,139,180,176,188,143,131,128,128
 	DEFB	172,188,188,170,149,128,170,149,128
 	DEFB	188,188,188,128,128,128,128,128,128
 	DEFB	188,188,180,128,128,128,128,128,128
 	DEFB	176,144,128,128,131,189,128,128,191
 	DEFB	170,149,128,170,149,128,142,143,143
 	DEFB	128,128,128,128,128,128,143,143,143
 	DEFB	128,128,128,128,128,128,143,143,135
 	DEFB	128,128,191,128,176,159,131,129,128
 	DEFB	159,175,159,129,170,149,128,170,149
 	DEFB	175,128,128,130,128,128,128,128,128
 	DEFB	128,186,181,128,128,128,128,128,128
 	DEFB	128,128,128,128,128,175,128,128,170
 	DEFB	128,128,128,159,128,128,149,128,128
 	DEFB	128,128,170,128,128,190,128,128,128
 	DEFB	149,128,128,189,128,128,128,128,184
 	DEFB	128,128,128,128,128,128,143,143,190
 	DEFB	128,128,149,128,128,149,128,128,139
 	DEFB	128,128,128,128,128,128,188,188,175
 	DEFB	128,128,128,128,128,187,128,160,133
 	DEFB	128,128,128,183,128,128,138,144,128
 	DEFB	128,186,176,128,151,131,128,128,128
 	DEFB	176,181,128,131,171,128,128,128,184
 	DEFB	128,128,128,128,184,143,128,149,128
 	DEFB	128,128,128,143,180,128,128,170,128
 	DEFB	128,149,128,128,139,188,128,128,128
 	DEFB	128,170,128,188,135,128,128,128,158
 	DEFB	128,128,128,128,128,128,143,143,173
 	DEFB	128,128,181,128,128,151,128,128,173
 	DEFB	184,128,130,139,128,160,188,188,158
 	DEFB	151,131,171,149,128,170,181,176,186
 	DEFB	168,188,148,170,128,149,138,143,133
 	DEFB	128,128,128,128,191,128,128,128,128
 	DEFB	151,131,171,149,088,170,181,176,186
 	DEFB	151,131,171,149,079,170,181,176,186
 	DEFB	191,128,128,191,128,128,191,128,128
 	DEFB	138,181,128,128,171,180,128,128,130
 	DEFB	128,128,128,128,128,128,143,188,188
 	DEFB	128,128,128,128,128,128,188,188,143
 	DEFB	128,160,190,184,135,191,129,128,128
 	DEFB	128,191,140,170,149,128,191,191,128
 	DEFB	140,140,140,128,128,128,128,128,128
 	DEFB	140,191,128,128,170,149,128,191,191
 	DEFB	139,191,191,128,130,139,128,128,128
 	DEFB	135,128,128,173,180,128,128,138,181
 	DEFB	128,128,139,128,184,158,186,133,128
 	DEFB	191,191,135,135,129,128,128,128,128
 	DEFB	144,128,128,139,181,128,128,171,148
 	DEFB	128,128,191,128,128,191,128,128,191
 	DEFB	139,191,135,128,191,128,168,151,128
 	DEFB	139,191,135,128,191,128,128,171,148
 	DEFB	174,191,132,128,139,180,128,128,130
 	DEFB	128,128,128,128,128,184,173,158,129
 	DEFB	128,128,128,180,128,128,130,173,158
 	DEFB	136,191,157,184,135,128,129,128,128
 	DEFB	128,128,128,128,128,128,128,184,135
 	DEFB	128,128,190,128,128,128,131,173,144
 	DEFB	189,128,128,128,128,128,128,128,136
 	DEFB	128,128,128,128,128,128,175,148,128
 	DEFB	170,149,128,128,175,156,128,128,140
 	DEFB	128,128,139,128,128,128,140,140,140
 	DEFB	180,128,128,130,173,176,140,140,140
 	DEFB	128,191,128,184,135,128,140,128,128
 	DEFB	191,191,191,170,191,191,128,191,191
 	DEFB	191,191,191,191,191,149,191,191,128
 	DEFB	128,191,191,128,170,191,128,170,191
 	DEFB	191,191,128,191,149,128,191,149,128
 	DEFB	066,065,068,066,065,068,066,065,068
 	DEFB	151,131,171,149,143,170,181,176,186
 
 ;	These are the 4 x 4 x 4 cell vectors
 
 ;	"TAS PRESENTS"
 
 CNFIG0	DEFB	000,001,002,003,004,005,006,004
 	DEFB	004,007,008,004,004,009,010,011
 	DEFB	004,012,013,004,004,014,015,004
 	DEFB	016,017,018,019,020,021,022,023
 	DEFB	024,025,026,027,028,029,030,004
 	DEFB	004,031,032,033,034,035,036,037
 	DEFB	038,039,040,041,004,004,004,004
 	DEFB	004,004,004,004,042,043,044,045
 
 ;	"3-D TIC TAC TOE"
 
 CNFIG1	DEFB	046,047,048,049,050,051,052,053
 	DEFB	054,055,056,057,058,059,060,061
 	DEFB	062,063,004,004,064,065,066,004
 	DEFB	004,067,068,069,004,004,070,071
 	DEFB	062,063,004,004,064,072,073,004
 	DEFB	004,074,075,069,004,004,070,071
 	DEFB	062,063,004,004,064,076,077,004
 	DEFB	004,078,079,080,004,004,081,082
 
 ;	Play set-up
 
 CNFIG2	DEFB	083,083,083,083,083,083,083,083
 	DEFB	083,083,083,083,083,083,083,083
 	DEFB	083,083,083,083,083,083,083,083
 	DEFB	083,083,083,083,083,083,083,083
 	DEFB	083,083,083,083,083,083,083,083
 	DEFB	083,083,083,083,083,083,083,083
 	DEFB	083,083,083,083,083,083,083,083
 	DEFB	083,083,083,083,083,083,083,083
 
 ;	"YOU WIN"
 
 CNFIG3	DEFB	096,097,098,099,004,005,006,004
 	DEFB	004,007,008,004,004,009,010,004
 	DEFB	024,025,026,100,088,004,004,101
 	DEFB	088,004,004,101,089,090,091,037
 	DEFB	102,004,004,103,088,004,004,101
 	DEFB	088,004,004,101,089,090,091,037
 	DEFB	104,105,106,107,004,065,066,004
 	DEFB	108,109,110,111,112,113,114,115
 
 ;	"I WIN"
 
 CNFIG4	DEFB	004,004,004,004,004,004,004,004
 	DEFB	004,004,004,004,004,004,004,004
 	DEFB	004,116,117,004,004,118,119,004
 	DEFB	004,007,008,004,004,009,010,004
 	DEFB	004,004,004,004,004,004,004,004
 	DEFB	004,004,004,004,004,004,004,004
 	DEFB	104,105,106,107,004,065,066,004
 	DEFB	108,109,110,111,112,113,114,115
 
 ;	"CATS"
 
 CNFIG5	DEFB	024,025,026,027,088,004,004,004
 	DEFB	088,004,004,004,089,090,091,092
 	DEFB	004,012,013,004,004,014,015,004
 	DEFB	016,017,018,019,093,094,094,095
 	DEFB	000,001,002,003,004,005,006,004
 	DEFB	004,007,008,004,004,009,010,004
 	DEFB	024,025,026,027,028,029,030,004
 	DEFB	004,031,032,033,034,090,091,037
 
 ;	[ blank screen ]
 
 CNFIG6	DEFB	004,004,004,004,004,004,004,004
 	DEFB	004,004,004,004,004,004,004,004
 	DEFB	004,004,004,004,004,004,004,004
 	DEFB	004,004,004,004,004,004,004,004
 	DEFB	004,004,004,004,004,004,004,004
 	DEFB	004,004,004,004,004,004,004,004
 	DEFB	004,004,004,004,004,004,004,004
 	DEFB	004,004,004,004,004,004,004,004
 
 SCORES	DEFS	40H		;Holds "grades" for moves
 
 SRTREF	DEFS	40H		;Holds sort reference
 
 EXPTBL	DEFB	1,2,3,4		;Level   I
 	DEFB	1,2,4,8		;Level  II
 	DEFB	1,2,4,12	;Level III
 	DEFB	1,3,9,36	;Level  IV
 	DEFB	1,3,9,64	;Level   V
 EXPTBX	DEFW	EXPTBL+8
 BRDPOS	DEFB	0		;Holds player cursor posn
 RNDPNT	DEFW	0		;Holds loc of random #
 
 ;	-- SOME TEXT FOR THE FANCY SCREEN STUFF
 
 
 ;	-- MESSAGES FOR THE BOTTOM OF THE SCREEN
 
 MESS1	DEFB	7
 	DEFM	'Level of play?  '
 	DEFM	' ( 1 - EASY  thru  5 - DIFFICULT )'
 	DEFB	0
 
 MESS2	DEFB	7
 	DEFM	'Do you wish to flip for FIRST MOVE?  '
 	DEFM	'  ( Y = YES )'
 	DEFB	0
 
 MESS3	DEFB	14H
 	DEFM	'You (O) or Me (X) FIRST?'
 	DEFB	0
 
 MESS4	DEFB	16H
 	DEFM	'HEADS -- It'
 	DEFB	27H
 	DEFM	's Yours!'
 	DEFB	0
 
 MESS5	DEFB	16H
 	DEFM	'TAILS -- It'
 	DEFB	27H
 	DEFM	's Mine!'
 	DEFB	0
 
 MESS6	DEFB	15H
 	DEFM	'Press < CLEAR > to Play'
 	DEFB	0
 
 MESS7	DEFB	5
 	DEFM	'< Right/Left Arrows moves Cursor > '
 	DEFM	' < "O" makes Move >'
 	DEFB	0
 
 
 ;	-- NOW LOCNS AND A ROM CALL
 
 NOKEY	EQU	3802H	;'N' & 'O' KEY
 YXKEY	EQU	3808H	;'Y' & 'X' KEY
 NUMKEY	EQU	3810H	;0 THRU 7
 ARWKEY	EQU	3840H	;Arrow and <CLEAR> key
 LOCZER	EQU	03C45H	;Loc of first move on screen
 CLEAR	EQU	001C9H	;Clears screen
 
 
 
 
 ;	***********************
 ;	*   FANCY   OPENING   *
 ;	*	NUMBER	      *
 ;	***********************
 
 
 
 START	LD	A,R
 	LD	(RNDPNT),A	;Initialize random pntr.
 	LD	SP,0FFFFH	;Initialize Stack
 
 	CALL	CLEAR		;Clear screen
 
 CYCLE	LD	IX,CNFIG0	;'flrout' = fill routine
 	CALL	SCRFIL
 	LD	B,0
 	CALL	PAUSE
 	CALL	PAUSE
 	CALL	PAUSE
 	CALL	PAUSE
 	CALL	PAUSE
 	CALL	PAUSE
 	CALL	PAUSE
 
 	LD	IX,CNFIG1
 	CALL	SCRFIL
 	LD	B,0
 	CALL	PAUSE
 	CALL	PAUSE
 	CALL	PAUSE
 	CALL	PAUSE
 	CALL	PAUSE
 	CALL	PAUSE
 
 	LD	IX,CNFIG2
 	CALL	SCRFIL
 	LD	B,80H
 	CALL	PAUSE
 	LD	HL,MESS6
 	CALL	MDSPLY
 	LD	B,80H
 	CALL	PAUSE
 	CALL	NEWBRD		;Prepare for simul. play
 
 SIMLTE	CALL	ANLYZE		;On return:
 ;				 A = 0 MEANS 'ALL WELL'
 ;				    HL <= COUNTER MOVE
 ;				 A = 1  MEANS 'WIN'
 ;				    DE <= REFTBL ROW VECT
 ;				 A = 2  MEANS 'CATS'
 ;				    NO PERTINENT VECTOR
 
 	OR	A	;'all well'?
 	JR	NZ,SIMOUT
 	PUSH	HL		;Save move
 	LD	BC,BOARD
 	ADD	HL,BC
 SIMTOK	LD	(HL),01H
 	LD	A,(SIMTOK+1)
 	XOR	11H		;Toggle token type
 	LD	(SIMTOK+1),A
 	POP	HL		;Get move back
 	LD	B,100		;Flash move counter
 	CALL	FLSHMV	;Flash it
 
 	LD	A,(ARWKEY)
 	CP	2
 	JP	Z,GAME
 
 	JR	SIMLTE
 
 SIMOUT	CP	1		;Test for win
 	CALL	Z,FLSHRW	;Flshrw if win
 
 	LD	B,0A0H
 	CALL	PAUSE
 	JP	CYCLE
 
 
 SCRFIL	CALL	NEWBRD
 	LD	B,64		;Count for board fill
 
 NXTLOC	PUSH	BC		;Save it
 	LD	IY,BOARD
 	PUSH	IX		;Save cnfigx
 
 LKAGIN	CALL	RANDOM
 	AND	3FH		;0 <= A <= 63
 	LD	L,A
 	LD	(IYCD60+2),A
 	LD	(IYCD61+2),A
 IYCD60	LD	A,(IY+0)
 	OR	A		;Check board for zero
 	JR	NZ,LKAGIN	;If not 0 , 'look again'
 
 IYCD61	INC	(IY+0)		;Set board for next time
 	LD	A,L
 	POP	IX		;Get back cnfigx
 	LD	(IXCD60+2),A
 IXCD60	LD	A,(IX+0)	;A = desired configuratn
 	LD	H,A
 	PUSH	IX		;Save that cnfigx
 
 	LD	B,8
 	CALL	PAUSE
 	CALL	LOCFIL		;H = CONFIG / L = BRD LOC
 
 	LD	A,(ARWKEY)
 	CP	2
 
 	POP	IX
 	POP	BC		;Get back count
 	JP	Z,GAME
 
 	DJNZ	NXTLOC
 	RET			;Back to main stream
 
 
 
 LOCFIL	PUSH	HL		;Save config/board loctn
 
 	LD	B,1
 	LD	A,L
 PANEL	CP	16		;Check board > 15
 	JR	C,ROWCON
 	INC	B
 	SUB	16		;We'll try again
 	JR	PANEL
 
 ROWCON	LD	C,A		;B has count
 	LD	A,0F2H		;0F2H = -14
 PNLOOP	ADD	A,14
 	DJNZ	PNLOOP		;Add 14 for @ mod16
 
 	LD	E,A
 	LD	D,0
 	PUSH	DE		;Stash this panel disp
 
 	LD	B,1
 	LD	A,C		;Get remainder
 
 ROW	CP	4
 	JR	C,COLCON
 	INC	B
 	SUB	4
 	JR	ROW
 
 COLCON	LD	HL,0FF40H
 	LD	DE,000C0H
 
 ROWLOP	ADD	HL,DE
 	DJNZ	ROWLOP
 
 	PUSH	HL
 	LD	C,A
 	RLCA
 	ADD	A,C
 	LD	E,A
 	LD	D,0
 	LD	HL,LOCZER
 	ADD	HL,DE
 	POP	DE
 	ADD	HL,DE
 	POP	DE
 	ADD	HL,DE
 
 	PUSH	HL
 	POP	IY
 
 	POP	HL
 	LD	L,H
 	LD	H,0
 	PUSH	HL
 	POP	BC
 
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,BC
 	PUSH	HL
 	POP	BC
 
 	LD	IX,FIGMAT
 	ADD	IX,BC
 
 	LD	BC,64
 	LD	A,(IX+0)
 	LD	(IY+0),A
 	LD	A,(IX+1)
 	LD	(IY+1),A
 	LD	A,(IX+2)
 	LD	(IY+2),A
 
 	ADD	IY,BC
 	LD	A,(IX+3)
 	LD	(IY+0),A
 	LD	A,(IX+4)
 	LD	(IY+1),A
 	LD	A,(IX+5)
 	LD	(IY+2),A
 
 
 
 
 
 	ADD	IY,BC
 	LD	A,(IX+6)
 	LD	(IY+0),A
 	LD	A,(IX+7)
 	LD	(IY+1),A
 	LD	A,(IX+8)
 	LD	(IY+2),A
 
 	RET
 
 
 PAUSE	PUSH	BC
 	LD	B,0
 PSLOP2	DJNZ	PSLOP2
 	POP	BC
 	DJNZ	PAUSE
 	RET
 
 
 
 ;	THIS IS THE FLASHING ROW SUBROUTINE
 
 FLSHRW	EX	DE,HL		;HL <= loc / row pointers
 	LD	B,10H		;Number of 4 cycles
 
 FLRWL1	PUSH	BC		;'flash row loop 1'
 	PUSH	HL
 	LD	B,4
 
 FLRWL2	PUSH	BC
 	PUSH	HL
 	LD	B,10		;Number of 'flash' cycles
 	LD	A,(HL)
 	LD	L,A
 	LD	H,0
 
 	CALL	FLSHMV
 
 	POP	HL
 	INC	HL		;To flash next winning
 ;				 move spot 10 times
 	POP	BC
 	DJNZ	FLRWL2
 
 	POP	HL		;Get back 1st pointer
 	POP	BC		;& 20 count
 	DJNZ	FLRWL1
 
 	RET
 
 
 ;	-- HERE'S WHERE WE FLASH AN INDIVIDUAL 'QUAD'
 
 
 FLSHMV	PUSH	HL		;Save move for later
 
 FLMVLP	PUSH	BC		;Stash that loop value
 	LD	H,53H		;'o' grafix unit
 	PUSH	HL
 	CALL	LOCFIL		;Write it
 	LD	B,1
 	CALL	PAUSE
 	POP	HL
 	INC	H		;Next, smaller 'o' unit
 	PUSH	HL
 	CALL	LOCFIL		;Write it
 	LD	B,1
 	CALL	PAUSE
 	POP	HL
 	INC	H		;Next, smallest '.' unit
 	PUSH	HL
 	CALL	LOCFIL		;Write it
 	LD	B,1
 	CALL	PAUSE
 	POP	HL
 
 	POP	BC		;Get back flash count
 	DJNZ	FLMVLP
 
 	POP	HL		;Get back move loc
 	CALL	PUTTOK		;Puts token on screen
 
 	RET
 
 
 
 PUTTOK	LD	BC,BOARD
 	ADD	HL,BC		;HL <= BOARD LOC
 	LD	A,(HL)		;A  <= TOKEN
 
 	OR	A	;Empty move place?
 	JR	Z,BLNKTK	;Put blank token
 
 	CP	01H	;'o' move place?
 	JR	Z,OHTK		;Put  'o'  token
 
 	LD	H,56H	;Else set up 'x' token
 	JR	CNTFIL
 OHTK	LD	H,57H	;'o' token
 	JR	CNTFIL
 BLNKTK	LD	H,53H	;Blank token
 
 CNTFIL	CALL	LOCFIL	;Fill 'er up!
 
 	RET
 
 
 GAME	CALL	CLRLIN
 	LD	IX,CNFIG6	;Clear screen
 	CALL	SCRFIL
 	LD	IX,CNFIG2	;Play set up
 	CALL	SCRFIL
 	LD	B,0
 	CALL	PAUSE
 	CALL	NEWBRD
 	LD	HL,MESS1
 	CALL	MDSPLY		;'level of play' mess
 
 GETNUM	LD	A,(NUMKEY)
 	RRA			;Cycle out zero key
 	LD	B,5		;Cycle out 5 bits
 NXBYT1	RRA
 	JR	C,GOTNUM
 	DJNZ	NXBYT1
 	JR	GETNUM		;No findee -- try again.
 
 GOTNUM	LD	A,5
 	SUB	B		; A <= 0 THRU 4
 	RLCA
 	RLCA			; A <= 0,4,8,10,14 HEX
 	LD	C,A
 	LD	B,0
 	LD	HL,EXPTBL
 	ADD	HL,BC
 	LD	(EXPTBX),HL
 	CALL	CLRLIN		;Clear message line
 
 	LD	HL,MESS2	;'flip?'
 	CALL	MDSPLY
 
 GETFLP	LD	A,(YXKEY)	;'Y'?
 	OR	A
 	JR	NZ,FLIP
 	LD	A,(NOKEY)	;'N'?
 	OR	A
 	JR	Z,GETFLP	;Not 'n' , try again.
 
 	CALL	CLRLIN		;Wants choice/clear mess.
 	LD	HL,MESS3	;''O' OR 'X' FIRST?'
 	CALL	MDSPLY
 GETCHO	LD	A,(NOKEY)
 	CP	80H		;Bit 7 alone
 	JR	Z,OFIRST-6	;If nokey, player first.
 	LD	A,(YXKEY)
 	OR	A
 	JR	Z,GETCHO
 
 	JP	XFIRST
 
 ;	>> some subroutines <<
 
 CLRLIN	LD	HL,3F80H	;Crt, beg. of line 14
 	PUSH	HL
 	POP	DE
 	INC	DE
 	LD	(HL),20H	;Load up first space
 	LD	BC,40H
 	LDIR		;Move spaces.
 	RET
 
 MDSPLY	LD	A,(HL)		;A <= tab
 	INC	HL		;HL <= 1ST BYTE OF MESSx
 	PUSH	HL		;Save it
 	LD	E,A
 	LD	D,0
 	LD	HL,3F80H
 	ADD	HL,DE
 	EX	DE,HL		;DE <= CRT DESTINATION
 	POP	HL		;Get source string back
 MESSLP	LDI		;Transfer message byte
 	LD	A,(HL)
 	OR	A
 	JR	NZ,MESSLP	;If new (HL) <> 0, again
 	RET
 
 FLIP	CALL	CLRLIN
 	CALL	RANDOM
 	RRCA
 	JR	C,O1STMS
 	LD	HL,MESS5	;'tails'
 	CALL	MDSPLY
 	LD	B,0
 	CALL	PAUSE
 	CALL	PAUSE
 	CALL	CLRLIN
 	JP	XFIRST
 
 O1STMS	LD	HL,MESS4	;'heads'
 	CALL	MDSPLY
 	LD	B,0
 	CALL	PAUSE
 	CALL	PAUSE
 	LD	HL,MESS7
 	CALL	MDSPLY
 
 OFIRST	LD	HL,BOARD
 	LD	BC,0
 	LD	A,0
 	CPIR
 	DEC	HL
 	LD	H,79H
 	LD	A,L
 	LD	(BRDPOS),A
 	CALL	LOCFIL
 	LD	B,0
 	CALL	PAUSE
 
 PLAYIN	LD	A,(ARWKEY)
 	LD	B,20
 	CALL	PAUSE	;Pause for "debounce"
 	RRA
 	RRA
 	RRA
 	RRA		;Rotate up arrow bit into 'a' reg
 	RRA
 	RRA
 	CALL	C,LEFARW
 	RRA
 	CALL	C,RGTARW
 	LD	A,(NOKEY)
 	OR	A		;To test for 'o' - move.
 	JR	Z,PLAYIN
 
 	CALL	CLRLIN
 	LD	A,(BRDPOS)	;Get position
 	LD	L,A
 	LD	H,0
 	LD	DE,BOARD
 	ADD	HL,DE
 	LD	A,(HL)		;Get token
 	OR	A		;Test for no move yet
 	JR	Z,POSIT		;If no move, posit move.
 
 BADMOV	LD	H,78H		;78H refs grafix 'bad'
 	PUSH	HL
 	CALL	LOCFIL		;Fill loc w/ 'badbadbad'
 	LD	B,0
 	CALL	PAUSE
 	CALL	PAUSE
 	POP	HL
 	LD	H,79H		;79H refs grafix cursor
 	CALL	LOCFIL		;Put cursor
 	JR	PLAYIN		;Reenter move key scan
 
 POSIT	LD	(HL),01H	;Player token
 	LD	H,0
 	LD	B,40
 	CALL	FLSHMV		;Flash move on screen
 	CALL	ANLYZE
 	OR	A
 	JP	Z,XFIRST+6	;All well/machine next	
 	CP	1		;Player win?
 	JR	Z,OWIN
 CATWIN	LD	IX,CNFIG5	;'cats'
 	JP	XWIN+7		;Fill screen/disp. cycle
 
 OWIN	CALL	FLSHRW		;Flash row
 	LD	IX,CNFIG3	;'you win'
 	JR	XWIN+7
 
 LEFARW	LD	B,0FFH		;0FF0 = -1
 	CALL	NEWPOS
 	RET
 
 RGTARW	LD	B,1
 	CALL	NEWPOS
 	RET
 
 NEWPOS	PUSH	BC		;Save move value in 'b'
 	LD	A,(BRDPOS)	;Get current board posn
 	PUSH	AF		;Save it.
 	LD	L,A
 	LD	H,0
 	CALL	PUTTOK		;Reinstate token grafix
 	POP	AF		;Get brdpos
 	CALL	POSFIX		;Fix for move math
 	POP	BC		;'B' <= -16,16,-1 or 1
 	ADD	A,B
 	CALL	POSFIX		;Fix it back again
 	LD	(BRDPOS),A	;Update brdpos
 	LD	L,A		;New board location
 	LD	H,79H		;79H is cursor grafix
 	CALL	LOCFIL
 	LD	B,28H	;Delay factor
 	CALL	PAUSE
 	RET
 
 POSFIX	AND	3FH	;Strip off 6,7 bits
 	LD	B,A
 	AND	03H
 	LD	C,A
 	LD	A,B
 	AND	3CH
 	LD	B,A
 	AND	30H
 	LD	D,A
 	LD	A,B
 	AND	0CH
 	RLCA
 	RLCA
 	LD	B,A
 	LD	A,D
 	RRCA
 	RRCA
 	ADD	A,B
 	ADD	A,C
 	RET
 
 XFIRST	CALL	CLRLIN
 	CALL	ANLYZE
 	LD	DE,BOARD
 	ADD	HL,DE
 	LD	(HL),10H	;Posit machine move
 	LD	H,0
 	LD	B,30
 	CALL	FLSHMV		;Flash it
 	CALL	ANLYZE
 	OR	A		;O. K. ?
 	JP	Z,OFIRST
 	CP	1		;Win?
 	JR	Z,XWIN
 
 CATWN2	LD	IX,CNFIG5	;'cats'
 	JR	XWIN+7
 
 XWIN	CALL	FLSHRW
 	LD	IX,CNFIG4	;'I win'
 	CALL	SCRFIL
 	LD	B,0
 	CALL	PAUSE
 	CALL	PAUSE
 	JP	CYCLE
 
 
 
 
 ;	THIS SEGMENT CLEARS THE BOARD FOR A NEW GAME --
 
 NEWBRD	LD	HL,BOARD
 	LD	(HL),0
 	PUSH	HL
 	POP	DE
 	INC	DE
 	LD	BC,63		;Set up for zero-out
 	LDIR		;Board cleared!
 	RET			;Back to basic ====>
 
 
 ;	THIS IS THE MAIN FUNCTION OF THIS WHOLE THING;
 ;		TO ANALYZE THE BOARD AND DETERMINE THE
 ;			BEST COUNTER-MOVE.
 
 
 ANLYZE	LD	IY,SCORES
 	LD	IX,SRTREF
 	LD	B,64		;Loop 64 times
 	XOR	A
 
 LDLOOP	LD	(IYCD0+2),A
 	LD	(IXCD0+2),A
 IYCD0	LD	(IY+0),0	;Ld scores w/ zeros
 IXCD0	LD	(IX+0),A	;Ld N into (IX+N)
 	INC	A
 	DJNZ	LDLOOP
 
 	LD	IX,BOARD
 	LD	B,76		;Row reference loop
 	LD	HL,REFTBL
 
 ROWTST	PUSH	BC
 	PUSH	HL
 	LD	B,4		;Number across row
 	LD	D,0		;Initialize move accum.
 
 ROWADD	LD	A,(HL)		;Get ref
 	LD	(IXCD1+2),A	;Load into code
 IXCD1	LD	A,(IX+0)	;A <= MOVE (01H OR 10H)
 	ADD	A,D
 	LD	D,A		;Acc into D
 	INC	HL		;For next ref
 	DJNZ	ROWADD
 
 	LD	A,D
 	AND	0FH		;Test for machine move
 	JR	Z,SFTGRD	;'shift then grade'
 	LD	A,D		;No?  then ;
 	AND	0F0H		;Test for human move
 	JR	Z,GRD		;'grade' no shift needed
 	JR	NXTROW		;If mixed, 'next row 1'
 
 SFTGRD	SRL	D
 	SRL	D
 	SRL	D
 	SRL	D		;Right justify
 
 GRD	LD	A,D
 	CP	4		;But first, test for win
 	JP	Z,WIN		;Jp to win if won
 
 	PUSH	IY
 	LD	IY,(EXPTBX)
 	LD	(IYCD50+2),A
 IYCD50	LD	D,(IY+0)
 	POP	IY
 
 	POP	HL		;Get beg of ref row
 	PUSH	HL		;Stuff it back
 	LD	B,4
 
 FOURZR	LD	A,(HL)		;Get that ref
 	LD	(IXCD2+2),A	;Load code w/ ref
 	LD	(IYCD10+2),A
 	LD	(IYCD11+2),A
 IXCD2	LD	A,(IX+0)	;A <= move
 	OR	A		;Test for no move yet
 	JR	NZ,NXT4ZR	;If not 0, next ref
 IYCD10	LD	A,(IY+0)
 	ADD	A,D
 IYCD11	LD	(IY+0),A
 
 NXT4ZR	INC	HL		;HL <= next ref
 	DJNZ	FOURZR
 
 NXTROW	POP	HL
 	INC	HL
 	INC	HL
 	INC	HL
 	INC	HL
 	POP	BC		;Big ref count (76)
 	DJNZ	ROWTST
 
 
 ;	NOW THAT WE'VE GRADED THE OPEN MOVE SPACES, WE
 ;	HAVE TO SORT THESE FIGURES TO FIND THE MOST
 ;	CRITICAL MOVE OPPORTUNITIES.  WE'LL ALSO SORT THE
 ;	POINTERS SO WE CAN KEEP TABS ON WHICH GRADINGS GO
 ;	WITH WHICH BOARD LOCATIONS.
 
 
 SORT	LD	IX,SRTREF
 	LD	B,63
 	LD	D,0
 
 
 SRT1ST	LD	C,B
 	DEC	C
 	JR	NZ,CONT
 	INC	C
 
 CONT	LD	E,D
 	INC	E
 
 	LD	A,D
 	LD	(IYCD20+2),A
 	LD	(IYCD21+2),A
 	LD	(IYCD22+2),A
 
 	LD	(IXCD21+2),A
 	LD	(IXCD22+2),A
 
 IYCD20	LD	A,(IY+0)	;Ld up 1stloop comparator
 
 SRT2ND	PUSH	AF
 	LD	A,E
 
 	LD	(IYCD25+2),A
 	LD	(IYCD26+2),A
 	LD	(IYCD27+2),A
 
 	LD	(IXCD26+2),A
 	LD	(IXCD27+2),A
 
 	POP	AF
 
 IYCD25	CP	(IY+0)
 
 	CALL	C,SWITCH
 
 	INC	E
 	DEC	C
 	JR	NZ,SRT2ND
 
 IYCD21	LD	(IY+0),A
 	INC	D
 	DJNZ	SRT1ST
 
 
 
 ;	NOW IN THIS SECTION WE ASCERTAIN THE NUMBER OF
 ;	IDENTICALLY 'WEIGHTED' HIGH SCORES AT THE
 ;	TOP OF OUR LIST.  WE'LL BE CHOOSING FROM ONE OF
 ;	THEM.
 
 
 ADJSCH	LD	A,(IY+0)
 	OR	A
 	JR	NZ,ADJSET
 	LD	A,2		;2 means 'cats'
 	RET
 
 ADJSET	LD	B,63
 	LD	E,1
 
 ADJLOP	LD	D,E
 	DEC	D
 	LD	A,D
 	LD	(IYCD30+2),A
 	LD	A,E
 	LD	(IYCD31+2),A
 IYCD30	LD	A,(IY+0)
 IYCD31	CP	(IY+0)
 	JR	NZ,SLCTMV
 	INC	E
 	DJNZ	ADJLOP
 
 
 
 
 
 ;	NOW, IN THIS SECTION, WE SELECT THE MOVE.  THE
 ;	NUMBER OF MOVES OF EQUAL AND MOST IMPORTANT
 ;	VALIDITY, HAS BEEN DEPOSITED IN REGISTER 'C'.
 
 
 SLCTMV	CALL	RANDOM
 
 DIVLOP	SBC	A,E
 	JR	NC,DIVLOP
 	ADD	A,E
 	LD	(IXCD40+2),A
 IXCD40	LD	L,(IX+0)
 	XOR	A		;A = 0 means no win
 	LD	H,0
 	RET
 
 
 WIN	POP	DE
 	POP	BC		;Clean off stack
 	LD	A,1		;A = 1 means win
 	RET
 
 
 SWITCH	LD	L,A
 
 IYCD26	LD	A,(IY+0)
 IYCD22	LD	(IY+0),A
 IYCD27	LD	(IY+0),L
 
 IXCD26	LD	L,(IX+0)
 IXCD21	LD	H,(IX+0)
 IXCD27	LD	(IX+0),H
 IXCD22	LD	(IX+0),L
 
 	RET
 
 ;	Thank you, thank you, thank you, Bruce Hanson
 ;		for this charming routine.
 
 RANDOM	PUSH	HL		;Save it
 	LD	HL,(RNDPNT)	;Get old location
 	INC	HL
 	LD	A,H
 	CP	30H		;Out of ROM?
 	JR	C,RAN10		;Nope
 	LD	H,0		;Yep
 RAN10	LD	(RNDPNT),HL	;Renew RNDPNT
 	LD	A,(HL)		;Get "Random" number
 	POP	HL		;Get original HL
 
 	RET
 
 	END	START
                                                                                                                                                                                                                                               