BABYBE ; #######################################################
 ; 10 INDIVIDUAL SOUND ROUTINES THAT USE BEEPER ROUTINE
 ; #######################################################
 	ORG	7D00H		; SOMEPLACE IN HIGH MEM.
 ; #######################################################
 ; SOUND ROUTINE #1 IMITATES FAMOUS PHASER EFFECT
 PHASER	LD	C,8		; NUMBER OF REPEATS
 LOOP01	LD	B,0C0H		; PITCH VALUE FOR SOUND
 	CALL	SOUND		; PLAY SOUND THROUGH PORT
 	PUSH	BC		; SAVE NUMBER OF REPEATS
 	DJNZ	$-0		; DELAY FOR EXISTING TIME
 	POP	BC		; GET NUMBER OF REPEATS
 	DJNZ	$-7		; REPEAT THE TOTAL SOUND
 	DEC	C		; REPEATS = REPEATS - 1
 	LD	A,C		; HOW MANY REPEATS LEFT?
 	AND	A		; SET THE FLAGS YEA / NAY
 	JR	NZ,LOOP01	; BACK IF MORE SOUNDS
 	RET			; DONE WITH THIS SOUND
 ; #######################################################
 ; SOUND ROUTINE #2 IS SIMILAR TO FAST, ZIPPING PHASER
 ZIPS	LD	C,10H
 	LD	HL,20H
 	CALL	SOUND
 	LD	B,0A0H
 	DJNZ	$-0
 	DEC	HL
 	LD	A,H
 	OR	L
 	JR	NZ,$-10
 	LD	HL,0A00H
 	DEC	HL
 	LD	A,H
 	OR	L
 	JR	NZ,$-3
 	DEC	C
 	LD	A,C
 	CP	0
 	JR	NZ,$-27
 	RET
 ; #######################################################
 ; SOUND ROUTINE #3 IS A GROUP OF IDENTICAL BOOPS IN A ROW
 BOOPS	LD	C,0AH
 	LD	B,30H
 	CALL	SOUND
 	PUSH	BC
 	LD	B,0FFH
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-9
 	LD	B,50H
 	CALL 	SOUND
 	PUSH	BC
 	LD	B,60H
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-9
 	DEC	C
 	LD	A,C
 	CP	0
 	JR	NZ,$-30
 	RET
 ; #######################################################
 ; SOUND ROUTINE #4 PLAYS A SHORT FANFARE-LIKE TUNE
 SAMPL	LD	B,40H
 	CALL	SOUND
 	PUSH	BC
 	LD	B,0C0H
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-9
 	LD	B,80H
 	CALL	SOUND
 	PUSH	BC
 	LD	B,50H
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-9
 	LD	B,0FFH
 	CALL	SOUND
 	PUSH	BC
 	LD	B,30H
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-9
 	LD	B,0B0H
 	CALL	SOUND
 	PUSH	BC
 	LD	B,0B0H
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-9
 	LD	B,0FFH
 	CALL	SOUND
 	PUSH	BC
 	LD	B,20H
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-9
 	LD	C,10H
 	LD	B,10H
 	CALL	SOUND
 	PUSH	BC
 	LD	B,0FFH
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-9
 	DEC	C
 	LD	A,C
 	CP	0
 	JR	Z,$+12
 	LD	HL,0A00H
 	DEC	HL
 	LD	A,H
 	OR	L
 	JR	NZ,$-3
 	JR	$-27
 	RET
 ; #######################################################
 ; SOUND ROUTINE #5 PRODUCES AN UPWARD-RISING SIREN SOUND
 SIREN	LD	C,8
 	LD	B,0
 	CALL	SOUND
 	PUSH	BC
 	INC	B
 	LD	A,B
 	OR	0
 	JR	NZ,$-4
 	POP	BC
 	INC	B
 	LD	A,B
 	OR	0
 	JR	NZ,$-15
 	LD	B,0FFH
 	CALL	SOUND
 	PUSH	BC
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-7
 	DEC	C
 	LD	A,C
 	CP	0
 	JR	NZ,$-34
 	RET
 ; #######################################################
 ; SOUND ROUTINE #6 MAKES A SINGLE, LOW-PITCHED BLOOP
 BLOOP	LD	B,80H
 	CALL	SOUND
 	PUSH	BC
 	LD	B,80H
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-9
 	RET
 ; #######################################################
 ; SOUND ROUTINE #7 MAKES A SINGLE, HIGH-PITCHED BLEEP
 BLEEP	LD	B,0C0H
 	CALL	SOUND
 	PUSH	BC
 	LD	B,40H
 	DJNZ	$-0
 	POP	BC
 	DJNZ	$-9
 	RET
 ; #######################################################
 ; SOUND ROUTINE #8 CREATES A FAMOUS RASPBERRY LOSER SOUND
 BUZZ	LD	C,20H
 	LD	HL,000AH
 	CALL	SOUND
 	LD	B,0FFH
 	DJNZ	$-0
 	DEC	HL
 	LD	A,H
 	OR	L
 	JR	NZ,$-10
 	LD	HL,0100H
 	DEC	HL
 	LD	A,H
 	OR	L
 	JR	NZ,$-3
 	DEC	C
 	LD	A,C
 	CP	0
 	JR	NZ,$-27
 	RET
 ; #######################################################
 ; SOUND SUBROUTINE SENDS LOW-LEVEL SOUND TO CASSETTE PORT
 SOUND	LD	A,(403DH)	; BASIC'S PORT 255 FLAG
 	AND	0FDH		; KEEP VIDEO VALUE INTACT
 	ADD	A,02		; SET AUDIO OUTPUT BIT
 	OUT	(0FFH),A	; SEND TO CASSETTE PORT
 	SUB	02		; RESET AUDIO OUTPUT BIT
 	OUT	(0FFH),A	; SEND TO CASSETTE PORT
 	RET			; THAT'S IT - ON AND OFF
 ; #######################################################
 	END	06CCH		; BASIC "READY" WHEN DONE
