; GETTIME - SET COMPUTER CLOCK USING ZTIME-1
;
; by: Ken Hipple
;     127 Plum Tree Road
;     Brandon, MS  39042
;     (601) 992-9965
;     CompuServe 74076,2331
;
; This program retrieves the time and date from the
; ZTIME-1 clock board made by Kenmore Computer Tech.;
; The time & date retrieved are then used to set the
; built-in Model III clock. The ZTIME-1 board does not
; really have a year register so the 100th's & 10th's of
; seconds latch register is used to hold the year.
;
	ORG	6000H
	LD	DE,4216H	;time & date storage - 1
	LD	BC,0622H	;B=# of registers
;				C=# of first clock port to
;				read if 20H is base addr.
LOOP	IN	A,(C)		;read value from ZTIME-1
	CALL	CONV		;convert to hex
	INC	DE
	LD	(DE),A		;store it
	INC	C
	DJNZ	LOOP
	DEC	DE		;now we need to set the
	DEC	DE		;year
	INC	C
	IN	A,(C)
	CALL	CONV
	LD	(DE),A
	LD	HL,DATE 	;display new time & date
	CALL	3033H
	INC	HL
	CALL	3036H
	LD	HL,DSPLY
	CALL	4467H
	RET
CONV	PUSH	AF		;Routine to convert a BCD
	AND	0F0H		;value to hexadecimal
	RRCA
	RRCA
	RRCA
	PUSH	AF
	POP	HL
	POP	AF
	SUB	H
	SUB	H
	SUB	H
	RET
DSPLY	DB	0AH
DATE	DEFM	'         '
TIME	DEFM	'        '
	DB	0DH
	END
 A