100 REM **** Z-TIME MBASIC SETDATE ROUTINE TO SET TIME AND DATE             ****
110 REM
120 REM Written by: Jerry Wagers
130 REM Date: 8 October 1086
140 REM 
150 REM This program is designed to be compiled with BASCOM and is to be    
160 REM used with TRS-80 Model 4, 4P or 4D machines running TRSDOS 6.x.
170 REM
180 REM LABEL "START" is the begining of the routine to capture the date and
190 REM from the keyboard. Label "SETUP" converts the ASCII characters into
200 REM BCD. Label "SETDATE" outputs the BCD data to the clock board and sets
210 REM the date and time.
220 REM
300 REM ***********************************************************************
310 REM * The following defines the variables and establishes the arrays and  *
320 REM * constants needed to program the Z-TIME board.                       *
330 REM ***********************************************************************
340 OPTION BASE 0
350 DIM TARRY%(6), TMP$(20), BDATE%(6) : DEFINT I,J
360 DAY$ = "SunMonTueWedThuFriSat"
370 MONTH$ = "JanFebMarAprMayJunJulAugSepOctNovDec"
380 POINTER$ = "BASE ADDRESS STORAGE AREA ------>"
390 CBASE% = &H20
400 POINTER1$ = "<------BASE ADDRESS STORAGE AREA"
410 REM ***********************************************************************
420 REM* Routine to capture date and time from keyboard and have operator     *
430 REM * choose moment to insert into clock timing.                          *
440 REM ***********************************************************************
450 '
460 CLS
470 PRINT "Z-TIME                         Version 3.0                   8 Jan 87 "
480 PRINT : PRINT "Based upon Alan D. Percy's 'C' program, written by Jerry Wagers"
490 PRINT "Copyright (C) 1986 WAGCOSOFT"
500 PRINT : PRINT "For use with KCT's Z-TIME1 and TRS-80 Model 4,4P & 4D computers"
510 PRINT "using TRSDOS 6.x.  BASE address is port 0020H"
520 PRINT : PRINT : PRINT "Press any key to continue....";
530 CHOICE$ = INKEY$ : IF CHOICE$ = "" GOTO 530
540 CLS
550 CHOICE$ = INKEY$ : PRINT : PRINT"1. RESET CLOCK"
560 PRINT : PRINT"2. GET DATE & TIME" : PRINT : PRINT : PRINT
570 PRINT"PRESS THE KEY CORRESPONDING TO THE NUMBER OF YOUR CHOICE: "
580 CHOICE$ = INKEY$ : IF CHOICE$ = "" GOTO 580
590 CHOICE% = VAL(CHOICE$) : ON CHOICE% GOTO 600,745
600 '
605 INPUT "Enter year digits (1987 = 87): ";TARRY%(6) : PRINT
610 INPUT "Enter Month (1-12): ";TARRY%(0) : PRINT
620 INPUT "Enter day of the Month (1-31): ";TARRY%(1) : PRINT
630 INPUT "Enter day of the Week (1-7, where Sunday = 1): ";TARRY%(2) : PRINT
640 INPUT "Enter hour (1-12): ";TARRY%(3) : PRINT
650 INPUT "Enter AM or PM: ";AMPM$ : PRINT
660    IF LEFT$(AMPM$,1) = "A" AND TARRY%(3) = 12 THEN TARRY%(3) = 0 : GOTO 680
670    IF LEFT$(AMPM$,1) <> "A" AND TARRY%(3) < 12 THEN TARRY%(3) = TARRY%(3)+12
680 INPUT "Enter Minute (0-59): ";TARRY%(4) : PRINT
690 INPUT "Enter seconds (0-59): ";TARRY%(5) : PRINT
700 GOSUB 770
710 CHOICE$ = INKEY$            'FLUSH INKEY LATCH
720 PRINT "Press any key when it is the exact time as stated: ";
730 CHOICE$ = INKEY$ : IF CHOICE$ = "" THEN GOTO 730
740 GOSUB 870
745 '
750 GOSUB 980
760 END
770 '
780 REM **********************************************************************
790 REM * Routine to convert the data input into BCD                         *
800 REM *                                                                    *
810 REM **********************************************************************
820 I = 0
830 FOR I = 0 TO 6
840   TARRY%(I) = INT(((TARRY%(I)\10)*16) OR (TARRY%(I)-(TARRY%(I)\10)*10))
850 NEXT I
860 RETURN
870 '
880 REM **********************************************************************
890 REM * Routine to update the clock chip with the BCD data from CONV.DTE   *
900 REM **********************************************************************
910 OUT CBASE%+&H12,&HFF               'Reset clock counters to 0
920  J=7
930 FOR I = 0 TO 5
940      OUT CBASE%+J,TARRY%(I)          'Reset clock ports on chip
950      J=J-1
960 NEXT I
965 OUT CBASE%+9,TARRY%(6)
970 RETURN
980 '
990 REM **************************************************
1000   REM *       Begining of Program  to Display Date   *
1010 REM **************************************************
1020 GOSUB 1080'get current date and time in ASCII
1030 CLS
1040 PRINT : PRINT
1050 PRINT "The current day, date and time is:    ";DTE$
1060 PRINT : PRINT
1070 RETURN
1080 '
1090 REM *************************************************
1100 REM * Get current date and time in ASCII into DTE$ *
1110 REM *************************************************
1120 DTE$=""           'null out string variable
1130 GOSUB 1390'get binary date and time
1140 IF BDATE%(3) < 1 OR BDATE%(3) > 7 THEN DTE$ = "*** " : GOTO 1170
1150 POINTER% = (BDATE%(3)*3)-2
1160 DTE$ = MID$(DAY$,POINTER%,3) + " "
1170 '
1180 IF BDATE%(1) < 1 OR BDATE%(1) > 12 THEN DTE$ = DTE$ + "***" : GOTO  1210
1190 POINTER% = (BDATE%(1)*3)-2
1200 DTE$ = DTE$ + MID$(MONTH$,POINTER%,3)
1210 '
1220 DTE$=DTE$+STR$(BDATE%(2))    'ADD IN DAY OF THE MONTH
1225 DTE$ = DTE$+","+STR$(BDATE%(0))
1230 IF BDATE%(4) < 12 THEN GOTO 1270  'SEE IF AM, JUMP IF SO.
1240 ZZFLAG%=-1                       'set pm flag
1250 IF BDATE%(4) > 12 THEN BDATE%(4)=BDATE%(4)-12   'convert to normal time
1260 GOTO 1300 'skip over else
1270 '
1280 ZZFLAG%=0                        'it's AM so clear PM flag
1290 IF BDATE%(4) = 0 THEN BDATE%(4)=12 'if 12 midnight make it 12 not 0
1300 '
1310 DTE$=DTE$+STR$(BDATE%(4))+":"  'add hours to print string
1320 IF BDATE%(5)<10 THEN DTE$=DTE$+"0"  'add leading zero
1330 DTE$=DTE$+MID$(STR$(BDATE%(5)),2)+":"  'put minutes on
1340 IF BDATE%(6)<10 THEN DTE$=DTE$+"0"   'add leading zero if required
1350 DTE$=DTE$+MID$(STR$(BDATE%(6)),2)    'put seconds on
1360 IF ZZFLAG% <> 0  THEN DTE$=DTE$+" PM"      'if pm put PM on
1370 IF  ZZFLAG% = 0 THEN DTE$=DTE$+" AM" 'if am put AM on
1380 RETURN
1390 '
1400 REM **************************************************
1410 REM * Get binary date and time into array BDATE%(1-6) *
1420 REM **************************************************
1430 REM
1440 REM First get Date and Time in BCD from chip.
1450 '
1460 FOR YYI%=1 TO 6
1470 BDATE%(YYI%)=INP(CBASE%+8-YYI%)    'get bcd value
1480 NEXT YYI%
1485 BDATE%(0) = INP(CBASE%+9)
1490 YYFLAG%=0                      'assume date is good and set otherwise
1500 FOR YYI%=1 TO 6                'read it again and make sure the are equal
1510 IF INP(CBASE%+8-YYI%) <> BDATE%(YYI%) THEN YYFLAG% = -1  'if not the same set flag
1520 NEXT YYI%
1525 BDATE%(0) = INP(CBASE%+9)
1530 IF YYFLAG% = -1 THEN GOTO 1450  'try it again if two read not the same
1540 FOR YYI%=0 TO 6                 'convert numbers from BCD to binary
1550 YYTMP%=INT(BDATE%(YYI%)/16)       'get left digit
1560 BDATE%(YYI%)=YYTMP%*10+BDATE%(YYI%)-YYTMP%*16 'all converted
1570 NEXT YYI%
1580 RETURN
D