00010 REM *****************************************************
00020 REM ****  ZBasic 3.0 Scientific Functions  10/14/85  ****
00030 REM **** Accuracy up to 50 digits, DBL & SCI set=54  ****
00040 REM **** SET SINGLE PRECISION FOR 50 DIGITS          ****
00050 REM *****************************************************
00060 REM ************ Constants used by Functions ************
00070 Log10v# = LOG(10.) : e# = EXP(1.)
00080 Pid4# = ATN(1.) : Pid2# = Pid4# << 1 : Pi# = Pid2# << 1
00090 REM ********** Sub-function used by functions ***********
00100 DEF FN Sqrxx#(x#) = SQR(x#*x#-1.)
00110 REM ******************* Other TRIG Functions ************
00120 DEF FN Sec#(x#)   = 1. \ COS(x#)
00130 DEF FN Csc#(x#)   = 1. \ SIN(x#)
00140 DEF FN Cot#(x#)   = 1. \ TAN(x#)
00150 REM ************** Inverse TRIG Functions ***************
00160 DEF FN ArcSin#(x#) = ATN( x# \ SQR( 1. - x# * x# ) )
00170 DEF FN ArcCos#(x#) = Pid2# - FN ArcSin#(x#)
00180 DEF FN ArcCsc#(x#) = ATN(1\FN Sqrxx#(x#))+(x#<0) * Pi#
00190 DEF FN ArcSec#(x#) = ATN(FN Sqrxx#(x#))+(SGN(x#)-1.)*Pid2
00200 DEF FN ArcCot#(x#) = Pid2# - ATN(x#)
00210 REM ************* Hyperbolic TRIG Functions *************
00220 DEF FN SinH#(x#) = (EXP(x#)-EXP(-x#)) >> 1.
00230 DEF FN CosH#(x#) = (EXP(x#)+EXP(-x#)) >> 1.
00240 DEF FN TanH#(x#) = 1.-2.*EXP(-x#)/(EXP(x#)+EXP(-x#))
00250 DEF FN SecH#(x#) = 2./(EXP(x#)+EXP(-x#))
00260 DEF FN CscH#(x#) = 2./(EXP(x#)-EXP(-x#))
00270 DEF FN CtnH#(x#) = (EXP(x#)+EXP(-x#))\(EXP(x#)-EXP(-x#))
00280 REM ********* Inverse Hyperbolic TRIG Functions *********
00290 DEF FN AsinH#(x#)= LOG(x#+SQR(x#*x#+1.))
00300 DEF FN AcosH#(x#)= LOG(x#+SQR(x#*x#-1.))
00310 DEF FN AtanH#(x#)= LOG((1.+x#)\(1.-x#)) >> 1.
00320 DEF FN AsecH#(x#)= LOG((SQR(1.-x#*x#)+1.)\x#)
00330 DEF FN AcscH#(x#)= LOG((SGN(x#)*SQR(x#*x#+1.)+1.)\x#)
00340 DEF FN AcotH#(x#)= LOG((x#+1.)\(x#-1.)) >> 1.
00350 REM **** Angle Conversions for RADIANS,DEGREES,BRADs ****
00360 DEF FN DegRad#(x#) =x#*Pid4#\90.
00370 DEF FN RadDeg#(x#) =x#*90\Pid4#
00380 DEF FN DegBrad#(x#)=x#*Pid4#\64.
00390 DEF FN BradDeg#(x#)=x#*64.\Pid4#
00400 DEF FN BradRad#(x#)=x#*1.40625 : REM * 1.40625 = 90/64 *
00410 DEF FN RadBrad#(x#)=x#*64.\90.
00420 REM ***************** LOG base 10 ***********************
00430 DEF FN Log10#(x#)= LOG(x#)/Log10v#
00440 REM ************Test Routine For Accuracy ***************
00450 DEFDBL A-Z
00460 FOR I=.01 TO .76 STEP .25
00470 TRONX : PRINT"Should be:";I#
00480 X!=FN ArcSin#(SIN(FN ArcCos#(COS(ATN(TAN(I#)))))):PRINTX!
00490 X!= FN ArcCot#(FN Cot#(FN AcotH#(FN CtnH#(I#)))):PRINTX!
00500 X!= FN AsecH#(FN SecH#(FN AcscH#(FN CscH#(I#)))):PRINTX!
00510 X!= FN AtanH#(FN TanH#(FN ArcCot#(FN Cot#(I#)))):PRINTX!
00520 X!= FN AcosH#(FN CosH#(FN ArcSec#(FN Sec#(I#)))):PRINTX!
00530 X!= FN AsinH#(FN SinH#(FN ArcCsc#(FN Csc#(I#)))):PRINTX!
00540 X!= FN DegRad(FN RadDeg(FN DegBrad(FN BradDeg(I#)))):PRINTX!
00550 X!= FN RadBrad(FN BradRad(10^FN Log10(I#))):PRINTX!
00560 TRONX:NEXT
