00001 ;
00002 ;	Modem/Xmodem protocol for interchange of programs
00003 ;	with the CP/M operating system. Employs the
00004 ;	"Christensen" protocol.
00005 ;
00006 ;	REQUIRES SVC TABLE INSTALLED IN SYSTEM WITH
00007 ;	THE CALL: SYSTEM (SVC)
00008 ;
00009 ;	Note entry into the routine is direct from the
00010 ;	terminal mode. The program prompts for the
00011 ;	filename to send/receive.
00012 ;
00013 ;	This segment makes no attempt to translate or
00014 ;	otherwise adjust the outgoing (or incoming) data
00015 ;	for the target/source system format. The user is
00016 ;	responsible for seeing to it that the data is
00017 ;	in the correct format for the transfer.
00018 ;
00019 ;	Comment (Copyright notice)
00020 	COMM	'XMODEM 3.1.1 Authored by Karl Denninger.
00021 	COMM	'  Released to the public domain 11/11/1984.
00022 ;
00023 SOH	EQU	1
00024 EOT	EQU	4
00025 ACK	EQU	6
00026 NAK	EQU	21
00027 CAN	EQU	24
00028 ;
00029 SECWT	EQU	15		; 15 SECONDS FOR TIMEOUT
00030 ;
00031 ;	Called subroutines:
00032 ;	Getchar		- Called to check on input
00033 ;			from the Rs-232 interface.
00034 ;	Send		- Called to send a character to
00035 ;			to other end.
00036 ;
00037 ;	Note that CP/M sends in 128-byte blocks, which
00038 ;	means that it is 2-for-1 on the TRS-80.
00039 ;	Due to this difference in record lengths, the
00040 ;	system treats the file(s) to send/receive as
00041 ;	a byte-stream of data. 1 record is buffered
00042 ;	by the segment (128 bytes). The last block is
00043 ;	padded with zeros if padding is needed.
00044 ;
00045 ;
00046 ;	Entry points:
00047 ;	SENDCPM	-	Send a file to another MODEM
00048 ;			system.
00049 ;	RECVCPM	- 	Receives a file from a MODEM
00050 ;			system.
00051 ;
00052 	ORG	0A000H		; THE STARTING POINT
00053 ;
00054 ;
00055 DUMMY	DL	DUMMY-$
00056 	IF	NOT,DUMMY
00057 	GET	SVC/ASM
00058 	ENIF
00059 ;
00060 SENDXY
00061 ;
00062 ;	ENTER HERE TO SEND A XMODEM FILE. (HL) MUST
00063 ;	CONTAIN THE FILESPEC TO SEND.
00064 ;
00065 	LD	A,@FSPEC
00066 	LD	DE,CPMDCB
00067 	RST	28H		; PARSE FILENAME
00068 	JP	NZ,CERROR	; FATAL ERROR IN FILENAME
00069 ;	LD	A,@FLAGS
00070 ;	RST	28H
00071 ;	SET	0,(IY+18)	; READ-ONLY
00072 	LD	A,@OPEN		; OPEN THE FILE
00073 	LD	DE,CPMDCB
00074 	LD	HL,CPMBUF
00075 	LD	B,0		; DO IT IN ANY CASE
00076 	RST	28H		; OK -- IT IS OPEN!
00077 	JP	NZ,CERROR	; OH OH -- SOMETHING IS
00078 				; WRONG!
00079 	LD	A,@GET
00080 	LD	DE,CPMDCB
00081 	RST	28H		; ATTEMPT TO READ 1 CHAR
00082 	JP	NZ,CERROR	; SOMETHING IS WRONG
00083 	LD	A,@REW
00084 	LD	DE,CPMDCB
00085 	RST	28H		; REWIND IF OK
00086 	CALL	WAIT5		; WAIT 5 SECONDS
00087 	CALL	SETOFF
00088 	LD	HL,STSMES
00089 	LD	A,@DSPLY
00090 	RST	28H
00091 	CALL	FLUSHBF		; FLUSH BUFFER
00092 WAIT10	CALL	GETCHAR		; WAIT FOR A NAK
00093 	CP	NAK		; SAME?
00094 	JR	Z,OKSND
00095 	CP	CAN		; CANCEL?
00096 	JP	Z,CANCPM
00097 	LD	A,@KBD
00098 	RST	28H
00099 	CP	80H
00100 	JP	Z,CANCPM	; CANCEL IF <BREAK>
00101 	JR	WAIT10
00102 OKSND	LD	A,1
00103 	LD	(BLOCK),A
00104 	XOR	A
00105 	LD	(LASTB),A
00106 FILL1	LD	HL,XMTBUF	; TRANSMIT BUFFER
00107 	LD	DE,XMTBUF+1
00108 	LD	A,0
00109 	LD	(HL),A
00110 	LD	BC,127
00111 	LDIR			; ZERO IT
00112 	XOR	A
00113 	LD	(CPMRET),A
00114 	LD	B,128
00115 	LD	HL,XMTBUF
00116 FILDC	LD	DE,CPMDCB
00117 	LD	A,@GET
00118 	RST	28H		; GET 1 CHARACTER
00119 	JP	NZ,DONXM
00120 	LD	(HL),A
00121 	INC	HL
00122 	DJNZ	FILDC
00123 SENDC	CALL	SENDBFR		; SEND A BUFFER UNTIL OK
00124 	LD	A,(LASTB)
00125 	OR	A
00126 	JP	NZ,ENDXMT
00127 	JR	FILL1
00128 SENDBFR	LD	A,SOH		; SEND SOH
00129 
00130 	CALL	SEND		; SEND IT
00131 	LD	A,(BLOCK)
00132 	CALL	SEND		; SEND BLOCK NUMBER
00133 	LD	A,(BLOCK)	; RELOAD IT
00134 	CPL			; COMPLEMENT ACCUM
00135 	CALL	SEND		; CHECK OF BLOCK NUMBER
00136 	LD	E,0		; STORE CHECKSUM
00137 	LD	B,128		; HOW MANY TO DO
00138 	LD	HL,XMTBUF	; PLACE TO GET FROM
00139 SDCPM1	LD	A,(HL)
00140 	ADD	A,E
00141 	LD	E,A
00142 	LD	A,(HL)		; RELOAD
00143 	PUSH	DE
00144 	PUSH	BC
00145 	CALL	SEND		; SEND IT
00146 	POP	BC		; RESTORE REGS
00147 	POP	DE
00148 	INC	HL
00149 	DJNZ	SDCPM1		; CONTINUE
00150 	LD	A,E
00151 	CALL	SEND		; SEND CHECKSUM
00152 	LD	B,SECWT		; 30 SECONDS TO WAIT
00153 WTOK	PUSH	BC		; SAVE COUNT
00154 	CALL	GETFROM		; GET ONE CHARACTER WITH
00155 				; TIMOUT
00156 	JR	Z,NOERX		; CHECK THE ONE WE GOT
00157 	POP	BC		; RESTORE COUNT
00158 	DJNZ	WTOK
00159 	JP	PERMER		; WE HAVE A PROBLEM
00160 NOERX	POP	BC		; FIX STACK
00161 	CP	CAN		; DO WE CANCEL?
00162 	JP	Z,CCCPM		; CANCEL XMIT
00163 	CP	ACK		; IS IT OK?
00164 	JR	NZ,CHKRET	; RETRIES IF NOT
00165 	LD	A,(BLOCK)	; ELSE NEXT BLOCK
00166 	INC	A
00167 	LD	(BLOCK),A
00168 	XOR	A		; SET ZERO FLAG
00169 	RET
00170 CHKRET	LD	A,(CPMRET)
00171 	INC	A		; INCREMENT IT
00172 	CP	10		; IS IT 10?
00173 	JR	Z,TOMRET	; PERMANENT ERROR
00174 	LD	(CPMRET),A
00175 	JR	SENDBFR
00176 TOMRET	LD	HL,TOMER
00177 	LD	A,@DSPLY
00178 	RST	28H
00179 	JP	CANCPM
00180 TOMER	DM	'! Cannot send block -- abort !',13
00181 CCCPM	LD	HL,CCPM
00182 	LD	A,@DSPLY
00183 	RST	28H
00184 PERMER	LD	HL,PERM
00185 	LD	A,@DSPLY
00186 	RST	28H
00187 	JP	CANCPM		; CANCEL FILESEND
00188 CCPM	DM	'! Transmission cancelled by receiving end !',13
00189 PERM	DM	10,'! Timeout waiting for ACK/NAK !',13
00190 STSMES	DM	'! Waiting for initial NAK -- ^X to cancel !',13
00191 GETFROM	CALL	GETCHAR		; CHECK FOR ONE NOW
00192 	RET	Z		; RETURN IF SO
00193 	PUSH	BC
00194 	LD	A,@PAUSE
00195 	LD	BC,32767
00196 	RST	28H		; WAIT 1/2 SEC.
00197 	POP	BC
00198 	CALL	GETCHAR
00199 	RET	Z
00200 	PUSH	BC
00201 	LD	A,@PAUSE
00202 	LD	BC,32767
00203 	RST	28H
00204 	POP	BC
00205 	CALL	GETCHAR
00206 	RET			; RETURN ANYWAYS!
00207 FLUSHBF	CALL	GETFROM		; CALL IT
00208 	RET	NZ
00209 	JR	FLUSHBF		; CONTINUE TILL NOTHING
00210 CANCPM	LD	A,CAN
00211 	CALL	SEND		; CALL THE SEND TO CANCEL
00212 	LD	A,@DSPLY
00213 	LD	HL,CANCDX
00214 	RST	28H
00215 	LD	HL,0FFFFH
00216 	JP	RETTER		; GO BACK TO TERMINAL
00217 CANCDX	DM	10,'! Transmit cancelled !',13
00218 CPMDCB	DS	32
00219 CPMBUF	DS	256
00220 XMTBUF	DS	129
00221 CPMFIL	DS	25
00222 DONXM	LD	A,0FFH
00223 	LD	(LASTB),A
00224 	JP	SENDC
00225 ENDXMT	LD	B,5		; TRY 5 TIMES
00226 ENDXM1	LD	A,EOT
00227 	CALL	SEND
00228 WTCRL	CALL	GETFROM
00229 	JR	NZ,XMW1		; RESEND IF NOTHING
00230 	CP	ACK		; ACK?
00231 	JR	Z,OKXT
00232 XMW1	DJNZ	ENDXM1
00233 	LD	HL,WRD
00234 	LD	A,@DSPLY
00235 	RST	28H
00236 OKXT	LD	A,@DSPLY
00237 	LD	HL,SDCCPM
00238 	RST	28H
00239 	LD	A,@CLOSE
00240 	LD	DE,CPMDCB
00241 	RST	28H
00242 	LD	HL,0
00243 	JP	RETTER
00244 ;
00245 CERROR	PUSH	AF		; SAVE ERROR CODE
00246 	LD	A,@DSPLY
00247 	LD	HL,DSSS
00248 	RST	28H
00249 LVN	POP	AF		; WE RESTORE
00250 	LD	C,A
00251 	SET	6,C
00252 	SET	7,C
00253 	LD	A,@ERROR
00254 	RST	28H		; PRINT ERROR MESSAGE
00255 	LD	A,@DSPLY
00256 	LD	HL,FRXN
00257 	RST	28H
00258 	LD	HL,0FFFFH	; ERROR!
00259 	JP	RETTER
00260 DSSS	DM	'? ',03
00261 FRXN	DM	'! Fatal error in Xmodem mode -- exit !',13
00262 SDCCPM	DM	'! Modem protocol filesend complete !',13
00263 BLOCK	DB	0
00264 OLDBIT7	DB	0
00265 LASTB	DB	0
00266 CPMRET	DB	0
00267 WRD	DM	'! Terminator not correct -- exiting anyway !',13
00268 RECVXY
00269 ;	ENTER HERE TO RECEIVE A XMODEM FILE. THE FILESPEC
00270 ;	MUST BE IN (HL).
00271 ;
00272 	LD	(STORHLX),HL	; SAVE FOR LATER
00273 	LD	A,@FSPEC
00274 	LD	DE,CPMDCB
00275 	RST	28H
00276 	JP	NZ,RXERROR	; RECIEVE ERROR
00277 ;	LD	A,@FLAGS
00278 ;	RST	28H
00279 ;	SET	0,(IY+18)	; SET READ ONLY
00280 	LD	A,@OPEN		; WE TRY AN OPEN FIRST
00281 	LD	DE,CPMDCB
00282 	LD	HL,CPMBUF
00283 	LD	B,0		; 0 LRL.
00284 	RST	28H		; OPEN IT.
00285 	JP	NZ,MAYROK	; MAY NOT EXIST.
00286 	JP	NOEXBAT
00287 MAYROK	CP	24		; FILE NOT HERE
00288 	JP	NZ,RXERROR	; RECEIVE ERROR
00289 MAYO3	LD	A,@FSPEC
00290 	LD	HL,(STORHLX)
00291 	LD	DE,CPMDCB
00292 	RST	28H
00293 	JP	NZ,RXERROR
00294 	LD	A,@INIT
00295 	LD	B,0
00296 	LD	HL,CPMBUF
00297 	LD	DE,CPMDCB
00298 	RST	28H		; ATTEMPT TO INIT
00299 	JP	NZ,RXERROR	; ERROR!
00300 	CALL	WAIT5		; WAIT 5 SECONDS
00301 	CALL	SETOFF
00302 	LD	HL,RDYRCV
00303 	LD	A,@DSPLY	; READY TO RECEIVE 
00304 	RST	28H
00305 	XOR	A		; RETRY COUNTER
00306 	LD	(COUNTR),A	; COUNTER LOAD
00307 	LD	A,1
00308 	LD	(BLOCK),A
00309 NAKIT	CALL	FLUSHBF		; FLUSH BUFFERS
00310 	LD	A,NAK
00311 	CALL	SEND		; SEND A <NAK>
00312 	LD	B,10		; WAIT 10 SECONDS
00313 WAITFOR	CALL	GETFROM
00314 	JP	Z,GOXIN		; WE GOT SOMETHING!
00315 	LD	A,@KBD
00316 	RST	28H
00317 	OR	A		; CHECK KB
00318 	JP	NZ,RXCAN
00319 	DJNZ	WAITFOR
00320 	LD	A,(COUNTR)
00321 	INC	A
00322 	CP	10		; 10 RETRIES?
00323 	JP	Z,RXCAN		; CANCEL RECEIVE
00324 	LD	(COUNTR),A
00325 	JR	NAKIT		; NAK IT AGAIN!
00326 RXCAN	CALL	GETFROM		; GET ONE CHAR
00327 	JR	Z,RXCAN
00328 	LD	A,CAN
00329 	CALL	SEND
00330 	LD	HL,RXCCAN
00331 	LD	A,@DSPLY
00332 	RST	28H
00333 	LD	A,@KILL
00334 	LD	DE,CPMDCB
00335 	RST	28H		; KILL THE FILE
00336 	LD	HL,CNC
00337 	LD	A,@DSPLY
00338 	RST	28H
00339 	CALL	FLUSHBF
00340 	LD	HL,0FFFFH
00341 	JP	RETTER
00342 CNC	DM	'! Receive cancelled, incomplete file deleted. !',13
00343 GOXIN	PUSH	AF
00344 	XOR	A
00345 	LD	(COUNTR),A
00346 	POP	AF
00347 GOXMOR	CP	EOT		; END OF TRANSMIT
00348 	JP	Z,ENDRCV
00349 	CP	SOH		; IS IT SOH?
00350 	JP	Z,SOHX		; GO GET BLOCK
00351 	CP	CAN		; CANCEL?
00352 	JP	Z,RXCAN
00353 	JP	RESEND
00354 SOHX	LD	HL,CPMI		; CLEAR INPUT BUFFER
00355 	LD	DE,CPMI+1
00356 	LD	BC,127		; WE ZERO 128 BYTES
00357 	XOR	A
00358 	LD	(HL),A
00359 	LDIR			; ZERO IT
00360 	CALL	GETFROM		; GET THE NEXT ONE
00361 	JP	NZ,TIMOR	; TIMEOUT RECEIVE
00362 	LD	B,A
00363 	LD	A,(BLOCK)	; WE GET BLOCK NUMBER
00364 	CP	B
00365 	JP	Z,BLKOK		; THE BLOCK NUMBER IS OK
00366 	DEC	A		; CHECK THIS ONE TOO
00367 	CP	B
00368 	JP	Z,RECVIGN	; IT'S A REPEAT
00369 	JP	LOST
00370 RECVIGN	CALL	FLUSHBF		; WAIT FOR LINE TO CLEAR
00371 	LD	A,ACK
00372 	CALL	SEND
00373 	JP	CONTMX
00374 BLKOK	CALL	GETFROM
00375 	JP	NZ,TIMOR
00376 	CPL
00377 	LD	B,A
00378 	LD	A,(BLOCK)
00379 	CP	B
00380 	JP	Z,CONV		; WE ARE OK!
00381 	DEC	A
00382 	CP	B		; CHECK LAST ONE
00383 	JP	Z,RECVIGN
00384 	JP	LOST
00385 CONV	LD	B,128		; 128 BYTES/RECORD
00386 	LD	C,0		; INITIALIZE CHECKSUM
00387 	LD	HL,CPMI
00388 RECV1	CALL	GETFROM
00389 	JP	NZ,RESEND	; RE-SEND (NOT ENOUGH)
00390 	LD	(HL),A
00391 	INC	HL
00392 	ADD	A,C
00393 	LD	C,A
00394 	LD	A,@KBD
00395 	RST	28H		; SCAN KEYBOARD
00396 	CP	80H		; IS IT A <BREAK>?
00397 	JP	Z,RXCAN
00398 	DJNZ	RECV1
00399 GETCK	CALL	GETFROM
00400 	JP	NZ,RESEND	; SOMETHING GOT LOST
00401 	CP	C		; CHECK IT
00402 	JP	NZ,RESEND	; RE SEND BLOCK
00403 	LD	B,128
00404 	LD	HL,CPMI
00405 WRITI	LD	A,@PUT
00406 	LD	DE,CPMDCB
00407 	LD	C,(HL)
00408 	PUSH	BC
00409 	PUSH	HL
00410 	RST	28H
00411 	POP	HL
00412 	POP	BC
00413 	JP	NZ,RXERROR
00414 	INC	HL
00415 	DJNZ	WRITI
00416 	LD	A,ACK
00417 	CALL	SEND
00418 	LD	A,(BLOCK)
00419 	INC	A
00420 	LD	(BLOCK),A
00421 CONTMX	CALL	GETFRX
00422 	JP	NZ,TIMOR	; TIMOUT ON RECEIVE
00423 	JP	GOXMOR
00424 ;
00425 TIMOR	LD	A,@KILL
00426 	LD	DE,CPMDCB
00427 	RST	28H
00428 	LD	HL,TIMORX
00429 	LD	A,@DSPLY
00430 	RST	28H
00431 	LD	HL,0FFFFH
00432 	JP	RETTER
00433 TIMORX	DM	'! Timeout during receive - incomplete file deleted. !',13
00434 ;
00435 ;
00436 RDYRCV	DM	'! File open, ready to receive !',10
00437 	DM	'! Type ^X to cancel before transmission begins !',13
00438 ENDRCV	LD	A,@CLOSE
00439 	LD	DE,CPMDCB
00440 	RST	28H
00441 	LD	A,@DSPLY
00442 	LD	HL,FILCOM
00443 	RST	28H
00444 	LD	A,ACK
00445 	CALL	SEND
00446 	JP	RETTER
00447 FILCOM	DM	'! Modem protocol file received. !',13
00448 RXERROR
00449 	PUSH	AF
00450 	LD	A,@DSPLY
00451 	LD	HL,RXERM
00452 	RST	28H
00453 	POP	AF
00454 	JP	CERROR		; ERROR HANDLING
00455 RXERM	DM	'! ? Disk error during receive -- message follows !',13
00456 CPMI	DS	129
00457 COUNTR	DB	0
00458 RXCCAN	DM	10,'! Cancelling receive. !',13
00459 ;
00460 ;
00461 LOST	JR	RESEND		; TRY AGAIN.
00462 RESEND	LD	A,(COUNTR)
00463 	INC	A
00464 	LD	(COUNTR),A
00465 	CP	10		; 10 RETRIES?
00466 	JR	Z,RESOUT
00467 	CALL	FLUSHBX		; CLEAR INPUT
00468 	LD	A,NAK
00469 	CALL	SEND
00470 	CALL	GETFRX
00471 	JP	NZ,TIMOR
00472 	JP	GOXMOR
00473 RESOUT	LD	HL,RESX
00474 	LD	A,@DSPLY
00475 	RST	28H
00476 	JP	RXCAN
00477 GETFRX	PUSH	BC
00478 	LD	B,SECWT		; USE RETRIES COUNTS
00479 FFX	CALL	GETFROM
00480 	JR	Z,GOB		; RETURN IF THERE IS ONE
00481 	DJNZ	FFX		; CONTINUE TILL DONE
00482 	XOR	A
00483 	CP	1
00484 	POP	BC
00485 	RET			; RETURN WITH NZ RESULT
00486 GOB	POP	BC
00487 	RET			; RETURN WITH IT
00488 RESX	DM	'! ? Block cannot be received !',13
00489 FLUSHBX	CALL	GETFROM		; GET ONE WITH TIMEOUT
00490 	RET	NZ		; RETURN IF NOTHING
00491 	JR	FLUSHBX		; CONTINUE
00492 NOEXBAT	LD	A,@DSPLY
00493 	LD	HL,BATMX
00494 	RST	28H
00495 	LD	HL,0FFFFH
00496 	JP	RETTER
00497 BATMX	DM	'! ? Xmodem receive file exists - ABORT !',13
00498 STORHLX	DW	0		; PLACE TO SAVE POINTER
00499 ;
00500 ;
00501 ;
00502 START	LD	DE,PLACE
00503 	LD	BC,50
00504 	LDIR			; MOVE IT TO A SAFE PLACE
00505 	LD	HL,XMODEM
00506 	LD	A,@DSPLY
00507 	RST	28H
00508 	LD	HL,PLACE
00509 	LD	A,(HL)
00510 	CP	13		; CHECK IT OUT
00511 	CALL	Z,GETPARMS
00512 	LD	HL,PLACE	; CHECK IT OUT
00513 	LD	B,80		; WE CHECK 80 CHARS
00514 CHKIT	LD	A,(HL)		; CHECK IT OUT
00515 	CP	13		; <ENTER>
00516 	JR	Z,CXX		; NOTHING
00517 	CP	3
00518 	JR	Z,CXX		; NOTHING
00519 	CP	'('		; OPEN PAREN'S?
00520 	JR	Z,GETCCC
00521 	INC	HL
00522 	DJNZ	CHKIT
00523 	JR	CXX
00524 GETCCC	LD	DE,DEVNAME
00525 	INC	HL
00526 	LD	B,3
00527 MOVIT	LD	A,(HL)
00528 	LD	(DE),A
00529 	INC	HL
00530 	INC	DE
00531 	DJNZ	MOVIT
00532 CXX	LD	A,@FSPEC
00533 	LD	DE,DCB
00534 	LD	HL,DEVNAME
00535 	RST	28H		; MOVE THE DEVICE NAME
00536 	LD	A,@OPEN
00537 	LD	DE,DCB
00538 	LD	HL,BUFFER
00539 	LD	B,0		; OPEN IT
00540 	RST	28H		; DO IT!
00541 	JP	NZ,NODEV	; NO DEVICE OF THAT NAME
00542 	LD	HL,PLACE
00543 	LD	A,(HL)		; CHECK IT AGAIN!
00544 	CP	13		; <RET>?
00545 	JP	Z,EXIT1		; LEAVE IF SO
00546 	AND	0DFH
00547 	CP	'S'		; SEND?
00548 	JP	Z,SENDCPM	; SEND IF SO
00549 	CP	'R'		; RECEIVE?
00550 	JP	Z,RECVCPM	; GO TO IT IF SO
00551 	LD	A,@DSPLY
00552 	LD	HL,NOTLEG
00553 	RST	28H
00554 EXIT1	LD	A,@EXIT
00555 	LD	HL,0
00556 	RST	28H
00557 NOTLEG	DM	'? Not a legal option. Options are:',10
00558 	DM	'  S filename  - send a file to your end',10
00559 	DM	'  R filename  - receive a file from your end',10
00560 	DM	10,'  Please try again.',13
00561 ;
00562 OKGO
00563 	PUSH	HL
00564 	LD	HL,(4475H+10)
00565 	LD	(OLDIY),HL
00566 	LD	HL,INTHDL
00567 	LD	(4475H+10),HL
00568 	POP	HL
00569 	RET
00570 ;
00571 SENDCPM	INC	HL		; SKIP NEXT
00572 	INC	HL
00573 	CALL	OKGO		; GO ATTACH THE RS-232
00574 	LD	(OLDSTK),SP	; SAVE STACK
00575 	JP	SENDXY		; SEND THE FILE
00576 RECVCPM	INC	HL
00577 	INC	HL
00578 	CALL	OKGO
00579 	LD	(OLDSTK),SP	; SAVE STACK
00580 	JP	RECVXY
00581 DCB	DS	32
00582 BUFFER	DS	256
00583 PLACE	DS	64
00584 NODEV	LD	A,@DSPLY
00585 	LD	HL,NODVR
00586 	RST	28H
00587 	LD	HL,0FFFFH
00588 	RET			; NO DEVICE OF THAT NAME
00589 NODVR	DM	'? No RS-232 device available.',13
00590 XMODEM	DM	10,10
00591 	DM	'** XMODEM TRS-80 Version 3.0.0',10
00592 	DM	'   Model III LDOS version',10
00593 	DM	'   Written by Karl Denninger',10
00594 	DM	'   Released to public domain',10,13
00595 DEVNAME	DM	'*RS',13
00596 GETPARMS
00597 	LD	HL,PARIN
00598 	LD	A,@DSPLY
00599 	RST	28H
00600 	LD	HL,PLACE
00601 	LD	B,50
00602 	LD	A,@KEYIN
00603 	RST	28H
00604 	JP	C,LXV
00605 	LD	A,B
00606 	OR	A
00607 	JP	Z,LXV
00608 	RET			; RETURN TO THE PLACE.
00609 PARIN	DM	'Enter direction, filename, and device as:',10,10
00610 	DM	'S filename (*XX)',10
00611 	DM	'     or',10
00612 	DM	'R filename (*XX)',10
00613 	DM	10,'Instructions? ',14,03
00614 LXV	POP	AF		; RESTORE OLD PLACE
00615 	LD	HL,0FFFFH
00616 	RET			; RETURN TO CALLER
00617 RETTER	PUSH	HL
00618 	LD	C,4
00619 	LD	IY,(OLDIY)
00620 	LD	(4475H+10),IY
00621 	CALL	WAIT5
00622 	CALL	SETON
00623 	LD	HL,DSPX
00624 	LD	A,@DSPLY
00625 	RST	28H
00626 	POP	HL
00627 	LD	SP,(OLDSTK)
00628 	RET			; RETURN TO CALLER
00629 DSPX	DM	10,'% Exiting',13
00630 OLDSTK	DW	0
00631 OLDIY	DW	0		; OLD IY LOCATION
00632 INTHDL	DI			; NOT RE-ENTRANT!
00633 	PUSH	DE
00634 	PUSH	HL
00635 	PUSH	AF
00636 	PUSH	BC
00637 	LD	DE,(BUFPOS)
00638 	INC	DE
00639 	LD	HL,(POSOF)
00640 	XOR	A
00641 	SBC	HL,DE
00642 	LD	A,H
00643 	OR	L
00644 	JR	Z,NORES
00645 	LD	HL,(POSIT)
00646 	IN	A,(0EBH)
00647 	LD	(HL),A
00648 	INC	HL
00649 	LD	(POSIT),HL
00650 	LD	HL,(BUFPOS)
00651 	INC	HL
00652 	LD	(BUFPOS),HL
00653 	LD	DE,(LASTW)	; LAST LEGAL WORD
00654 	XOR	A
00655 	SBC	HL,DE
00656 	LD	A,H
00657 	OR	L
00658 	JR	NZ,NORES
00659 	LD	HL,INTBUF
00660 	LD	(POSIT),HL
00661 	LD	DE,0
00662 	LD	(BUFPOS),DE
00663 NORES	POP	BC
00664 	POP	AF
00665 	POP	HL
00666 	POP	DE
00667 	RET
00668 POSIT	DW	INTBUF
00669 BUFPOS	DW	0
00670 POSOF	DW	0
00671 POSRED	DW	INTBUF
00672 ;
00673 GETCHAR
00674 	PUSH	HL
00675 	PUSH	DE
00676 	PUSH	BC
00677 	PUSH	AF
00678 	DI
00679 	LD	HL,(BUFPOS)
00680 	LD	DE,(POSOF)
00681 	XOR	A
00682 	SBC	HL,DE
00683 	LD	A,H
00684 	OR	L		; CHECK TO SEE IF SAME
00685 	JR	Z,NOCHAR
00686 	INC	DE
00687 	LD	(POSOF),DE
00688 	LD	HL,(POSRED)
00689 	LD	C,(HL)
00690 	INC	HL
00691 	LD	(POSRED),HL
00692 	LD	HL,(POSOF)
00693 	LD	DE,(LASTW)
00694 	XOR	A
00695 	SBC	HL,DE
00696 	LD	A,H
00697 	OR	L
00698 	JR	NZ,NORESX
00699 	LD	HL,INTBUF
00700 	LD	(POSRED),HL
00701 	LD	DE,0
00702 	LD	(POSOF),DE
00703 NORESX	POP	AF
00704 	LD	A,C
00705 	POP	BC
00706 	POP	DE
00707 	POP	HL
00708 	CP	A
00709 	EI
00710 	RET
00711 NOCHAR	POP	AF
00712 	POP	BC
00713 	POP	DE
00714 	POP	HL
00715 	LD	A,0
00716 	CP	1
00717 	EI
00718 	RET
00719 BKMK	DB	0
00720 SEND	PUSH	AF
00721 	PUSH	BC
00722 	PUSH	DE
00723 	PUSH	AF
00724 WAITIII	IN	A,(0EAH)
00725 	BIT	6,A
00726 	JR	Z,WAITIII
00727 	POP	AF
00728 	OUT	(0EBH),A
00729 	POP	DE
00730 	POP	BC
00731 	POP	AF
00732 	RET			; RETURN TO CALLER
00733 SETOFF	RET			; RETURN
00734 SETON	RET
00735 SETOF	DM	'Setcom (break=0,word=8)',13
00736 SETO	DM	'Setcom (break=3)',13
00737 LASTW	DW	256		; THE LAST PLACE (SUPPOSEDLY)
00738 INTBUF	DB	0
00739 	DS	257
00740 ;
00741 TTON	DM	'TTY CRT',13
00742 TTOF	DM	'TTY OFF',13
00743 WAIT5	PUSH	BC
00744 	PUSH	AF
00745 	PUSH	DE
00746 	LD	B,4
00747 WT1	PUSH	BC
00748 	LD	BC,60000
00749 	LD	A,@PAUSE
00750 	RST	28H
00751 	POP	BC
00752 	DJNZ	WT1
00753 	POP	DE
00754 	POP	AF
00755 	POP	BC
00756 	RET
00757 	END	START
