SXMODEM00010 ;
00020 ;	Source Filename:	XMODEM/SRC
00030 ;	Object Filename:	XMODEM/CMD
00040 ;
00050 ;	Program Author:		Steven Bradley
00060 ;	Creation Date:		01-27-84
00070 ;	Version:		2.02
00080 ;
00090 ;	Last changed on:	06-05-84
00100 ;
00110 ;	This program is supplied for your personal and
00120 ;	non-commercial use only.  No commercial use is
00130 ;	permitted.   Any  distribution  for profit  is
00140 ;	prohibited.  Distribution  to any  system that
00150 ;	charges  for  computer  access  is  prohibited
00160 ;	unless  written permission  has been  obtained
00170 ;	from the program author.
00180 ;
00190 ;	Please send problem reports and suggestions
00200 ;
00210 ;	To:	Steven Bradley
00220 ;		121 Cambridge Drive
00230 ;		Longwood, Florida  32779
00240 ;
00250 ;	Or call (305) 788-1968
00260 ;
00270 XKEY	EQU	0		; Bit for the 'X' key
00280 SOH	EQU	1		; Start of header
00290 BRKKEY	EQU	2		; Break key bit
00300 EOL	EQU	3		; End of line
00310 EOT	EQU	4		; End of transmission
00320 DWNARR	EQU	4		; Down arrow pressed
00330 ACK	EQU	6		; Acknowledge
00340 BELL	EQU	7		; Ding-dong!
00350 BCKSPC	EQU	8		; Backspace
00360 LF	EQU	10		; Linefeed
00370 CR	EQU	13		; Carriage return
00380 ILLFNM	EQU	19		; Illegal filename error
00390 INPBYT	EQU	19		; Input byte routine
00400 NAK	EQU	21		; Negative acknowledge
00410 CANCEL	EQU	24		; Cancel (ctrl-x)
00420 OUTBYT	EQU	27		; Output byte routine
00430 EOF	EQU	28		; End of file error
00440 LCTOUC	EQU	32		; Lower to uppercase
00450 SPACE	EQU	32		; Space
00460 COMMA	EQU	44		; Comma
00470 CHROUT	EQU	51		; Character to crt
00480 FEXIST	EQU	53		; File exists error
00490 OUTMEM	EQU	59		; Out of memory
00500 INPUT	EQU	40H		; Line input routine
00510 MODEL3	EQU	49H		; Test for model III
00520 LCCHAR	EQU	60H		; Test for lowercase char
00530 CONFIG	EQU	6DH		; 8-1-N configuration
00540 HIGH	EQU	80H		; Bit 7 value
00550 RETURN	EQU	0C9H		; Return instr.
00560 MR	EQU	0E8H		; Master reset (rs232)
00570 MODEM	EQU	0E8H		; Modem status port
00580 CARDET	EQU	5		; Carrier detect
00590 BAUD	EQU	0E9H		; Set baud location
00600 RSCTRL	EQU	0EAH		; RS232 control port
00610 STATUS	EQU	0EAH		; RS232 status port
00620 DRECVD	EQU	7		; Data received
00630 XEMPTY	EQU	6		; Transmit buffer empty
00640 OVRERR	EQU	5		; Over-run error
00650 FRMERR	EQU	4		; Framing error
00660 RSDATA	EQU	0EBH		; RS232 data port
00670 PORT	EQU	0FEH		; Custom options port
00680 M1OR3	EQU	125H		; Model I/III addr check
00690 VIDEO3	EQU	473H		; Model III video driver
00700 P10TBL	EQU	13D8H		; Powers of ten table
00710 XYZVEC	EQU	3808H		; XYZ keyboard vector
00720 CTLVEC	EQU	3840H		; Control keys
00730 SHIFT	EQU	3880H		; Shift key
00740 VIDDCB	EQU	401EH		; Video DCB
00750 DOS	EQU	402DH		; DOS exit
00760 NMSERR	EQU	4030H		; No message error exit
00770 HIMEM1	EQU	4049H		; Model I himem
00780 ERROR	EQU	4409H		; Error exit
00790 HIMEM3	EQU	4411H		; Model III himem
00800 GFSPEC	EQU	441CH		; Get filespec
00810 OPENN	EQU	4420H		; Open new file
00820 OPENE	EQU	4424H		; Open old file
00830 CLOSE	EQU	4428H		; Close file
00840 KILL	EQU	442CH		; Kill file
00850 MSGOUT	EQU	4467H		; Display message
00860 ORIGIN	EQU	5300H		; Origin of program
00870 STACK	EQU	ORIGIN		; Stack location
00880 ;
00890 BR50	EQU	0		; Baud rate values
00900 BR75	EQU	11H
00910 BR110	EQU	22H
00920 BR135	EQU	33H
00930 BR150	EQU	44H
00940 BR300	EQU	55H
00950 BR600	EQU	66H
00960 BR1200	EQU	77H
00970 BR1800	EQU	88H
00980 BR2000	EQU	99H
00990 BR2400	EQU	0AAH
01000 BR3600	EQU	0BBH
01010 BR4800	EQU	0CCH
01020 BR7200	EQU	0DDH
01030 BR9600	EQU	0EEH
01040 BR1920	EQU	0FFH
01050 ;
01060 	ORG	ORIGIN
01070 ;
01080 START	PUSH	HL		; Save command pointer
01090 	LD	HL,(HIMEM1)	; Model I addresses
01100 	LD	DE,VIDEO1
01110 	LD	BC,3000H
01120 	LD	A,(M1OR3)	; Check model
01130 	CP	MODEL3		; Is it a model III?
01140 	JR	NZ,CM1OR3	; No, a model I
01150 	LD	HL,(HIMEM3)	; Model III addresses
01160 	LD	DE,VIDEO3
01170 	LD	BC,4000H
01180 CM1OR3	LD	(NEWDVR),DE	; Store video driver
01190 	LD	(RSIDLY),BC	; and input delay
01200 	LD	DE,ENDPGM	; Get end of pgm addr
01210 	OR	A		; Clear carry
01220 	SBC	HL,DE		; Enough memory?
01230 	POP	HL		; Restore command pointer
01240 	LD	A,OUTMEM	; Out of memory err code
01250 	JP	C,ERROR		; and take error exit
01260 	XOR	A		; Turn off any custom
01270 	OUT	(PORT),A	; port 254 options
01280 	LD	(STKSAV),SP	; Save stack pointer
01290 	LD	SP,STACK	; and set new stack
01300 	PUSH	HL
01310 	CALL	ILPRNT
01320 	DEFB	LF
01330 	DEFM	'XMODEM File Transfer Utility - Version 2.02 / June 5, 1984'
01340 	DEFB	LF
01350 	DEFM	'Written by Steven Bradley.     *** Not for sale. ***'
01360 	DEFB	CR
01370 	POP	HL
01380 GETOPT	LD	A,(HL)		; Get option
01390 	CP	CR		; CR?
01400 	JP	NZ,CHKOPT	; No, so check the option
01410 BADOPT	CALL	ILPRNT		; Missing or bad option
01420 	DEFB	LF
01430 	DEFB	BELL
01440 	DEFM	'Parameters available are:'
01450 	DEFB	LF
01460 	DEFB	LF
01470 	DEFM	'Receive a new file:               R {filename}'
01480 	DEFB	LF
01490 	DEFM	'Send an existing file:            S {filename}'
01500 	DEFB	LF
01510 	DEFM	'Initialize the RS232 interface:   I {=baud rate}'
01520 	DEFB	CR
01530 	IN	A,(MODEM)	; Check for carrier
01540 	BIT	CARDET,A	; Any present?
01550 	JP	Z,EXIT		; Yes, so skip this cmd
01560 	CALL	ILPRNT
01570 	DEFM	'Direct transfer, no modems:       X'
01580 	DEFB	CR
01590 EXIT	LD	SP,(STKSAV)	; Restore system stack
01600 	JP	DOS		; and exit to DOS
01610 ;
01620 CHKOPT	CP	LCCHAR		; Is it lowercase?
01630 	JR	C,NOTLCO	; No, do not convert
01640 	SUB	LCTOUC		; Make it uppercase
01650 NOTLCO	LD	(OPTSAV),A	; Save option
01660 	CP	'R'		; Receive?
01670 	JR	Z,RECSND
01680 	CP	'S'		; Send?
01690 	JR	Z,RECSND
01700 	CP	'I'		; Initialize RS232 board?
01710 	JP	Z,RSINIT
01720 	PUSH	AF
01730 	IN	A,(MODEM)	; Check for carrier
01740 	BIT	CARDET,A	; any present?
01750 	JP	Z,BADOPT	; Yes, so bad option
01760 	POP	AF
01770 	CP	'X'		; Direct transfer?
01780 	JP	Z,NMDMCK
01790 	JP	BADOPT		; Bad option
01800 ;
01810 FNDCHR	INC	HL		; Point to next character
01820 	LD	A,(HL)		; Get the char.
01830 	CP	SPACE		; Is it a space?
01840 	JR	Z,FNDCHR	; Yes, so look some more
01850 	CP	COMMA		; Is it a comma?
01860 	JR	Z,FNDCHR	; Yes, so look some more
01870 	CP	CR		; Set Z flag if CR
01880 	RET			; and return
01890 ;
01900 FNDOPT	CALL	FNDCHR		; Get next character
01910 	JP	Z,EXIT		; If CR, end options chk
01920 	JP	GETOPT		; Go to normal checking
01930 ;
01940 RECSND	CALL	FNDCHR		; Get next character
01950 	JP	NZ,GFILE	; If not CR, go get file
01960 	DEC	HL		; HL=HL-1
01970 	LD	(CMDPTR),HL	; Save command pointer
01980 	LD	A,(OPTSAV)	; Get option key
01990 	CP	'R'		; Receive?
02000 	JR	NZ,ASDMSG	; No, ask for send name
02010 	CALL	ILPRNT
02020 	DEFB	LF
02030 	DEFM	'Receiving'
02040 	DEFB	EOL
02050 	JR	ASKNAM		; Go finish question
02060 ;
02070 ASDMSG	CALL	ILPRNT		; Ask for send name
02080 	DEFB	LF
02090 	DEFM	'Sending'
02100 	DEFB	EOL
02110 ASKNAM	CALL	ILPRNT		; Finish question
02120 	DEFM	' - Enter filename:  '
02130 	DEFB	BELL
02140 	DEFB	EOL
02150 	LD	B,23		; Max of 23 characters
02160 	LD	HL,DSKBUF	; into disk buffer (temp)
02170 	CALL	INPUT		; Get filename
02180 	JP	C,EXIT		; If break - exit
02190 	LD	A,(HL)		; Check for no input
02200 	CP	CR		; CR only?
02210 	JP	Z,EXIT		; Yes - exit
02220 	XOR	A		; Set entry status
02230 GFILE	PUSH	AF		; Save entry status
02240 	LD	DE,FILE		; Get filename
02250 	CALL	GFSPEC		; Create filespec
02260 	JR	Z,NAMEOK	; If no error, else
02270 	LD	A,ILLFNM+HIGH	; must be bad name
02280 	CALL	ERROR		; Display error
02290 	JP	EXIT		; and abort
02300 ;
02310 NAMEOK	POP	AF		; Get entry status
02320 	JR	Z,XOPEN		; If asked for name
02330 	DEC	HL		; HL=HL-1
02340 	LD	(CMDPTR),HL	; Save command pointer
02350 XOPEN	PUSH	DE
02360 	LD	B,23		; Format filename for
02370 	LD	HL,FNAME	; displaying later
02380 XOPENL	LD	A,(DE)
02390 	CP	EOL
02400 	JR	Z,XOPENM
02410 	CP	CR
02420 	JR	Z,XOPENM
02430 	CP	'A'
02440 	JR	C,CHROK
02450 	OR	LCTOUC
02460 	SUB	LCTOUC
02470 CHROK	LD	(HL),A
02480 	INC	DE
02490 	INC	HL
02500 	DJNZ	XOPENL
02510 XOPENM	LD	(HL),CR
02520 	POP	DE
02530 	LD	B,0		; LRL=256
02540 	LD	HL,DSKBUF	; Sector buffer
02550 	LD	A,(OPTSAV)	; Get option key
02560 	CP	'R'		; Is it receive?
02570 	JR	NZ,OPENSF	; No, it is send
02580 	CALL	OPENN		; Open new file
02590 	JR	Z,RFOPEN	; Go if no error
02600 OPNERR	OR	HIGH		; Make it CALLable
02610 	CALL	ERROR		; Display error
02620 	JP	EXIT		; and abort
02630 ;
02640 RFOPEN	JR	C,RECEIV	; Go if new file created
02650 	CALL	CLOSEF		; else close file because
02660 	LD	A,FEXIST	; file already exists err
02670 	JR	OPNERR		; Display error and exit
02680 ;
02690 OPENSF	CALL	OPENE		; Open existing file
02700 	JP	Z,SEND		; Go to send if no error
02710 	JR	OPNERR		; Show error and exit
02720 ;
02730 RECEIV	LD	HL,FMSG
02740 	CALL	MSGOUT
02750 	CALL	ILPRNT
02760 	DEFB	LF
02770 	DEFM	'Enter ctrl-x to abort file transfer.'
02780 	DEFB	LF
02790 	DEFB	LF
02800 	DEFM	'Ready to receive - awaiting transmission.'
02810 	DEFB	CR
02820 	CALL	INITRS		; Receive-send init
02830 	XOR	A		; Zero first block
02840 	LD	(FIRST),A	; SOH found status
02850 	LD	A,NAK		; Send a negative
02860 	CALL	CRSOUT		; acknowledge
02870 RECFIL	CALL	INCBLK		; Increment block count
02880 	CALL	RECBKS		; Receive a block
02890 	JR	C,RECEND	; Go if end of file
02900 	LD	A,(BLOCKS)	; Increment the
02910 	INC	A		; number of
02920 	LD	(BLOCKS),A	; transferred
02930 	CP	20		; Have there been 20?
02940 	CALL	Z,SAVBLK	; Yes, so save the blocks
02950 	CALL	SNDACK		; Send acknowledge
02960 	JR	RECFIL		; and go receive more
02970 ;
02980 RECEND	LD	A,(BLOCKS)	; Get blocks xfered count
02990 	OR	A		; Zero blocks?
03000 	CALL	NZ,SAVBLK	; If blocks to be saved
03010 	CALL	CLOSEF		; Close the file
03020 	OR	A		; Any error occured?
03030 	JP	NZ,ABORT	; Yes, so send cancel
03040 	CALL	SNDACK		; No, so send acknowledge
03050 	JP	SUCCES		; and xfer completed
03060 ;
03070 RECBKS	XOR	A		; Zero number of tries
03080 	LD	(TRIES),A	; counter
03090 RECBLK	LD	B,10		; 10 seconds per attempt
03100 	CALL	CRSINP		; Look for a character
03110 	JR	C,RTRIES	; If no char, check tries
03120 	CP	CANCEL		; Cancelled?
03130 	JP	Z,ABORT		; Yes, so abort transfer
03140 	CP	SOH		; Is it start of header?
03150 	JR	Z,RECBKH	; Yes, so get first block
03160 	CP	EOT		; End of transmission?
03170 	SCF			; Maybe...
03180 	RET	Z		; Yes, so return
03190 RTRIES	CALL	WNCHRS		; No, wait until no chars
03200 	LD	A,NAK		; and then send negative
03210 	CALL	CRSOUT		; acknowledge
03220 BADACK	LD	A,(FIRST)	; Check for initial block
03230 	OR	A		; Has it been started?
03240 	JR	Z,CRTRYS	; No error display needed
03250 	CALL	DPYBLK		; Display error block #
03260 	CALL	ILPRNT		; Display * error status
03270 	DEFM	'*   '
03280 	DEFB	EOL
03290 CRTRYS	LD	A,(TRIES)	; Get number of attempts
03300 	INC	A		; and increment it by 1
03310 	LD	(TRIES),A	; Store # attempts left
03320 	CP	10		; Have there been 10?
03330 	JR	NZ,RECBLK	; If not 10, try again
03340 	JP	ABORT		; else abort transfer!
03350 ;
03360 RECBKH	LD	A,HIGH		; Since an SOH was recvd
03370 	LD	(FIRST),A	; rest of blk should come
03380 	CALL	DPYBLK		; Display current block #
03390 	LD	BC,RTRIES	; Save error return addr
03400 	PUSH	BC		; for convenient exits
03410 	LD	B,1		; 1 second attempt
03420 	CALL	CRSINP		; Look for a character
03430 	RET	C		; If no character, exit
03440 	LD	D,A		; Save first block number
03450 	LD	B,1		; 1 second attempt
03460 	CALL	CRSINP		; Look for a character
03470 	RET	C		; If no character, exit
03480 	CPL			; Make normal block #
03490 	CP	D		; Is it the same?
03500 	RET	NZ		; No, so error exit
03510 	LD	A,(BLKCNT)	; Check block number
03520 	CP	D		; Is it the same?
03530 	JR	Z,NEWBLK	; Yes, go get block
03540 	DEC	A		; Check for bad ack char
03550 	CP	D		; Was it previous block?
03560 	RET	NZ		; No, so error exit
03570 	CALL	WNCHRS		; Yes, so wait until all
03580 	CALL	SNDACK		; sent, then send an ack
03590 	POP	HL		; Fix stack
03600 	JR	BADACK		; and try block again
03610 ;
03620 NEWBLK	LD	HL,(BLKADR)	; Get start of block
03630 	LD	E,128		; 128 bytes expected
03640 	LD	C,0		; Zero checksum
03650 RECBLP	LD	B,1		; 1 second attempt
03660 	CALL	CRSINP		; Look for character
03670 	RET	C		; If no character, exit
03680 	LD	(HL),A		; Store character
03690 	INC	HL		; Increment buffer ptr
03700 	DEC	E		; Decrement # received
03710 	JR	NZ,RECBLP	; and loop if not 0
03720 	LD	D,C		; Save calculated chksum
03730 	LD	B,1		; 1 second attempt
03740 	CALL	CRSINP		; Look for character
03750 	RET	C		; If no character, exit
03760 	CP	D		; Do checksums match?
03770 	RET	NZ		; If no match, error exit
03780 	LD	(BLKADR),HL	; Save new address
03790 	POP	HL		; and pop the error addr
03800 	RET			; and we are done
03810 ;
03820 SAVBLK	LD	HL,BUFFER	; Get start of buffer
03830 	LD	DE,FILE		; Open file
03840 	LD	C,A		; Number of blocks
03850 SAVEBK	LD	B,128		; Length of each block
03860 SAVELP	LD	A,(HL)		; Get a byte
03870 	CALL	OUTBYT		; Write to disk file
03880 	JR	Z,NSERR		; Go if no error
03890 	OR	HIGH		; Make it CALLable
03900 	CALL	ERROR		; Display error
03910 	JP	ABORT		; and abort
03920 ;
03930 NSERR	INC	HL		; Increment buffer
03940 	DJNZ	SAVELP		; Loop until 128 written
03950 	DEC	C		; Decrement blocks
03960 	JR	NZ,SAVEBK	; Loop until all written
03970 	XOR	A		; Zero number of blocks
03980 	LD	(BLOCKS),A	; transferred
03990 	LD	HL,BUFFER	; Reset block buffer
04000 	LD	(BLKADR),HL	; to the start of buffer
04010 	RET
04020 ;
04030 SEND	LD	HL,(FILE+12)	; Get # of full records
04040 	ADD	HL,HL		; # of 128 byte records
04050 	LD	A,(FILE+8)	; and see if any in eof
04060 	OR	A		; Any bytes in eof sec?
04070 	JR	Z,CALC		; No, so go calc
04080 	INC	HL		; Increment # of records
04090 	CP	129		; See how many recs, 1-2
04100 	JR	C,CALC		; If 1 record, end check
04110 	INC	HL		; otherwise 2 records
04120 CALC	PUSH	HL		; Save number of records
04130 	XOR	A		; Zero number of
04140 	LD	(BLOCKS),A	; blocks counter
04150 	LD	DE,0		; Init seconds counter
04160 	LD	BC,5		; Init i/o time used
04170 	LD	A,132		; Number bytes per record
04180 	PUSH	AF		; and save it to stack
04190 	JR	CALENT		; Enter calculation loop
04200 ;
04210 CALC1	POP	AF		; Get number left in rec
04220 	SUB	30		; 30 cps
04230 	PUSH	AF		; Save number left in rec
04240 	JR	C,CALC2		; End loop if not enough
04250 ;
04260 	INC	DE		; Increment # of seconds
04270 	JR	CALC1		; and resume calculating
04280 ;
04290 CALC2	POP	AF		; Get number left
04300 	ADD	A,162		; Add previous & next rec
04310 	PUSH	AF		; Store new value
04320 	LD	A,(BLOCKS)	; Get record count
04330 	INC	A		; Increment it
04340 	CP	2		; Have there been 2?
04350 	JR	NZ,CALC3	; No, so nothing done
04360 ;
04370 	INC	BC		; Inc i/o seconds count
04380 	XOR	A		; and zero record count
04390 ;
04400 CALC3	LD	(BLOCKS),A	; Store new count
04410 	DEC	HL		; Decrement # of records
04420 CALENT	LD	A,H		; Check for end of record
04430 	OR	L		; End of records?
04440 	JR	NZ,CALC1	; No, so go get more
04450 ;
04460 	POP	AF		; Fix the stack
04470 	PUSH	BC		; Save i/o seconds
04480 	PUSH	DE		; Save seconds for later
04490 ;
04500 	EX	DE,HL		; Move DE to HL
04510 	ADD	HL,BC		; Get total seconds
04520 	LD	BC,60		; Number to divide by
04530 	CALL	DIVIDE		; Divide 60 into HL
04540 	PUSH	DE		; Save remainder
04550 	LD	B,3		; 3 places
04560 	LD	A,B		; Suppress leading zeroes
04570 	LD	DE,BM300	; Where to store it
04580 	CALL	BINASC		; Convert to ascii
04590 	POP	HL		; Get remainder
04600 	LD	B,2		; 2 places
04610 	LD	A,B		; Suppress leading zeroes
04620 	LD	DE,BS300	; Where to store it
04630 	CALL	BINASC		; Convert to ascii
04640 	POP	HL		; Now to calc for 1200
04650 	LD	BC,4		; Number to divide by
04660 	CALL	DIVIDE		; Divide 4 into HL
04670 	POP	BC		; Get i/o seconds
04680 	ADD	HL,BC		; and add for total secs
04690 	LD	BC,60		; Number to divide by
04700 	CALL	DIVIDE		; Divide 60 into HL
04710 	PUSH	DE		; Save remainder
04720 	LD	B,3		; 3 places
04730 	LD	A,B		; Suppress leading zeroes
04740 	LD	DE,BM1200	; Where to store it
04750 	CALL	BINASC		; Convert to ascii
04760 	POP	HL		; Get remainder
04770 	LD	B,2		; 2 places
04780 	LD	A,B		; Suppress leading zeroes
04790 	LD	DE,BS1200	; Where to store it
04800 	CALL	BINASC		; Convert to ascii
04810 ;
04820 	POP	HL		; Get number of records
04830 	PUSH	HL		; and keep it saved
04840 	LD	B,5		; 5 places
04850 	LD	A,B		; Suppress leading zeroes
04860 	LD	DE,NUMREC	; Where to store it
04870 	CALL	BINASC		; Convert to ascii
04880 ;
04890 	POP	HL		; Get number of records
04900 	LD	BC,8		; Divide them by 8 to
04910 	CALL	DIVIDE		; get number of K bytes
04920 	PUSH	DE		; and save the remainder
04930 	LD	B,3		; 3 places
04940 	LD	A,B		; Suppress leading zeroes
04950 	LD	DE,KBYTES	; Where to store it
04960 	CALL	BINASC		; Convert it to ascii
04970 ;
04980 	POP	HL		; Get number of records
04990 	LD	B,10		; Number to multiply by
05000 	CALL	MULT		; Multiply by 10
05010 	LD	BC,8		; Get 10ths of a K
05020 	CALL	DIVIDE		; Go get it
05030 	LD	A,L		; Get value
05040 	ADD	A,'0'		; Make it ascii
05050 	LD	(DBYTES),A	; and store it
05060 ;
05070 	LD	HL,FMSG
05080 	CALL	MSGOUT
05090 	CALL	ILPRNT		; Show message
05100 	DEFB	LF
05110 	DEFM	'File size in Kilobytes:  '
05120 KBYTES	DEFM	'kkk.'
05130 DBYTES	DEFM	'd  (1 K-byte = 1024 bytes)
05140 	DEFB	LF
05150 	DEFM	'              Block(s):  '
05160 NUMREC	DEFM	'nnnnn   (1 Block = 128 bytes)'
05170 	DEFB	LF
05180 	DEFB	LF
05190 	DEFM	'Send time at 1200 baud:    '
05200 BM1200	DEFM	'mmm minute(s), '
05210 BS1200	DEFM	'ss second(s).'
05220 	DEFB	LF
05230 	DEFM	'              300 baud:    '
05240 BM300	DEFM	'mmm minute(s), '
05250 BS300	DEFM	'ss second(s).'
05260 	DEFB	LF
05270 	DEFB	LF
05280 	DEFM	'Enter ctrl-x to abort file transfer.'
05290 	DEFB	LF
05300 	DEFB	LF
05310 	DEFM	'Ready to send - awaiting initial NAK.'
05320 	DEFB	CR
05330 ;
05340 	CALL	INITRS		; Send initialization
05350 ;
05360 	LD	E,90		; Number of tries for NAK
05370 ;
05380 GETNAK	LD	B,1		; 1 second attempt
05390 	CALL	CRSINP		; Look for a character
05400 	JR	C,NOCHAR	; If no character
05410 ;
05420 	CP	NAK		; NAK received?
05430 	JR	Z,SNDFIL	; Yes, so go send file
05440 ;
05450 	CP	CANCEL		; Is it cancelled?
05460 	JP	Z,ABORT		; Yes, so go abort xfer
05470 ;
05480 NOCHAR	DEC	E		; Keep looking?
05490 	JR	NZ,GETNAK	; Yes
05500 	JP	ABORT		; No, abort transfer
05510 ;
05520 SNDFIL	CALL	INCBLK		; Increment block number
05530 	LD	A,(BLOCKS)	; Check number of blocks
05540 	OR	A		; More needed?
05550 	CALL	Z,GETBKS	; If we have run out
05560 	JR	C,SNDEND	; If end of file
05570 	CALL	SNDBKS		; Send the blocks
05580 	JR	SNDFIL		; and go get/send more
05590 ;
05600 SNDEND	LD	A,(BLOCKS)	; Check number to send
05610 	OR	A		; Are there any left?
05620 	JR	Z,SNDEOT	; No, so go send EOT
05630 	CALL	SNDBKS		; Send last blocks
05640 	CALL	INCBLK		; Increment block count
05650 	JR	SNDEND		; Loop if more to send
05660 ;
05670 SNDEOT	CALL	SNDBKS		; Send EOT character
05680 	CALL	CLOSEF		; Close the file
05690 	JP	SUCCES		; and xfer completed
05700 ;
05710 GETBKS	LD	HL,BUFFER	; Get start of buffer
05720 	LD	(BLKADR),HL	; Store start of block
05730 	LD	DE,FILE		; Open file
05740 	LD	C,0		; Zero blocks read
05750 ;
05760 LOADBK	LD	B,128		; Length of each block
05770 ;
05780 LOADLP	CALL	INPBYT		; Read a byte
05790 	JR	Z,NLERR		; Go if no error
05800 ;
05810 	CP	EOF		; End of file?
05820 	JR	Z,LDEOF		; Yes, go to eof routine
05830 ;
05840 	OR	HIGH		; Make it CALLable
05850 	CALL	ERROR		; Display error
05860 	JP	ABORT		; and abort
05870 ;
05880 NLERR	LD	(HL),A		; Store byte
05890 	INC	HL		; and prepare for next
05900 	DJNZ	LOADLP		; Read rest of block
05910 ;
05920 	INC	C		; Increment blocks read
05930 ;
05940 	LD	A,20		; Check # blocks read
05950 	CP	C		; Have we read 20?
05960 	JR	NZ,LOADBK	; No, so read more
05970 ;
05980 	LD	(BLOCKS),A	; Store number read
05990 	RET			; and return
06000 ;
06010 LDEOF	LD	A,128		; Check bytes read
06020 	CP	B		; Any bytes read in?
06030 	JR	Z,LDEND		; No, so skip fill
06040 ;
06050 	XOR	A		; Set fill char = 0
06060 ;
06070 LDFILL	LD	(HL),A		; Store character
06080 	INC	HL		; Increment buffer
06090 	DJNZ	LDFILL		; and loop until filled
06100 ;
06110 	INC	C		; Inc blocks read count
06120 ;
06130 LDEND	LD	A,C		; Get block count
06140 	LD	(BLOCKS),A	; and store it
06150 	SCF			; Show end of file
06160 	RET			; and we are done
06170 ;
06180 SNDBKS	XOR	A		; Zero number of tries
06190 	LD	(TRIES),A	; counter
06200 ;
06210 SNDBLK	LD	A,(BLOCKS)	; Check if any to send
06220 	OR	A		; Are there any blocks?
06230 	JR	Z,SDEOTC	; No, send EOT character
06240 ;
06250 	CALL	DPYBLK		; Since not EOT block
06260 ;
06270 	LD	A,SOH		; Send start of header
06280 	CALL	CRSOUT		; character
06290 ;
06300 	LD	A,(BLKCNT)	; Get block count
06310 	CALL	CRSOUT		; Send it
06320 	CPL			; Complement it
06330 	CALL	CRSOUT		; Send it
06340 ;
06350 	LD	HL,(BLKADR)	; Get start of block
06360 	LD	B,128		; 128 bytes / block
06370 	LD	C,0		; Zero checksum
06380 ;
06390 SNDBLP	LD	A,(HL)		; Get character
06400 	CALL	CRSOUT		; Send it
06410 	INC	HL		; Prepare for next
06420 	DJNZ	SNDBLP		; and keep sending
06430 ;
06440 	LD	A,C		; Get checksum
06450 	CALL	CRSOUT		; and send it
06460 ;
06470 SNDAWT	LD	B,10		; 10 seconds per attempt
06480 	CALL	CRSINP		; Look for a character
06490 	JR	C,STRIES	; If no character
06500 ;
06510 	CP	CANCEL		; Is it cancelled?
06520 	JP	Z,ABORT		; Yes, so abort
06530 ;
06540 	CP	ACK		; Acknowledge character?
06550 	JR	NZ,STRIES	; No, so check tries
06560 ;
06570 	LD	A,(BLOCKS)	; Decrement number of
06580 	OR	A		; Is it zero?
06590 	RET	Z		; Yes, so end here
06600 	DEC	A		; Decrement blocks left
06610 	LD	(BLOCKS),A	; and store new number
06620 	LD	(BLKADR),HL	; Store new block addr
06630 	RET			; and we are done
06640 ;
06650 SDEOTC	LD	A,EOT		; Send EOT
06660 	CALL	CRSOUT		; character
06670 	JR	SNDAWT		; and look for ack
06680 ;
06690 STRIES	CALL	WNCHRS		; Wait until no chars
06700 	CALL	ILPRNT		; Display * error status
06710 	DEFM	'*   '		;
06720 	DEFB	EOL		;
06730 ;
06740 	LD	A,(TRIES)	; Get number of attempts
06750 	INC	A		; and increment it by 1
06760 	LD	(TRIES),A	; Store # attempts left
06770 	CP	10		; Have there been 10?
06780 	JR	NZ,SNDBLK	; If not 10, try again
06790 	JP	ABORT		; else abort transfer!
06800 ;
06810 RSINIT	LD	BC,2		; Wait for RS232 data
06820 	CALL	DELAY		; registers to clear
06830 ;
06840 	OUT	(MR),A		; Reset the RS232 board
06850 ;
06860 	INC	HL
06870 	LD	A,(HL)
06880 	CP	'='
06890 	JR	Z,GIBAUD
06900 	DEC	HL
06910 	PUSH	HL
06920 	LD	HL,BDTBL
06930 	IN	A,(BAUD)
06940 	AND	7
06950 	LD	B,0
06960 	LD	C,A
06970 	ADD	HL,BC
06980 	LD	A,(HL)
06990 	JR	CRS232
07000 GIBAUD	PUSH	HL
07010 	LD	B,0
07020 FBDLEN	INC	HL
07030 	INC	B
07040 	LD	A,(HL)
07050 	CP	'0'
07060 	JR	C,FBDEND
07070 	CP	'9'+1
07080 	JR	C,FBDLEN
07090 FBDEND	DEC	B
07100 	POP	DE
07110 	INC	DE
07120 	LD	A,B
07130 	OR	A
07140 	JP	Z,BADOPT
07150 	CP	6
07160 	JP	NC,BADOPT
07170 	CALL	ASCBIN
07180 	PUSH	DE
07190 	PUSH	HL
07200 	POP	BC
07210 	LD	IX,BDCTBL
07220 FIBDLP	LD	L,(IX+0)
07230 	LD	H,(IX+1)
07240 	LD	A,H
07250 	OR	L
07260 	JP	Z,BADOPT
07270 	LD	A,(IX+2)
07280 	INC	IX
07290 	INC	IX
07300 	INC	IX
07310 	SBC	HL,BC
07320 	JR	NZ,FIBDLP
07330 CRS232	LD	IX,BDCTBL-3
07340 GBDRLP	INC	IX
07350 	INC	IX
07360 	INC	IX
07370 	CP	(IX+2)
07380 	JR	NZ,GBDRLP
07390 	PUSH	AF
07400 	LD	L,(IX+0)
07410 	LD	H,(IX+1)
07420 	LD	DE,BAUDMS
07430 	LD	B,5
07440 	LD	A,B
07450 	CALL	BINASC
07460 	POP	AF
07470 	OUT	(BAUD),A	; Set the baud rate
07480 	LD	A,CONFIG	; 8 word, 1 stop, no par.
07490 	OUT	(RSCTRL),A	; Set the configuration
07500 ;
07510 	CALL	ILPRNT		; Display initialized msg
07520 	DEFB	LF
07530 	DEFM	'The serial interface has been configured for xmodem file xfer.'
07540 	DEFB	LF
07550 	DEFM	'Configuration is 8 bit word length, 1 stop bit, and no parity.'
07560 	DEFB	LF
07570 	DEFB	LF
07580 	DEFM	'Baud rate selected:  '
07590 BAUDMS	DEFM	'nnnnn bps.'
07600 	DEFB	CR
07610 ;
07620 	POP	HL		; Get command pointer
07630 	JP	FNDOPT		; Check for more options
07640 ;
07650 NMDMCK	LD	A,RETURN	; Set a bypass return
07660 	LD	(MDMCHK),A	; to not check carrier
07670 	PUSH	HL		; Save cmd params
07680 	CALL	ILPRNT
07690 	DEFB	LF
07700 	DEFM	'Modem carrier check disabled for direct serial to serial xfer.'
07710 	DEFB	CR
07720 ;
07730 	POP	HL
07740 	JP	FNDOPT		; Go check next option
07750 ;
07760 DELAY	PUSH	BC		; Save count
07770 	LD	BC,0		; 1 second of delay
07780 	CALL	60H		; Delay for 1 second
07790 	POP	BC		; Get count
07800 	DEC	BC		; Decrement it
07810 	LD	A,B		; Is it
07820 	OR	C		; zero?
07830 	JR	NZ,DELAY	; No, so delay some more
07840 	RET			; otherwise return
07850 ;
07860 MULT	PUSH	HL		; Move the value to DE
07870 	POP	DE		; without losing HL
07880 ;
07890 MULTLP	ADD	HL,DE		; Do the multiplying
07900 	DJNZ	MULTLP		; Until done
07910 	RET			; and then return
07920 ;
07930 DIVIDE	OR	A		; Clear carry
07940 	LD	DE,0		; To be used as a counter
07950 ;
07960 DIVLP	SBC	HL,BC		; Subtract
07970 	JR	C,DIVEND	; until carry
07980 	INC	DE		; and increment each time
07990 	JR	DIVLP		; Keep going til too much
08000 ;
08010 DIVEND	ADD	HL,BC		; Fix value
08020 	EX	DE,HL		; Flip the count and the
08030 	RET			; remainder, then return
08040 ;
08050 BINASC	LD	(BAFLAG),A	; Zero=spaces option
08060 	LD	IX,P10TBL+10	; Get powers of ten table
08070 	LD	A,B		; Check # of positions
08080 	OR	A		; Zero positions?
08090 	JR	NZ,BA0		; No, so ok
08100 ;
08110 	LD	B,1		; Set to 1 position
08120 	LD	A,B		; and in register A too!
08130 ;
08140 BA0	CP	6		; Check for too many
08150 	JR	C,BA1		; Go if not too many
08160 ;
08170 	LD	B,5		; Set to 5 positions
08180 	LD	A,B		; and in register A too!
08190 ;
08200 BA1	DEC	IX		; Get location in table
08210 	DEC	IX		;
08220 	DJNZ	BA1		; and loop until found
08230 ;
08240 	CP	5		; Max value allowed?
08250 	JR	Z,BA2		; Yes, so no check needed
08260 ;
08270 	PUSH	HL		; Save value
08280 	LD	B,(IX-1)	; Get check value
08290 	LD	C,(IX-2)	; to test for too high
08300 	OR	A		; Clear carry flag
08310 	SBC	HL,BC		; Too high?
08320 	POP	HL		; Fix HL
08330 	JR	C,BA2		; Not too high, so skip
08340 ;
08350 	PUSH	BC		; Move BC to HL
08360 	POP	HL		;
08370 	DEC	HL		; Set highest value
08380 ;
08390 BA2	XOR	A		; Zero leading zeroes
08400 	LD	(LEADNZ),A	; check flag
08410 ;
08420 BA3	XOR	A		; Zero the A register
08430 	LD	C,(IX+0)	; Get current power of
08440 	LD	B,(IX+1)	; ten from the table
08450 ;
08460 BA4	SBC	HL,BC		; Subtract values
08470 	JR	C,BA5		; until too much
08480 ;
08490 	INC	A		; Increment ascii value
08500 	JR	BA4		; and keep going
08510 ;
08520 BA5	ADD	HL,BC		; Fix value
08530 	ADD	A,'0'		; Make ascii character
08540 	PUSH	AF		; Save character
08550 	LD	A,C		; Check for last location
08560 	CP	1		; Is it last?
08570 	JR	Z,BA7		; Yes, no more processing
08580 ;
08590 	POP	AF		; Restore AF
08600 	PUSH	AF		; and keep it on stack
08610 	CP	'0'		; Ascii zero?
08620 	JR	Z,BA6		; Yes, so go process
08630 ;
08640 	LD	A,HIGH		; Set flag to a
08650 	LD	(LEADNZ),A	; non-zero value
08660 ;
08670 BA6	LD	A,0		; Check for storing
08680 BAFLAG	EQU	$-1		; leading zeroes
08690 	OR	A		; Store them?
08700 	JR	Z,BA7		; Yes
08710 	LD	A,0		; Check for previous
08720 LEADNZ	EQU	$-1		; non-zero value stored
08730 	OR	A		; Any found?
08740 	JR	NZ,BA7		; Yes, so store value
08750 	POP	AF		; Get character
08760 	LD	A,SPACE		; Change it to a space
08770 	PUSH	AF		; and restore character
08780 ;
08790 BA7	POP	AF		; Get character from stk
08800 	LD	(DE),A		; Store character
08810 	INC	DE		; Prepare for next
08820 	LD	A,C		; Check for end
08830 	CP	1		; Have we done yet?
08840 	RET	Z		; Yes, so return
08850 	INC	IX		; No, so get next
08860 	INC	IX		; power of ten position
08870 	JR	BA3		; and resume converting
08880 ;
08890 ASCBIN	LD	IX,P10TBL+10	; Obtain powers of ten
08900 	LD	HL,0		; Initialize HL to zero
08910 	LD	A,B		; Check for zero pos(s)
08920 	OR	A		; Zero?
08930 	JR	NZ,AB0		; No, so skip section
08940 ;
08950 	LD	B,1		; Set field to 1
08960 	LD	A,B		; and store new value
08970 ;
08980 AB0	CP	6		; Check for too many!
08990 	JR	C,AB1		; If less than 6
09000 	LD	B,5		; Set to max allowed
09010 ;
09020 AB1	DEC	IX		; Find place in table
09030 	DEC	IX		;
09040 	DJNZ	AB1		; Until B=0
09050 ;
09060 AB2	XOR	A		; Clear flags
09070 	LD	C,(IX+0)	; Obtain power of ten
09080 	LD	B,(IX+1)	;
09090 	LD	A,(DE)		; Get value from buffer
09100 	SUB	'0'		; and make it 0-9 binary
09110 ;
09120 AB3	SUB	1		; Decrement it
09130 	JR	C,AB4		; until too many
09140 	ADD	HL,BC		; Accum value if not
09150 	JR	AB3		; and keep looping
09160 ;
09170 AB4	LD	A,C		; Check for end
09180 	CP	1		; Are we there?
09190 	RET	Z		; Yes, so return
09200 	INC	DE		; else get next position
09210 	INC	IX		; and next power of ten
09220 	INC	IX		;
09230 	JR	AB2		; and keep looping
09240 ;
09250 ILPRNT	POP	HL		; Get message address
09260 	LD	A,(HL)		; and char found there
09270 	INC	HL		; Increment for next char
09280 	PUSH	HL		; and push back on stack
09290 ;
09300 	CP	EOL		; End of line?
09310 	RET	Z		; Yes, so we are done
09320 ;
09330 	PUSH	AF		; Save AF and DE
09340 	PUSH	DE		;
09350 	CALL	CHROUT		; Display character
09360 	POP	DE		; Restore DE and AF
09370 	POP	AF		;
09380 ;
09390 	CP	CR		; Was it a CR?
09400 	RET	Z		; Yes, so we are done
09410 ;
09420 	JR	ILPRNT		; Look for next character
09430 ;
09440 CLOSEF	LD	DE,FILE		; Get open file
09450 	CALL	CLOSE		; try and close it
09460 	RET	Z		; Done if no error
09470 	OR	HIGH		; Make it CALLable
09480 	JP	ERROR		; and return to previous
09490 ;
09500 ABORT	IN	A,(MODEM)	; Check for carrier
09510 	BIT	CARDET,A	; Carrier detected?
09520 	JR	NZ,ABORT1	; No, so skip cancel send
09530 ;
09540 	CALL	WNCHRS		; Wait until no chars
09550 	LD	A,CANCEL	; Send the cancel char
09560 	CALL	CRSOUT		; to show aborting
09570 ;
09580 ABORT1	CALL	VIDFIX		; Fix the video output
09590 	LD	DE,FILE		; Get open file
09600 	LD	A,(OPTSAV)	; Check receive or send
09610 	CP	'R'		; Receive?
09620 	JR	NZ,SNDABT	; No, must be send
09630 ;
09640 	CALL	KILL		; Kill received file
09650 	JR	RECABT		; Exit to receive abort
09660 ;
09670 SNDABT	CALL	CLOSEF		; Close send file
09680 RECABT	JR	Z,DPYABT	; Display abort message
09690 	OR	HIGH		; Make it CALLable
09700 	CALL	ERROR		; Display error
09710 ;
09720 DPYABT	CALL	ILPRNT		; Display message
09730 	DEFB	BELL
09740 	DEFB	LF
09750 	DEFB	LF
09760 	DEFM	'>> File transfer aborted!'
09770 	DEFB	CR
09780 ;
09790 	JP	EXIT		; and take normal exit
09800 ;
09810 SUCCES	CALL	VIDFIX		; Fix video output
09820 	CALL	ILPRNT		; Display message
09830 	DEFB	BELL
09840 	DEFB	LF
09850 	DEFB	LF
09860 	DEFM	'>> File transfer completed.'
09870 	DEFB	CR
09880 ;
09890 	LD	HL,(CMDPTR)	; Get command pointer
09900 	JP	FNDOPT		; and see if more waiting
09910 ;
09920 VIDFIX	LD	HL,(VIDSAV)	; Get old video driver
09930 	LD	(VIDDCB),HL	; and store it
09940 	RET			; and return
09950 ;
09960 INCBLK	PUSH	AF		; Save AF
09970 	LD	A,(BLKCNT)	; Get block count
09980 	INC	A		; and increment it
09990 	LD	(BLKCNT),A	; and save it
10000 	POP	AF		; Restore AF
10010 	RET			; then return
10020 ;
10030 SNDACK	LD	A,ACK		; Send acknowledge
10040 	JP	CRSOUT		; character
10050 ;
10060 WNCHRS	LD	B,1		; 1 second attempt
10070 	CALL	CRSINP		; Look for character
10080 	JR	NC,WNCHRS	; Loop if character found
10090 	RET			; otherwise return
10100 ;
10110 ABTCHK	LD	A,(CTLVEC)	; Get control keys info
10120 	BIT	BRKKEY,A	; Break pressed?
10130 	JR	Z,CTLXCK	; No, so check ctrl-x
10140 ;
10150 BRKLP	LD	A,(CTLVEC)	; Get control keys info
10160 	BIT	BRKKEY,A	; Break still held down?
10170 	JR	NZ,BRKLP	; Yes, wait 'til released
10180 ABTKEY	JP	ABORT		; Abort transfer
10190 ;
10200 CTLXCK	LD	A,(SHIFT)	; Check shift key
10210 	OR	A		; Is it pressed?
10220 	JR	Z,MDMCHK	; No, so check modem
10230 	LD	A,(CTLVEC)	; Check down arrow
10240 	BIT	DWNARR,A	; Is it pressed?
10250 	JR	Z,MDMCHK	; No, so check modem
10260 	LD	A,(XYZVEC)	; Check for key X
10270 	BIT	XKEY,A		; Is it pressed?
10280 	JR	Z,MDMCHK	; No, so check modem
10290 ;
10300 CTLXLP	LD	A,(SHIFT)	; Wait 'til keys released
10310 	OR	A		; Is shift pressed?
10320 	JR	NZ,CTLXLP	; Yes, so try again
10330 	LD	A,(CTLVEC)	; Check down arrow
10340 	BIT	DWNARR,A	; Is it pressed?
10350 	JR	NZ,CTLXLP	; Yes, so try again
10360 	LD	A,(XYZVEC)	; Check for key X
10370 	BIT	XKEY,A		; Is it pressed?
10380 	JR	NZ,CTLXLP	; Yes, so try again
10390 	JR	ABTKEY		; Jump to abort routine
10400 ;
10410 MDMCHK	NOP			; If bypass = return
10420 	IN	A,(MODEM)	; Check for carrier
10430 	BIT	CARDET,A	; Carrier present?
10440 	RET	Z		; Yes, so we are done
10450 ;
10460 	CALL	ILPRNT		; Display a message
10470 	DEFB	BELL
10480 	DEFB	LF
10490 	DEFB	LF
10500 	DEFM	'>> No carrier detected!'
10510 	DEFB	EOL
10520 ;
10530 	JP	ABORT1		; Abort transfer
10540 ;
10550 INITRS	XOR	A		; Zero some counters
10560 	LD	(BLOCKS),A	; Blocks transferred
10570 	LD	(BLKCNT),A	; Block count
10580 	LD	(DPYHDR),A	; Zero to dpy blk msg
10590 	LD	HL,BUFFER	; Set block address
10600 	LD	(BLKADR),HL	; to start of buffer
10610 	IN	A,(RSDATA)	; Clear RS232 flags/port
10620 ;
10630 	LD	HL,(VIDDCB)	; Get old video driver
10640 	LD	(VIDSAV),HL	; and save it
10650 	LD	HL,0		; Get new video driver
10660 NEWDVR	EQU	$-2		; Location of driver
10670 	LD	(VIDDCB),HL	; Store new driver
10680 ;
10690 	RET			; and we are done
10700 ;
10710 DPYBLK	CALL	DPYHDR		; Display block message
10720 	LD	A,BCKSPC	; Move cursor back two
10730 	CALL	CHROUT		; positions by sending
10740 	LD	A,BCKSPC	; two backspace codes
10750 	CALL	CHROUT		; to the screen
10760 	LD	A,(BLKCNT)	; Get current block count
10770 	PUSH	AF		; and save for low bits
10780 	CALL	HIBITS		; Display high nibble
10790 	POP	AF		; Restore for low bits
10800 	JP	LOBITS		; and display low nibble
10810 ;
10820 HIBITS	RRCA			; We want the high
10830 	RRCA			; nibble here, so rotate
10840 	RRCA			; the four bits into
10850 	RRCA			; position
10860 ;
10870 LOBITS	AND	15		; Get first 4 bits only
10880 	CP	10		; Is it > 9 ?
10890 	JR	C,NOTAF		; No, so it is not A - F
10900 ;
10910 	ADD	A,7		; A-F after conversion
10920 ;
10930 NOTAF	ADD	A,'0'		; Make it ascii
10940 	JP	CHROUT		; and display it (done)
10950 ;
10960 DPYHDR	NOP			; Executes once/file xfer
10970 	LD	A,RETURN	; Make sure only once
10980 	LD	(DPYHDR),A	; by storing a return
10990 ;
11000 	LD	A,(OPTSAV)	; Get option
11010 	CP	'R'		; Is it receive?
11020 	JR	NZ,DPYSDH	; No, must be send
11030 ;
11040 	CALL	ILPRNT		; Display block message
11050 	DEFB	LF
11060 	DEFM	'Receiving'
11070 	DEFB	EOL
11080 	JR	ENDHDR		; End block message
11090 ;
11100 DPYSDH	CALL	ILPRNT		; Display block message
11110 	DEFB	LF
11120 	DEFM	'Sending'
11130 	DEFB	EOL
11140 ;
11150 ENDHDR	CALL	ILPRNT		; Display rest of blk msg
11160 	DEFM	' Block:    '
11170 	DEFB	EOL
11180 	RET			; Now we are done
11190 ;
11200 VIDEO1	JR	C,NORMAL	; If carry, use rom
11210 	LD	L,(IX+3)	; otherwise get cursor
11220 	LD	H,(IX+4)	; screen location
11230 	LD	A,C		; and the character
11240 	SUB	20H		; Lower it 20H
11250 	CP	LCCHAR		; Is it lowercase?
11260 	LD	A,C		; Obtain original again
11270 	JP	C,47DH		; Yes, it is lc so exit
11280 NORMAL	JP	458H		; else use normal entry
11290 ;
11300 CRSINP	PUSH	DE		; Save DE
11310 ;
11320 RSINP1	LD	DE,3000H	; Count = 1 second
11330 RSIDLY	EQU	$-2		; Number of tries
11340 ;
11350 RSINP2	CALL	ABTCHK		; Check for abort
11360 	IN	A,(STATUS)	; Check receive buffer
11370 	BIT	DRECVD,A	; Any data received?
11380 	JR	NZ,DARECV	; Yes, so exit loop
11390 ;
11400 	DEC	DE		; Decrement counter
11410 	LD	A,D		; Check for end of loop
11420 	OR	E		; End?
11430 	JR	NZ,RSINP2	; No, so try again
11440 ;
11450 	DJNZ	RSINP1		; Loop if more secs
11460 ;
11470 RSIERR	POP	DE		; Restore DE
11480 	IN	A,(RSDATA)	; Clear the RS data reg
11490 	SCF			; Set carry=no char recvd
11500 	RET			; and we are done
11510 ;
11520 DARECV	IN	A,(STATUS)	; Check for errors
11530 	BIT	OVRERR,A	; Overrun error?
11540 	JR	NZ,RSIERR	; Yes, take error exit
11550 ;
11560 	BIT	FRMERR,A	; Framing error?
11570 	JR	NZ,RSIERR	; Yes, take error exit
11580 ;
11590 	IN	A,(RSDATA)	; Get character
11600 	POP	DE		; Restore DE
11610 ;
11620 	PUSH	AF		; Save character
11630 	ADD	A,C		; Perform
11640 	LD	C,A		; checksum
11650 	POP	AF		; Restore character
11660 	OR	A		; Clear carry if set
11670 	RET			; and we are done
11680 ;
11690 CRSOUT	PUSH	AF		; Save character
11700 	ADD	A,C		; Perform
11710 	LD	C,A		; checksum
11720 ;
11730 RSOUT	CALL	ABTCHK		; Check for abort
11740 	IN	A,(STATUS)	; Check xmit buffer
11750 	BIT	XEMPTY,A	; Is it empty?
11760 	JR	Z,RSOUT		; No, so keep looping
11770 ;
11780 	POP	AF		; Restrieve character
11790 	OUT	(RSDATA),A	; and sent it
11800 	RET			; and we are done
11810 ;
11820 BDTBL	DEFB	BR110
11830 	DEFB	BR150
11840 	DEFB	BR300
11850 	DEFB	BR600
11860 	DEFB	BR1200
11870 	DEFB	BR2400
11880 	DEFB	BR4800
11890 	DEFB	BR9600
11900 ;
11910 BDCTBL	DEFW	50
11920 	DEFB	BR50
11930 	DEFW	75
11940 	DEFB	BR75
11950 	DEFW	110
11960 	DEFB	BR110
11970 	DEFW	135
11980 	DEFB	BR135
11990 	DEFW	150
12000 	DEFB	BR150
12010 	DEFW	300
12020 	DEFB	BR300
12030 	DEFW	600
12040 	DEFB	BR600
12050 	DEFW	1200
12060 	DEFB	BR1200
12070 	DEFW	1800
12080 	DEFB	BR1800
12090 	DEFW	2000
12100 	DEFB	BR2000
12110 	DEFW	2400
12120 	DEFB	BR2400
12130 	DEFW	3600
12140 	DEFB	BR3600
12150 	DEFW	4800
12160 	DEFB	BR4800
12170 	DEFW	7200
12180 	DEFB	BR7200
12190 	DEFW	9600
12200 	DEFB	BR9600
12210 	DEFW	19200
12220 	DEFB	BR1920
12230 	DEFW	0
12240 ;
12250 FMSG	DEFB	LF
12260 	DEFM	'File = '
12270 FNAME	DEFS	24
12280 STKSAV	DEFS	2		; Save area for stack ptr
12290 VIDSAV	DEFS	2		; Save area for video dvr
12300 OPTSAV	DEFS	1		; Save area for opt key
12310 TRIES	DEFS	1		; Number of attempts
12320 BLKCNT	DEFS	1		; Block counter
12330 BLOCKS	DEFS	1		; Number transferred
12340 BLKADR	DEFS	2		; Current buffer pointer
12350 CMDPTR	DEFS	2		; End of current command
12360 FIRST	DEFS	1		; First block flag
12370 FILE	DEFS	50		; Filespec work area
12380 DSKBUF	DEFS	256		; Disk sector buffer
12390 BUFFER	DEFS	2560		; Big buffer for blocks
12400 ENDPGM	EQU	$-1		; Last addr used by pgm
12410 ;
12420 	END	START
