;	MAKEOLAY/ASM	10/24/88
;
	ORG	3000H
;
ETX	EQU	3
@ERROR	EQU	26
@INIT	EQU	58
@CLOSE	EQU	60
@WRITE	EQU	75
@BANK	EQU	102
;
BEGIN	LD	HL,BUFFER
	LD	DE,FCB
	LD	BC,0
	LD	A,@INIT
	RST	40			;open OVERLAY/IMG file
	JR	Z,BEGN01
;
ERROR	OR	40H
	LD	C,A
	LD	A,@ERROR
	RST	40
;
BEGN01	EXX
	LD	DE,BUFFER
	LD	HL,8000H
	EXX
;
	LD	HL,200H
BEGN02	INC	HL
	LD	B,H
	LD	C,L
	LD	A,@BANK
	RST	40			;test if bank in use
	JR	Z,BEGN02		;go if bank NOT in use
	LD	C,L
	LD	B,0
	LD	A,@BANK
	RST	40			;select 1st bank in use
;
	LD	HL,9201H		;-> GAT table byte for track 1
	LD	BC,302H			;B=3 (factor), C=track counter
BEGN03	LD	A,(HL)			;p/u GAT table entry
	CP	-1
	JR	NZ,BEGN04		;go if track not full
	INC	C			;accumulate # of full tracks + 1
	INC	HL			;-> next GAT table entry
	JR	BEGN03
;
BEGN04	DB	0EDH,4CH		;MLT BC:  BC = # of granules + 3
	SCF
	RLA				;shift 5 bits left
	RLA
	RLA
	RLA
	RLA
BEGN05	SLA	A			;test leftmost bit
	JR	C,BEGN06		;go if bit was set
	DEC	BC			;subtract 1 granule for each reset bit
	JR	BEGN05			;go test next bit
BEGN06	LD	B,6			;factor (6 sectors/granule)
	DB	0EDH,4CH		;MLT BC: BC = # of sectors to copy
;
WRIT01	EXX
	PUSH	DE			;save buffer pointer
	LD	BC,100H
	LDIR				;move data from RAMDISK to buffer
	POP	DE			;restore buffer pointer
	LD	A,H
	OR	L
	JR	NZ,WRIT02		;go if not at end of RAMDISK bank
	LD	H,80H			;-> HL to start address of bank
	LD	BC,400H
	LD	A,@BANK
	RST	40			;p/u current bank # in A
	INC	A
	LD	C,A
	LD	A,@BANK
	RST	40			;select next higher bank
WRIT02	EXX
	LD	A,@WRITE
	RST	40
	JR	NZ,ERROR
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,WRIT01		;do next sector
	LD	A,@BANK			;BC = 0 if here
	RST	40			;select bank 0
	LD	A,@CLOSE
	RST	40
	JR	NZ,ERROR
	RET
;
FCB	DM	'OVERLAY/IMG:1',ETX,'                  '
;
BUFFER	EQU	$
;
	END	BEGIN
