;WAMDUMP Version 1.0.0  PROWAM Application Command Dump Utility
;Copyright 1987 by Claude E. Hunter
;
;Placed in the Public Domain.
;
;Extract PRO-WAM application using WAMLIB
;
;Issue WAMDUMP filename:d
;
;NOTE:  Do not use an extension.  WAMDUMP will automatically open the
;       application with the /APP extension and write the command file
;       with an /CMD extension.
;
;PRO-DUCE can now be used to disassemble the PRO-WAM application.
;
	ORG	3000H
START	PUSH	HL		;Save command line
	LD	HL,TITLE	;Display title
	LD	A,10
	RST	40
	JP	NZ,ERROR
	POP	HL
	LD	DE,FCB		;Point to FCB
	PUSH	DE
	PUSH	DE
	POP	IY		;  and move to IY
	PUSH	HL		;Save filename
	LD	A,78
	RST	40		;Move filename to FCB
	JR	NZ,ERROR
	LD	HL,APP		;Append /APP ext to filename
	LD	A,79
	RST	40
	LD	B,0
	LD	HL,BUFFER
	LD	A,59
	RST	40		;Open file
	JR	NZ,ERROR
LOOP	LD	A,67
	RST	40		;Read record
	JR	NZ,EOF		;Jp if error
	LD	A,(IY+4)	;Bump buffer to load all of record
	INC	A
	LD	(IY+4),A
	LD	A,(COUNT)	;Bump num of records loaded
	INC	A
	LD	(COUNT),A
	JR	LOOP		;Loop for next record
EOF	CP	28		;EOF error
	JR	Z,EOF1
	CP	29		;Rec num out of range
	JR	Z,EOF1
	JR	ERROR
EOF1	LD	A,(COUNT)	;Get record count and decrement for last record
	DEC	A
	LD	(COUNT),A
	LD	A,(IY+8)	;Get EOF offset
	LD	(EOFOFF),A
	LD	A,60		;Close /APP file
	RST	40
	JR	NZ,ERROR
	POP	HL		;Restore filename
	LD	A,78
	RST	40		;Move filename to FCB
	JR	NZ,ERROR
	LD	HL,CMD		;Point to /CMD ext
	LD	A,79
	RST	40		;Add /CMD ext to filename
	LD	HL,BUFF
	LD	A,58
	LD	B,0
	RST	40		;Open /CMD file
	JR	NZ,ERROR
	LD	DE,FCB
	LD	HL,BUFFER
	LD	C,5		;Load module header
	LD	A,4
	RST	40
	JR	NZ,ERROR
	LD	C,0		;Load module header is 256 bytes
	LD	A,4
	RST	40
	JR	NZ,ERROR
	CALL	WRITE		;Write load module header
	LD	A,(COUNT)
	DEC	A
	LD	(COUNT),A
	CALL	EXECUTE
	JR	Z,EXIT
ERROR	OR	128		;Set high bit
	LD	C,A
	LD	A,26
	RST	40
EXIT	LD	HL,0
	LD	A,22
	RST	40		;Exit
LOAD	LD	C,1		;Load block
	LD	A,4
	RST	40
	JR	NZ,ERROR
	LD	C,2		;Load 256 bytes
LOAD1	LD	A,4
	RST	40
	JR	NZ,ERROR
	LD	C,0		;Load address
	LD	A,4
	RST	40
	JR	NZ,ERROR
	LD	A,(ADD)		;Load address
	LD	C,A
	INC	A
	LD	(ADD),A
	LD	A,4
	RST	40
	JR	NZ,ERROR
	RET
WRITE	LD	B,0		;Write 256 bytes
WLP	LD	A,(HL)		;Get byte from buffer and send to file
	LD	C,A
	LD	A,4
	RST	40
	JR	NZ,ERROR
	INC	HL		;Bump buffer
	DJNZ	WLP		;Loop until 256
	RET
LAST	LD	C,1
	LD	A,4
	RST	40
	JR	NZ,ERROR
	LD	A,(EOFOFF)
	INC	A
	INC	A
	LD	C,A
	CALL	LOAD1
	LD	A,(EOFOFF)
	LD	B,A
	JR	WLP
TRA	LD	C,2
	LD	A,4
	RST	40
	JR	NZ,ERROR
	LD	C,2
	LD	A,4
	RST	40
	JR	NZ,ERROR
	LD	C,0
	LD	A,4
	RST	40
	JR	NZ,ERROR
	LD	C,40
	LD	A,4
	RST	40
	JR	NZ,ERROR
	RET
EXECUTE	EQU	$
LP1	CALL	LOAD		;Write load info to cmd file
	CALL	WRITE		;Write 256 block to file
	LD	A,(COUNT)	;Get blocks to write
	DEC	A		;  and dec
	LD	(COUNT),A
	JR	NZ,LP1		;Loop if not last block
	CALL	LAST		;Write last part of last block
	CALL	TRA		;Write transfer add
	LD	DE,FCB
	LD	A,60
	RST	40		;Close file
	RET
TITLE	DB	'WAMDUMP Version 1.0.0  PRO-WAM Application Command Dump'
	DB	' Utility',10
	DB	'Copyright 1987 by Claude E. Hunter',10,10
	DB	'Placed in the Public Domain.',13
APP	DB	'APP',13
CMD	DB	'CMD',13
ADD	DB	40		;Start load address
EOFOFF	DB	0
COUNT	DB	0
FCB	DS	32
BUFF	EQU	3200H
BUFFER	EQU	3300H
	END	START
