;WFIND/ASM - 07/05/92
;-----
;	WFIND application for searching a text file
;	using PRO-WAM Copyright (c) 1987 MISOSYS, Inc.
;-----
	TITLE	'<Textfinder>
	OPTION	+CI
;
ETX	EQU	03H
CR	EQU	0DH
LF	EQU	0AH
TAB	EQU	09H
;
@CLOSE	EQU	3CH
@DIV8	EQU	5DH
@ERROR	EQU	1AH
@FLAGS	EQU	65H
@FSPEC	EQU	4EH
@GET	EQU	03H
@OPEN	EQU	3BH
@SOUND	EQU	68H
@WINDOW	EQU	7CH
;
BUFFER	EQU	2600H		;File input buffer
;
;-----
;	Establish macro
;-----
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
;-----
;	The following is the header protocol
;-----
	ORG	2700H		;Forces START to 2800H
	DB	'PROWAM'
	DB	'Text finder ',ETX
	DC	.HIGH.$<8-$+256,0
;-----
;	This is where the program starts
;-----
	IFNE	$,2800H
	ERR	'Something is wrong in the header
	ENDIF
;-----
START:	LD	(SPSAV),SP
	LD	HL,0		;Origin NW corner at row 0, col 0
	LD	DE,24<8+80	;Window to have 24 rows, 80 columns
	LD	B,7
	SVC	@WINDOW		;Function to open a window
	JR	Z,START1	;Go if we were able to open it
	LD	B,00<4+2	;No good, set up parms for beep
	SVC	@SOUND		;Beep the speaker and return
	RET
;-----
;	Window opened, open the search file and get search string
;-----
START1:	LD	HL,FILEPMT
	LD	B,10		;Fuction: dsp line
	SVC	@WINDOW		;prompt for file name
	LD	HL,FCB		;Get name into FCB
	LD	BC,32		;Max char=32, func=get line
	SVC	@WINDOW
	LD	DE,FCB
	SVC	@FSPEC
	JP	NZ,F_ERR	;Go invalid file name
	LD	HL,BUFFER
	LD	B,L		;Set lrl=256
	SVC	@OPEN
	JR	Z,START2	;No error continue
	CP	2AH		;Lrl error, ignore
	JR	Z,START2
	JP	NZ,IOERR
START2	LD	HL,STRPMT	;Prompt for search string
	LD	B,10		;Function: dsp str
	SVC	@WINDOW
	LD	HL,SUBSTR	;Get sub string
	LD	BC,80		;Function, get string, max 80 char
	SVC	@WINDOW
	LD	A,B		;P/u num char input
	LD	(SUBLEN),A	;Save below
	CALL	ENDLIN		;Move to next line
;
PLOOP	LD	HL,LBUFFER
	LD	B,80		;Max screen line length
	CALL	LINEIN		;Read a line from file
	JR	Z,SEARCH	;Okay--go and search
	CP	1CH		;end of file?
	JR	Z,EXITAP	;yes, go exit
	JP	IOERR
;
SEARCH	PUSH	DE		;Save FCB addr.
	LD	C,00H		;Set by init code
SUBLEN	EQU	$-1		;Linein returns input len in B
	LD	HL,LBUFFER
	LD	DE,SUBSTR
	CALL	INSTR
	POP	DE		;Restore FCB PTR
	OR	A		;test index returned in A
	JR	Z,PLOOP		;not found, loop next else
	CALL	DSPLINE		;Display line
	LD	A,3		;get count of lines, start on 2
LIN_CNT	EQU	$-1
	INC	A		;bump cursor line
	CP	22		;compare to bottom of screen
	JR	NZ,PLOOP1	;not at end of screen, go
	LD	HL,CONT_MSG
	LD	B,10		;Func: display line
	SVC	@WINDOW
	CALL	GETKEY		;prompt for key
	JR	C,EXITAP1	;Break or export, so quit
	LD	HL,CLS$		;Clear screen
	LD	B,10
	SVC	@WINDOW
	LD	A,0		;set count to 0
PLOOP1:	LD	(LIN_CNT),A
	JR	PLOOP		;Get next line
;
EXITAP	LD	HL,EXIT_MSG
	LD	B,10		;Func: display line
	SVC	@WINDOW
	CALL	GETKEY		;Wait for ENTER, BREAK, or export
				;before exiting
EXITAP1:
	LD	DE,FCB
	SVC	@CLOSE
EXITAP2:
	LD	SP,$-$		;P/u entry stack pointer
SPSAV	EQU	$-2
	LD	B,8
	SVC	@WINDOW		;Close the window
	RET
;
F_ERR:	LD	HL,FILE_ERR$
	LD	B,10		;Display message
	SVC	@WINDOW
	CALL	GETKEY
	JR	EXITAP2
;
IOERR	OR	0C0H		;Set short & return bits
	LD	C,A
	SVC	@FLAGS
	SET	7,(IY+'C'-'A')	;Get error message
	LD	DE,IOERR$+2	;  into a buffer
	SVC	@ERROR		;  past the LF,1EH
	LD	H,D		;Replace the CR with ETX
	LD	L,E
	LD	A,CR
	LD	B,A		;Make BC large
	CPIR			;Has to find it!!!
	DEC	HL		;Point to the CR
	LD	(HL),ETX
	LD	HL,IOERR$
	LD	B,10
	SVC	@WINDOW
	JR	EXITAP		;and quit program
;
GETKEY	LD	BC,0		;Accept only 1 key stroke
	SVC	@WINDOW
	RET	C		;break or export pressed
	CP	CR
	JR	NZ,GETKEY	;Loop, not valid response
	LD	C,0		;Set to no export
	RET
;
; LINEIN
;	Read a line of input from an open file or device
;	Line is placed in a buffer and is not echoed to
;	the screen or printer
;
LINEIN:	PUSH	HL		;Save beginning of buff
	LD	C,0		;to count characters
LOOP1	PUSH	DE
	LD	DE,FCB
	SVC	@GET
	POP	DE
	JR	Z,NOERR		;Go if no error reported
	OR	A
	JR	Z,LOOP1		;loop if no char available
	JR	ERROR
NOERR	CP	TAB		;Keep tab in line
	JR	Z,SAVCHR
	CP	CR
	JR	Z,END1		;Keep CR in line
	CP	LF
	JR	Z,END1		;and linefeed also
	CP	' '
	JR	C,EOF1		;Go if not ASCII
;
SAVCHR	LD	(HL),A		;Put char. in buff.
	INC	HL		;point to next space
	INC	C		;Add to count
	DJNZ	LOOP1		;Get next character
;
END1	LD	B,C		;Get count of char. saved
	INC	B		;Count terminating CR
	LD	(HL),CR		;Terminate string
	POP	HL		;Recover pointer
	XOR	A		;Set Z flag
	JR	OUT1		;and leave
;
EOF1	LD	A,C		;Get count
	OR	A		;Were any char. saved?
	JR	NZ,END1		;Yes -- normal end
	LD	A,1CH		;Else show EOF error
	OR	A
;
ERROR	POP	HL		;Clear stack
	LD	B,0		;No valid characters
;
OUT1	RET
;
;	INSTR
;Purpose:  Search for the first occurrence of a substring
;	   within a string and return its starting index.
;	   If the substring is not found a 0 is returned.
;
INSTR	DEC	HL		;Position one before string
	LD	(STRING),HL	;Save string address
	EX	DE,HL
	LD	(SUBSTG),HL
	LD	A,C		;Get length of substring
	OR	A
	JR	Z,NOTFND	;Exit if length of substring=0
	LD	(SUBLEN),A	;Save substring length
	LD	A,B		;Get length of string
	OR	A
	JR	Z,NOTFND	;Exit if length of string=0
	LD	(SLEN),A	;Save string length
	SUB	C		;A=string length - substring length
	JR	C,NOTFND	;Exit if string shorter than substring
	INC	A		;Count = difference in lengths + 1
	LD	B,A
	SUB	A		;Initial starting index = 0
	LD	(INDEX),A
SLP1	LD	HL,INDEX	;Increment starting index
	INC	(HL)
	LD	HL,SUBLEN	;C = length of substring
	LD	C,(HL)
	LD	HL,(STRING)	;Increment to next byte of string
	INC	HL
	LD	(STRING),HL	;HL = next address in string
	LD	DE,(SUBSTG)	;DE = starting address of substring
				;C = current value of count
CMPLP	LD	A,(DE)		;Get a character of substring
	CP	(HL)		;Compare to character of string
	JR	NZ,SLP2		;Jump if not same
	DEC	C
	JR	Z,FOUND		;Jump if substring found
	INC	HL
	INC	DE
	JR	CMPLP
SLP2	DJNZ	SLP1		;Try next higher index if enough
				;string left
	JR	NOTFND		;Else exit not found
;
FOUND	LD	A,(INDEX)	;Substring found, A = starting index
	RET
;
NOTFND	SUB	A		;Substring not found, A = 0
	RET
;
DSPLINE	LD	HL,LBUFFER	;Line buffer to display
	LD	B,80		;Maximum 80 characters
WLP1	LD	A,(HL)
	CP	CR
	JR	Z,ENDLIN
	CP	LF
	JR	Z,ENDLIN
	CP	TAB
	JR	NZ,DSPCHR
	PUSH	BC		;Save old count
	PUSH	DE
	PUSH	HL		;Save buffer ptr
	LD	C,8		;Expand tabs to 8 spaces
	LD	B,4		;Function, get cursor pos
	SVC	@WINDOW
	LD	E,L		;Set up for divide
	SVC	@DIV8
	LD	A,C		;A=8
	SUB	E		;Subtract remainder
WLP4	LD	B,A		;Move count to B
WLP2	LD	C,' '
	PUSH	BC		;Save count
	LD	B,9
	SVC	@WINDOW
	POP	BC		;P/u count
	DJNZ	WLP2
	POP	HL
	POP	DE
	POP	BC
	JR	WLP3
DSPCHR	LD	C,A
	PUSH	BC		;Save count
	LD	B,9
	SVC	@WINDOW
	POP	BC		;P/u count
WLP3	INC	HL		;Bump line ptr
	DJNZ	WLP1
ENDLIN	LD	BC,9<8+CR
	SVC	@WINDOW
	RET
;
;-----
;	This is the text buffer
;-----
CONT_MSG:
	DB	LF,'Press BREAK, or EXPORT to quit, and ENTER to continue',ETX
EXIT_MSG:
	DB	LF,'Press EXPORT, ENTER, or BREAK to quit',ETX
FILE_ERR$:
	DB	LF,'Invalid file name',ETX
FILEPMT	DB	'WFIND--ASCII file searcher by Aaron O''Neill, July 6, 1992',LF
	DB	'Search what text file? ',ETX
STRPMT	DB	LF,'Search for what string? ',ETX
CLS$	DB	1CH,1FH,ETX
FCB	DS	32
IOERR$	DB	LF,1EH
LBUFFER	DS	81
SUBSTR	DS	80
STRING	DW	$-$		;Base address of string
SUBSTG	DW	$-$		;Base address of substring
SLEN	DB	00H		;Length of string
INDEX	DB	00H		;Current index into string
;
;-----
;	Standard memory overflow check
;-----
	IF	$.GT.3000H		;Check on memory overflow
	ERR	'Memory overflow!!!'
	ENDIF
;-----
;	Zero last sector of application file - patch space
;-----
	IFLT	$,3000H
	DC	.HIGH.$.SHL.8-$+256,0	;Zero remainder of sector
	ENDIF
;
	END	START			;START must be 2800H
