; VTEXDO/asm    Videotext *DO filter for Model 4
; JGBender      29 Mar 84
;
;       ***     System Equates          ***
;
@ADTSK  EQU     29          ; install interrupt task DE in slot C
@CHNIO  EQU     20          ; chain IO SVC
@CKTSK  EQU     28          ; see if slot C is available
@CTL    EQU     5           ; send control byte
@DSPLY  EQU     10          ; display string =>{HL}
@EXIT   EQU     22          ; return to DOS
@FLAGS$ EQU     101         ; system flags
@GTDCB  EQU     82          ; get DCB of device named in DE
@HIGH$  EQU     100         ; get | set HIGH$
@LOGOT  EQU     12          ; abort/error log
@VDCTL  EQU     15          ; Video control SVC
@PARAM  EQU     17          ; extract command line parameters
@PAUSE  EQU     16          ; 14.3 usec delay per BC count
@PRT    EQU     6           ; send char to *PR
@RMTSK  EQU     30          ; remove task in Slot C
SOUND_PORT EQU  90H         ; Model 4 sound port  (@SOUND SVC is too slow)
;
;       ***     Filter  Equates         ***
;
K_CR     EQU    0DH         ; carriage return
K_LF     EQU    0AH         ; line feed
K_ESC    EQU    1BH         ; escape
K_CAN    EQU    18H         ; line kill (^X)
K_BELL   EQU    07H         ; bell
K_FF     EQU    0CH         ; form feed
K_TAB    EQU    09H         ; tab
K_BS     EQU    08H         ; backspace
;
;       ***     Escape sequence characters      ***
;
SET_RC   EQU    'Y'
MOV_UP   EQU    'A'
MOV_DOWN EQU    'B'
MOV_RIGH EQU    'C'
MOV_LEFT EQU    'D'
MOV_HOME EQU    'H'
CLR_EOP  EQU    'J'
CLS      EQU    'j'
CLR_EOL  EQU    'K'
DSP_80   EQU    'l'
DSP_40   EQU    'm'
REV_VID  EQU    'p'
NOR_VID  EQU    'q'
;
;
;       ***     Macros                  ***
;
SVC     MACRO  #SVC_NAME
        LD      A,#SVC_NAME
        RST     28H
        ENDM
;
;       ***     LOADER      ***
;
        ORG     3000H
;
BEGIN   PUSH    BC
        PUSH    HL          ; points to command buffer
        PUSH    DE
        POP     IX          ; put DCB pointer into IX
        LD      (MODDCB),DE ; stuff DCB ptr in actual filter
        LD      HL,HELLO$   ; ident
        SVC     @DSPLY      ; to screen
        POP     HL
;
; verify entered from SET command
;
        SVC     @FLAGS$        ; get flag ptr
        BIT     3,(IY+2)       ; System request ?
        JR      Z,VIASET       ;  must use SET, error -->
;
; parse for bell-to-printer parameter
;
        LD      DE,PARM     ; point to parameter table
        SVC     @PARAM
        JR      NZ,VIASET   ; parameter error
;       LD      A,(PR_PARM) ; fetch parse found flag
;       AND     40H         ; test if flag response
;       JR      Z,SET_HI    ;  default -->
        LD      A,(BELL_PR) ; get entered parameter value
        AND     08H         ; save just the BEEP_PR bit
        LD      (VTXFLAGS),A
;
;       install at HIGH$ and set new HIGH$
;
SET_HI  LD      HL,0        ; get current HIGH$
        LD      B,L
        SVC     @HIGH$
        JR      NZ,NOMEM    ; no memory available, error -->
        LD      (OLDHI),HL  ; put old HIGH$ into filter header
;
;       adjust relocation addresses
;
        LD      IY,RELTAB   ; point to relocation table
        LD      DE,VTXEND
        OR      A           ; clear CY
        SBC     HL,DE       ; compute load offset
        LD      B,H         ; move into BC
        LD      C,L
RLOOP
        LD      L,(IY)      ; get addr to relocate
        LD      H,(IY+1)
        LD      A,H         ; end of table ?
        OR      L
        JR      Z,RXEND
        LD      E,(HL)      ; P/U address
        INC     HL
        LD      D,(HL)
        EX      DE,HL       ; offset it
        ADD     HL,BC       ; {BC} contains offset value
        EX      DE,HL
        LD      (HL),D      ; and put back
        DEC     HL
        LD      (HL),E
        INC     IY          ; point to next relocation address
        INC     IY
        JR      RLOOP
;
;       move the module
;
RXEND   LD      DE,(OLDHI)  ; destination is old HIGH$ == end-of-pgm
        LD      HL,VTXEND   ; last byte of module
        LD      BC,LENGTH   ; length of filter
        LDDR
        EX      DE,HL       ; move new HIGH$ into {HL}
        SVC     @HIGH$
        INC     HL          ; bump to filter entry
        POP     AF          ; retrieve TYPE byte in {A}
        OR      40H         ; set Filter TYPE bit
        LD      (IX+0),A
        LD      (IX+1),L
        LD      (IX+2),H    ; install addr into DCB
        ;
        LD      B,8
        LD      C,'_'       ; make sure cursor is an underscore
        SVC     @VDCTL
        LD      HL,0        ; return successful
        JR      DONE
;
VIASET  LD      HL,VIASET$  ; error message
        JR      ERRORMSG
NOMEM   LD      HL,NOMEM$
ERRORMSG
        POP     BC          ; clear stack
        SVC     @LOGOT     ; display error msg, abort JCL
        LD      HL,-1       ; extended error
DONE    SVC     @EXIT
;
HELLO$  DB      ' VIDEOTEX Screen (*DO) Filter           '
        DB      '    Version 2.2    -Model 4-   LDOS 6.1',K_LF
        DB      ' Public Domain 1984                     '
        DB      '    J. Gary Bender, rIO grande software',K_CR
VIASET$ DB      K_LF,' Must install via:  SET *VT VTEXDO (BELLPR=ON|OFF)'
        DB      K_LF,'                    FILTER *DO *VT'
        DB      K_LF,' (B=ON) will send bells to *PR.'
        DB      K_LF,'  B=ON  is the default.',K_CR
NOMEM$  DB      K_LF,' High memory is not available !',K_CR
;
PARM    DEFB    80H         ; parameter table header
        DEFB    52H         ; param is FLAG, match 1 or 2 chars
        DB      'BE'
PR_PARM DEFB    0
        DEFW    BELL_PR
        DEFB    0           ; end table
BELL_PR DEFW    0FFFFH      ; recv word for flag
;
;
;       ***     FILTER      ***
;
VTXBEGIN JR     VTXSTART    ; std LDOS 6.1.x header
OLDHI   DEFW    VTXEND-1    ; last byte used by filter
        DEFB    MODDCB-VTXBEGIN-5  ; name length
        DEFM    'VtexDO'
MODDCB  DEFW    $-$         ; install at load time
        DEFW    0           ; for LDOS use
;
;       *** data used by filter ***
;
VTXFLAGS DEFB   08H         ; bit flags for current/pending actions
                            ; BEEP_PR defaults ON
ESCAPING   EQU    7           ; Bit in VTXFLAGS - processing an escape seq.
NEED_R     EQU    6           ; Bit in VTXFLAGS - need row setting
NEED_C     EQU    5           ; Bit in VTXFLAGS - need column setting
BEEP       EQU    4           ; Bit in VTXFLAGS - beep routine is active
BEEP_PR    EQU    3           ; Bit in VTXFLAGS - send beep to *PR
LAST_CHR DEFB   0           ; previous char sent
NEW_R    DEFB   0           ; new row position
BEEP_MAX EQU    06H         ; max beeper ticks (.10 sec in slot 11)
;
VTXSTART
        PUSH    IX
        JR      NZ,NOFILTER
        JR      FILTERIT  ; @PUT --> process it
        ;                   chain the rest on thru
SENDIT
        LD      (LAST_CHR),A    ; save "last char sent"
RX00    EQU     $-2
        POP     AF
        POP     HL
NOFILTER
        LD      IX,(MODDCB)
RX01    EQU     $-2
        SVC     @CHNIO
        POP     IX
        RET
;
FILTERIT
        PUSH    HL
        PUSH    AF
        LD      A,7FH       ; mask parity
        AND     C
        LD      C,A
        LD      HL,VTXFLAGS ; point to filter's flags
RX02    EQU     $-2
        BIT     ESCAPING,(HL)
        JP      NZ,GETESC   ; this is 2nd char of ESC sequence  -->
RX30    EQU     $-2
        BIT     NEED_C,(HL) ; need the column setting ?
        JP      NZ,SETRC    ;   yes -->
RX03    EQU     $-2
;
        CP      20H         ; a control character ?
        JR      NC,SENDIT   ;  no  -->
        CP      K_LF        ; ignore line-feeds after CR
        JR      NZ,CKTAB
        LD      A,(LAST_CHR) ; was last char a CR ?
RX04    EQU     $-2
        CP      K_CR
        JP      Z,IGNOREIT  ; yes, ignore the LF -->
RX32    EQU     $-2
        JR      JRSENDONE   ; else, send it
;
CKTAB   CP      K_TAB       ; tab ?
        JR      NZ,CKESC    ;  no  -->
        LD      C,' '       ; send 1 blank for a tab (add tab routine later)
        JR      JRSENDONE
;
CKESC   CP      K_ESC       ; ESCape character ?
        JR      NZ,CKCTLX   ;  no  -->
        SET     ESCAPING,(HL)
        JP      IGNOREIT
RX41    EQU     $-2
;
CKCTLX  CP      K_CAN       ; control-X ?
        JR      NZ,CKCR     ;  no -->
        LD      C,1DH
        POP     AF
        PUSH    AF
        LD      IX,(MODDCB)
RX05    EQU     $-2
        SVC     @CHNIO
        LD      C,1EH       ; erase e-o-l
        JR      SENDIT
;
CKCR    CP      K_CR        ; CR ?
        JR      NZ,CKBELL   ;  no -->
;
        LD      HL,LAST_CHR ; was last char a CR also ?
RX06    EQU     $-2
        CP      (HL)
        JR      Z,SENDIT    ;  yes -->
        ;       if not, line may have ended in col 80, this
        ;       code prevents false double CR.
        PUSH    BC          ; protect original regs
        LD      B,4         ; see where cursor is now
        SVC     @VDCTL
        POP     BC
        LD      A,L         ; column 0 ?
        OR      A
        JR      NZ,SENDONE  ; sent it, if not at col 1 now
        LD      A,C
        LD      (LAST_CHR),A
RX07    EQU     $-2
        JR      JRIGNORE    ; dont send CR if at Col 1 now
;
JRSENDONE JR    SENDONE
;
CKBELL  CP      K_BELL      ; BEL ?
        JR      NZ,CKIGNORE ;  no -->
        PUSH    DE
        PUSH    HL
        BIT     BEEP_PR,(HL)    ; send a ^G to *PR ?
        JR      Z,CKBELL3       ;  no  -->
        LD      DE,'RP'     ; fetch *PR DCB addr (SVC wants E=1st)
        SVC     @GTDCB
        JR      NZ,CKBELL3  ; not found  -->
        EX      DE,HL
        LD      C,0         ; test *PR ready
        SVC     @CTL
        JR      NZ,CKBELL3  ; not ready -->
        LD      C,K_BELL
        SVC     @PRT
CKBELL3 POP     HL
        POP     DE
        DI                  ; incase BELL is already executing
        LD      A,BEEP_MAX
        LD      (BEEP_CNT),A    ; set countdown in BEEPER task
RX20    EQU     $-2
        BIT     BEEP,(HL)   ; see if intrupt task already installed
        SET     BEEP,(HL)   ; turn it on in any case
        JR      NZ,CKBELL1  ; do not need to install
        LD      C,12        ; try to get high priority slot
CKBELL2 DEC     C
        SVC     @CKTSK
        JR      Z,CKBELL0   ; OK to use slot C
        LD      A,C         ; try down to slot 0
        OR      A
        JR      NZ,CKBELL2  ; continue loop
;
        LD      HL,VTXFLAGS ; no slots available -- remove flag
RX21    EQU     $-2
        RES     BEEP,(HL)
        LD      (BEEP_CNT),A    ; A==0 to get here
RX22    EQU     $-2
        JR      CKBELL1
CKBELL0
        LD      A,C         ; save slot number
        LD      (BEEP_SLOT),A
RX23    EQU     $-2
        PUSH    DE
        LD      DE,BEEPER   ; TCB pointer addr
RX24    EQU     $-2
        SVC     @ADTSK
        POP     DE
CKBELL1
;       EI                  ; re-enable interrupts
        JR      JRIGNORE
;
CKIGNORE
        CP      22          ; ignore ^V
        JR      Z,JRIGNORE
        CP      25          ; ignore ^Y
        JR      Z,JRIGNORE
        CP      26          ; ignore ^Z
        JR      Z,JRIGNORE
;
SENDONE LD      A,C
        JP      SENDIT
RX31    EQU     $-2
;
JRIGNORE JP     IGNOREIT    ;  but do not send the ESC char -->
RX40    EQU     $-2
;
;
GETESC                      ; determine ESCape sequence
        RES     ESCAPING,(HL) ; unmark ESCAPING
                            ; get 2nd character
        CP      SET_RC
        JR      NZ,GETE0
        SET     NEED_R,(HL)
        SET     NEED_C,(HL) ; set flags
        JR      JRIGNOR2
;
GETE0   CP      MOV_UP
        JR      NZ,GETE1
        LD      C,1BH       ; move UP
        JR      SENDONE
;
GETE1   CP      MOV_DOWN
        JR      NZ,GETE2
        LD      C,1AH       ; move down
        JR      SENDONE
;
GETE2   CP      MOV_RIGH
        JR      NZ,GETE3
        LD      C,19H       ; move right
        JR      SENDONE
;
GETE3   CP      MOV_LEFT
        JR      NZ,GETE4
        LD      C,18H       ; move left
        JR      SENDONE
;
GETE4   CP      MOV_HOME
        JR      NZ,GETE5
        XOR     A           ; home cursor, leave other settings
        LD      (NEW_R),A   ; set row = 0
RX08    EQU     $-2
        RES     NEED_R,(HL)
        LD      C,32        ; SET col = 0
        SET     NEED_C,(HL) ; mark NEED_C
        JR      SETRC
;
GETE5   CP      CLR_EOL
        JR      NZ,GETE6
        LD      C,1EH       ; clear end-of-line
        JR      SENDONE
;
GETE6   CP      CLR_EOP
        JR      NZ,GETE7
        LD      C,1FH       ; clear end-of-page
        JR      SENDONE
;
GETE7   CP      DSP_40
        JR      NZ,GETE8
        LD      C,17H       ; wide chars
        JR      SENDONE
;
GETE8   CP      DSP_80
        JR      NZ,GETE9
        LD      C,1CH
        POP     AF          ; recover @PUT flag
        PUSH    AF
        LD      IX,(MODDCB)
RX09    EQU     $-2
        SVC     @CHNIO
        LD      C,1FH       ; clear e-o-s
JRSEND1 JR      SENDONE
;
GETE9   CP      CLS
        JR      NZ,GETE10
        LD      C,0CH       ; form-feed
        JR      SENDONE
;
GETE10  CP      REV_VID
        JR      NZ,GETE11
        LD      C,10H       ; turn on reverse video
        JR      JRSEND1
;
GETE11  CP      NOR_VID
        JR      NZ,GETE12
        LD      C,11H       ; turn reverse video off
        JR      JRSEND1
;
GETE12                      ; ignore other ESC sequences
JRIGNOR2 JR     IGNOREIT
;
;
SETRC   LD      A,C         ; compute offset
        SUB     32
        LD      C,A
        BIT     NEED_R,(HL) ; need row ?
        JR      Z,SETRC2    ;  no -->
        CP      24          ;  yes, check range
        JR      C,SETRC1    ;   ok -->
        LD      A,23        ; set to max
SETRC1  LD      (NEW_R),A   ; save
RX10    EQU     $-2
        RES     NEED_R,(HL) ; clear flag
        JR      IGNOREIT
;
SETRC2  RES     NEED_C,(HL) ; clear flag
        CP      80          ; range check
        JR      C,SETRC3    ;   ok -->
        LD      A,79        ; set to max col
SETRC3  PUSH    BC
        LD      L,A         ; set up to move cursor
        LD      A,(NEW_R)   ; get new row
RX11    EQU     $-2
        LD      H,A
        LD      B,3         ; set cursor function
        SVC     @VDCTL
        POP     BC
        ; drop thru to  IGNOREIT
;
IGNOREIT
        POP     AF          ; ignore (do not send) the char
        POP     HL
        POP     IX          ; restore stack
        RET
;
;
;       ********        BEEPER  interrupt task          ********
;
BEEPER  DW      BEEPER0
RX25    EQU     $-2
BEEP_CNT  DB    0           ; mainline sets number of ticks
BEEP_SLOT DB    0           ; remember beeper slot number
;
BEEPER0                     ; if E=8, takes about 650 usec to execute
        LD      A,(IX+2)    ; check for countdown               4.75 usec
        OR      A               ;                               2.00
        RET     Z           ; counted down --> immediate return 1.25
        LD      E,8         ; number of cycles to send          1.75
                            ; should be OK at 9600 baud ...
BEEPER1
        LD      A,1         ; sound bit high    1.75
        OUT     (SOUND_PORT),A  ;               2.75
        LD      BC,2            ;               2.50
        SVC     @PAUSE          ;   14.3 * BC  29.00+-
        XOR     A           ; sound bit low     1.00
        OUT     (SOUND_PORT),A  ;               2.75
        LD      BC,2            ;               2.50
        SVC     @PAUSE         ;   14.3 * BC  29.00+-
        DEC     E               ;               1.00
        JR      NZ,BEEPER1      ;               3.00
        ;                       about 75 usec/cycle = 13.3 Khz+-
        DEC     (IX+2)      ; countdown                         5.75
        RET     NZ              ;                               2.50
;
        LD      HL,VTXFLAGS ; clear BEEP flag and kill task
RX26    EQU     $-2
        RES     BEEP,(HL)
        LD      A,(IX+3)    ; BEEP_SLOT
        LD      C,A
        SVC     @RMTSK      ; kill the beeper task
        RET
;
VTXEND  EQU     $-1
;
;
LENGTH  EQU     $-VTXBEGIN
RELTAB  DEFW    RX00,RX01,RX02,RX03,RX04,RX05,RX06,RX07,RX08,RX09
        DEFW    RX10,RX11
        DEFW    RX20,RX21,RX22,RX23,RX24,RX25,RX26
        DEFW    RX30,RX31,RX32
        DEFW    RX40,RX41,0
TABLEN  EQU     $-RELTAB/2-1
;
        END     BEGIN
