100 'DEMO1A/BAS
110 '             ************************
120 '             *   DEMO1A/BAS         *
130 '             *    02/23/87          *
140 '             ************************
150 SYSTEM "SYSTEM (BREAK=NO)"
160      '
170      'We will enter the machine language routine with HL pointing
180      'to MOD.NAME$ in memory.  Using that name, we will find
190      'the VIDMAN module in memory using the GTMOD SVC.
200      '
210      'GTMOD returns the address of the module in HL.
220      'We will transfer the module address to VIDMAN.ADDRESS% in
230      'lines 340-380.  If the module was not found, VIDMAN.ADDRESS%
240      'will equal 0.
250      '
260 DATA E5:          '      PUSH   HL          ;Save VIDMAN.ADDRESS%
270 DATA 5E:          '      LD     E,(HL)      ;Point DE
280 DATA 23:          '      INC    HL          ;to
290 DATA 56:          '      LD     D,(HL)      ;the name VIDMAN in memory
300 DATA 3E,53:       '      LD     A,GTMOD
310 DATA EF:          '      RST    28H         ;Execute the GTMOD SVC
320 DATA D1:          '      POP    DE          ;Get VIDMAN.ADDRESS% address
330                   '                         ;off stack into DE
340 DATA 7D:          '      LD     A,L         ;HL points to first byte of
350 DATA 12:          '      LD     (DE),A      ;memory header
360 DATA 13:          '      INC    DE
370 DATA 7C:          '      LD     A,H         ;put it in VIDMAN.ADDRESS%
380 DATA 12:          '      LD     (DE),A      ;for return
390 DATA C9:          '      RET
400 FIND.MOD$=""
410 VIDMAN.ADDRESS%=0
420 PRINT "Reading machine language routine to find VIDMAN module ..."
430 FOR ZZ1%=1 TO 14
440   READ ZZ1$
450   FIND.MOD$=FIND.MOD$+CHR$(VAL("&H"+ZZ1$))
460 NEXT ZZ1%
470      '
480      'The above section reads the machine language routine into
490      'FIND.MOD$.
500      '
510 MOD.NAME$="VIDMAN"+CHR$(3)
520      '
530      'Module names must end in ETX(03H) for GTMOD SVC.
540      '
550 ZZ1%=VARPTR(FIND.MOD$)
560      '
570      'ZZ1% has address of the machine language routine string variable.
580      '
590 FIND.MOD%=CVI(CHR$(PEEK(ZZ1%+1))+CHR$(PEEK(ZZ1%+2)))
600      '
610      'A string variable in BASIC exists in memory as a length byte
620      'followed by the address.  Hence, FIND.MOD% is determined by
630      'PEEKing at the location VARPTR returns plus 1 and 2 for
640      'the address to the beginning of the machine language routine.
650      '
660 ZZ1%=VARPTR(MOD.NAME$)
670 VIDMAN.ADDRESS%=CVI(CHR$(PEEK(ZZ1%+1))+CHR$(PEEK(ZZ1%+2)))
680      '
690      'The same reason for VIDMAN.ADDRESS%.  To simplify the CALL
700      'VIDMAN.ADDRESS% is given the the address of the MOD.NAME$
710      'for the GTMOD SVC to use, and return from the machine language 
720      'routine loads VIDMAN.ADDRESS% with the memory address of VIDMAN.
730      '
740 PRINT "Calling machine language routine to find VIDMAN module ..."
750 CALL FIND.MOD%(VIDMAN.ADDRESS%)
760 IF VIDMAN.ADDRESS%<>0 THEN GOTO 850
770      '
780      'If VIDMAN.ADDRESS% comes back as 0 then VIDMAN wasn't loaded
790      '
800 CLS
810 CLS:SOUND 1,1
820 PRINT@(6,0),"VIDMAN not installed -- must install prior to entering BASIC"
830 PRINT@(12,0),"":STOP
840      '
850      'Now to load DEMO02/VCB into the bottom of the buffer.
860      '
870 PRINT "Loading DEMO02/VCB into buffer space ..."
880 BUFF.BOT%=CVI(CHR$(PEEK(VIDMAN.ADDRESS%+11))+CHR$(PEEK(VIDMAN.ADDRESS%+12)))
890 OPEN"R",1,"DEMO02/VCB",1
900      '
910      'Open with a record length of 1.
920      '
930 FIELD 1,1 AS ZZ1$
940      '
950      'Field as ZZ1$, then can use ASC(ZZ1$) for POKing.
960      '
970 I%=BUFF.BOT%
980 DEMO02%=BUFF.BOT%
990      '
1000      'Start at the bottom of the buffer we established in DEMO/BAS.
1010      'Also note the address where DEMO02/VCB starts for later use.
1020      '
1030 GET 1
1040      '
1050      'Get first record (LRL=1), to start loop.
1060      '
1070 WHILE EOF(1)=0
1080 POKE I%,ASC(ZZ1$)
1090 I%=I%+1
1100 GET 1
1110 WEND
1120 CLOSE
1130 POKE I%,ASC(ZZ1$)
1140      '
1150      'POKE last character from file
1160      '
1170 UBUFF.ADDRESS%=I%+1
1180      '
1190      'This is where we will start UBUFF!
1200      '
1210 GOTO 2500      'After setup, start the main program
1220      '
1230      'Load UBUFF subroutine
1240      '
1250      'When called by GOSUB, this routine will load the first
1260      'byte of the UBUFF with STATUS$, so prior to calling,
1270      'STATUS$ is loaded with D, M, or R.
1280      '
1290 POKE UBUFF.ADDRESS%,ASC(STATUS$)
1300      '
1310 I%=UBUFF.ADDRESS%+1
1320      '
1330      'NUM.ITEMS% is used to tell the subroutine how many data items
1340      'to load into the UBUFF.  Data items are loaded into UBUFF$()
1350      'prior to GOSUB.
1360      '
1370 FOR I1%=1 TO NUM.ITEMS%
1380 FOR I2%=1 TO LEN(UBUFF$(I1%))
1390 POKE I%,ASC(MID$(UBUFF$(I1%),I2%,1))
1400 I%=I%+1
1410 NEXT I2%
1420      '
1430      'Each character is individually poked into the UBUFF.
1440      'This is a fairly slow method, but will be required any time
1450      'the required UBUFF length exceeds 256 characters.  Otherwise,
1460      'the method shown in LOANS/BAS can be used to up and down load 
1470      'data.
1480      '
1490 POKE I%,13
1500      '
1510      'And followed by a carriage return.
1520      '
1530 I%=I%+1
1540 NEXT I1%
1550 POKE I%,&H3
1560      '
1570      'And then by ETX(03H).
1580      '
1590 I%=I%+1
1600 IF LEN(EMSG$)=0 THEN 1680
1610 FOR I2%=1 TO LEN(EMSG$)
1620 POKE I%,ASC(MID$(EMSG$,I2%,1))
1630 I%=I%+1
1640 NEXT I2%
1650      '
1660      'Load EMSG after the data stream.
1670      '
1680 POKE I%,&H3
1690      '
1700      'Followed by ETX(03H).
1710      '
1720 I%=I%+1
1730 POKE I%,CURPOS%
1740      '
1750      'And CURPOS.
1760      '
1770 POKE I%+1,&H81
1780      '
1790      'And end the UBUFF with 81H, logical end marker.
1800      '
1810 IF STATUS$<>"D" THEN 1890
1820 ZZ1%=VARPTR(VCB$)
1830 VCB.ADDRESS%=CVI(CHR$(PEEK(ZZ1%+1))+CHR$(PEEK(ZZ1%+2)))
1840      '
1850      'For a disk read of the /VCB file, VCB.ADDRESS% will be
1860      'the name of the file.
1870      '
1880 GOTO 2020
1890 IF STATUS$="M" THEN VCB.ADDRESS%=VCB%
1900      '
1910      'For a memory read of the /VCB file, we set VCB% equal
1920      'to the memory address and load that into VCB.ADDRESS%.
1930      '
1940 IF STATUS$="R" THEN VCB.ADDRESS%=0
1950      '
1960      'For reuse of the existing screen, it does not matter
1970      'what VCB.ADDRESS% equals.  Remember not to clear the
1980      'screen if you intend to reuse it since VIDMAN does
1990      'not redisplay the text.
2000      '
2010 IF STATUS$<>"D" AND STATUS$<>"M" AND STATUS$<>"R" THEN STOP
2020 CALL VIDMAN.ADDRESS%(VCB.ADDRESS%,UBUFF.ADDRESS%)
2030 STATUS%=PEEK(UBUFF.ADDRESS%)
2040      '
2050      'We set STATUS% equal to the ASCII code of the first
2060      'character in the UBUFF, the status byte.  This lets us use
2070      'the status byte to branch as required.
2080      '
2090 IF STATUS%<128 THEN GOTO 2260
2100      '
2110      'When the status byte is less than 80H, an error has occurred.
2120      'The branch is to the error section.
2130      '
2140 I%=UBUFF.ADDRESS%+1
2150 FOR I1%=1 TO 50
2160 UBUFF$(I1%)=""
2170 ZZ1%=PEEK(I%):I%=I%+1
2180 IF ZZ1%>31 THEN UBUFF$(I1%)=UBUFF$(I1%)+CHR$(ZZ1%):GOTO 2170
2190 IF ZZ1%=3 OR ZZ1%=129 THEN RETURN
2200 IF ZZ1%=13 THEN NEXT I1%
2210      '
2220      'When an error has not occurred, the UBUFF is downloaded into
2230      'UBUFF$(), where the first data item goes into UBUFF$(1).
2240      '
2250      '
2260 'VIDMAN error handling
2270 IF STATUS%>&H44 THEN 2290
2280 CLS:PRINT "TRSDOS error number DECIMAL: ";STATUS%:STOP
2290 IF STATUS%<>&H45 THEN 2310
2300 CLS:PRINT "/VCB file format error":STOP
2310 IF STATUS%<>&H46 THEN 2330
2320 CLS:PRINT "UBUFF Format error":STOP
2330 IF STATUS%<>&H47 THEN 2350
2340 CLS:PRINT "Invalid status byte in buffer":STOP
2350 IF STATUS%<>&H48 THEN 2370
2360 CLS:PRINT "UBUFF to short -- 80H encountered"
2370 CLS:PRINT "UNSPECIFIED ERROR":STOP
2380      '
2390      'The entire section above is usable in other programs
2400      'pretty much as is, except for loading DEMO02/VCB into
2410      'memory.  Although it looks like a lengthy programming section,
2420      'after all the remarks are removed, it isn't.  Also, once
2430      'you are familiar with the workings of VIDMAN, this section
2440      'requires little modification for reuse in other programs.
2450      '
2460      'The following section is specific to the demonstration program
2470      'and is an example of moving among screens, using the status of
2480      'return for branching, and handling data.
2490      '
2500      'Main Program
2510      '
2520 ENTER%=128
2530 F1%=129
2540 F2%=130
2550 F3%=131
2560 DATA1$="A"
2570      '
2580      'Display the first demonstration screen, DEMO01/VCB.
2590      '
2600 CLS
2610 VCB$="DEMO01"+CHR$(13)
2620      '
2630      'Let the subroutine know the filename to use (end it with a
2640      'carriage return).
2650      '
2660 STATUS$="D"
2670      '
2680      'And the status byte.
2690      '
2700 EMSG$=""
2710      '
2720      'EMSG string is null when first displayed in this case.
2730      '
2740 CURPOS%=1
2750      '
2760      'Set CURPOS to the first field.
2770      '
2780 NUM.ITEMS%=0
2790      '
2800      'We do not want to upload any data to the screen, so NUM.ITEMS%
2810      'is set to 0 for the subroutine.
2820      '
2830 GOSUB 1230
2840      '
2850      'Use the subroutine we set up to load data into the UBUFF, call
2860      'VIDMAN, and unload data into UBUFF$() -- there will be no data
2870      'downloaded from this screen.
2880      '
2890 IF STATUS%=ENTER% THEN 3090
2900      '
2910      'We set STATUS% to the ASCII value of the status byte in the
2920      'subroutine -- now we can use it for branching.  If the
2930      'display screen was left using the enter key, we want to go
2940      'to the next screen.
2950      '
2960 IF STATUS%=F3% THEN STOP
2970      '
2980      'If the user left the screen by way of the F3 key, stop the
2990      'program.
3000      '
3010 EMSG$="F1, F2 not supported"
3020 STATUS$="R"
3030 GOTO 2740
3040      '
3050      'Otherwise, we must have left the screen with F1 or F2, which
3060      'are not supported on this screen.  So, we load EMSG$, change
3070      'the status to R for reuse, and reuse the screen.
3080      '
3090 CLS
3100 VCB%=DEMO02%
3110      '
3120      'We kept track of the memory location of the beginning of 
3130      'DEMO02/VCB in the variable DEMO02%.  Setting VCB% equal
3140      'to it lets the subroutine know where it is.
3150      '
3160 STATUS$="M"
3170 EMSG$=""
3180 NUM.ITEMS%=1
3190 UBUFF$(1)=DATA1$
3200 CURPOS%=1
3210      '
3220      'Again, set up the variables for the subroutine.
3230      'We will use DATA1$ to hold the user's response from the
3240      'data input field.  Remember, this is the screen that
3250      'allows input of 1 character and then keeps track of it.
3260     '
3270      '
3280 GOSUB 1230
3290 DATA1$=UBUFF$(1)
3300      '
3310      'The first thing to do is to get the data out of UBUFF$()
3320      'since UBUFF$() is reused each time a screen is displayed.
3330      '
3340 IF STATUS%=ENTER% THEN 3540
3350 IF STATUS%=F1% THEN 2600
3360 IF STATUS%=F3% THEN STOP
3370      '
3380      'Similar technique on checking the status of return, except
3390      'that the F1 key causes a return to the previous display screen.
3400      '
3410 EMSG$="F2 not supported"
3420 NUM.ITEMS%=0
3430 STATUS$="R"
3440      '
3450      'When a display screen is to be redisplayed, it is not necessary
3460      'to upload data into the UBUFF unless you want to do so.  Any
3470      'data input on the screeen is retained automatically.  It is
3480      'generally faster not to reload data.
3490      '
3500 GOTO 3200
3510      '
3520      'AND THE LAST SCREEN, DEMO03/VCB.
3530      '
3540 CLS
3550 VCB$="DEMO03"+CHR$(13)
3560 STATUS$="D"
3570 EMSG$=""
3580 NUM.ITEMS%=1
3590 UBUFF$(1)=STATUS$
3600      '
3610      'A protected field in the top line of the display screen
3620      'will be loaded with the status character.
3630      '
3640 CURPOS%=1
3650 GOSUB 1230
3660 IF UBUFF$(2)="9" THEN 3780
3670 EMSG$="DATA 1 <> 9"
3680 STATUS$="R"
3690 GOTO 3580
3700      '
3710      'Here, we check to see if the data entry is 9.  Notice that
3720      'it is in UBUFF$(2) since the one protected field is UBUFF$(1).
3730      '
3740      'Also notice that VIDMAN returns only character data, even for
3750      'numeric input fields.  Use BASIC's VAL function to change
3760      'UBUFF$() strings to numeric data.
3770      '
3780 IF STATUS%=ENTER% THEN STOP
3790 IF STATUS%=F1% THEN 3090
3800 IF STATUS%=F3% THEN STOP
3810 EMSG$="F2 NOT SUPPORTED"
3820 STATUS$="R"
3830 GOTO 3580
3840 STOP
3