100 '             ************************
110 '             *   DEMO/BAS           *
120 '             *    02/23/87          *
130 '             ************************
140 'This is a starter program for DEMO1/BAS required to set up buffer
150 'space below BASIC.  This first section locates VIDMAN in memory.
160 'The new bottom for BASIC will be poked into VIDMAN's memory header,
170 'as will the original bottom for BASIC.
180 'That way, DEMO/BAS can check to see if the buffer is already there
190 'and prevent spiraling inflation of the buffer size each time it
200 'is run.  THIS IS IMPORTANT, but understanding it is not really
210 'necessary.  See HARDIN BROTHERS article, 80 MICRO, 3/87.
220 '
230 'To use this program for starting your own programs, determine the
240 'amount of buffer space you need and change lines 780 and 890 accordingly.
250 'Then change the name of the program to run in line 1700.
260 '
270 'It is not nexessary to exit BASIC to run a second program using VIDMAN
280 'but it is prudent to run a starter program such as this ahead of
290 'the next program.
300 '
310 SYSTEM "SYSTEM (BREAK=NO)"
320 DATA E5,5E,23,56,3E,53,EF,D1,7D,12,13,7C,12,C9
330 FIND.MOD$=""
340 VIDMAN.ADDRESS%=0
350 FOR ZZ1%=1 TO 14
360   READ ZZ1$
370   FIND.MOD$=FIND.MOD$+CHR$(VAL("&H"+ZZ1$))
380 NEXT ZZ1%
390 MOD.NAME$="VIDMAN"+CHR$(3)
400 ZZ1=VARPTR(FIND.MOD$)
410 FIND.MOD=CVI(CHR$(PEEK(ZZ1+1))+CHR$(PEEK(ZZ1+2)))
420 ZZ1=VARPTR(MOD.NAME$)
430 VIDMAN.ADDRESS%=CVI(CHR$(PEEK(ZZ1+1))+CHR$(PEEK(ZZ1+2)))
440 CALL FIND.MOD(VIDMAN.ADDRESS%)
450 IF VIDMAN.ADDRESS%<>0 THEN GOTO 540
460 CLS
470 CLS:SOUND 1,1
480 PRINT@(6,0),"VIDMAN not installed -- must install prior to entering BASIC"
490 PRINT@(12,0),"":STOP
500 '
510 'The above section is described in DEMO1/BAS
520 '
530 'Now determine a new bottom for BASIC to allow for buffer requirements
540 '
550 BOTTOM.BASIC=CVI(CHR$(PEEK(&H6E9E))+CHR$(PEEK(&H6E9F)))
560      '
570      '6E9EH holds a pointer to BASIC's table area.  By changing it
580      'we will leave some buffer space we will use for VIDMAN.
590      '
600 CHECK1=CVI(CHR$(PEEK(VIDMAN.ADDRESS%+11))+CHR$(PEEK(VIDMAN.ADDRESS%+12)))
610 CHECK2=CVI(CHR$(PEEK(VIDMAN.ADDRESS%+13))+CHR$(PEEK(VIDMAN.ADDRESS%+14)))
620      '
630      'VIDMAN has 12 bytes for programmer usage beginning with
640      'the 11th byte in the memory header.
650      '
660      'We will use the first 2 to hold BASIC's original table pointer
670      'and the next 2 to hold the current value.
680      '
690      'That way, we can check to see if buffer space is already 
700      'available from a previous run, check to see if it is large
710      'large enough for this application, and change it if we need to.
720      '
730 IF CHECK1=0 AND CHECK2=0 THEN CHECK1=BOTTOM.BASIC:GOTO 890
740      '
750      'If CHECK1 and CHECK2 are 0, then the table pointer has not been
760      'altered for VIDMAN.  VIDMAN loads the 12 spare bytes with 00H.
770      '
780 IF CHECK2=BOTTOM.BASIC AND CHECK2=CHECK1+1100+4 THEN 1300
790      '
800     'If the current bottom is the same as the address contained in
810     'VIDMAN's header and the buffer is large enough (1100 bytes),
820      'don't expand again.  Just insure format is ok.
830      '
840 BOTTOM.BASIC=CHECK1   'Reset to original bottom
850      '
860      'If the buffer is not large enough, reset to the original
870      'bottom.  This also prevents recurring increases in the buffer size.
880      '
890 NEW.BOTTOM=BOTTOM.BASIC+1100+4
900      '
910      'We plan to add DEMO02/VCB to the buffer for a memory call
920      'to VIDMAN.
930      'DEMO02/VCB is 866 bytes and we want a 200 byte UBUFF --
940      'make it 1100 bytes of buffer space by adding 1100 to the
950      'value found at 6E9EH (MSB) and 6E9F (LSB).
960      '
970      'The extra 4 bytes are for 80H (physical end of UBUFF) and
980      '3 00H bytes BASIC requires to be present ahead of the tables.
990      '
1000 A$=HEX$(CHECK1)
1010 A1$=RIGHT$(A$,2)  'LSB
1020 A2$=LEFT$(A$,2)   'MSB
1030 POKE VIDMAN.ADDRESS%+11,VAL("&H"+A1$)
1040 POKE VIDMAN.ADDRESS%+12,VAL("&H"+A2$)
1050      '
1060      'Poke BASIC's original pointer into bytes 11 and 12 of 
1070      'VIDMAN's header.
1080      '
1090 A$=HEX$(NEW.BOTTOM)
1100 A1$=RIGHT$(A$,2)  ' LSB
1110 A2$=LEFT$(A$,2)   ' MSB
1120 POKE VIDMAN.ADDRESS%+13,VAL("&H"+A1$)
1130 POKE VIDMAN.ADDRESS%+14,VAL("&H"+A2$)
1140      '
1150      'And poke the new address into bytes 13 and 14 of the header.
1160      '
1170 FOR I%=NEW.BOTTOM-3 TO NEW.BOTTOM+4
1180   POKE I%,0
1190 NEXT I%
1200      '
1210      'Insure the 3 bytes prior to the table address are 00H for 
1220      'BASIC's sake.
1230      '
1240 POKE &H6E9E,VAL("&H"+A1$)
1250 POKE &H6E9F,VAL("&H"+A2$)
1260      '
1270      'Last item is to poke the new pointer address into 6E9EH.
1280 '
1290      '
1300      'Now let's fix up the buffer so we know what is there.
1310      '
1320 BUFF.BOT%=CVI(CHR$(PEEK(VIDMAN.ADDRESS%+11))+CHR$(PEEK(VIDMAN.ADDRESS%+12)))
1330      '
1340      'Remember we put the old bottom of the BASIC tables in the
1350      '11th and 12th bytes of VIDMAN's header.  Now we can use those to 
1360      'find the beginning of our buffer.
1370      '
1380 BUFF.TOP%=CVI(CHR$(PEEK(VIDMAN.ADDRESS%+13))+CHR$(PEEK(VIDMAN.ADDRESS%+14)))
1390      '
1400      'And we can locate the end of the buffer since it is the new bottom
1410      'of BASIC's tables.
1420      '
1430 IF BUFF.BOT%=0 OR BUFF.TOP%=0 THEN PRINT "DEMO/BAS WAS NOT RUN":STOP
1440      '
1450      'Check to insure a buffer was left.
1460      '
1470 BUFF.TOP%=BUFF.TOP%-4
1480     '
1490     'And leave the 00H bytes in the last 3 positions.
1500     '
1510      'Now let's fill the buffer with a known value so we know what is
1520      'there.
1530      '
1540 I%=BUFF.BOT%
1550 PRINT "Clearing buffer space below BASIC tables ..."
1560 WHILE I%<BUFF.TOP%
1570 POKE I%,0
1580 I%=I%+1
1590 WEND
1600      '
1610      'And POKE a 80H into the last byte to set the physical end of UBUFF.
1620      '
1630 POKE I%,&H80
1640      '
1650      'It is best not to attach a program after manipulating BASIC as
1660      'we have.  So, we will use the RUN command for our demonstration
1670      'program.
1680      '
1690 PRINT "Loading DEMO1A/BAS ..."
1700 RUN "DEMO1A/BAS"
1710 END
A