{=================== Model 4 Video Routines ==============}
{ Routines to control the TRS-80 Model 4 Video Display    }
{ R1V1 860615 Joe Oglesby - Nexial Systems  813/866-9281  }
{ Alcor/TRS-80 Pascal Version 2.0                         }
{ TRSDOS 6 Reference Manual, pages A-46 to A-47           }
{ Please leave messages on Shamrock BBS in Tampa FL       }
{ 813/681-2611 8/N/1 300/1200 baud                        }

procedure CursOn; {turns video cursor on}
 const Code = '#0E'; begin WriteCh (Code) end;

procedure CursOff; {turns video cursor off}
 const Code = '#0F'; begin WriteCh (Code) end;

procedure RVidOn;  {turns reverse video on}
 const Code = '#10';begin WriteCh (Code) end;

procedure RVidOff; {turns reverse video off}
 const Code = '#11';begin WriteCh (Code) end;

procedure DispChar (Ch: char); {Display video characters 1-255}
 const Prefix = '#00'; Blank = '#20';
 begin
  if (Ch < Blank) then
   WriteCh (Prefix);  {Video char 1-31}
  WriteCh (Ch)
 end;

procedure AltSpcTog; {toggle between special characters and space compression}
 const Code = '#15'; begin WriteCh (Code) end;

procedure CharSet (ModeWanted:boolean);
 {***** WARNING **** WILL CLEAR SCREEN ****}
 {Mode = true for Special Characters, False for Space compression}
 {This is not elegant. Please let me know if there is an easier method
  of determining the video character modes (Space Compression, Set 1, Set 2}

 const Code = '#C5'; {If SpaceComp on, Col should = 5}
 var Col, Row: integer; CurrentMode: boolean;
 procedure ReadCursor (var Col, ROw: integer);external;
 begin

  ClearScreen; DispChar (Code); ReadCursor (Col, Row);

  CurrentMode := (Col = 1);

  if (CurrentMode <> ModeWanted) then
   AltSpcTog;

  ClearScreen;

 end;

procedure AltChrTog; { toggle between special characters & alt char}
 const Code = '#16'; begin WriteCh (Code) end;

procedure Vid40; { Set to display 40 char per line}
 const Code = '#17'; begin WriteCh (Code) end;

{ Codes #18-#1B (24-27) are used for cursor control}

procedure ResetVideo; {resets video to 80 col, normal video, homes cursor}
 const Code = '#1C'; begin WriteCh (Code) end;

procedure ClrLine; {erase line, reset cusor to start of line}
 const Code = '#1D'; begin WriteCh (Code); end;

procedure ClrEoLn; {erase screen to end of line; cursor not affected}
 const Code = '#1E'; begin WriteCh (Code) end;

procedure ClrEoScr;{erase screen to end of screen; cursor not affected}
 const Code = '#1F'; begin WriteCh (Code) end;
{=========================== End VidLib Routines ======================}