;	ANIMATE/ASM
;
*GET	EQUATES
;
	ORG	3000H
;
IMAGE	DS	19200
WRKBUF	DS	240
KBDMAP	DS	8
XPOS	DB	37
YPOS	DB	96
XTEMP	DB	0
YTEMP	DB	0
RYTCYC	DB	-1
LEFTCYC	DB	-1
UPCYCLE	DB	-1
DOWNCYC	DB	-1
;
*GET	BILL/DAT
;
TASK	DW	WAIT		;called every 1/30th of a second
COUNTER	DB	2		;IX+2
FLAG	DB	0		;IX+3
WAIT	DEC	(IX+2)
	RET	NZ		;if COUNTER > 0
	LD	(IX+2),2	;else reset COUNTER
TIMER	EQU	$-1
	LD	(IX+3),-1	;   and set flag every TIMER/30 seconds
	RET
;
;
BEGIN	LD	DE,'IK'		;get address of *ki driver
	SVC	@GTDCB
	LD	(KIDCB),HL	;store for keyboard scan
;
; copy gfx board RAM to computer RAM @ IMAGE
;
	DI
	LD	A,11010111B	;gfx on, txt off, auto inc Y on read
	OUT	(CONTROL),A	;CONTROL = 83H
	LD	HL,IMAGE
	LD	BC,XREG		;XREG = 80H
	LD	E,0		;x position
	LD	A,80
BGN010	OUT	(C),E		;send E out port 80H
	INC	C
	OUT	(C),B		;send 0 out port 81H
	INC	C		;C = 82H
	LD	B,240
	INIR			;read column to image buffer
	DEC	C
	DEC	C		;C = 80H
	INC	E
	DEC	A
	JR	NZ,BGN010
;
	LD	DE,TASK
	LD	C,8
	SVC	@ADTSK		;install timing brake task
	EI
;
	LD	A,01110111B	;gfx on, txt off, inc Y on write
	OUT	(CONTROL),A
	LD	HL,FRONT
	JP	DISPLAY		;put Bill in middle of screen
;
GETKEY	LD	DE,$-$		;copy kbd map to KBDMAP
KIDCB	EQU	$-2
	LD	C,255
	LD	IY,KBDMAP
	SVC	@CTL
	LD	A,(IY-4)	;p/u byte for keys '0' - '7'
	AND	3EH		;mask out bits for '7', '6' & '0'
	JR	Z,GTK030	;go if '1' thru '5' not pressed
	LD	C,0
GTK010	RRA
	JR	C,GTK020
	INC	C
	JR	GTK010
GTK020	LD	A,C		;A = one less than # of shifts to CY
	DI			;   (e.g., 02H becomes 1; 20H becomes 5)
	LD	(TIMER),A	;change brake task delay time
	EI
;
GTK030	LD	BC,0FF00H	;B <> 0 forces extern, C = joystick port #
	IN	A,(C)		;read joystick port
	CPL			;reverse bits
	LD	E,A		;and store result in E
	LD	A,(IY-2)	;get keyboard image of arrows + space, etc.
	SRL	A		;lose ENTER bit
	SRL	A		;lose CLEAR bit
	SRL	A		;shift BREAK bit to C flag
	JP	C,EXIT		;go if break was pressed
	OR	E		;merge keyboard and joystick input
	JR	Z,GETKEY	;go if no input
	PUSH	AF		;   else save input data
;
GTK050	LD	A,(FLAG)
	OR	A
	JR	Z,GTK050	;wait for task to OK next graphics write
	DI
	INC	A
	LD	(FLAG),A	;reset FLAG
	LD	A,(TIMER)
	LD	(COUNTER),A	;reset COUNTER
	EI
;
	POP	AF		;restore input data
	LD	HL,DISPLAY	;RET address for all branches
	PUSH	HL
;
;  The bits in A have the following meanings:
;	bit 0 = north			(up)
;	    1 = south			(down)
;	    2 = west			(left)
;	    3 = east			(right)
;	    4 = fire			(fire button/space bar)
;	  5-7 - not used
;
	SLA	A		;each address is 2 bytes
	LD	L,A
	LD	H,0
	LD	DE,GTK060	;address table base
	ADD	HL,DE
	LD	A,(HL)		;p/u lsb
	INC	HL
	LD	H,(HL)		;p/u msb
	LD	L,A
	JP	(HL)
;
GTK060	DW	NOTHING		;00000 = no keyboard/joystick input
	DW	NORTH		;00001 = N
	DW	SOUTH		;00010 = S
	DW	NOTHING		;00011 = S-N	(not used in this program)
	DW	WEST		;00100 = W
	DW	NORTHWEST	;00101 = W-N
	DW	SOUTHWEST	;00110 = W-S
	DW	WEST		;00111 = W-S-N
	DW	EAST		;01000 = E
	DW	NORTHEAST	;01001 = E-N
	DW	SOUTHEAST	;01010 = E-S
	DW	EAST		;01011 = E-S-N
	DW	NOTHING		;01100 = E-W	(not used in this program)
	DW	NORTH		;01101 = E-W-N
	DW	SOUTH		;01110 = E-W-S
	DW	NOTHING		;01111 = E-W-S-N (not used in this program)
	DW	FIRE		;10000 = fire only
	DW	NORTH		;10001 = F-N
	DW	SOUTH		;10010 = F-S
	DW	FIRE		;10011 = F-S-N
	DW	WEST		;10100 = F-W
	DW	NORTHWEST	;10101 = F-W-N
	DW	SOUTHWEST	;10110 = F-W-S
	DW	WEST		;10111 = F-W-S-N
	DW	EAST		;11000 = F-E
	DW	NORTHEAST	;11001 = F-E-N
	DW	SOUTHEAST	;11010 = F-E-S
	DW	EAST		;11011 = F-E-S-N
	DW	FIRE		;11100 = F-E-W
	DW	NORTH		;11101 = F-E-W-N
	DW	SOUTH		;11110 = F-E-W-S
	DW	FIRE		;11111 = F-E-W-S-N
;
NOTHING	POP	HL		;clear RET addr off stack
	JP	GETKEY
;
FIRE	POP	HL		;clear stack
	JP	EXIT
;
NORTH	LD	A,-1
	LD	(RYTCYC),A
	LD	(LEFTCYC),A
	LD	(DOWNCYC),A
	LD	A,(UPCYCLE)
	INC	A
	AND	3
	LD	(UPCYCLE),A
	BIT	0,A
	JR	NZ,NTH010
	LD	HL,BACK
	JR	NTH030
NTH010	BIT	1,A
	JR	NZ,NTH020
	LD	HL,RSTEPB
	JR	NTH030
NTH020	LD	HL,LSTEPB
NTH030	LD	A,(YPOS)
	OR	A
	RET	Z		;no change if already at top
	SUB	3
	LD	(YPOS),A	;else move three lines up
	OUT	(YREG),A
	RET
;
SOUTH	LD	A,-1
	LD	(RYTCYC),A
	LD	(LEFTCYC),A
	LD	(UPCYCLE),A
	LD	A,(DOWNCYC)
	INC	A
	AND	3
	LD	(DOWNCYC),A
	BIT	0,A
	JR	NZ,STH010
	LD	HL,FRONT
	JR	STH030
STH010	BIT	1,A
	JR	NZ,STH020
	LD	HL,RSTEPF
	JR	STH030
STH020	LD	HL,LSTEPF
STH030	LD	A,(YPOS)
	CP	195
	RET	NC		;no change if already at bottom
	ADD	A,3
	LD	(YPOS),A	;else move three lines up
	OUT	(YREG),A
	RET
;
NORTHEAST
	CALL	NTH030
	JR	EAST
;
SOUTHEAST
	CALL	STH030
;
EAST	LD	A,(XPOS)
	CP	74
	JR	Z,EST010	;no change if already max right
	INC	A
	LD	(XPOS),A	;else move one byte right
EST010	LD	A,-1
	LD	(LEFTCYC),A
	LD	(UPCYCLE),A
	LD	(DOWNCYC),A
	LD	A,(RYTCYC)
	INC	A
	AND	3
	LD	(RYTCYC),A
	BIT	0,A
	JR	NZ,EST020
	LD	HL,RIGHT
	RET
EST020	BIT	1,A
	JR	NZ,EST030
	LD	HL,RSTEPR
	RET
EST030	LD	HL,LSTEPR
	RET
;
SOUTHWEST
	CALL	STH030
	JR	WEST
;
NORTHWEST
	CALL	NTH030
;
WEST	LD	A,(XPOS)
	OR	A
	JR	Z,WST010	;no change if already max left
	DEC	A
	LD	(XPOS),A	;else move one byte left
WST010	LD	A,-1
	LD	(RYTCYC),A
	LD	(UPCYCLE),A
	LD	(DOWNCYC),A
	LD	A,(LEFTCYC)
	INC	A
	AND	3
	LD	(LEFTCYC),A
	BIT	0,A
	JR	NZ,WST020
	LD	HL,LEFT
	RET
WST020	BIT	1,A
	JR	NZ,WST030
	LD	HL,RSTEPL
	RET
WST030	LD	HL,LSTEPL
	RET
;
DISPLAY	LD	B,(HL)		;p/u # of columns
	INC	HL
	LD	C,(HL)		;p/u # of bytes/column
	INC	HL		;HL -> data
	PUSH	HL
	PUSH	BC
	LD	HL,(XPOS)	;L = X, H = Y
	LD	(XTEMP),HL
	LD	B,H		;store Y value
	LD	H,0		;HL = X value
	LD	C,240		;multiply * # bytes/column
	SVC	@MUL16
	LD	H,L		;MSB to H
	ADD	A,B		;add Y value to LSB
	LD	L,A		;put sum in LSB of HL
	LD	A,H		;p/u MSB
	ADC	A,30H		;add base address of table + CY from LSB add
	LD	H,A		;and stuff in MSB
	EX	DE,HL		;DE -> up-left byte of background in RAM
	POP	BC		;counters
	POP	HL		;HL -> animation data
;
DSP010	PUSH	BC		;save column counter in B
	LD	IX,WRKBUF
	PUSH	BC		;save # bytes in C
	PUSH	BC		;   ...twice
DSP020	LD	A,(DE)		;p/u background byte
	INC	DE
	AND	(HL)		;apply mask to punch "hole" in background
	INC	HL
	LD	(IX),A
	INC	IX
	DEC	C
	JR	NZ,DSP020	;repeat masking until for C bytes
;
	POP	BC		;# of bytes in C
	PUSH	DE
	LD	DE,WRKBUF
DSP030	LD	A,(DE)		;p/u masked background byte
	OR	(HL)		;add animation data
	LD	(DE),A		;and return to buffer
	INC	HL
	INC	DE
	DEC	C
	JR	NZ,DSP030
	POP	DE
;
	LD	A,(XTEMP)
	OUT	(XREG),A
	INC	A
	LD	(XTEMP),A
	LD	A,(YTEMP)
	OUT	(YREG),A
	POP	BC		;# of bytes in C
	LD	B,C
	LD	C,GFXDAT
	PUSH	HL
	LD	HL,WRKBUF
	OTIR			;write buffer data to gfx board
	POP	HL
;
	POP	BC		;B = # columns, C = # of bytes
	LD	A,240
	SUB	C		;A = # of bytes offset to top of next backgnd
	ADD	A,E		;   column in RAM
	LD	E,A
	LD	A,D
	ADC	A,0
	LD	D,A		;DE -> next background column in RAM
;
	DJNZ	DSP010
	JP	GETKEY
;
EXIT	LD	A,11111100B	;gfx off, text on
	OUT	(CONTROL),A
	LD	C,8		;remove timer task
	SVC	@RMTSK
	SVC	@CKBRKC
	LD	HL,0		;return to DOS ready
	SVC	@EXIT
;
	END	BEGIN
