	COM	'<VERSION/CMD-display hardware, operating system version>'
;------------------------------- ASSEMBLE MACROS ------------------------------
*GET SVC/MAC
*GET MOVBLK/MAC
;------------------------------- EQUATE SECTION -------------------------------
@DSPLY	EQU	10		;DISPLAY A MESSAGE LINE
@FLAGS	EQU	101		;POINT IY TO THE SYSTEM FLAG TABLE
;
CR	EQU	13		;CARRIAGE RETURN
ETX	EQU	03		;END TEXT
LF	EQU	10		;LINEFEED
;
;------------------------------- ORIGIN DECLARATION ---------------------------
	ORG	3000H
;------------------------------- PROGRAM SECTION ------------------------------
;
RUN:	LD	HL,BANR$	;LOAD ADDR OF THE BANNER MESSAGE
	SVC	@DSPLY
	SVC	@FLAGS		;POINT IY TO THE SYSTEM FLAG TABLE
	LD	HL,MSG1$	;LOAD THE ADDR OF THE FIRST MESSAGE
	SVC	@DSPLY
TYPE:	LD	A,(IY+19)	;LOAD BYTE 19 OF THE FLAG TABLE
	LD	HL,MACHS-1	;LOAD ENDING ADDR OF OPTIONS TABLE
	LD	BC,MACHS-HOPTS	;LENGTH OF OPTIONS TABLE
	CPDR			;SCAN
	JR	NZ,ERR1		;NO MATCH, NOT ON FILE
;BC NOW CONTAINS THE OFFSET FROM THE BEGINNING OF THE OPTIONS TABLE
	LD	HL,MACHS	;NOW LOAD ADDR OF MACHINES TABLE
	ADD	HL,BC		;DOUBLE THE OFFSET
	ADD	HL,BC
;HL NOW CONTAINS THE ADDR OF THE MACHINE TYPE
	LD	DE,MODLS$+6	;POSITION OF TYPE IN MODELS MSG
	LD	BC,2		;LENGTH OF BLOCK TO COPY
	LDIR			;PERFORM COPY
	LD	HL,MODLS$	;ADDR OF MODELS MSG
	JR	PRT1		;NOW PRINT THE MODEL
ERR1:	LD	HL,NOF$		;NONE OF THE ABOVE
PRT1:	SVC	@DSPLY
;
VERS:	LD	HL,MSG2$
	SVC	@DSPLY
	LD	A,(IY+27)	;LOAD A WITH BYTE 27 OF THE FLAG TABLE
	CP	60H		;VERSION 6.0 OR GREATER?
	JR	C,ERR2		;NOT ON FILE
	SUB	60H		;TAKE OUT THE MAJOR VERSION NUMBER
TRSLS:	CP	03H		;VERSION 6.3 OR GREATER?
	JR	NC,MINOR	;YES, LEAVE MSG AS LS-DOS
	MOVBLK	TRS$,OPSYS$+0,3	;COPY 'TRS' TO BYTE 0 OF OPSYS MSG
MINOR:	ADD	A,30H		;CONVERT THE MINOR NUMBER TO ASCII
	LD	(OPSYS$+17),A	;WRITE IT TO THE OPSYS BUFFER
REV:	LD	A,(IY-47)	;LOAD BYTE -47 OF THE FLAG TABLE
	ADD	A,30H		;CONVERT TO ASCII
	LD	(OPSYS$+19),A	;WRITE IT TO THE OPSYS BUFFER
PRT2:	LD	HL,OPSYS$	;DISPLAY THE OPSYS BUFFER
	SVC	@DSPLY
	JR	EXIT
ERR2:	LD	HL,NOF$		;NONE OF THE ABOVE
	SVC	@DSPLY
	JR	EXIT
;
EXIT:	RET
;------------------------------- DATA SECTION ---------------------------------
BANR$:	DM	'VERSION ',21,239,21,' 1990 '
	DM	'by Alan Varga (70701,2373)',LF,CR
;
MSG1$:	DM	'     Current hardware: ',ETX
MSG2$:	DM	LF,'     Current operating system: ',ETX
NOF$:	DM	'Not on file!',CR
;
HOPTS:	DM	02H,04H,05H,12H
MACHS:	DM	'II4 4P12'
MODLS$:	DM	'Model xx',CR
;
OPSYS$:	DM	'LS-DOS version 6.x.x',CR
TRS$:	DM	'TRS'
;
	END	RUN
