	COM	'<VERSION/CMD-display hardware, operating system version>'
;------------------------------- ASSEMBLE MACROS ------------------------------
*GET SVC/MAC
*GET CURS/MAC
;------------------------------- EQUATE SECTION -------------------------------
@CKBRKC	EQU	106		;CHECK IF BREAK KEY WAS PRESSED
@CLS	EQU	105		;CLEAR SCREEN
@DSP	EQU	02		;DISPLAY CHARACTER AT CURSOR AND
				;ADVANCE THE CURSOR
@DSPLY	EQU	10		;DISPLAY A MESSAGE LINE
@FLAGS	EQU	101		;POINT IY TO THE SYSTEM FLAG TABLE
@KEY	EQU	01		;SCAN *KI DEVICE, WAIT FOR CHARACTER
@VDCTL	EQU	15		;POSITION/LOCATE CURSOR
;
CR	EQU	13		;CARRIAGE RETURN
BREAK	EQU	128		;BREAK
ETX	EQU	03		;END TEXT
LF	EQU	10		;LINEFEED
;
;------------------------------- ORIGIN DECLARATION ---------------------------
	ORG	3000H
;------------------------------- PROGRAM SECTION ------------------------------
;
RUN:	SVC	@CLS
	LD	HL,BANR$	;LOAD ADDR OF THE BANNER MESSAGE
	SVC	@DSPLY
	LD	HL,MENU$	;LOAD ADDR OF MENU
	SVC	@DSPLY
	SVC	@FLAGS		;POINT IY TO THE SYSTEM FLAG TABLE
TYPE:	LD	HL,NOPTS-1	;LOAD ENDING ADDR OF OPTIONS TABLE
	LD	BC,NOPTS-HOPTS	;LENGTH OF OPTIONS TABLE
	LD	A,C		;SAVE NUMBER OF OPTIONS
	LD	(NOPTS),A	;AT ADDR NOPTS
	LD	A,(IY+19)	;LOAD BYTE 19 OF THE FLAG TABLE
	CPDR			;SCAN HOPTS FOR MATCH 
;C NOW CONTAINS THE OFFSET FROM THE BEGINNING OF THE OPTIONS TABLE
	LD	A,C
	ADD	A,2
	CURS	A,0		;ROW, COLUMN TO PRINT HAND
	LD	HL,HAND$
	SVC	@DSPLY
INP:	LD	A,(NOPTS)
	ADD	A,3
	CURS	A,23		;ROW, COLUMN FOR INPUT
	SVC	@KEY		;INPUT NEW MACHINE TYPE
	LD	C,A		;SAVE KEY
	CP	BREAK
	JR	Z,EXIT
;	SVC	@CKBRKC		;WAS IT BREAK?
;	JR	NZ,EXIT		;YES, QUIT,
	SVC	@DSP		;OTHERWISE DISPLAY THE KEY
RANGE:	LD	A,C		;LOAD KEY BACK INTO A
	SUB	30H		;CONVERT RESPONSE TO HEX ('0'=ASCII 30H)
	CP	1		;KEY < 1 ? 
	JR	C,RUN		;C=YES, INVALID, TRY AGAIN
	LD	HL,NOPTS	;LOAD NUMBER OF OPTIONS
	LD	C,(HL)		;INTO C
	INC	C		;ADD 1 MORE FOR COMPARE
	CP	C		;KEY > LAST OPTION?
	JR	NC,RUN		;NC=YES, INVALID, TRY AGAIN
	LD	HL,HOPTS	;LOAD ADDR OF HARDWARE OPTIONS
	LD	B,1		;INITIALIZE COUNTER
LOOP:	CP	B		;IS KEY IN A THE BTH ELEMENT IN THE TABLE?
	JR	Z,WRITE		;YES, QUIT LOOP
	INC	HL		;MOVE TO NEXT HARDWARE OPTION
	INC	B		;BUMP COUNTER
	JR	LOOP		;AND TRY AGAIN
WRITE:	LD	A,(HL)		;LOAD THE CODE FROM THE OPTIONS TABLE
	LD	(IY+19),A	;WRITE NEW CODE TO SYSTEM FLAG TABLE
	JR	RUN		;REDISPLAY DATA
ERR1:	LD	HL,NOF$
	SVC	@DSPLY
EXIT:	RET
;------------------------------- DATA SECTION ---------------------------------
BANR$:	DM	'MODTEST ',21,239,21,' 1990 '
	DM	'by Alan Varga (70701,2373)',LF,CR
;
HAND$:	DM	21,244,245,246,21,ETX
;
MENU$:	DM	'    1) Model II',LF
	DM	'    2) Model 4',LF
	DM	'    3) Model 4P',LF
	DM	'    4) Model 12',LF,LF
	DM	'Enter selection (1-4): ',ETX
;
HOPTS:	DM	02H,04H,05H,12H
NOPTS:	DS	1
;
NOF$:	DM	'Hardware type not found!',CR
;
	END	RUN
