	TITLE	<VT-52 EMULATOR>
;=======================================================
;	VT52/ASM	VT52 DISPLAY EMULATION BY *DO
;			FILTER FOR TRS-80 MODEL 4
;			UNDER TRSDOS 6.2.X
;	AUTHOR:		GARY LEE PHILLIPS  72425,354
;	DATE:		10-AUG-1986
;	NOTES:		FROM A CONCEPT PROVIDED BY J.G.
;			BENDER. INSTALLED VIA SET, THIS
;			FILTER ALLOWS AN EMULATION OF A
;			STANDARD VT-52 DISPLAY SUFFICIENT
;			FOR MOST APPLICATIONS (INCLUDING
;			USE AS A TERMINAL ON A VAX HOST.)
;			A MATCHING KSM FILE PERMITS
;			EMULATION OF THE KEYPAD FUNCTIONS
;			OF THE VT-52 AS WELL.
;========================================================
	SPACE	1
;	***	SYSTEM EQUATES		***
	SPACE	1
DEBUG	EQU	@@1	; USE P1 FOR DEBUG MODE
@CHNIO	EQU	20	; CHAIN TO I/O DEVICE
@CTL	EQU	5	; SEND CTRL BYTE
@DSP	EQU	2	; BYTE TO *DO
@DEBUG	EQU	27	; ENTER DEBUG MODE
@DSPLY	EQU	10	; DISPLAY MESSAGE
@EXIT	EQU	22	; RETURN TO DOS
@FLAGS$	EQU	101	; GET FLAG POINTER
@GTDCB	EQU	82	; GET DCB POINTER
@GTMOD	EQU	83	; GET MOD POINTER
@HIGH$	EQU	100	; GET|SET HIGH$
@LOGOT	EQU	12	; ABORT/ERROR LOG
@VDCTL	EQU	15	; VIDEO CONTROL
@PARAM	EQU	17	; PARSE PARAMETERS
@PAUSE	EQU	16	; WAIT A BIT
@PRT	EQU	6	; SEND CHAR TO PRINTER
@PUT	EQU	4	; OUTPUT A CHAR
@SOUND	EQU	104	; GENERATE SOUND
	SPACE	1
;	***	CHARACTER VALUES	***
	SPACE	1
BEL	EQU	07H	; TERMINAL BELL
BS	EQU	08H	; BACK SPACE
HT	EQU	09H	; HORIZONTAL TAB
LF	EQU	0AH	; LINE FEED
VT	EQU	0BH	; VERTICAL TAB
FF	EQU	0CH	; FORM FEED
CR	EQU	0DH	; CARRIAGE RETURN
XON	EQU	11H	; DC1 ALLOW OUTPUT
XOFF	EQU	13H	; DC3 HALT OUTPUT
CAN	EQU	18H	; CANCEL
ESC	EQU	1BH	; ESCAPE
DEL	EQU	7FH	; DELETE CHAR
	PAGE
;	***	VT-52 ESCAPE CODES	***
	SPACE	1
UP	EQU	'A'	; CURSOR UP
DOWN	EQU	'B'	; CURSOR DOWN
RIGHT	EQU	'C'	; CURSOR RIGHT
LEFT	EQU	'D'	; CURSOR LEFT
GRAPHIC	EQU	'F'	; GRAPHICS MODE
TEXT	EQU	'G'	; TEXT MODE
HOME	EQU	'H'	; HOME CURSOR
REV_LF	EQU	'I'	; REVERSE SCROLL
CLR_EOS	EQU	'J'	; CLEAR TO END OF SCREEN
CLR_EOL	EQU	'K'	; CLEAR TO END OF LINE
CURSOR	EQU	'Y'	; SET CURSOR POSITION
DEC_ID	EQU	'Z'	; SEND TERM ID
	SPACE	2
;	***	MACRO DEFINITIONS	***
	SPACE	1
SVC	MACRO	#SVC_NAME
	LD	A,#SVC_NAME
	RST	28H
	ENDM
	SPACE	2
	PAGE
;	***	FILTER INITIALIZER	***
	SPACE	1
	ASEG
	ORG	3000H
	SPACE	1
BEGIN	EQU	$
	IF	DEBUG		; DEBUG REQUESTED?
	PUSH	AF		; YES, SAVE AF
	SVC	@DEBUG		; START DEBUG
	POP	AF		; RESTORE AF
	ENDIF			; AND CONTINUE
	PUSH	DE		; DCB PTR
	PUSH	HL		; CMDLIN PTR
	LD	(MODDCB),DE	; STUFF IN FILTER
	LD	HL,HELLO$	; DISPLAY ID
	SVC	@DSPLY
	POP	HL		; GET CMDLIN BACK
	SPACE	1
	SVC	@FLAGS$		; GET FLAG PTR
	BIT	3,(IY+'C'-'A')	; WAS THIS SET?
	JP	Z,ERROR		; NO, ABORT NOW
	SET	3,(IY+'M'-'A')	; ENABLE SPC CHARS
	LD	A,(IY+'M'-'A')
	OUT	(0ECH),A
	LD	DE,DSP_NAM	; FIND $DO MODULE
	SVC	@GTMOD
	LD	HL,0004H	; OFFSET TO DATA
	ADD	HL,DE
	BIT	3,(HL)		; PERMIT SPC CHARS
	JR	NZ,SPCOK	; ALREADY SET
	LD	C,15H		; DO THE ENABLE
	SVC	@DSP
	SPACE	1
SPCOK	LD	DE,PARM		; PARM TBL PTR
	SVC	@PARAM		; DO PARSE
	JP	NZ,BDPAR	; SYNTAX ERROR
	LD	A,(BELL_PR)	; GET BELLPR
	LD	B,00H
	SET	BEEP_PR,B
	AND	B		; SET BIT IF YES
	LD	(VTDATA+VTFLAGS),A
	LD	A,(DEV_RSP)	; GET DEV RESP
	CP	3FH		; SHOULD BE STRING
	JP	NC,NODEV	; ERR IF NOT < 3FH
	LD	HL,(DEV_NAM)	; PTR TO DEV NAME
	LD	E,(HL)
	INC	HL
	LD	D,(HL)		; DE IS DEV ID
	SVC	@GTDCB		; FIND DCB
	JP	NZ,NODEV	; NOT FOUND
	LD	(VTDATA+COM_DCB),HL ; SAVE DCB PTR
	SPACE	1
	LD	HL,0		; GET HIGH$
	LD	B,L
	SVC	@HIGH$
	JP	NZ,NOMEM	; NO MEMORY ERROR
	LD	(OLDHI),HL	; PUT IN HEADER
	SPACE	1
	LD	IY,RELTAB	; RELOCATION TBL
	LD	DE,VTEND
	OR	A		; CLEAR CARRY
	SBC	HL,DE		; CALC OFFSET
	LD	B,H		; PUT IT IN BC
	LD	C,L
RLOOP	EQU	$
	LD	L,(IY+0)	; ADR TO RELOCATE
	LD	H,(IY+1)
	LD	A,H		; END OF TBL?
	OR	L
	JR	Z,RXEND
	LD	E,(HL)		; GET ADDRESS
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	ADD	HL,BC		; OFFSET IT
	EX	DE,HL
	LD	(HL),D		; PUT IT BACK
	DEC	HL
	LD	(HL),E
	INC	IY		; POINT TO NEXT
	INC	IY
	JR	RLOOP
	SPACE	1
RXEND	EQU	$		; RELOCATE MODULE
	LD	HL,VTEND	; LAST BYTE OF MODULE
	LD	BC,LENGTH	; LENGTH
	LD	DE,(OLDHI)	; DESTINATION
	LDDR			; MOVE IT
	EX	DE,HL		; SET NEW HIGH$
	SVC	@HIGH$
	INC	HL		; PTR TO ENTRY
	LD	A,47H		; SET FILTER TYPE
	POP	IX		; DCB PTR
	LD	(IX+0),A	; SET UP DCB
	LD	(IX+1),L
	LD	(IX+2),H
	SPACE	1
	LD	HL,0		; ZERO RET CODE
	JR	DONE
	SPACE	1
ERROR	EQU	$
	LD	HL,ERRMSG$	; INDICATE ERROR
	JR	DSPERR
NOMEM	LD	HL,NOMEM$
	JR	DSPERR
BDPAR	LD	HL,BDPAR$
	JR	DSPERR
NODEV	LD	HL,NODEV$
DSPERR	EQU	$
	SVC	@LOGOT		; DISPLAY MSG
	LD	HL,0FFFFH	; ERROR CODE
	SPACE	1
DONE	EQU	$
	SVC	@EXIT		; RETURN TO DOS
	SPACE	2
	PAGE
HELLO$	DB	LF,'VT-52 Display (*DO) Filter ver.1.0'
	DB	LF,'Gary Lee Phillips, August, 1986.'
	DB	LF,CR
ERRMSG$	DB	LF,' Must install via: '
	DB	LF,'    SET *VT VT52 (BELLPR=ON|OFF,'
	DB	'DEVICE="CL")'
	DB	LF,'      B=ON  will send bells to *PR.'
	DB	LF,'      B=OFF is default.'
	DB	LF,'      DEVICE is name of comm device.'
	DB	LF,'      DEV="CL" is default.',LF,CR
NOMEM$	DB	LF,' High memory not available.',LF,CR
NODEV$	DB	LF,' Bad devspec or DCB not found.',LF,CR
BDPAR$	DB	LF,' Invalid parameter value.',LF,CR
PARM	DB	80H		; PARAMETER TABLE HDR
	DB	52H		; SWITCH TYPE
	DB	'BE'		; PARAMETER NAME
BEL_RSP	DB	0		; RESPONSE BYTE
	DW	BELL_PR		; VALUE PTR
	DB	32H		; STRING TYPE
	DB	'DE'		; PARAMETER NAME
DEV_RSP	DB	02H		; RESPONSE BYTE
	DW	DEV_NAM		; VALUE PTR
	DB	0		; END OF TBL
BELL_PR	DW	0		; RCV WD FOR FLAG
DEV_NAM	DW	DEVCL		; PTR TO DEV NAME
DEVCL	DB	'CL'		; DEFAULT DEV
DSP_NAM	DB	'$DO'		; *DO MOD NAME
	SPACE	2
	PAGE
;	***	RESIDENT MODULE		***
	SPACE	1
VTBEGIN	JR	VTSTART		; STD MODULE HEADER
OLDHI	DW	VTEND-1		; LAST BYTE USED
	DB	MODDCB-VTBEGIN-5
	DM	'VT-52'		; MODULE NAME
MODDCB	DW	$-$		; DCB ADDRESS
	DW	0		; RESERVED
	SPACE	1
;	***	DATA AREA		***
	SPACE	1
VTDATA	EQU	$		; INDEXED BY IX
VTFLAGS	EQU	$-VTDATA
	DB	00H		; STATUS FLAGS
ESCACT	EQU	7		; ESCAPE SEQ ACTIVE
NEED_R	EQU	6		; NEED ROW NUMBER
NEED_C	EQU	5		; NEED COL NUMBER
BEEP_PR	EQU	3		; SEND BEL TO *PR
GR_MODE	EQU	2		; GRAPHICS ACTIVE
SUPP_LF	EQU	1		; IGNORE NEXT LF
CR_LAST	EQU	0		; LAST WAS A CR
NEW_R	EQU	$-VTDATA
	DB	0		; NEW ROW POS
COM_DCB	EQU	$-VTDATA
	DW	0		; COM DCB PTR
	SPACE	2
VTSTART	EQU	$
	PUSH	IX		; SAVE DCB PTR
	JP	NZ,CHAIN	; CHAIN IF NOT @PUT
RX01	EQU	$-2
	LD	IX,VTDATA	; INDEX TO DATA AREA
RX02	EQU	$-2
	JP	FLTRIT		; PROCESS @PUT
RX03	EQU	$-2
	SPACE	1
FLTRIT	EQU	$
	RES	7,C		; STRIP PARITY
	LD	A,C
	SPACE	1
	CP	CAN		; CANCEL ESCAPE?
	JR	NZ,CKACT	; NO, CHECK STATUS
	LD	A,0FH		; YES, CLEAR STATUS
	AND	(IX+VTFLAGS)
	LD	(IX+VTFLAGS),A
	JR	JRIGN1
	SPACE	1
CKACT	BIT	ESCACT,(IX+VTFLAGS)
	JP	NZ,GETESC	; PROCESS ESC CODE
RX04	EQU	$-2
	BIT	NEED_C,(IX+VTFLAGS)
	JP	NZ,SETRC	; FINISH CURSOR POS
RX05	EQU	$-2
	SPACE	1
	CP	DEL		; IS IT DEL?
	JR	Z,JRIGN1	; IGNORE IF SO
	CP	20H		; CTRL CHAR?
	JR	C,CTLCHR	; NO, SO SEND IT
	BIT	GR_MODE,(IX+VTFLAGS)
	JR	Z,JRCHN1	; NO GRAPHICS
	CP	5FH		; IN RANGE?
	JR	C,JRCHN1	; NO, NOT GRAPHIC
	LD	HL,GR_TBL-5FH	; PTR TO TABLE
RX06	EQU	$-2
	PUSH	BC
	LD	B,0
	ADD	HL,BC		; OFFSET IT
	POP	BC
	LD	C,(HL)		; GET XLT CHAR
	LD	A,20H
	CP	C
	JR	C,NOTSPC	; NOT SPECIAL
	PUSH	BC
	LD	C,0		; NULL BEFORE SPEC
	SVC	@CHNIO		; SEND NULL
	POP	BC
NOTSPC	JR	JRCHN1
	SPACE	1
CTLCHR	CP	BS		; IS IT BS?
	JR	NZ,CKVT		; NO, TRY VT
	LD	C,18H		; BS W/O ERASING
	JR	JRCHN1
	SPACE	1
JRIGN1	JP	IGNORE
RX07	EQU	$-2
JRCHN1	JP	CHAIN
RX08	EQU	$-2
	SPACE	1
CKVT	CP	VT		; IS IT VT?
	JR	NZ,CKFF		; NO, TRY FF
DOLF	LD	C,LF		; YES, DO LF
	LD	A,C
	JR	CKLF
	SPACE	1
CKFF	CP	FF		; IF FF THEN
	JR	Z,DOLF		; DO LF INSTEAD
	SPACE	1
CKLF	CP	LF		; IS IT LF?
	JR	NZ,CKESC	; NO, TRY ESC
	BIT	SUPP_LF,(IX+VTFLAGS)
	JR	NZ,JRIGN1	; SUPPRESSED
	PUSH	BC
	LD	B,4		; YES, DO REAL LF
	SVC	@VDCTL
	LD	A,23		; ON BOTTOM LINE?
	CP	H
	JR	Z,SCROLL	; YES, SCROLL UP
	INC	H		; NO, MOVE DOWN
NOSCR	EQU	$
	LD	B,3
	SVC	@VDCTL
	POP	BC
	JR	JRIGN1
SCROLL	EQU	$
	PUSH	HL		; SAVE CURSOR POS
	PUSH	IX		; AND DATA PTR
	LD	B,2		; CODE FOR @PUT
	LD	IX,(MODDCB)	; GET DCB PTR
RX09	EQU	$-2
	SVC	@CHNIO		; DO THE LF
	POP	IX		; GET BACK DATA PTR
	POP	HL		; AND CURSOR POS
	JR	NOSCR
	SPACE	1
CKESC	CP	ESC		; IS IT ESC?
	JR	NZ,CKCR		; NO, TRY CR
	SET	ESCACT,(IX+VTFLAGS)
	JR	JRIGN1
	SPACE	1
CKCR	CP	CR		; IS IT CR?
	JR	NZ,CKBEL	; NO, TRY BEL
	PUSH	BC
	LD	B,4		; GET CURSOR POS
	SVC	@VDCTL
	XOR	A		; CLEAR OUT A
	OR	L		; AT COL 0?
	JR	NZ,DOCR		; NO SO GO
	BIT	CR_LAST,(IX+VTFLAGS)
	JR	Z,SUPRES	; SUPPRESS LF
	RES	SUPP_LF,(IX+VTFLAGS)
	JR	NOCR		; NO SUPPRESS
SUPRES	EQU	$
	SET	SUPP_LF,(IX+VTFLAGS)
	JR	NOCR		; NO CR/NO LF
DOCR	LD	L,0		; GO TO COL 0
	LD	B,3		; MOVE CURSOR
	SVC	@VDCTL
	SET	CR_LAST,(IX+VTFLAGS)
NOCR	POP	BC
	JR	IGNORE
	SPACE	1
CKBEL	CP	BEL		; IS IT BEL?
	JR	NZ,IGNORE	; IGNORE ALL OTHERS
	BIT	BEEP_PR,(IX+VTFLAGS)
	JR	Z,CKBEL2	; NO PR, USE SOUND
	LD	DE,'RP'		; FIND *PR DCB
	SVC	@GTDCB
	JR	NZ,IGNORE	; NOT FOUND
	EX	DE,HL
	PUSH	BC
	LD	C,0		; IS PR READY?
	SVC	@CTL
	POP	BC
	JR	NZ,IGNORE	; NOT READY
	SVC	@PRT		; BEL TO PR
	JR	IGNORE
CKBEL2	PUSH	BC
	LD	E,(IX+COM_DCB)	; *CL DCB PTR
	LD	D,(IX+COM_DCB+1)
	LD	C,XOFF		; HOLD OUTPUT
	SVC	@PUT
	LD	BC,20000	; LET IT TAKE EFFECT
	SVC	@PAUSE
	LD	B,0*8+0		; LENGTH 0, PITCH 0
	SVC	@SOUND
	LD	C,XON		; OUTPUT OK NOW
	SVC	@PUT
	POP	BC
	JR	IGNORE
	SPACE	1
CHAIN	EQU	$
	RES	SUPP_LF,(IX+VTFLAGS)
	RES	CR_LAST,(IX+VTFLAGS)
	LD	IX,(MODDCB)	; GET DCB PTR
RX10	EQU	$-2
	SVC	@CHNIO		; PASS BYTE THRU
	POP	IX
	RET
	SPACE	1
IGNORE	EQU	$
	POP	IX
	CP	A		; SET Z FLAG
	RET
	SPACE	1
;	***	HANDLE ESC CODES	***
	SPACE	1
GETESC	EQU	$
	RES	ESCACT,(IX+VTFLAGS)
	CP	CURSOR		; CURSOR POS?
	JR	NZ,GETE1
	SET	NEED_R,(IX+VTFLAGS)
	SET	NEED_C,(IX+VTFLAGS)
	JR	IGNORE
	SPACE	1
GETE1	CP	UP		; MOVE UP?
	JR	NZ,GETE2
	LD	C,1BH
	JR	CHAIN
	SPACE	1
GETE2	CP	DOWN		; MOVE DOWN?
	JR	NZ,GETE3
	LD	C,1AH
	JR	CHAIN
	SPACE	1
GETE3	CP	RIGHT		; MOVE RIGHT?
	JR	NZ,GETE4
	LD	C,19H
	JR	CHAIN
	SPACE	1
GETE4	CP	LEFT		; MOVE LEFT?
	JR	NZ,GETE5
	LD	C,18H
	JR	CHAIN
	SPACE	1
GETE5	CP	HOME		; CURSOR HOME?
	JR	NZ,GETE6
	LD	C,1CH
	JR	CHAIN
	SPACE	1
GETE6	CP	CLR_EOL		; CLR TO END OF LINE?
	JR	NZ,GETE7
	LD	C,1EH
	JR	CHAIN
	SPACE	1
GETE7	CP	CLR_EOS		; CLR TO END OF SCR?
	JR	NZ,GETE8
	LD	C,1FH
	JR	CHAIN
	SPACE	1
GETE8	CP	DEC_ID		; SEND TERM ID?
	JR	NZ,GETE9
	LD	E,(IX+COM_DCB)	; *CL DCB PTR
	LD	D,(IX+COM_DCB+1)
	PUSH	BC
	LD	C,ESC		; VT-52 ID
	SVC	@PUT		; IS <ESC>/Z
	LD	C,'/'
	SVC	@PUT
	LD	C,'Z'
	SVC	@PUT
	POP	BC
	JR	IGNORE
	SPACE	1
GETE9	CP	REV_LF		; SCROLL DOWN?
	JR	NZ,GETE10	; CHECK GRAPHICS
	PUSH	BC
	LD	B,6		; SCR TO BUFFER
	LD	HL,2450H	; BUFFER ADDRESS
	SVC	@VDCTL		; USE 2450H BUFFER
	JR	NZ,POPBC	; FAILED
	LD	A,' '		; BLANK FIRST LINE
	LD	B,80		; LENGTH OF LINE
	LD	HL,2450H	; END OF LINE
BLNK	EQU	$
	DEC	HL
	LD	(HL),A
	DJNZ	BLNK
	LD	B,5		; BUFFER TO SCR
	SVC	@VDCTL		; USE 2400H BUFFER
	JR	POPBC		; DONE
	SPACE	2
SETRC	SUB	32		; CALC OFFSET
	PUSH	BC
	LD	C,A
	BIT	NEED_R,(IX+VTFLAGS)
	JR	Z,DOCOL
	CP	24		; CHECK RANGE
	JR	C,DOROW		; IS OK (<24)
	LD	A,23		; USE MAX
DOROW	LD	(IX+NEW_R),A	; SET ROW
	RES	NEED_R,(IX+VTFLAGS)
	JR	POPBC
	SPACE	1
DOCOL	RES	NEED_C,(IX+VTFLAGS)
	CP	80		; CHECK RANGE
	JR	C,COLOK		; IS OK (<80)
	LD	A,79		; USE MAX
COLOK	LD	L,A		; COL NUMBER
	LD	H,(IX+NEW_R)	; ROW NUMBER
	LD	B,3		; MOVE CURSOR
	SVC	@VDCTL
POPBC	POP	BC
JRIGN2	JP	IGNORE
RX11	EQU	$-2
	SPACE	1
GETE10	CP	GRAPHIC		; GRAPHICS MODE?
	JR	NZ,GETE11	; NO, TRY TEXT
	SET	GR_MODE,(IX+VTFLAGS)
	JR	JRIGN2
	SPACE	1
GETE11	CP	TEXT		; TEXT MODE?
	JR	NZ,JRIGN2	; NO SO IGNORE
	RES	GR_MODE,(IX+VTFLAGS)
	JR	JRIGN2
	SPACE	1
GR_TBL	EQU	$		; GRAPHICS CHARS
	DB	80H,0C2H,0F0H,0F9H,0FAH,0F8H
	DB	0E6H,0EH,7FH,0E9H,0EDH,85H,94H
	DB	9CH,8DH,9DH,83H,83H,8CH,0B0H
	DB	0B0H,9DH,95H,8DH,9CH,95H,0C6H
	DB	0C7H,0D7H,0E7H,06H,1DH
VTEND	EQU	$-1
	SPACE	1
LENGTH	EQU	$-VTBEGIN
RELTAB	DW	RX01,RX02,RX03,RX04,RX05
	DW	RX06,RX07,RX08,RX09,RX10
	DW	RX11,0
	SPACE	1
	END	BEGIN
