#!/bin/sh
###########################################################################
#									  #
#  VT132 terminal emulator by Michael S. Leibow				  #
#									  #
###########################################################################
echo x hextocmd.src
sed -e 's/^X//' << 'PaRtIcUlAtEmAtTeR' > hextocmd.src
X00100		ORG	3000H
X00110	EXIT	EQU	22
X00120	DOPEN	EQU	59
X00130	DCLS	EQU	60
X00140	DINIT	EQU	58
X00150	DSP	EQU	2
X00160	GET	EQU	3
X00170	PUT	EQU	4
X00180	DSPLY	EQU	10
X00190	KEYIN	EQU	9
X00200	ERROR	EQU	26
X00210	START	LD	HL,MFNAM
X00220		LD	A,DSPLY
X00230		RST	28H
X00240		LD	A,KEYIN
X00250		LD	HL,FNAM
X00260		LD	B,79
X00270		LD	C,0
X00280		RST	28H
X00290		JP	C,BYE
X00300		PUSH	HL
X00310		POP	DE
X00320		LD	HL,BUFF
X00330		LD	B,0
X00340		LD	A,DOPEN
X00350		RST	28H
X00360		JP	NZ,BYE
X00370		LD	HL,BUFF1
X00380		LD	DE,AOUT
X00390		LD	B,0
X00400		LD	A,DINIT
X00410		RST	28H
X00420		JP	NZ,BYE
X00430	LOOP	LD	A,GET
X00440		LD	DE,FNAM
X00450		RST	28H
X00460		JP	NZ,DONE
X00470		SUB	'0'
X00480		JP	C,LOOP
X00490		CP	10
X00500		CALL	NC,SUB7
X00510		CP	16
X00520		JP	NC,LOOP
X00530		SLA	A
X00540		SLA	A
X00550		SLA	A
X00560		SLA	A
X00570		LD	(TEMP),A
X00580		LD	A,GET
X00590		LD	DE,FNAM
X00600		RST	28H
X00610		JP	NZ,DONE
X00620		SUB	'0'
X00630		JP	C,LOOP
X00640		CP	10
X00650		CALL	NC,SUB7
X00660		CP	16
X00670		JP	NC,LOOP
X00680		LD	B,A
X00690		LD	A,(TEMP)
X00700		ADD	A,B
X00710		LD	C,A
X00720		LD	A,PUT
X00730		LD	DE,AOUT
X00740		RST	28H
X00750		JP	NZ,DONE
X00760		LD	A,(TIME)
X00770		INC	A
X00780		LD	(TIME),A
X00790		CALL	Z,PERIOD
X00800		JP	LOOP
X00810	SUB7	SUB	7
X00820		RET
X00830	PERIOD	LD	C,'.'
X00840		LD	A,DSP
X00850		RST	28H
X00860		RET
X00870	BYE	LD	C,A
X00880		LD	A,ERROR
X00890		RST	28H
X00900		LD	A,EXIT
X00910		LD	HL,0
X00920		RST	28H
X00930	DONE	PUSH	AF
X00940		LD	DE,AOUT
X00950		LD	A,DCLS
X00960		RST	28H
X00970		LD	DE,FNAM
X00980		LD	A,DCLS
X00990		RST	28H
X01000		LD	HL,0
X01010		POP	AF
X01020		OR	A
X01030		JP	NZ,BYE
X01040		LD	A,EXIT
X01050		LD	HL,0
X01060		RST	28H
X01070	BUFF	DEFS	256
X01080	BUFF1	DEFS	256
X01090	MFNAM	DEFM	'File please :'
X01100		DEFB	03H
X01110	FNAM	DEFS	80
X01120	AOUT	DEFM	'OUT/OUT'
X01130		DEFB	0DH
X01140		DEFS	100
X01150	TEMP	DEFB	0
X01160	TIME	DEFB	0
X01170		END	START
PaRtIcUlAtEmAtTeR
echo -n '	'
ls -l hextocmd.src
echo x hextocmd.uue
sed -e 's/^X//' << 'PaRtIcUlAtEmAtTeR' > hextocmd.uue
Xbegin 600 hextocmd.cmd
XM`;4`,"&S,CX*[SX)(<$R!D\.`._:CC#ET2&S,`8`/COOPHXP(;,Q$1$S!@`^
XM.N_"CC`^`Q'!,N_"F##6,-HN,/X*U(4P_A#2+C#+)\LGRR?+)S)],SX#$<$R
XM[\*8,-8PVBXP_@K4A3#^$-(N,$<Z?3.`3SX$$1$S[\*8,#I^,SPR?C/,B###
XM+C#6!\D.+CX"[\E//AKO/A8A``#O]1$1,SX\[Q'!,CX\[R$``/&WPHXP/A8A
XM``#O`1"S,D9I;&4@<&QE87-E(#H#`0H1,T]55"]/550-`01],P```@(`,```
X?`````````````````````````````````````````%0-
X`
Xend
PaRtIcUlAtEmAtTeR
echo -n '	'
ls -l hextocmd.uue
echo x keys1.hex
sed -e 's/^X//' << 'PaRtIcUlAtEmAtTeR' > keys1.hex
X00010203040506077F00000B0C0D0E0F
X101112131415160008001A1B1C1D1E00
X202122232425262728292A2B2C2D2E2F
X303132333435363738393A3B3C3D3E3F
X404142434445464748494A4B4C4D4E4F
X505152535455565758595A1B5C5D5E5F
X606162636465666768696A6B6C6D6E6F
X707172737475767778797A7B7C7D7E7F
X00010203040506071809000B0C0D0E0F
X101112131415161718191A1B1C1D1E00
X207B7D7C7E5F5C605B5D2A2B2C2D2E5C
X307B7D7C7E5F5E605B5D3A3B3C3D3E5C
X800102030405060708090A0B0C0D0E0F
X101112131415161718191A1B1C1D1E1F
X600102030405060708090A0B0C0D0E0F
X101112131415161718191A1B1C1D1E1F
PaRtIcUlAtEmAtTeR
echo -n '	'
ls -l keys1.hex
echo x keys2.hex
sed -e 's/^X//' << 'PaRtIcUlAtEmAtTeR' > keys2.hex
X013A80F4E6085F21D4A0AE73A3C2B6A0
X0101F421D5A016007AFE06CC46A0C44C
XA00AE6FF5FAE73A3C271A0CDC0A0F218
XA0CDC5A0A6C252A021000022DDA021DC
X0522DFA0AFC93EFD3223A0C93EFF3223
XA0C9E52ADDA02322DDA0ED5BDFA0ED52
XD1DA44A0AF1222DDA02E6022DFA0C310
XA05FC501880BCDE1A0C10AA3C832D3A0
X7D32D2A07A171717577B0FDA92A014C3
X8AA05A16007BFE01DAA7A0FE1BD2A7A0
X3A00A0B7C2ACA03A80F4E603C4CDA021
XE9A0197EB7C03A00A0EE013200A0AFC9
X1423CB01C93AD2A06F3AD3A0C93E3883
X5FC90000000000000000000000000000
X007F0B78B1C2E1A0C940616263646566
X6768696A6B6C6D6E6F70717273747576
X7778797A000000000030313233343536
X3738393A3B2C2D2E2F0D00015B0A0809
X20604142434445464748494A4B4C4D4E
X4F505152535455565758595A00000000
X00002122232425262728292A2B3C3D3E
PaRtIcUlAtEmAtTeR
echo -n '	'
ls -l keys2.hex
echo x moofterm.doc
sed -e 's/^X//' << 'PaRtIcUlAtEmAtTeR' > moofterm.doc
XThe documentation for this is a little vague since I am pressed for time.  I
Xhope that this program will be a good tool for you.
X
XTo execute it, you just type VT132 from TRSDOS.
X
XWhen you start you will be in TERMINAL MODE with UART settings of
X	wordlength = 7
X	stop bits  = 1
X	Baud rate  = 1200
X	Parity	   = EVEN
X
XYou can change any of these settings by depressing SHIFT and BREAK at the
Xsame time.  A menu will appear, and you can select any settings you want from
Xthe menu.  Press Break to return to TERMINAL MODE.
X
XWhen in TERMINAL MODE, there are many keys on the keyboard which have special
Xmeaning.  Here is  a description of the keyboard:
X
XShifted and unshifted, all black keys will send the ASCII value of what is
Xprinted on them.
X
XThe UP arrow is the escape key.
XThe DOWN arrow and CTRL keys are the control keys.  You can use either one.  For
X    now on, when I mention the CTRL key, I also mean the DOWN arrow if you would
X    rather use that.
XThe LEFT arrow or BACKSPACE key is normally the delete key.  Shifted it is the
X    backspace key.  If you normally use backspace instead of delete then you
X    can change its meaning with the menu described above.
XThe RIGHT arrow key is a special control key .. I'll describe that in a moment.
X
XThe control key can be used with any of the LETTER keys to mean CONTROL A
Xthrough CONTROL Z.  If it is used with the number keys, then then this is 
Xwhat will appear:
X	1   2   3   4   5  6   7   8   9 / @
X	{   }   |   ~   _  ^   `   [   ] \ NULL
XIf you want something like control [ or control \ then you can use the
XRIGHT arrow key.  It will do the control of a "control key."  For example
Xa CTRL / will be a \.  A RIGHT-ARROW / will be a CTRL \.
X
XVT100 keypad:
X	To use the keypad like a vt100 keypad, you must hold down the clear key
Xwhile using it:
X
X		VT100 keypad				TRS-80 Equivalent
X     