VIDEO4 ;VIDEO4 version 2.0 - last revision December 10, 1986
 ;24 x 80 Video Driver for the TRS-80 Models 4, 4D, & 4P
 ;with optional control-arrow key keyboard enhancement
 ;(for use in the Model III mode).
 
 ;Program written by:
 
 ;		Jack Decker
 ;		1804 West 18th Street  Lot # 155
 ;		Sault Ste. Marie, Michigan  49783-1268
 ;		(906) 632-3248
 
 ;Released to the Public Domain December 25, 1986 as part
 ;of The Alternate Source Public Domain Software Library.
 
 ;If you write regarding this program, please be sure to
 ;enclose a self-addressed, stamped envelope (U.S. or
 ;Canadian postage O.K.) if you wish a reply.  No replies
 ;will be sent within Canada or the U.S.A. unless the SASE
 ;is included with your correspondence.
 
 ;For more information on The Alternate Source Public
 ;Domain Software Library for the TRS-80 Models
 ;I/III/4/4D/4P, please contact:
 
 ;		The Alternate Source
 ;		704 North Pennsylvania Avenue
 ;		Lansing, Michigan  48906-5319
 ;		(517) 482-8270
 
 
 ;*****  INITIALIZATION & RELOCATION SEGMENT BEGINS  *****
 
 	ORG	5200H
 INTLZE	LD	A,(HL)		;Get argument if any
 	CP	0DH		;Is it a <CR>?
 	JP	Z,ENDARG	;Jump if end arguments
 	INC	HL		;Bump argument pointer
 	CP	' '		;Is it a space?
 	JR	Z,INTLZE	;Try again
 	CP	','		;Is it a comma?
 	JR	Z,INTLZE	;Try again
 	DEC	HL		;Backspace arg pointer
 ASCBIN	EQU	$		;Convert ASCII to binary
 	PUSH	HL		;Start input
 	LD	B,00H		;Set to null
 	CALL	GETHEX		;Pass 1, find end of #
 	JR	C,NOTADR	;Go if not valid address
 	LD	A,(HL)		;Get last character
 	SUB	41H		;Is it A - H
 	CP	08H
 	JR	NC,TSTADR	;No, test for not addr
 	POP	HL		;Restore input
 	LD	B,01H		;Set flag for hex input
 	PUSH	HL		;Store again
 	CALL	GETHEX		;Get hex value
 	JR	C,NOTADR	;Go if not valid address
 	LD	A,(HL)		;Get last char
 	CP	48H		;Is it 'H'
 	INC	HL		;Move on
 	JR	NZ,NOTADR	;Not an address if not
 TSTADR	EQU	$		;Test for not address
 	BIT	1,B		;Is decimal flag set
 	JR	Z,NOTADR	;If not a valid address
 	POP	BC		;Clear stack
 	EX	DE,HL		;HL=Flag addr, DE->buffer
 	LD	(HL),4		;Set 80 column screen on
 	LD	(RELO9A+1),HL	;Plug specified port 84H
 	LD	(RELO13+1),HL	;  bit mask (FLAG)
 	LD	(CLOCK+1),HL	;  address into proper
 	LD	(RELO31+1),HL	;  places in program
 	LD	(RELO32+1),HL
 	LD	(RVS+1),HL
 	LD	(RELO36+1),HL
 	LD	(RELO43+1),HL
 	LD	(CLRBLK+1),HL
 	LD	(RELO46+1),HL
 	LD	(SETPRT+1),HL
 	LD	(LOWER+1),HL
 	LD	(KBREL3+1),HL
 	LD	(KBREL6+1),HL
 	LD	HL,0		;Cancel relocation rtne
 	LD	(CANCEL),HL	;  on above locations
 	LD	HL,BITCHK-START	;Length of 2nd initlztn
 	LD	(STRADR+1),HL	;Don't use pgm flag byte
 	EX	DE,HL		;Restore buffer ptr to HL
 INTL2	JR	INTLZE		;Process remaining args
 NOTADR	POP	HL		;Reset pointer to start
 	INC	HL		;Bump pointer to next chr
 	LD	A,(HL)		;Get character
 	CP	' '		;Is it a space?
 	JR	Z,CONT		;Go if space
 	CP	','		;Is it a comma?
 	JR	Z,CONT		;Go if space
 	CP	0DH		;Is it a <CR>?
 	JR	Z,CONT		;Go if <CR>
 ERROR	LD	HL,PRMERR	;Point to error message
 	CALL	4467H		;Display it
 	JP	4030H		;Error exit
 CONT	DEC	HL		;Point to character
 	LD	A,(HL)		;Get argument if any
 	INC	HL		;Point to next char
 	AND	0DFH		;Mask out lowercase
 	CP	'F'		;Set fast speed?
 	JR	NZ,NOTF		;If fast not specified
 	LD	A,(4210H)	;Bit mask for port ECH
 	OR	40H		;Set bit 6
 	OUT	(0ECH),A	;Output to port ECH
 	LD	(4210H),A	;Re-save bit mask
 	JR	INTL2		;Process remaining args
 NOTF	CP	'K'		;Enable KB flt/scrn edit?
 	JR	NZ,ERROR	;If not "F" or "K"
 	EX	DE,HL		;Save arg pointer in DE
 	LD	HL,(4016H)	;Get current KB dvr addr
 	LD	(KBCALL+1),HL	;Patch into program
 	LD	HL,ALTEND	;Include KB filter &
 	LD	(ENDARG+1),HL	;  screen editor in code
 	LD	HL,ALTEND-OFFST+1	;to be relocated
 	LD	(PGLGTH+1),HL
 	EX	DE,HL		;Restore arg pointer
 	LD	A,22H		;Start of LD (nn),HL inst
 	LD	(ENABKB),A	;Enanble KB flt/scrn edit
 	JR	INTL2		;Process remaining args
 ENDARG	LD	HL,END		;End of unrelocated pgrm
 	LD	DE,(4411H)	;End of unprotected mem
 PGLGTH	LD	BC,END-OFFST+1	;Length of main program
 	LDDR			;Move the program
 STRADR	LD	HL,FLAG-START	;Length of 2nd initlztn
 	ADD	HL,DE		;HL = New memory size
 	LD	(4411H),HL	;Save new memory size
 	INC	DE		;DE=Start 2nd initialztn
 	LD	HL,TABLE	;Get start of reloc table
 NXTLOC	LD	A,(HL)		;Get first address byte
 	LD	B,A		;Save first byte in B
 	INC	HL		;Point @ 2nd address byte
 	OR	(HL)		;Do both bytes equal 0?
 	JR	NZ,REPLCE	;No - replace address
 	EX	DE,HL		;2nd init addr in HL
 	JP	(HL)		;Finish initialization
 REPLCE	PUSH	HL		;Save reloc table pointer
 	LD	H,(HL)		;H=MSB of addr from table
 	LD	L,B		;L=LSB of addr from table
 	ADD	HL,DE		;Get address of label
 	LD	C,(HL)		;Get byte displacement
 	INC	HL		;  from program and
 	LD	B,(HL)		;  put in BC
 	DEC	HL		;HL=address of label
 	PUSH	DE		;Save new START address
 	EX	DE,HL		;HL=new START address
 	ADD	HL,BC		;HL=new address for label
 	EX	DE,HL		;  now put in DE
 	LD	(HL),E		;New address calculated -
 	INC	HL		;  now write it into
 	LD	(HL),D		;  label (address field)
 	POP	DE		;Restore new START addr
 	POP	HL		;Restore reloc table pntr
 	INC	HL		;Bump pointer to nxt addr
 	JR	NXTLOC		;Process next table entry
 GETHEX	LD	DE,0000H	;Set initial value to 0
 GOAGN	LD	A,(HL)		;Get character
 	SUB	30H		;Is it in range 0-9?
 	CP	0AH
 	JR	C,ADDIT		;If in range go add it
 	BIT	0,B		;Is input hex?
 	RET	Z		;If it is 1st pass over
 	SUB	11H		;In hex range (A-F)?
 	CP	06H
 	RET	NC		;If not return
 	ADD	A,0AH		;Set back to 10 - 15
 ADDIT	PUSH	HL		;Store input address
 	LD	H,D		;DE into HL
 	LD	L,E
 	LD	C,A		;Store new value
 	XOR	A		;Clear
 	SET	1,B		;Flag numeric character
 	ADD	HL,HL		;* 2
 	ADC	A,A		;Check for overflow
 	ADD	HL,HL		;* 4
 	ADC	A,A		;Check
 	BIT	0,B		;*10 (dec) or *16 (hex)
 	JR	Z,DECMAL	;If decimal skip
 	ADD	HL,HL		;* 8
 	JR	SKPADD		;Skip decimal add
 DECMAL	ADD	HL,DE		;Decimal * 5
 SKPADD	ADC	A,A		;Check
 	ADD	HL,HL		;* 10 or 16
 	ADC	A,A		;Check
 	LD	E,C		;New value to E
 	LD	D,00H		;Zero D
 	ADD	HL,DE		;Orig *10/16 + new val
 	ADC	A,A		;Check
 	EX	DE,HL		;Into DE
 	POP	HL		;Get input back
 	SCF			;Set carry flag
 	RET	NZ		;If A <> 0 then not addr
 	INC	HL		;Next input char
 	JR	GOAGN		;Go again
 
 ;*****  PARAMETER ERROR MESSAGE  *****
 
 PRMERR	DEFB	1CH		;Home cursor
 	DEFB	1FH		;Clear screen
 	DEFM	'Parameter ERROR - VIDEO4 has NOT been installed.'
 	DEFB	0AH
 	DEFM	'     Use calling sequence:     VIDEO4 [addr[H]] [F] [K]'
 	DEFB	0AH
 	DEFM	'(Brackets indicate optional parameters.  Do not type the'
 	DEFB	0AH
 	DEFM	'brackets themselves.)  Explanation of parameters:
 	DEFB	0AH
 	DEFM	'F = leave computer in fast (4 MHz) CPU speed mode.'
 	DEFB	0AH
 	DEFM	'K = install optional keyboard filter / screen edit feature.'
 	DEFB	0AH
 	DEFM	'addr[H] = address for the port 84H bit mask (if use of a'
 	DEFB	0AH
 	DEFM	'specific memory location is required for compatibility with'
 	DEFB	0AH
 	DEFM	'other programs that manipulate port 84H). Address is assumed to'
 	DEFB	0AH
 	DEFM	'be decimal if "H" suffix is not used.  If no address given, bit'
 	DEFB	0AH
 	DEFM	'mask location will default to the first byte of the relocated'
 	DEFB	0AH
 	DEFM	'program (HIMEM + 1 immediately after program installation).'
 	DEFW	0A0DH
 
 ;*****  RELOCATION TABLE  *****
 ;Must be located prior to "START" label of main program!
 
 TABLE	DEFW	RELO1+1-OFFST
 	DEFW	RELO2+1-OFFST
 	DEFW	RELO3+1-OFFST
 	DEFW	RELO4+1-OFFST
 	DEFW	RELO5+1-OFFST
 	DEFW	RELO5A+1-OFFST
 	DEFW	RELO6+1-OFFST
 	DEFW	RELO6A+1-OFFST
 	DEFW	RELO7+1-OFFST
 	DEFW	RELO7A+1-OFFST
 	DEFW	RELO8+1-OFFST
 	DEFW	RELO9+1-OFFST
 	DEFW	RELO9B+1-OFFST
 	DEFW	RELO9C+1-OFFST
 	DEFW	WRNGBT+1-OFFST
 	DEFW	ROMFIX+1-OFFST
 	DEFW	RELO10+1-OFFST
 	DEFW	RELO11+1-OFFST
 	DEFW	RELO12+1-OFFST
 	DEFW	PRNTLP+1-OFFST
 	DEFW	RELO14+1-OFFST
 	DEFW	RELO15+1-OFFST
 	DEFW	RELO16+1-OFFST
 	DEFW	REL16A+1-OFFST
 	DEFW	RELO17+1-OFFST
 	DEFW	RELO18+1-OFFST
 	DEFW	FPOS+1-OFFST
 	DEFW	RELO19+1-OFFST
 	DEFW	RELO20+1-OFFST
 	DEFW	RELO21+1-OFFST
 	DEFW	CUROFF+1-OFFST
 	DEFW	RELO22+1-OFFST
 	DEFW	RELO23+1-OFFST
 	DEFW	RELO24+1-OFFST
 	DEFW	DSPCHR+1-OFFST
 	DEFW	RELO25+1-OFFST
 	DEFW	USECUR+1-OFFST
 	DEFW	NOCUR+1-OFFST
 	DEFW	RELO26+1-OFFST
 	DEFW	RELO27+1-OFFST
 	DEFW	RELO28+1-OFFST
 	DEFW	FNDEND+1-OFFST
 	DEFW	RELO29+1-OFFST
 	DEFW	RELO30+1-OFFST
 	DEFW	SAVCHR+1-OFFST
 	DEFW	RELO33+1-OFFST
 	DEFW	RELO34+1-OFFST
 	DEFW	BCKTWC+1-OFFST
 	DEFW	BACKUP+1-OFFST
 	DEFW	RELO35+1-OFFST
 	DEFW	AHEAD+1-OFFST
 	DEFW	BITFLG+1-OFFST
 	DEFW	CONTRL+1-OFFST
 	DEFW	RELO37+1-OFFST
 	DEFW	RELO38+1-OFFST
 	DEFW	RELO39+1-OFFST
 	DEFW	RELO40+1-OFFST
 	DEFW	RELO41+1-OFFST
 	DEFW	PRTCHR+1-OFFST
 	DEFW	RELO42+1-OFFST
 	DEFW	CRLF+1-OFFST
 	DEFW	RELO44+1-OFFST
 	DEFW	RELO45+1-OFFST
 	DEFW	NOSWTC+1-OFFST
 	DEFW	KBREL1+1-OFFST
 	DEFW	KBREL2+1-OFFST
 	DEFW	KBREL4+1-OFFST
 	DEFW	KB+1-OFFST
 	DEFW	KBEXIT+1-OFFST
 	DEFW	KBREL5+1-OFFST
 	DEFW	KBREL7+1-OFFST
 	DEFW	RSTBFR+1-OFFST
 	DEFW	KBREL8+1-OFFST
 	DEFW	CHGFLG+1-OFFST
 	DEFW	KBREL9+1-OFFST
 	DEFW	KBRE10+1-OFFST
 CANCEL	DEFW	RELO9A+1-OFFST	;This word changed to 00H
 	DEFW	RELO13+1-OFFST	;  if bit mask location
 	DEFW	CLOCK+1-OFFST	;  specified during
 	DEFW	RELO31+1-OFFST	;  program initialization
 	DEFW	RELO32+1-OFFST	;  thus cancelling this
 	DEFW	RVS+1-OFFST	;  group of relocation
 	DEFW	RELO36+1-OFFST	;  addresses
 	DEFW	RELO43+1-OFFST
 	DEFW	CLRBLK+1-OFFST
 	DEFW	RELO46+1-OFFST
 	DEFW	SETPRT+1-OFFST
 	DEFW	LOWER+1-OFFST
 	DEFW	KBREL3+1-OFFST
 	DEFW	KBREL6+1-OFFST
 	DEFW	0
 
 ;*****  INITIALIZATION PART 2 (WILL BE RELOCATED)  *****
 
 OFFST	EQU	$		;Used by relocator
 
 ;Move BASIC (0000H-37FFH) from ROM into RAM
 START	DI			;Disable interrupts
 	LD	HL,37FFH	;End of BASIC ROM
 LOOP	XOR	A		;A=0
 	OUT	(84H),A		;Flip ROM into 0H-37FFH
 	LD	B,(HL)		;Get byte from ROM
 	INC	A		;A=1
 	OUT	(84H),A		;Flip RAM into 0H-37FFH
 	LD	(HL),B		;Save byte to RAM
 	DEC	HL		;Decrement ROM/RAM pntr
 	BIT	7,H		;ROM moved (HL=FFFFH)?
 	JR	Z,LOOP		;Loop if not
 ;Install patches to BASIC interpreter
 RELO1	LD	HL,ROMFIX-OFFST	;Point to ROM fix code
 	LD	DE,06C9H	;Start of code to fix
 	LD	BC,9		;Number of bytes to move
 	LDIR
 	LD	A,0FFH		;New mask for TAB fn
 	LD	(213BH),A	;Allow TABs to 255
 RELO2	LD	HL,DRIVER-OFFST	;Get new video dvr addr
 	LD	(401EH),HL	;Store in video dcb
 	LD	HL,4050H	;Print statement parms
 	LD	(1914H),HL	;Save in BASIC and
 	LD	(409DH),HL	; also in reserved RAM
 	LD	A,160		;Number of pixels/line
 	LD	(0141H),A	;Save in BASIC
 	LD	A,72		;Number of pixels/column
 	LD	(014CH),A	;Save in BASIC
 RELO3	LD	HL,SETRES-OFFST	;Patch SET/RESET/POINT
 	LD	(0151H),HL	;  into BASIC
 RELO4	LD	HL,SRPEND-OFFST	;End of SET/RESET/POINT
 	LD	(018DH),HL	;Go from old end
 RELO5	LD	HL,SCRNPT-OFFST	;Patch for screen printer
 	LD	(01DAH),HL	;Patch into BASIC
 	LD	(34FEH),HL	;Both old & new drivers
 RELO5A	LD	HL,SYSLD-OFFST	;Patch to beep after
 	LD	(02B0H),HL	;  SYSTEM tape loaded
 RELO6	LD	HL,POSPTC-OFFST	;Get patch for POS funct
 	LD	(0340H),HL	;Patch former calls to
 	LD	(0647H),HL	;  0348H
 RELO6A	LD	HL,ERRMSG-OFFST	;Error warning beep patch
 	LD	(1A07H),HL	;Beep aft "ERROR","BREAK"
 	LD	(2194H),HL	;Beep after "REDO"
 	LD	(2280H),HL	;..after "EXTRA IGNORED"
 	LD	(2C7EH),HL	;Beep following CLOAD
 	LD	(2C8EH),HL	;Beep after "BAD"
 RELO7	LD	HL,PTPTCH-OFFST	;Address to jump to
 	LD	(208BH),HL	;Store it
 RELO7A	LD	HL,CLOCK-OFFST	;On-screen clock patch
 	LD	(359EH),HL	;Save it
 RELO8	LD	HL,KB-OFFST	;Get keyboard patch addr
 ENABKB	DEFB	0		;22H to form LD (4016),HL
 	DEFW	4016H		;  if KB filter enabled
 RELO9	LD	HL,CASSET-OFFST	;Cassette blinker patch
 	LD	(31D9H),HL	;Save it
 	LD	A,0C3H		;Start of JP instruction
 	LD	(0150H),A	;Store it where needed
 	LD	(018CH),A
 	LD	(01D9H),A
 	LD	(208AH),A
 	LD	(34FDH),A
 	LD	(359DH),A
 	LD	A,0CDH		;Start of CALL instr.
 	LD	(3015H),A	;Force ROM reload @reboot
 	LD	(31D8H),A	;Store CALL where needed
 	LD	A,4EH		;Cassette blinker LSB
 	LD	(0310H),A	;Store it
 	LD	(2C94H),A	;  as required
 	LD	(31DDH),A
 	LD	(3294H),A
 	LD	(3360H),A
 	LD	(338BH),A
 	INC	A		;A=4FH (Cass blinker MSB)
 	LD	(3216H),A
 	LD	(321BH),A
 	LD	A,(4210H)	;Bit mask for port ECH
 	AND	40H		;Check bit 6
 	JR	Z,NOTFST	;If slow clock speed used
 	LD	A,3CH		;Clock update counter val
 	LD	(355DH),A	;Replace previous counter
 NOTFST	LD	A,4		;Set bit 2
 	LD	HL,0EF2H	;Address of ROM error
 	LD	B,0D7H		;B = RST 10H instruction
 	LD	(HL),B		;Fix ROM bug in RAM
 	OUT	(84H),A		;Enable 80 columns & ROM
 	LD	A,(HL)		;Get byte just fixed
 	CP	B		;Is is still fixed?
 	JR	Z,MOD4P		;Go if so (Model 4P)
 	LD	A,5		;Set bits 0 & 2
 	OUT	(84H),A		;Flip RAM back in
 RELO9A	LD	(FLAG-OFFST),A	;Fix flag value
 MOD4P	LD	HL,4409H	;Point to DOS error rtne
 	LD	A,(HL)		;Check first byte
 	CP	0F5H		;Is it "PUSH AF"?
 	JR	NZ,WRNGBT	;If not
 	INC	HL
 	LD	A,(HL)		;Check second byte
 	CP	3EH		;Is it "LD A,nn"?
 	JR	NZ,WRNGBT	;If not
 	INC	HL
 	LD	A,(HL)		;Get third byte
 RELO9B	LD	(RSTVL+1-OFFST),A ;Store in patch code
 	INC	HL
 	LD	A,(HL)		;Check fourth byte
 	CP	0EFH		;Is it "RST 28H"?
 	JR	NZ,WRNGBT	;If not
 	LD	HL,0C300H	;NOP & start of "JP nn"
 	LD	(4409H),HL	;Plug in error vector
 RELO9C	LD	HL,DOSERR-OFFST	;Start of patch code
 	LD	(440BH),HL	;Plug in error vector
 WRNGBT	LD	HL,ITLMSG-OFFST	;Point to opening message
 MSGLP	LD	A,(HL)		;Get character to print
 	CALL	0033H		;Display character
 	INC	HL		;Bump message pointer
 	CP	0DH		;Was character <CR>?
 	JR	NZ,MSGLP	;Display next char if not
 	JP	402DH		;Back to DOS READY
 
 ;*****  OPENING DISPLAY MESSAGE STRING  *****
 
 ITLMSG	DEFB	1CH		;Home cursor
 	DEFB	1FH		;Clear screen
 	DEFM	'VIDEO4 version 2.0 by Jack Decker is now installed.'
 	DEFB	0AH		;Start next line
 	DEFM	'Part of The Alternate Source Public Domain Software Library for the TRS-80.'
 	DEFB	0AH		;Start next line
 	DEFM	'The Alternate Source, 704 North Pennsylvania Ave., Lansing, Michigan 48906-5319'
 	DEFB	0AH		;Leave one blank line
 	DEFB	0DH		;Message terminator
 
 ;*****  FOLLOWING CODE IS RELOCATED TO 06C9H-06D1H  *****
 
 ROMFIX	DEFB	0C3H		;Start of JP instruction
 	DEFW	BYPASS-OFFST	;Jump to ROM fix code
 	LD	BC,1A18H	;Original code found at
 	JP	19AEH		;  06CCH in Model I
 
 ;*****  START OF PROTECTED MEMORY  *****
 ;*****  VARIABLE STORAGE LOCATIONS USED BY DRIVER  *****
 
 ;Default bit mask for port 84H (in protected mem if used)
 FLAG	DEFB	04H
 
 BITCHK	DEFB	00H		;Reverse video flag
 CHAR	DEFB	0FFH		;Previous char. storage
 CSRPS	DEFW	3C00H		;Cursor position storage
 
 ;*****  24 X 80 VIDEO DRIVER BEGINS HERE  *****
 
 DRIVER	DI			;Disable interrupts
 RELO20	LD	HL,(CSRPS-OFFST);Get cursor position
 	LD	A,(IX+05H)	;Get character at cursor
 	OR	A		;Cursor on?
 	JR	Z,CUROFF	;If cursor off
 RELO21	CALL	LDHLA-OFFST	;Display char at cursor
 CUROFF	LD	A,(CHAR-OFFST)	;Check previous character
 	OR	A		;Was it ASCII 0?
 	LD	A,C		;Get character to display
 RELO22	LD	(CHAR-OFFST),A	;Save it for next time
 	JR	Z,DSPCHR	;If prev char was zero
 	CP	20H		;Control character?
 RELO23	JP	C,CONTRL-OFFST	;If control character
 RELO24	LD	A,(BITCHK-OFFST);Check reverse video flag
 	OR	A		;Reverse video on?
 	LD	A,C		;Get character to display
 	JR	Z,COMPCK	;If reverse video not on
 	OR	80H		;Set bit 7 for rev video
 DSPCHR	CALL	PRTCHR-OFFST	;Display printable char
 FINISH	LD	A,H		;Make sure cursor isn't
 	CP	3CH		;  "below" video memory
 	JR	NC,NOTLOW	;If address >= 3C00H
 	LD	DE,1920		;24 lines
 	ADD	HL,DE		;Move cursor up 24 lines
 	JR	SKPADJ
 NOTLOW	LD	DE,1920+3C00H	;Past last cursor loc
 	RST	18H		;Cmp to present loc
 	JR	C,SKPADJ	;Skip adjustment
 	LD	DE,-1920	;24 lines
 	ADD	HL,DE		;Move cursor back 24 lns
 SKPADJ	LD	A,(IX+05H)	;Is cursor on?
 	OR	A		;Test for cursor on
 	JR	Z,NOCUR		;If cursor not on
 RELO25	CALL	LDAHL-OFFST	;Get character in A
 	LD	(IX+05H),A	;Save char "under" cursor
 	LD	A,(IX+06H)	;Get cursor character
 	CP	20H		;Control character?
 	JR	NC,USECUR	;Use it if not
 	LD	A,0B0H		;Else use default cursor
 USECUR	CALL	LDHLA-OFFST	;Display cursor
 NOCUR	LD	(CSRPS-OFFST),HL;Save pos for next time
 RELO26	CALL	CONVRT-OFFST	;Convert to 3C00H-3FFFH
 	JP	04A8H		;Finish up in ROM
 LDAHL	PUSH	HL		;Save current screen loc
 RELO27	CALL	CONVRT-OFFST	;Convert to real location
 	LD	A,(HL)		;Get byte stored there
 	POP	HL		;Restore HL
 	RET
 LDHLA	PUSH	HL		;Save current screen loc
 	PUSH	AF		;Save char to display
 RELO28	CALL	CONVRT-OFFST	;Convert to real location
 	POP	AF		;Restore char to display
 	LD	(HL),A		;Put it to screen
 	POP	HL		;Restore screen loc
 	RET
 FNDEND	CALL	FNDST-OFFST	;Find start of current ln
 	PUSH	DE		;Save DE
 RELO29	CALL	FWRDLN-OFFST	;Get beginning next line
 	POP	DE		;Restore DE
 	RET
 FNDST	EX	DE,HL		;Present cursor loc in DE
 	LD	HL,1919+3C00H	;Last valid screen loc
 	PUSH	BC		;Save BC
 	LD	BC,-80		;Negative one screen line
 ADDLP	ADD	HL,BC		;Move back one line
 	RST	18H		;See if below present loc
 	JR	NC,ADDLP	;Back another line if not
 	POP	BC		;Restore BC
 SCRNST	INC	HL		;Start current video line
 	RET	
 COMPCK	CP	0C0H		;Space comp./special chr?
 	JR	C,DSPCHR	;If not spc comp or spec
 	LD	A,(IX+07H)	;Space comp or spec chrs?
 	OR	A		;Space comp if Z set
 	LD	A,C		;Get original character
 	JR	NZ,DSPCHR	;If special characters
 	SUB	0C0H		;A=# spaces to insert
 	JR	Z,FINISH	;If zero spaces to insert
 	LD	B,A		;B=# of spaces to output
 CMPRLP	LD	A,20H		;Space character in A
 RELO30	CALL	PRTCHR-OFFST	;Output it to display
 	DJNZ	CMPRLP		;Do until finished
 	JR	FINISH		;Clean up and exit
 SAVCHR	CALL	LDAHL-OFFST	;Get character @ cursor
 	JP	04CDH		;Store character & return
 HOME	LD	HL,3C00H	;Point to start video
 	LD	A,(4210H)	;Current port 0ECH bits
 	AND	0FBH		;Bit 2 reset (64 chr/ln)
 	CALL	0570H		;Save mask & port output
 RELO31	LD	A,(FLAG-OFFST)	;Current port 84H bits
 	AND	0F7H		;Turn off inverse chars
 RELO32	LD	(FLAG-OFFST),A	;Re-save current bits
 	XOR	A		;Zero the A register
 RELO33	LD	(BITCHK-OFFST),A;Reverse video flag off
 	LD	A,(4214H)	;# scroll protected lines
 	AND	7		;Keep in range 0 - 7
 PROTLP	RET	Z		;If no more lines to prot
 RELO34	CALL	FWRDLN-OFFST	;Move down one line
 	DEC	A		;Last protected line?
 	JR	PROTLP		;Loop back
 BACKSP	DEC	HL		;Backup cursor
 	LD	A,(4210H)	;Test for use of double-
 	AND	4		;  width characters
 	JR	Z,BCKTWC	;Go if 64 characters/line
 	DEC	HL		;Backup cursor once more
 BCKTWC	LD	A,(BITCHK-OFFST);A=80H if reverse vid on
 	OR	20H		;Make it a space anyway
 	JR	LDHLA		;Put on video & ret
 BACKUP	CALL	FNDST-OFFST	;Find start of line
 	EX	DE,HL		;Start of line in DE
 	LD	A,(4210H)	;Test for use of double-
 	AND	4		;  width characters
 RELO35	CALL	NZ,GOBACK-OFFST	;Do twice if 32 chr/line
 GOBACK	RST	18H		;Check if at start of ln
 	DEC	HL		;Backup
 	RET	NZ		;If not at start of line
 FWRDLN	LD	DE,80		;One video display line
 	ADD	HL,DE		;Bump cursor ahead 1 line
 	RET
 AHEAD	CALL	FNDEND-OFFST	;Find end of current line
 	EX	DE,HL		;End in DE, current in HL
 	INC	HL		;Move ahead one position
 	RST	18H		;Check if at end of line
 	RET	NZ		;If not at end of line
 BACKLN	LD	DE,-80		;Negative # chars/line
 	ADD	HL,DE		;Subtract 80 from HL
 	RET			;  (move back one line)
 RVS	LD	A,(FLAG-OFFST)	;Get port 84H mask
 	OR	8		;Select inverse char set
 RELO36	LD	(FLAG-OFFST),A	;Re-save mask
 	LD	A,80H		;Mask for space chars
 BITFLG	LD	(BITCHK-OFFST),A;Set reverse video flag
 	RET
 CONTRL	LD	DE,FINISH-OFFST	;End routine address
 	PUSH	DE		;Save as "RET" address
 	SUB	7		;Bell character?
 RELO37	JP	Z,BELL-OFFST	;Go if bell
 	DEC	A		;Backspace?
 	JR	Z,BACKSP	;Jump if backspace
 	SUB	2		;Linefeed?
 RELO38	JP	Z,CRLF-OFFST	;Jump if linefeed
 	SUB	3		;Carriage return
 RELO39	JP	Z,CRLF-OFFST	;Jump if carriage return
 	DEC	A		;Cursor on?
 	JR	Z,SAVCHR	;Go if cursor on
 	DEC	A		;Cursor off?
 	JP	Z,04D1H		;Go if cursor off
 	DEC	A		;Reverse video?
 	JR	Z,RVS		;Go if reverse video
 	DEC	A		;Turn off auto reverse?
 	JR	Z,BITFLG	;Go if auto rvs off
 	SUB	4		;Swap cmprs/spc chars?
 	JP	Z,0560H		;If swapping compr/spec
 	DEC	A		;Special/alternate chars?
 	JP	Z,056BH		;Go if special/alternate
 	DEC	A		;Double size?
 	JP	Z,0513H		;Go if double size
 	DEC	A		;Move cursor back?
 	JR	Z,BACKUP	;Go if moving back
 	DEC	A		;Move cursor ahead?
 	JR	Z,AHEAD		;Go if moving ahead
 	DEC	A		;Move cursor down 1 line?
 	JR	Z,FWRDLN	;Go if moving down
 	DEC	A		;Move cursor up one line?
 	JR	Z,BACKLN	;Go if moving up
 	DEC	A		;Home cursor?
 RELO40	JP	Z,HOME-OFFST	;Go if homing cursor
 	DEC	A		;Cursor to start of line?
 RELO41	JP	Z,FNDST-OFFST	;Go if going to line strt
 	DEC	A		;Clear to end of line?
 	JR	Z,CLRLN		;Go if clearing to end
 	DEC	A		;Clear to end of screen?
 	JR	Z,CLREND	;Go if clearing screen
 	RET			;Ignore invalid ctrl code
 PRTCHR	CALL	LDHLA-OFFST	;Put char in A to video
 	INC	HL		;Bump video location ptr
 	LD	A,(4210H)	;Get flag bits
 	AND	4		;Test for double width
 	JR	Z,EIGHTY	;Go if 80 chars/line
 	INC	HL		;Bump pointer again
 EIGHTY	LD	DE,1920+3C00H	;Past last video location
 	RST	18H		;Compare ptr to video end
 	RET	C		;If HL within scrn limits
 RELO42	CALL	BACKLN-OFFST	;Move cursor up one line
 	PUSH	HL		;Save new cursor position
 SCROLL	LD	A,(4214H)	;# scroll protected lines
 	AND	7		;Limit to 7 lines or less
 	LD	HL,3C00H	;First video location
 	LD	DE,400H		;Size of one video page
 	PUSH	BC		;Save BC
 	LD	BC,80		;# characters per line
 	INC	A		;Adjust # protected lines
 SKPROT	ADD	HL,BC		;Advance HL by one line
 	EX	DE,HL		;HL=size of page to move
 	OR	A		;Clear carry flag
 	SBC	HL,BC		;Reduce page size by 1 ln
 	EX	DE,HL		;HL=start of blk to move
 	DEC	A		;Reduce protected ln cnt
 	JR	NZ,SKPROT	;If more lines to protect
 	PUSH	DE		;Save size of pg to move
 	PUSH	HL		;Save strt of blk to mov
 	OR	A		;Clear carry flag
 	SBC	HL,BC		;Move strt up one line
 	EX	DE,HL		;DE=blk move destination
 	POP	HL		;HL=block move start
 	POP	BC		;BC=# bytes to move
 RELO43	LD	A,(FLAG-OFFST)	;Get port 84H flag bits
 	AND	7FH		;Select video page one
 	OUT	(84H),A		;Output back to port
 	LDIR			;Move page 1 up one line
 	LD	HL,3C00H	;Point to start page two
 	LD	B,80		;Move one line
 COPYLN	OR	80H		;Select video page two
 	OUT	(84H),A		;Output bits to port 84H
 	LD	C,(HL)		;Get character at HL
 	EX	DE,HL		;HL=page one destination
 	AND	7FH		;Select video page one
 	OUT	(84H),A		;Output bits to port 84H
 	LD	(HL),C		;Store character to video
 	EX	DE,HL		;HL=page two source
 	INC	HL		;Bump to next character
 	INC	DE		;Bump to next dest. loc.
 	DJNZ	COPYLN		;If more chars to move
 	OR	80H		;Select video page two
 	OUT	(84H),A		;Output bits to port 84H
 	LD	DE,3C00H	;Point to start page two
 	LD	BC,0330H	;# of bytes to move
 	LDIR			;Move page two up one ln
 	POP	BC		;Restore BC
 	LD	HL,0400H	;Offset for page 2 loc
 	ADD	HL,DE		;Adjust location pointer
 	JR	CLEND2		;Clear last video line
 CRLF	CALL	FNDST-OFFST	;Move HL to start of line
 	PUSH	HL		;Save start current line
 RELO44	CALL	FWRDLN-OFFST	;Bump to start next line
 	LD	DE,1920+3C00H	;DE=past last video loc
 	RST	18H		;Is HL past end of video?
 	JR	NC,SCROLL	;Scroll screen if so
 	POP	DE		;Get former cursor loc
 CLRLN	PUSH	HL		;Save present cursor loc
 RELO45	CALL	FNDEND-OFFST	;HL=end of current line
 	EX	DE,HL		;HL=present loc DE=ln end
 	JR	CLRBLK		;Clear to end of line
 CLREND	PUSH	HL		;Save HL
 CLEND2	LD	DE,1920+3C00H	;DE=past last video loc
 CLRBLK	LD	A,(FLAG-OFFST)	;Get port 84H output bits
 	AND	7FH		;Select video page one
 	OUT	(84H),A		;Output bits to port
 CLRLP	BIT	6,H		;Is current loc on pg 2?
 	JR	Z,NOSWTC	;No switch to pg 2 if not
 RELO46	LD	A,(FLAG-OFFST)	;Get port 84H output bits
 	OR	80H		;Select video page 2
 	OUT	(84H),A		;Output bits to port
 	PUSH	BC		;Save BC
 	LD	BC,-0400H	;Offset for page 2
 	EX	DE,HL		;Last loc to clear in HL
 	ADD	HL,BC		;Offset it
 	EX	DE,HL		;Current loc to clr in HL
 	ADD	HL,BC		;Offset it
 	POP	BC		;Restore BC
 NOSWTC	LD	A,(BITCHK-OFFST);A=80H if reverse vid on
 	OR	20H		;Make it a space anyway
 	LD	(HL),A		;Put space at current loc
 	INC	HL		;Bump pointer to next loc
 	RST	18H		;Past last loc to clear?
 	JR	NZ,CLRLP	;If more locations to clr
 	POP	HL		;Restore HL
 	RET
 BELL	XOR	A		;A=0
 	LD	C,A		;Determine tone duration
 BELLP	LD	B,80H		;Determine tone frequency
 	XOR	1		;Change state of bit 1
 	OUT	(90H),A		;Send it to port
 DELAY	DJNZ	DELAY		;Wait a while
 	DEC	C		;Finished yet?
 	JR	NZ,BELLP	;Do again if not finished
 	RET
 ;Routine converts psuedo-location to real & selects page
 CONVRT	LD	A,H		;Get cursor location MSB
 	AND	3		;Convert to fall in range
 	OR	3CH		;  3CH - 3FH
 	BIT	6,H		;Check if page 1 or 2
 	LD	H,A		;Save converted MSB
 SETPRT	LD	A,(FLAG-OFFST)	;Get currnt port 84H bits
 	SET	7,A		;Select video page 2
 	JR	NZ,LOWER	;If lower display half
 	AND	7FH		;Select video page 1
 LOWER	LD	(FLAG-OFFST),A	;Save current port 84H
 	OUT	(84H),A		;  bits & output them
 	RET
 
 ;*****  PATCHES TO BASIC  *****
 
 ;Following code used in fix of 06CCH BASIC re-entry point
 BYPASS	CP	'E'		;Duplicate original ROM
 	RET	NZ		;  code at 06C9H - 06D1H
 	DEC	BC
 	LD	A,(BC)
 	CP	'R'
 	RET	NZ
 	DEC	BC
 	JP	06D2H		;Back into BASIC
 ;Code provides audible beep after SYSTEM tape loaded
 SYSLD	CALL	01F8H		;Turn off cassette
 	JR	BEEP		;Output beep and return
 ;Code provides audible beep after some error messages
 ERRMSG	CALL	28A7H		;Display string
 BEEP	LD	A,7		;"Bell" character
 	JP	032AH		;Output it and return
 ;Following code fixes BASIC SET/RESET/POINT functions
 SETRES	EX	(SP),HL		;Save BASIC pgrm pointer
 	PUSH	HL		;Re-save AF registers
 	LD	HL,3C00H-80	;Screen loc 0 - 80 dec.
 	LD	DE,80		;Count off 80 for each ln
 SRLP1	ADD	HL,DE		;Advance count one line
 	SUB	3		;Subtract 3 pixels per ln
 	JR	NC,SRLP1	;Count off all lines
 	ADD	A,3		;Get remainder
 	LD	C,A		;Save remainder in C
 	POP	AF		;Restore pixel cnt on ln
 	SRL	A		;Divide by 2, remndr in C
 	LD	E,A		;Put char cnt on ln in E
 	LD	A,C		;Get line count remainder
 	ADC	A,A		;A = A*2 + char cnt rmndr
 	INC	A		;Add 1
 	LD	B,A		;B-1 is bit of interest
 	XOR	A		;Zero the A register
 	LD	D,A		;DE=char count on line
 	SCF			;Set carry flag
 SRLP2	RLA			;Rotate set bit to left
 	DJNZ	SRLP2		;Do until bit in position
 	LD	C,A		;Save bit mask in C
 	ADD	HL,DE		;HL=video location pntr
 	DI			;Inhibit blinking cursor
 RELO10	CALL	CONVRT-OFFST	;Convert to real location
 	EX	DE,HL		;Put it in DE
 	POP	HL		;Restore BASIC prgm pntr
 	JP	0175H		;Back to BASIC
 SRPEND	EX	DE,HL		;Save BASIC pgm pointer
 RELO11	LD	HL,(CSRPS-OFFST);Get current cursor pos
 RELO12	CALL	CONVRT-OFFST	;Reset video page flag
 	EX	DE,HL		;Restore BASIC pgm pntr
 	EI			;Re-enable cursor blink
 	RST	08H		;Check for Syntax Error
 	DEFB	')'		;Character to check for
 	RET
 ;Following code fixes ROM screen print routines
 SCRNPT	LD	HL,3C00H	;Point to 1st video loc
 	PUSH	BC		;Save BC registers
 	PUSH	DE		;Save DE registers
 	LD	A,(401CH)	;Get cursor blink flag
 	PUSH	AF		;Save it
 	LD	A,0FFH		;Set A to non-zero
 	LD	(401CH),A	;Inhibit blinking cursor
 	LD	C,24		;# lines to print
 NXTLN	LD	B,80		;# characters per line
 PRNTLP	CALL	LDAHL-OFFST	;Get character from scrn
 	LD	E,A		;Save original char
 RELO13	LD	A,(FLAG-OFFST)	;Is reverse video on?
 	AND	8		;Check bit 3 only
 	LD	A,E		;Get original character
 	RES	7,A		;Make it non-graphics
 	JR	NZ,PRNTIT	;Go if reverse video
 	LD	A,E		;Get original character
 	RLCA			;Check for graphic chars
 	JR	NC,ALPHA	;Go if not graphic
 	RLCA			;Check for bit 6 set
 	JR	C,ALPHA		;Go if bit 6 set
 	LD	E,2EH		;Substitute period
 ALPHA	LD	A,E		;Restore original char
 PRNTIT	CALL	003BH		;Print character
 	INC	HL		;Point to next character
 	DJNZ	PRNTLP		;If not end of line
 	CALL	0214H		;Print <CR> for newline
 	DEC	C		;Check for end of screen
 	JR	NZ,NXTLN	;Go print next line
 RELO14	LD	HL,(CSRPS-OFFST);Get current cursor pos
 RELO15	CALL	CONVRT-OFFST	;Reset video page flag
 	POP	AF		;Restore cursor blink sw
 	LD	(401CH),A	;Save it back to memory
 	POP	DE		;Restore DE
 	POP	BC		;Restore BC
 	JP	0214H		;Final <CR> and return
 ;Following code fixes PRINT routine that gets line pos
 PTPTCH	CALL	2B01H		;Get screen position
 	PUSH	HL		;Save HL
 	LD	HL,-1920	;- # video positions
 	ADD	HL,DE		;Test for # too high
 	JP	C,1E4AH		;FC error if too high
 	LD	HL,3C00H	;Video position 0
 	ADD	HL,DE		;Calculate video pos
 RELO16	LD	(CSRPS-OFFST),HL;Save new cursor pos
 REL16A	CALL	FPOS-OFFST	;Calc cursor pos on line
 	LD	A,L		;Position on line in A
 	JP	209DH		;Back to the ROM
 ;Following code finds cursor position within line
 POSPTC	PUSH	HL		;Save HL
 RELO17	LD	HL,(CSRPS-OFFST);Get cursor position
 RELO18	CALL	FPOS-OFFST	;Find cursor on line
 	LD	A,(4210H)	;Get double-width flag
 	AND	04H		;Mask out other bits
 	LD	A,L		;Line position in A
 	POP	HL		;Restore HL
 	RET	Z		;If not double-width
 	RRCA			;Divide position by 2
 	RET
 FPOS	CALL	FNDST-OFFST	;Find start of line
 	EX	DE,HL		;Current pos in HL
 	OR	A		;Clear carry flag
 	SBC	HL,DE		;Find position on line
 	RET
 ;Code makes sure on-screen clock display is on top line
 CLOCK	LD	A,(FLAG-OFFST)	;Get curent port 84H bits
 	PUSH	AF		;Save current bits
 	AND	7FH		;Select video page 1
 	OUT	(84H),A		;Output to port 84H
 	LD	HL,3C45H	;Point to display area
 	CALL	35A0H		;Display TIME$
 	POP	AF		;Restore current bits
 	OUT	(84H),A		;Output to port 84H
 	RET
 ;Code makes sure CLOAD asterisks are on top half of video
 CASSET	XOR	A		;Set Z flag
 RELO19	CALL	SETPRT-OFFST	;Select top screen page
 	LD	DE,2020H	;Replace patched instr
 	RET
 
 ;*****  PATCH DOS TO BEEP ON ERROR (4409H EXIT)  *****
 
 DOSERR	PUSH	AF		;Duplicate code @ 4409H
 	LD	A,7		;Bell character
 	CALL	33H		;Output beep
 RSTVL	LD	A,00H		;Val inserted in intlztn
 	RST	28H		;Duplicate code @ 440CH
 	JP	440DH		;If return from RST
 
 ;*****  END RELOCATED PGM IF KB FILTER NOT USED  *****
 
 END	EQU	$-1		;Used by relocator
 
 ;*****  KEYBOARD FILTER & SCREEN EDIT CODE  *****
 
 FRMBFR	LD	L,A		;Store PB buffer pos in L
 KBREL1	LD	A,(RECPOS-OFFST);Get record buffer pos
 	SUB	L		;Compare buffer pointers
 	JR	NZ,GETCHR	;If not end of buffer
 	LD	A,8		;Set bit 3
 	LD	(403CH),A	;Up-arrow was pressed
 	RRA			;Set bit 2
 	LD	(41F4H),A	;CTRL key was pressed
 	XOR	A		;A=0
 KBREL2	LD	(PBPOS-OFFST),A	;Zero playback flag
 	RET			;With null character
 GETCHR	LD	H,3FH		;Construct 16 bit address
 KBREL3	LD	A,(FLAG-OFFST)	;Get curent port 84H bits
 	PUSH	AF		;Save current bits
 	OR	80H		;Select video page 2
 	OUT	(84H),A		;Output to port 84H
 	LD	B,(HL)		;Get character from bfr
 	POP	AF		;Restore current bits
 	OUT	(84H),A		;Output to port 84H
 	LD	A,L		;Get PB	buffer position
 	INC	A		;Bump it
 KBREL4	LD	(PBPOS-OFFST),A	;Save new PB buffer pos
 	LD	A,B		;Get buffer character
 RSTZ	OR	A		;Reset Z flag
 	RET
 
 ;*****  ENTRY POINT FOR KEYBOARD DRIVER  *****
 
 KB	LD	A,(PBPOS-OFFST)	;Get buffer playback flag
 	OR	A		;Zero?
 	JR	NZ,FRMBFR	;Get buffer char if not
 KBCALL	CALL	0		;Modified to call KB dvr
 	RET	Z		;Return if no character
 	LD	B,A		;Save char in A
 	LD	A,(3880H)	;Get CTRL key row
 	AND	4		;Mask out other keys
 	JR	NZ,CTRL		;Go if control char
 KBEXIT	LD	A,(RECFLG-OFFST);Check keystroke rec flag
 	OR	A		;Zero byte?
 	LD	A,B		;Get original character
 	JR	Z,RSTZ		;If key not recorded
 	OR	A		;Is key ASCII 0?
 	RET	Z		;If no key pressed
 KBREL5	LD	HL,(RECPOS-OFFST);Get record buffer pos
 KBREL6	LD	A,(FLAG-OFFST)	;Get curent port 84H bits
 	PUSH	AF		;Save current bits
 	OR	80H		;Select video page 2
 	OUT	(84H),A		;Output to port 84H
 	LD	(HL),B		;Save character to bfr
 	POP	AF		;Restore current bits
 	OUT	(84H),A		;Output to port 84H
 	LD	A,L		;Get rec buffer position
 	INC	A		;Bump it
 KBREL7	LD	(RECPOS-OFFST),A;Save new PB buffer pos
 RSTBFR	LD	(RECFLG-OFFST),A;Will turn off full bfr
 	LD	A,B		;Get buffer character
 	JR	RSTZ
 CTRL	LD	A,(403CH)	;Keyboard row storage
 	AND	0FBH		;Key other than BRK?
 	JR	Z,KBEXIT	;Go if not
 	LD	A,B		;Get original character
 	CP	0BH		;Greater than 0AH?
 	JR	NC,HICTRL	;Go if greater than 0AH
 	CP	8		;Less than 08H?
 	JR	C,NULRET	;Return if so
 	OR	10H		;Make cursor ctrl char
 MVCRSR	CALL	0033H		;Output char to video
 NULRET	XOR	A		;Make null (zero) byte
 	RET			;Return with no char
 HICTRL	AND	0BFH		;Make 5BH same as 1BH
 	CP	1BH		;Was character uparrow?
 	JR	NZ,NOTUP	;Go if not
 	LD	A,(3880H)	;Get SHIFT key row
 	AND	3		;Either shift key down?
 	LD	A,B		;Get original character
 	JR	Z,MVCRSR	;Send to video if unshftd
 	LD	A,80H		;Buffer playback start
 KBREL8	LD	(PBPOS-OFFST),A	;Store in playback buffer
 	XOR	A		;Make null (zero) byte
 	RET			;Return with no char
 NOTUP	SUB	0DH		;Stop recording to bfr?
 	JR	Z,CHGFLG	;Zero rec flag if so
 	SUB	0BH		;Restart recording (18H)?
 	JR	NZ,NOTRES	;Go if not
 KBREL9	LD	A,(RECPOS-OFFST);Get buffer position
 CHGFLG	LD	(RECFLG-OFFST),A;Non-zero if not end
 NULRE2	XOR	A		;Make null (zero) byte
 	RET			;Return with no char
 NOTRES	DEC	A		;CTRL+SHIFT+rt arr (19H)?
 	JR	NZ,NOTCSR	;Go if not
 	LD	A,(4022H)	;Get char under cursor
 	OR	A		;Check for valid char
 	JR	NZ,GOTCHR	;Go if valid character
 	LD	HL,(4020H)	;Get current cursor pos
 	LD	A,(HL)		;Get char at cursor
 GOTCHR	CP	20H		;Control character?
 	JR	C,NULRE2	;Return null if control
 	LD	B,A		;Save character in B
 	CP	0C0H		;"Special" character?
 	JR	C,KBEXIT	;Output if regular chr
 	RLA			;Set bit 1 of A register
 	LD	(4024H),A	;Set spec. chars flag
 	RRA			;Restore original char
 	JR	KBEXIT
 NOTCSR	SUB	6		;Begin recording (1FH)?
 	JR	NZ,NULRE2	;Return null chr if not
 	LD	A,80H		;Buffer start position
 KBRE10	LD	(RECPOS-OFFST),A;Re-initialize buffer
 	JR	CHGFLG		;Set rec flag non-zero
 RECFLG	DEFB	0		;<>0 when rec keystrokes
 PBPOS	DEFB	0		;Playback position flag
 RECPOS	DEFW	3F80H		;Recording position flag
 
 ;*****  END RELOCATED PGM WHEN KB FILTER IS USED  *****
 
 ALTEND	EQU	$-1		;Used by relocator
 
 	END	INTLZE
