;*****************************************************************
;UPGAT v 2.0 (c) Scott Toenniessen 1991
;
;For use with pfix/cmd and pfix6/cmd GAT repairs
;Update disk configuration byte CD bit 3 to indicate LS-DOS 6.3.x style
;   dating
;
;Execute via:  upgat :d (old)  where d is the drive number and old
;                              is an optional param. to set pre 6.3.x dating
;                              The colon may be omitted
;
;This version of upgat is may be freely distributed as long as the
;   authors name and copyright notice is left intact.

;It may be modified as long as the above is observed
;
;Compile with: MRAS upgat/asm -gc    for LS-DOS 6
;              MRAS upgat/asm -gc (p1) for LDOS 5
;
;********************************************************************
;
DOS5	EQU	@@1
DOS6	EQU	.NOT.DOS5

	IF	DOS6
*GET	SVC
	ENDIF

	IF	DOS5
*GET	EQUATE3
	ENDIF

     	ORG	7000H

START	PUSH	HL			;Save command line arg
HELLO	LD	HL,HELLO1		;Display greeting
	SVC	@DSPLY
	LD	HL,HELLO2
	SVC	@DSPLY
	LD	HL,HELLO3
	SVC	@DSPLY
	LD	HL,LF
	SVC	@DSPLY

ARG1	POP	HL			;Get command line arg
	LD	A,003AH			;Check for ':'
	CPI
	JR	Z,ARG2
	DEC	HL		;if no colon, check for drive number anyway

ARG2 	LD	A,000DH			;check for carriage return
	CPI
	JR	Z,ERR2			;  if CR, quit
	DEC	HL			;else check for number 0-7

ARG3	LD	A,0038H			;check for 8
	CPI
	JR	Z,ERR3			;if 9, go error
	DEC	HL
	LD	A,0039H			;check for 9
	CPI
	JR	Z,ERR3			; if 9, go error
	DEC	HL

	LD	C,(HL)			;Specify drive number
	PUSH	HL			;Save HL PARM
	PUSH	HL			;Save HL for WRGAT
	SVC	@CKDRV			;Check drive availability
	JR	NZ,NODISK		;   go if not ready

RDGAT	LD	E,00H			;Read dir sector 0
	LD	HL,BUFFER		;   (GAT sector)
	IF	DOS6
	SVC	@RDSSC
	ENDIF
	IF	DOS5
	SVC	RDSSEC
	ENDIF
	JR	NZ,ERR1			;Go if error reading

PARM	POP	HL			;Recall HL
	INC	HL			;Advance past drive spec
	PUSH	DE			;Save dir cyl.
	LD	DE,PRMTBL		;Point to parameter table
	SVC	@PARAM			;Parse parameters
	JR	NZ,ERR2			;Go if parm. error

OPARM	LD	BC,0			;Set default to off
	LD	A,B			;Merge the hi and lo orders
	OR	C
	JR	Z,SETBIT		;If old=n, go

RSTBIT	LD	HL,DSKCFG	;reset CDH bit 3 for pre LS-DOS 6.3 dating
	RES	3,(HL)
	JP	WRGAT

SETBIT	LD	HL,DSKCFG    		;set CDH bit 3 LS-DOS 6.3.x dating
	SET	3,(HL)

WRGAT	LD	E,00H			;Save modified GAT sector
	POP	DE			;Get dir cyl
	POP	HL			;Get drive number
	LD	C,(HL)
	LD	HL,BUFFER		;Point to buffer
	IF	DOS6
	SVC	@WRSSC			;Save
	ENDIF
	IF	DOS5
	SVC	WRPROT
	ENDIF
	JR	NZ,ERR1			;Go if error writing
	JP	EXIT			;else exit to LS-DOS

ERR1	LD	C,A			;@RDSSEC/@WRSSEC error
	SET	6,C			;   set short error message
	SVC	@ERROR			;   display error and exit to LS-DOS

ERR2	LD	HL,SPECMSG		;Command line spec error
	SVC	@DSPLY			;  Display error message
	SVC	@ABORT			;  abort to LS-DOS

ERR3	LD	HL,ILLMSG		;Illegal drive number
	SVC	@DSPLY
	SVC	@ABORT

NODISK	LD	HL,DSKMSG		;Drive not ready error
	SVC	@DSPLY			;  display error message
	SVC	@ABORT			;  abort to LS-DOS

EXIT	LD	HL,DSKCFG		;Exit to LS-DOS
	BIT	3,(HL)			;  Check if which messageto use
	JR	Z,BYE62
BYE63 	LD	HL,BYE1			;Use 6.3.x message
	SVC	@DSPLY
	JP	LSTJP
BYE62	LD	HL,BYE2			;Use pre 6.3.x message
	SVC	@DSPLY
LSTJP	LD	HL,0000H		;   no error
	SVC	@EXIT			;  EXIT

DSKCFG	EQU	$+00CDH			;locate disk configuration byte in GAT
BUFFER	DS	256
DSKMSG	DB	'Drive not available',0DH
SPECMSG DB	'Must invoke via: upgat :d     where d is the drive to fix',0DH
ILLMSG	DB	'Illegal drive number',0DH
HELLO1	DB	'UPGAT v. 2.0 (c) 1991 by Scott Toenniessen',0DH
	IF	DOS6
HELLO2	DB	'Updates GAT sector of LS-DOS 6.3.x formatted disks',0DH
HELLO3	DB	'after being repaired with PFIX6/CMD',0DH
	ENDIF
	IF	DOS5
HELLO2	DB	'Updates GAT sector of LDOS 5.3.x formatted disks',0DH
HELLO3	DB	'after being repaired with PFIX/CMD',0DH
	ENDIF
LF	DB	0DH
	IF	DOS6
BYE1	DB      'GAT is now 6.3.x compatable!',0DH
BYE2	DB	'GAT is now pre 6.3.0 compatable!',0DH
	ENDIF
	IF	DOS5
BYE1	DB	'GAT is now 5.3.x compatable!',0DH
BYE2	DB	'GAT is now pre 5.3.0 compatable',0DH
	ENDIF

PRMTBL	DB	'OLD   '		;Old style dating parameter
	DW	OPARM+1
	DB	'O     '
	DW	OPARM+1
	NOP				;End of table

	DATE
	TIME
	END	START
