;*=*=*
;	UNLOCK PROGRAM
;	By Peter Lengsfeld
;	Mar. 20th, 1985
;*=*=*
@HIGH$	EQU	100
@OPEN	EQU	59
@CLOSE	EQU	60
@FSPEC	EQU	78
@FLAGS$	EQU	101
@READ	EQU	67
@WRITE	EQU	75
@KEYIN	EQU	9
@DSPLY	EQU	10
@INIT	EQU	58
BUFPTR	EQU	3
EOF	EQU	8
NRN	EQU	10
ERN	EQU	12
@ERROR	EQU	26
	ORG	3000H
;*=*=*
;	INITIALIZE
;*=*=*
START	LD	(STACK),SP	;save return point
BGNMEM	EQU	$-4
ENDMEM	EQU	$-2
	LD	HL,MSG1		;logon msg
	CALL	DISPLY
GETINP	CALL	NZ,INVAL
	LD	HL,MSG2		;prompt for input file
	CALL	CKSPEC		;get keyboard input line
	JR	NZ,GETINP
	LD	A,@FLAGS$	;point to base of flags
	RST	40
	PUSH	IY		;put in DE
	POP	DE
	LD	HL,'S'-'A'	;offset for SFLAG$
	ADD	HL,DE		;add offset to base
	SET	0,(HL)		;dont check LRL, force READ
;*=*=*
;	OPEN FILE
;*=*=*
	CALL	POINT
	LD	A,@OPEN
	CALL	DODOS
;*=*=*
;	LOAD BUFFER WITH FILE USING
;	FASTFILE TECHNIQUE
;*=*=*
FASTIO	LD	HL,0		;lets get HIGH
	LD	B,L		;SVC requires B=0
	LD	A,@HIGH$
	RST	40
	CALL	SETSUB
	LD	HL,BUFFER	;have room for
AGAIN	LD	(FCB+BUFPTR),HL	;put buf addr in
	LD	A,@READ		;FCB
	RST	40		;READ sector
	JP	NZ,CKERR	;is err EOF or DOS?
	INC	H		;inc buf addr
	DJNZ	AGAIN		;keep reading sectors
	PUSH	HL		;save
	LD	HL,(FCB+NRN)	;check if ERN was last
	LD	DE,(FCB+ERN)	;to fit in end of mem
	OR	A
	SBC	HL,DE
	POP	HL
	JP	NZ,NOMEM
ISEOF	LD	A,(FCB+EOF)	;get EOF offset byte
	DEC	A
	LD	E,A
	LD	D,0		;DE = offset of EOF
	DEC	H		;backup 1 full sector
	ADD	HL,DE		;add offset
	INC	HL
	LD	(ENDMEM),HL	;store end of buffer
;*=*=*
	CALL	CLOFIL		;close file
	LD	HL,BUFFER	;check to see if file
	LD	A,(HL)		;is a protected BASIC
	CP	0FEH		;program
	JP	NZ,NOLOCK
	INC	(HL)		;set to FFH
	INC	HL
	LD	(BGNMEM),HL
	CALL	UNLOCK
GETOUT	CALL	NZ,INVAL
	LD	HL,MSG3
	CALL	CKSPEC
	JR	NZ,GETOUT
	CALL	POINT
	LD	A,@INIT
	CALL	DODOS
	LD	HL,(ENDMEM)
	CALL	SETSUB
	LD	C,L
	INC	B
	LD	HL,BUFFER
WRMORE	LD	(FCB+BUFPTR),HL
	LD	A,@WRITE
	CALL	DODOS
	INC	H
	DJNZ	WRMORE
	LD	A,C
	LD	(FCB+EOF),A
	LD	A,@CLOSE
	RST	40
	JP	NZ,ABORT
	LD	HL,0
	JP	QUIT
;*=*=*
*GET	LOCKCODA
;	CLOSE FILE
;*=*=*
CLOFIL	LD	DE,FCB
	LD	A,@CLOSE
	RST	40
	RET
;*=*=*
;	GET KEYBOARD INPUT AND CHECK FOR VALID FSPEC
;*=*=*
CKSPEC	CALL	DISPLY
	LD	HL,TEMP		;keyin buffer pntr
	LD	BC,1F00H	;1FH = max line input
	LD	A,@KEYIN
	RST	40
	JR	C,ABORT		;<BREAK> was pressed
	JR	NZ,DOSERR
	LD	DE,FCB
	LD	A,@FSPEC
	RST	40
	RET
;*=*=*
POINT	LD	HL,BUFFER	;open file
	LD	DE,FCB
	LD	B,0		;set LRL=256
	RET
;*=*=*
SETSUB	LD	BC,BUFFER	;get start of BUFFER
	OR	A		;clear CARRY FLAG
	SBC	HL,BC		;subtract (HIGH-BUF)
	LD	B,H		;num of sectors we
	RET
;*=*=*
INVAL	LD	HL,MSG4
DISPLY	LD	A,@DSPLY
DODOS	RST	40
	JR	NZ,DOSERR
	RET
;*=*=*
;	ERROR ROUTINES
;*=*=*
CKERR	CP	1CH		;EOF?
	JP	Z,ISEOF
	CP	1DH		;past EOF?
	JP	Z,ISEOF
DOSERR	OR	0C0H		;set short msg
	LD	C,A
	LD	A,@ERROR
	RST	40
ABORT	LD	HL,-1
QUIT	LD	SP,$-$
STACK	EQU	$-2
	RET
;*=*=*
;	ERROR MESSAGES
;*=*=*
NOLOCK$	DB	'NOT a PROTECTED BASIC PROGRAM',0DH
NOMEM$	DB	'File to large',0DH
;*=*=*
NOLOCK	LD	HL,NOLOCK$
	DB	0DDH
NOMEM	LD	HL,NOMEM$
	LD	A,@DSPLY
	RST	40
	JR	ABORT
;*=*=*
;	MESSAGES
;*=*=*
MSG1	DB	'UNLOCK By P. Lengsfeld',0DH
MSG2	DB	0AH,'Enter LOAD filespec ..> ',03H
MSG3	DB	'Enter SAVE filespec ..> ',03H
MSG4	DB	0AH,'Invalid filespec',0DH
;*=*=*
;	END
;*=*=*
TEMP	EQU	$
FCB	EQU	TEMP+32
BUFFER	EQU	FCB+32<-8+1<8
	END	START
;
;	The next piece is the "LOCKCODA/ASM" included file
;
;*=*=*
;	UNLOCK ROUTINE
; 	THIS ROUTINE IS USED TO UNLOCK BASIC
;	PROGRAMS SAVED WITH "P" OPTION
;
;	NOTES:	ROUTINE SHOULD BE CALLED FROM MAIN PROGRAM
;		BGNMEM SHOULD POINT TO FIRST CHAR AFTER 0FEH
;		ENDMEM SHOULD POINT TO LAST CHAR +1
;*=*=*
UNLOCK	LD	BC,0D0BH
	LD	DE,(BGNMEM)
UNLOCK1	LD	HL,(ENDMEM)
	OR	A
	SBC	HL,DE
	RET	Z
	LD	HL,TABLE1
	LD	A,L
	ADD	A,B
	LD	L,A
	LD	A,H
	LD	H,A
	LD	A,(DE)
	SUB	C
	XOR	(HL)
	PUSH	AF
	LD	HL,TABLE2
	LD	A,L
	ADD	A,C
	LD	L,A
	LD	A,H
	LD	H,A
	POP	AF
	XOR	(HL)
	ADD	A,B
	LD	(DE),A
	INC	DE
	DEC	C
	JR	NZ,UNLOCK2
	LD	C,0BH
UNLOCK2	DEC	B
	JR	NZ,UNLOCK1
	LD	B,0DH
	JR	UNLOCK1
TABLE1	EQU	$-1
	DB	0FBH,0D7H,1EH,86H,65H,26H,99H,87H,58H,34H,23H,87H,0E1H
TABLE2	EQU	$-1
	DB	4AH,0D7H,3BH,78H,02H,6EH,84H,7BH,0FEH,0C1H,2FH
;*=*=*
;	END OF UNLOCK CODE
;*=*=*
