/*

		unpit - Macintosh PackIt file unpacker

		Version 2, for PackIt II

This program will unpack a Macintosh PackIt file into separate files.  The
data fork of a PackIt file contains both the data and resource forks of the
packed files.  The program will unpack each Mac file into separate .dat,
.rsc., and .inf files.

The program syntax is:

	unpit [-ardc] packit-file.ext

The -a flag will cause the both the resource and data forks to be written,
as well as information about the file, appended with the ".inf" suffix. (BP)

The  -r and -d flags will cause only the resource or data fork to be
written.  The -c flag will cause only the data fork to be written and
to have carriage return characters changed to CP/M CR-LF pairs.

The -c option is the default. (BP)


Some of the program is borrowed from the macput.c/macget.c programs.

	Author: Allan G. Weber, (Weber%Brand@USC-ECL)		
	Date:   September 30, 1985
	Revised: January 24, 1986 - added CRC checking
		 March 25, 1986 - support compressed mode of PackIt II,
				  check for illegal Unix file names
	Implemented: Sep 28, 1987 - A version for CP/M, by Bob Presswood.
		Note the discarding of the first 128 bytes of the .PIT 
		file.  This algorithm is not functional without doing so.
		This block is apparently an information resource for the
		Macintosh operating system.  When the same .PIT file is
		reviewed with Fedit 3.5 (a file dump/edit utility) on a
		Mac II, these 128 bytes are not available.  For CP/M
		(and PC/MSDOS if someone wishes to transport this file)
		these data are not significant, but could potentially be
		used for reporting statistics of Mac files.  Note the
		addition of a recursive routine to check for the presence
		of a file of the same name so to avoid file overwriting.
	Implemented: Dec 1987 - A version for Tandy Model 4 by David Huelsmann.
		Note that all files INF, DAT, RSC are now combined into one
		file. Added code to automatically assume proper extension
		on PackIt II file as well as appropriate code to handle
		appending and drive selection. Uses extensive custom video
		routines written for AZTEC C and available on request.
		All options for writing separate files have been removed.
		Some error handling for i/o error on write has been implemented.
		Jan 1987 - RSC fork now discarded as information indicates that
		it is not needed for Model 4.
*/

/* There is some confusion as to what to do with the "inited" flag in the
   finder info bytes that are in the header of each file in the packit file.
   If this flag bit is copied to the .inf file, it seems to confuse
   MacTerminal into placing the file icons in the upper left corner of the
   window on top of each other.  Setting this bit to zero in the .inf file
   seems to fix that problem but may cause others.  I haven't been able to
   find any .inf files that have this flag set so making it zero may be OK.
   Anyway, MacTerminal seems to set the flag when it create the file on the
   Mac.  The "#define INITED_BUG" can be used to try both settings.  */

/*
Format of a Packit file:

Repeat the following sequence for each file in the Packit file:

	4 byte identifier ("PMag" = not compressed, "Pma4" = compressed)
	variable length compression data (if compressed file)
	92 byte header (see struct pit_header below) *
	2 bytes CRC number *
	data fork (length from header) *
	resource fork (length from header) *
	2 bytes CRC number *

Last file is followed by the 4 byte Ascii string, "Pend", and then the EOF.

* these are in compressed form if compression is on for the file

*/

#define PROGRAM "UNPIT4/CMD Ported by David Huelsmann"
#define VERSION "Tandy Model 4 Version 01.00.02"
#define USAGE "Macintosh PackIt II file unpacker"
#define ORIGAUTH "Original Unix Author - Allan G. Weber 9/30/85"
#define SECAUTH "Ported to CP/M by Bob Presswood 9/28/87"

struct pit_header {	/* Packit file header (92 bytes)
	char nlen;	/* number of characters in packed file name */
	char name[63];	/* name of packed file */
	char type[4];	/* file type */
	char auth[4];	/* file creator */
	short flags;	/* file flags (?) */
	short lock;	/* unknown */
	long dlen;	/* number of bytes in data fork */
	long rlen;	/* number of bytes in resource fork */
	long ctim;	/* file creation time */
	long mtim;	/* file modified time */
};
	
#define HDRBYTES  92
#define INFOBYTES 128
	
#define BYTEMASK 0xff
	
#define H_NAMELEN 63
	
#define H_NLENOFF 0
#define H_NAMEOFF 1
#define H_TYPEOFF 64
#define H_AUTHOFF 68
#define	H_LOCKOFF 70
#define H_FLAGOFF 72
#define H_DLENOFF 76
#define H_RLENOFF 80
#define H_CTIMOFF 84
#define H_MTIMOFF 88
	
#define I_NAMELEN 69	/* H_NAMELEN + strlen(".info") + 1 */
	
/* The following are copied out of macput.c/macget.c */
#define I_NLENOFF 1
#define I_NAMEOFF 2
/* 65 <-> 80 is the FInfo structure */
#define I_TYPEOFF 65
#define I_AUTHOFF 69
#define I_FLAGOFF 73
#define I_LOCKOFF 81
#define I_DLENOFF 83
#define I_RLENOFF 87
#define I_CTIMOFF 91
#define I_MTIMOFF 95

#define INITED_BUG
#define INITED_OFF	I_FLAGOFF	/* offset to byte with Inited flag */
#define INITED_MASK	(~1)		/* mask to '&' with byte to reset it */

#define TEXT 0
#define DATA 1
#define RSRC 2
#define FULL 3

struct node {
	int flag, byte;
	struct node *one, *zero;
} nodelist[512], *nodeptr, *read_tree();	/* 512 should be big enough */

char f_info[I_NAMELEN];
char f_data[I_NAMELEN];
char f_rsrc[I_NAMELEN];

char hdr[HDRBYTES];
char info[INFOBYTES];
char text[H_NAMELEN+1];
char text1[9];			/* New variable (BP) */
char suffix[5];			/*  "     "      "   */

int mode, txtmode;
long datalen, rsrclen;	/* Mistakenly were integers in original (BP) */
int decode, bit;

char drive[3];			/* new variable (DH) */
int filecnt = 0;		/* new variable (DH) */

FILE *f1;		/* New file pointer; stdin formerly used (BP) */
