#include <stdio/h>
#include <date/h>
#include <unpit4/h>

main(num, arg)
int num;					/* changed from ac and **av (DH) */
char **arg;
{
char Macdata[128];			/* Operating system info (BP) */
char *makefnam();			/* filename fixup routine (DH) */
char *chkfile();			/* routine to check for file (DH) */
char temp[4], name[32];		/* changed name from pointer */
int n, crc, data_crc;

	mode = FULL;				/* used to be TEXT (DH) */
								/* removed name = ""; (DH) */
	if(num<2)					/* forced full help if PackIt file not given */
		help();
	crtdsp();					/* display CRT format (DH) */
	cursor(7,26);
	rvideo();
	printf(" Reading File Statistics: ");
	nvideo();
	hdraw(14,0,79,'-');
	cursor(15,26);
	rvideo();
	printf(" Writing File Statistics: ");
	nvideo();
	hdraw(18,0,79,'_');

	for(n=1; n<num; n++)		/* for each argument (DH) */
		stoupper(arg[n]);		/* convert it to uppercase (DH) */
	
	makefnam(arg[1],"/PIT",name);	/* supply default for name (DH) */
	
	if ((f1 = fopen(name,"r")) == NULL) {
		/* stdin formerly used (BP) */
		eraeop(19,0);
		printf("%s ",name);
		error("Can't open input file");	/* common error routine (DH) */
	}

	if (fread(Macdata, 1, 128, f1) == 0)	{	/* Dump 1st 128 bytes (BP) */
		eraeop(19,0);
		error("Unrecognized Packit format");
	}
	while (1) {
		if (fread(temp, 1, 4, f1) == 0)
			break;
		if (strncmp(temp, "PMag", 4) == 0 ||
		    strncmp(temp, "PMa4", 4) == 0) {
			if (temp[3] == '4') {
				nodeptr = nodelist;
				read_tree();
				decode = 1;
			}
			else
				decode = 0;
			filecnt += 1;
			data_crc = read_hdr();	/* writes info portion of file	*/
			crc = getcrc();
			if (crc != data_crc) {
				eraeop(19,0);
				error("File header CRC mismatch");
			}
			txtmode = (mode == TEXT);
			eraeol(17,10);
			printf("Writing: %s [data fork]",f_data);
			cursor(17,60);
			printf("File #: %d",filecnt);
			data_crc = write_file(f_data,datalen,0);	/* data portion	*/
			txtmode = 0;
			data_crc = write_file(f_rsrc,rsrclen,data_crc);	/* rsrc portion */
			crc = getcrc();
			if (crc != data_crc) {
				eraeop(19,0);
				error("File data/rsrc CRC mismatch");
			}
			decode = 0;
			bit = 0;	/* flush unused bits */
		}
		else if (strncmp(temp, "PEnd", 4) == 0)
			break;
		else {
			eraeop(19,0);
			error("Unrecognized Packit format");
		}
	}
	curson();
	eraeop(7,0);
	cursor(8,33);
	printf("UNPIT4: done\n");
	exit(0);
}

help()
{

		/* note use of custom library routines */

		crtdsp();
		cursor(8,36);
		printf("USAGE:");
		cursor(10,29);
		rvideo();
		printf(" UNPIT4 PackItfile ");
		nvideo();
		cursor(13,21);
		printf("Note: Extension of /PIT is assumed");
		cursor(19,0);
		curson();
		beep();
		exit(-1);
}


crtdsp()
{

		/* note use of custom library routines */

		clrscr();
		cursoff();
		cursor(0,39-(strlen(PROGRAM)/2));
		printf("%s",PROGRAM);
		cursor(1,39-(strlen(USAGE)/2));
		printf("%s",USAGE);
		cursor(2,39-(strlen(VERSION)/2));
		printf("%s",VERSION);
		cursor(3,39-(strlen(ORIGAUTH)/2));
		printf("%s",ORIGAUTH);
		cursor(4,39-(strlen(SECAUTH)/2));
		printf("%s",SECAUTH);
		cursor(5,26);
		printf("Compiled %s",_DATETIME);
		hdraw(6,0,79,'_');
}

/* This routine recursively reads the compression decoding data.
   It appears to be Huffman compression. */
struct node *read_tree()
{
struct node *np;
	
	np = nodeptr++;
	if (getbit() == 1) {
		np->flag = 1;
		np->byte = getbyte();
	}
	else {
		np->flag = 0;
		np->zero = read_tree();
		np->one  = read_tree();
	}
	return(np);
}


read_hdr()
{
long get4();
register int i, n, crc;
FILE *fp;
char *np;
char *chkfile();	/* New function (BP) */

	for (n = 0; n < INFOBYTES; n++)
		info[n] = '\0';
	for (n = 0; n < HDRBYTES; n++)
		hdr[n] = getbyte();
	crc = 0;
	for (n = 0; n < HDRBYTES; n++) {
		crc = crc ^ ((int)hdr[n] << 8);
		for (i = 0; i < 8; i++)
			if (crc & 0x8000)
				crc = (crc << 1) ^ 0x1021;
			else
				crc <<= 1;
	}

	n = hdr[H_NLENOFF] & BYTEMASK;
	if (n > H_NAMELEN)
		n = H_NAMELEN;
	info[I_NLENOFF] = n;
	copy(info + I_NAMEOFF, hdr + H_NAMEOFF, n);
	strncpy(text, hdr + H_NAMEOFF, n);
	text[n] = '\0';
	datalen = get4(hdr + H_DLENOFF);
	rsrclen = get4(hdr + H_RLENOFF);
	
	eraeol(9,10);					/* file statistics display */
	printf("Full Name = \"%s\"",text);
	eraeol(10,15);
	printf("Type = %4.4s",hdr + H_TYPEOFF);
	eraeol(11,13);
	printf("Author = %4.4s",hdr + H_AUTHOFF);
	eraeol(12,8);
	printf("Data Length = %ld",datalen);
	eraeol(13,4);
	if(rsrclen)
		printf("Resource Length = %ld {discarded}",rsrclen);


/* check for illegal CP/M characters in file name (BP) */
	for (np = text; *np; np++)
		if (*np <= ' ' || *np == '*' || *np == '_' || 
				(*np > '9' && *np < '@') || 
				*np == '[' || *np > '~')
			*np = 'Z';

	strncpy(text1, text, 8);
	text1[8] = '\0';	/* Limit CP/M names to 8 + 3 chars (BP) */
	if (np = index(text1,'.'))
		*np = '\0';
	if (np = index(text,'.')){
		strncpy(suffix,np,4);
		if (np = index(suffix+1,'.'))
			*np = '\0';
	} else
		*suffix = '\0';
	strcpy(text,text1);
	strcat(text,suffix);
	if (mode == FULL) {
				/* Suffices are now 3 chars (BP) */
		sprintf(f_info, "%s/DAT", text1);		/* used to be inf (DH)	*/
		sprintf(f_data, "%s/DAT", text1);
		sprintf(f_rsrc, "/dev/null");			/* don't write resource (DH) */
		if(*drive == ':')	{				/* added for ouput drive (DH) */
			strcat(f_info,drive);
			strcat(f_data,drive);
		}
		stoupper(f_info);						/* convert to uppercase (DH) */
		stoupper(f_data);

		copy(info + I_TYPEOFF, hdr + H_TYPEOFF, 4);
		copy(info + I_AUTHOFF, hdr + H_AUTHOFF, 4);
		copy(info + I_FLAGOFF, hdr + H_FLAGOFF, 2);
#ifdef INITED_BUG
		info[INITED_OFF] &= INITED_MASK;	/* reset init bit */
#endif
		copy(info + I_LOCKOFF, hdr + H_LOCKOFF, 2);
		copy(info + I_DLENOFF, hdr + H_DLENOFF, 4);
		copy(info + I_RLENOFF, hdr + H_RLENOFF, 4);
		copy(info + I_CTIMOFF, hdr + H_CTIMOFF, 4);
		copy(info + I_MTIMOFF, hdr + H_MTIMOFF, 4);

		strcpy(f_info,chkfile(f_info));
		fp = fopen(f_info, "w");
		if (fp == NULL) {
			eraeop(19,0);
			printf("%s ", f_info);
			error("Can't open for writing");
		}
		eraeol(17,10);
		printf("Writing: %s [info fork]",f_info);
		cursor(17,60);
		printf("File #: %d",filecnt);
		clearerr(fp);					/* make sure no error exists	*/
		fwrite(info, 1, INFOBYTES, fp);
		if(ferror(fp) != 0)	{
			eraeop(19,0);
			error("i/o error while writing");
		}
		fclose(fp);
	}
	else if (mode == RSRC) {
			sprintf(f_data, "/dev/null");
			sprintf(f_rsrc, "%s/rsc", text1);
	}
	else {
			sprintf(f_data, "%s", text);
			sprintf(f_rsrc, "/dev/null");
	}
	return(crc & 0xffff);
}


write_file(fname, bytes, crc)
char *fname;
long bytes;
register int crc;
{
register int b, i;
int write_flag;		/* New variable (BP) */
FILE *outf;

	if (!bytes)	  /* If no output, don't open for null file (BP) */
		return(crc & 0xffff);
	/* Null device not for CP/M (BP) */
	write_flag = strcmp(fname,"/dev/null"); 
	if (write_flag){
		outf = fopen(fname, "a");		/* changed to append (DH) */
		if (outf == NULL) {
			eraeop(19,0);
			printf("%s ", fname);
			error("Can't open for writing");
		}
	}
	while (bytes-- > 0) {
		b = getbyte();
		crc = crc ^ (b << 8);
		for (i = 0; i < 8; i++)
			if (crc & 0x8000)
				crc = (crc << 1) ^ 0x1021;
			else
				crc <<= 1;
		if (write_flag){
			if (txtmode && (b & BYTEMASK) == '\r'){
				putc(b, outf);
				b = '\n';
			}
			if(putc(b, outf) != b)	{
				eraeop(19,0);
				error("i/o error while writing");
			}
		}
	}
	if (write_flag)
		fclose(outf);
	return(crc & 0xffff);
}


long get4(bp)
char *bp;
{
register int i;
long value;

	value = 0L;				/* Use of 0L (BP) */
	for (i = 0; i < 4; i++) {
		value <<= 8;
		value |= (*bp & BYTEMASK);
		bp++;
	}
	return(value);
}


getcrc()
{
int value;

	value = getbyte() & BYTEMASK;
	return( value << 8 | (getbyte() & BYTEMASK) );
}


copy(p1, p2, n)
char *p1, *p2;
int n;
{
	while (n-- > 0)
		*p1++ = *p2++;
}


/* This routine returns the next bit in the input stream (MSB first) */
getbit()
{
static char b;

	if (bit == 0) {
		b = getc(f1) & 0xff;  /* File, rather than stdin (BP) */
		bit = 8;
	}
	bit--;
	return((b >> bit) & 1);
}


/* This routine returns the next 8 bits.  If decoding is on, it finds the
byte in the decoding tree based on the bits from the input stream.  If
decoding is not on, it either gets it directly from the input stream or
puts it together from 8 calls to getbit(), depending on whether or not we
are currently on a byte boundary
*/
getbyte()
{
register struct node *np;
register int i, b;

	if (decode) {
		np = nodelist;
		while (np->flag == 0)
			np = (getbit()) ? np->one : np->zero;
		b = np->byte;
	}
	else {
		if (bit == 0)	/* on byte boundary? */
			b = getc(f1) & 0xff;	/* File, rather than stdin */
		else {		/* no, put a byte together */
			b = 0;
			for (i = 8; i > 0; i--) {
				b = (b << 1) + getbit();
			}
		}
	}
	return(b);
}


char *chkfile(s)		/* New function (BP) */
char *s;
{
static char newname[32];
char ans, *chkfile();
char *p;
FILE *fp;

	if ((fp = fopen(s,"r")) != NULL){
		fclose(fp);
		eraeop(19,0);
		printf("%s already exists!  Proceed?  (Y/N) ", s);
		beep();
		do	{
			ans = toupper(keyscan());
		} while (ans != 'Y' && ans != 'N');
		if (ans == 'Y')	{
			eraeop(19,0);
			return(s);
		}
		*newname = '\0';
		do {
			eraeop(20,0);
			printf("Input another filename to use: ");
			gets(newname);
		} while (!strlen(newname));
		strcpy(newname,chkfile(newname));	/* note recursion (DH) */
		eraeop(19,0);
		return(newname);
	}
	return(s);
}

stoupper(name)
char *name;
{

	while(*name)	{
		*name = toupper(*name);
		++name;
	}
}

error(str)								/* new common error function (DH)	*/
char *str;
{

	printf(" * * * UNPIT4: %s * * *\n",str);
	beep();
	exit(-1);
}

char *makefnam(source, template, destination)	/* new ext function (DH)	*/
char *source, *template, *destination;
{
char *character;
char buf[32];
int i;

	strcpy(buf,source);					/* copy source */
	if(character = index(source,':'))	/* if drive exists on source */
		strcpy(drive, character);		/* save it */
	i = 0;								/* strip off drivespec */
	while(buf[i])	{
		if(buf[i] == ':')	{
			buf[i] = '\0';
			break;
		}
		i++;
	}
	if(!index(buf,'/'))	{				/* if source does not have */
		strcpy(destination,buf);		/* an extension, add template */
		strcat(destination,template);
	}	else	{
			strcpy(destination,buf);	/* Otherwise, accept as supplied */
		}
	if(*drive == ':') strcat(destination,drive);	/* if drive, add it */
}

