00100 ; TYPER/ASM -- Program to print characters from keyboard
00110 ; Makes your computer/line printer work like a typewriter.
00120 ; Released to public domain 07/14/84
00130 ;
00140 ; Macros for TRSDOS 6.x Supervisor Calls
00150 ;
00160 @DSP    MACRO                   ; Display a character on screen
00170         LD      A,02            ; Put svc # in A register
00180         RST     28H             ; Call @DSP svc
00190         ENDM
00200 @DSPLY  MACRO                   ; Display a line on screen
00210         LD      A,10            ; Put svc # in A register
00220         RST     28H             ; Call @DSPLY svc
00230         ENDM
00240 @EXIT   MACRO                   ; Exit to TRSDOS
00250         LD      A,22            ; Put svc # in A register
00260         RST     28H             ; Call @EXIT svc
00270         ENDM
00280 @KEY    MACRO                   ; Get a character from keyboard
00290         LD      A,01            ; Put svc # in A register
00300         RST     28H             ; Call @KEY svc
00310         ENDM
00320 @PRT    MACRO                   ; Send character to *PR
00330         LD      A,06            ; Put svc # in A register
00340         RST     28H             ; Call @PRT svc
00350         ENDM
00360 ;
00370         ORG     3000H
00380 ;
00390 START   CALL    CLRSCN          ; Clear screen
00400 ;
00410         LD      HL,INTRO        ; Point to INTRO message
00420         @DSPLY                  ; Display it
00430 ;
00440 INPUT   @KEY                    ; Get character from keyboard
00450 ;
00460         CP      80H             ; Is it the BREAK key?
00470         JP      Z,EXIT          ; Return to DOS if yes
00480 ;
00490         LD      C,A             ; Move input character into C register
00500         @DSP                    ; Display the character
00510         @PRT                    ; Send character to *PR
00520 ;
00530         JP      INPUT           ; Get next character
00540 ;
00550 CLRSCN  LD      C,1CH           ; Move cursor to upper left corner
00560         @DSP                    ; Call @DSP svc
00570         LD      C,1FH           ; Erase to end of display
00580         @DSP                    ; Call @DSP svc
00590         RET                     ; Return
00600 ;
00610 EXIT    @EXIT                   ; Return to TRSDOS
00620 ;
00630 ;
00640 ; Prompt messages
00650 ;
00660 INTRO   DEFM    'TRSDOS 6.x T-Y-P-E-R',0AH
00670         DEFM    'Version 01.00.00',0AH
00680         DEFM    'Press <BREAK> to exit.',0AH,0DH
00690 ;
00700         END     START
