;	WTETRIS --short form of tetris for model 4
;
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
;	SVC used
;
@KBD	EQU	08H
@KEY	EQU	01H
@MUL16	EQU	5BH
@HEXDEC	EQU	61H
@SOUND	EQU	68H
@WINDOW	EQU	7CH
;
CR	EQU	0DH
LF	EQU	0AH
ETX	EQU	03H
;
;	The following is the header protocol
;
	ORG	2700H		;Forces START to 2800H
	DB	'PROWAM'
	DB	'Tetris Game ',3
	DC	.HIGH.$.SHL.8-$+256,0
;
;	This is where the program starts
;
	IFNE	$,2800H
	ERR	'Something is wrong in the header
	ENDIF
;
START:	LD	HL,0<8+24	;start row 0, col 24
	LD	DE,24<8+32	;use 24 rows and 32 cols
	LD	B,7		;function: open window
	SVC	@WINDOW
	JR	Z,START1	;no error, go program
	LD	B,00.SHL.4+02	;else beep & quit
	SVC	@SOUND
	RET
;
;	Initialize first piece to be played.
;
START1:	CALL	LOAD_NEXT
;
;	Get the next block.
;
NEXT:	LD	A,0		;Bring next block number into play.
NEXT_B:	EQU	$-1
	LD	(BLOCK),A
	LD	A,0
NEXT_P:	EQU	$-1		;Bring next block position into play.
	LD	(POSIT),A
	LD	BC,5.SHL.8+1	;set position to 5,1
	LD	(Y_POS),BC	;and set positions
	CALL	CHECK
	JP	NZ,QUIT		;If new piece won't fit, then quit.
;
;	Update Main Score.
;
	LD	HL,$-$		;Number of lines completed. 
SCORE_L: EQU	$-2
	LD	C,20
	SVC	@MUL16
	LD	H,L		;lines * 20 = line score
	LD	L,A		;into HL
;
NXT_LOOP_1:
	LD	DE,$-$
SCORE_P: EQU	$-2
	INC	DE		;Increment piece count score.
	LD	(SCORE_P),DE
	ADD	HL,DE		;Add line score to piece score.
	LD	(SCORE_T),HL	;Total = Lines * 20 + Pieces.
;
;	Random number generated for next piece position.
;
	CALL	LOAD_NEXT	;Set up for next piece
NXT_LOOP_3:
	CALL	DISPLAY		;Display piece
;
;	Check the keyboard for COMMANDS and options.
;
NXT_LOOP_4:
	SVC	@KBD		;SCAN KEY BOARD
	CP	80H		;Break key.
	JP	Z,QUIT
	CP	'4'		;move left
	JR	Z,MOVE_LEFT
	CP	'6'		;move right
	JR	Z,MOVE_RIGHT
	CP	'2'		;drop piece
	JP	Z,DROP_PIECE
	CP	'5'		;rotate piece
	JR	Z,ROTATE_PIECE
	CP	'1'		;pause
	JP	Z,PAUSE
	CP	'7'		;kill piece
	JR	Z,KILL_PIECE
	CP	'3'		;new piece
	JR	NZ,NXT_LOOP_5	;no, continue loop
	LD	DE,(SCORE_P)	;else dec score by one
	DEC	DE
	LD	(SCORE_P),DE
	JR	NEXT		;and do next piece
;
;	Decrement delay counter. Pause, then loop until completed.
;
NXT_LOOP_5:
	LD	DE,04FFH	;start with long delay
DELAY:	EQU	$-2
	DEC	DE
	LD	(DELAY),DE
	LD	A,D
	OR	E
	JR	NZ,NXT_LOOP_4
;
;	Time counter completed, reset timer.
;
	LD	DE,04FFH	;reset delay
TIME_L:	EQU	$-2
	LD	(DELAY),DE
;
;	Counter goes to ZERO.  Drop the current block where it it.
;
MOVE_DOWN:
	LD	BC,$-$
Y_POS:	EQU	$-2
X_POS:	EQU	$-1
	LD	A,C
	INC	A
	CP	21		;bottom row of playing area?
	JR	Z,KILL_PIECE	;yes, kill piece
	LD	C,A
	CALL	CHECK
	JR	NZ,KILL_PIECE
	LD	A,(Y_POS)
	INC	A
	LD	(Y_POS),A
	JR	NXT_LOOP_3
;
KILL_PIECE:
	CALL	KILL		;Kill this piece.
	LD	A,0FFH
	LD	(BLOCK),A
	CALL	LINES		;Check for lines completed.
	JP	NEXT		;Killed it, now get next piece.
;
;	Move the current block one space to the LEFT.
;
MOVE_LEFT:
	LD	BC,(Y_POS)
	DEC	B		;Left = X - 1
	CALL	CHECK		;Check if piece can be moved there.
	JR	NZ,NXT_LOOP_5
	LD	A,(X_POS)
	DEC	A
	LD	(X_POS),A
	JP	NXT_LOOP_3
;
;	Move piece one space to the right.
;
MOVE_RIGHT:
	LD	BC,(Y_POS)
	INC	B
	CALL	CHECK		;Check if piece can be moved there.
	JR	NZ,NXT_LOOP_5
	LD	A,(X_POS)
	INC	A
	LD	(X_POS),A
	JP	NXT_LOOP_3
;
;	Rotate piece.   Cycle through 0-3 to change piece position.
;
ROTATE_PIECE:
	LD	A,00H
POSIT:	EQU	$-1
	INC	A
	AND	03H
	LD	(POSIT),A
	LD	BC,(Y_POS)
	CALL	CHECK
	JP	Z,NXT_LOOP_3
	LD	A,(POSIT)
	DEC	A
	AND	03H
	LD	(POSIT),A
	JP	NXT_LOOP_5
;
;	Pause game.
;
PAUSE:	LD	HL,23<8+0	;row 23, col 0
	LD	B,3		;func: set cursor
	SVC	@WINDOW
	LD	HL,PAUSE_TEXT
	LD	B,10		;func: display string
	SVC	@WINDOW
	SVC	@KEY		;wait for key
	LD	DE,(TIME_L)	;Reset timer
	LD	(DELAY),DE
	JP	NXT_LOOP_5
;
;	Drop piece in the current ROW.
;
DROP_PIECE:
	LD	BC,(Y_POS)
DROP_LOOP_1:
	INC	C
	CALL	CHECK
	JR	Z,DROP_LOOP_1
	DEC	C
	LD	A,C
	LD	(Y_POS),A
	CALL	KILL
	LD	A,0FFH
	LD	(BLOCK),A
	CALL	LINES
	JP	NEXT
;
;	Kill the current block and mark the GRID table as taken.
;
;	On entry,
;	Memory (X_POS) = The current blocks X location.
;	Memory (Y_POS) = The current blocks Y location.
;	Memory (BLOCK) = The current BLOCK to be positioned.
;	Memory (POSIT) = The current block allignment to be used.
;
;	Get future location of block in GRID into HL.
;
KILL:	LD	A,(Y_POS)
	LD	B,A
	CALL	DOWN_GRID
;
;	Count across on GRID by X_POS positions.
;
	LD	A,(X_POS)
	LD	E,A		;X Position.
	LD	D,0
	ADD	HL,DE
	PUSH	HL
;
;	Go get pointer to SHAPE table entry.
;
	LD	A,00H		;Get table entry number.
BLOCK:	EQU	$-1
	CALL	DWN_SHAPE
KILL_LOOP_3:
	LD	A,(POSIT)	;Get shape table position number.
	AND	03H		;Mask entry from 0-3
	LD	E,A
	LD	D,0
	ADD	HL,DE		;Add position number to table address
	ADD	HL,DE		;this is a word so do it twice.
;
;	Convert pointer to actual shape block graphic.
;
	LD	E,(HL)		;Get actual address from table.
	INC	HL
	LD	D,(HL)		;DE = SHAPE table graphic block
	POP	HL		;HL = GRID location of block
;
	LD	BC,0505H	;5 x 5 shape table size.
;
;	compare shape table with grid data.
;
KILL_LOOP_4:
	LD	A,(DE)		;Kill if SHAPE position is empty.
	RLA			;Move to first bit and test
	RLA
	RLA
KL_LP_4:
	RLA
	JR	NC,KILL_LOOP_5	;Not set, skip
;
	LD	(HL),'X'	;Kill if GRID position is NOT empty.
;
KILL_LOOP_5:
	INC	HL
	DJNZ	KL_LP_4
;
	PUSH	DE		;Start HL at beginning of next grid line.
	LD	DE,11
	ADD	HL,DE
	POP	DE
;
	LD	B,5
	INC	DE		;BUMP TO NEXT BYTE
	DEC	C		;DEC COUNT
	JR	NZ,KILL_LOOP_4
;
;	Passed Kill. The piece may be placed where it has been checked.
;
	RET
;
;	Check if the requested block can fit in the proposed location.
;
;	On entry,
;	Regester Pair BC = The proposed X,Y location. (B=X,C=Y)
;	Memory (BLOCK) = The current BLOCK to be positioned.
;	Memory (POSIT) = The current block allignment to be used.
;
;	On Exit,
;	Regester A = 0 if shape will fit in proposed location.
;	         A = FF if shape will not fit in proposed loctaion.
;	Flag C = 0 if shape will fit in proposed location.
;	     C = 1 if shape will not fit in proposed location.
;	Flag Z = 0 if shape will fit in proposed location.
;	     Z = 1 if shape will not fit in proposed location.
;
;	Get future location of block in GRID into HL.
;
CHECK:	PUSH	BC		;Save position
	LD	B,C		;Move Y to B
	CALL	DOWN_GRID
;
;	Count across on GRID by X_POS positions.
;
	POP	BC		;p/u position
	PUSH	BC		;save position again
	LD	E,B		;X position.
	LD	D,0		;DE==X POS
	ADD	HL,DE		;Offset into grid
;
	PUSH	HL		;Save grid offset
;
;	Go get pointer to SHAPE table entry.
;
	LD	A,(BLOCK)	;Get table entry number.
	CALL	DWN_SHAPE
;
CHECK_LOOP_3:
	LD	A,(POSIT)	;Get shape table position number.
	AND	03H		;Mask entry from 0-3
	LD	E,A
	LD	D,0
	ADD	HL,DE		;Add position number to table address
	ADD	HL,DE		;this is a word so do it twice.
;
;	Convert pointer to actual shape block graphic.
;
	LD	E,(HL)		;Get actual address from table.
	INC	HL
	LD	D,(HL)		;DE = SHAPE table graphic block
	POP	HL		;HL = GRID location of block
	LD	BC,0505H	;5 x 5 shape table size.
;
;	compare shape table with grid data.
;
CHECK_LOOP_4:
	LD	A,(DE)		;Check if SHAPE position is empty.
	RLA			;Rotate to start of data
	RLA
	RLA
CK_LP_4	RLA
	JR	NC,CHECK_LOOP_5	;Is empty, loop
	PUSH	BC		;Save reg
	LD	C,A		;Save count
	LD	A,(HL)		;Check if GRID position is empty.
	CP	'.'
	LD	A,C		;Move count to A again
	POP	BC		;Restore reg
	JR	NZ,CHECK_LOOP_6	;If shape is full and grid not.
CHECK_LOOP_5:
	INC	HL
	DJNZ	CK_LP_4
	PUSH	DE		;Advance grid pointer to beginning next line.
	LD	DE,11
	ADD	HL,DE
	POP	DE
	LD	B,5
	INC	DE		;Point to next table byte
	DEC	C		;Reduce count
	JR	NZ,CHECK_LOOP_4	;Loop till all 5 bytes checked
;
;	Z==Passed Check. The piece may be placed where it has been checked.
;	NZ==Failed check. The piece cannot be placed where it has been checked.
;
CHECK_LOOP_6:
	POP	BC
	RET
;
;	Display map.
;	Clear the video buffer area.
;
DISPLAY:
	LD	HL,WID_BUF	;The WID_BUF area is 768 bytes
	LD	DE,WID_BUF+1	;in size, this routine will set
	LD	BC,767		;all 768 bytes to <SPACE> character.
	LD	A,' '		;BC = 768 - 1 since the first byte
	LD	(HL),A		;is already set.  Once set up.....
	LDIR			;<== This commands does it all.
;
;	Build the grid in the video buffer area.
;
	LD	DE,WID_BUF
	LD	HL,GRID
	LD	C,00H
;
DISPLAY_LOOP_0:
	LD	B,10H
;
DISPLAY_LOOP_1:
	LD	A,(HL)
	CP	' '
	JR	Z,DSP_LP_2A
	CP	'+'
	JR	Z,DISPLAY_BLOCK
	CP	'-'
	JR	Z,DISPLAY_BLOCK_2
	CP	'|'
	JR	Z,DISPLAY_BLOCK_1
	CP	'X'
	JR	Z,DISPLAY_BLOCK
	CP	'Y'
	JR	Z,DISPLAY_BLOCK_1
	CP	'Z'
	JR	Z,DISPLAY_BLOCK_2
	CP	'.'
	JR	Z,DISPLAY_SPACE
;
;	Type of display not found, insert question marks.
;
	LD	A,'+'
DSP_LP_2A:
	LD	(DE),A
DSP_LP_2:
	INC	DE
	LD	(DE),A
	INC	DE
	INC	HL
;
;	Completed creation of a character.
;
	DJNZ	DISPLAY_LOOP_1
	JR	DISPLAY_LOOP_2A
;
;	Filled in block character.
;
DISPLAY_BLOCK:
*LIST	OFF
	LD	A,''
	LD	(DE),A
	LD	A,''
	JR	DSP_LP_2
;
DISPLAY_BLOCK_1:
	LD	A,''
	LD	(DE),A
	LD	A,''
	JR	DSP_LP_2
;
DISPLAY_BLOCK_2:
	LD	A,''
	JR	DSP_LP_2A
*LIST ON
;
DISPLAY_SPACE:
	LD	A,' '
	JR	DSP_LP_2A
;
;	Increment row counter.
;
DISPLAY_LOOP_2A:
	INC	C
	LD	B,C
	LD	HL,WID_BUF
	LD	DE,32		;Add offset for start of next row.
;
DISPLAY_LOOP_3:
	ADD	HL,DE
	DJNZ	DISPLAY_LOOP_3
	PUSH	HL		;Save destination in WID_BUF.
;
;	Compute next row on GRID pointer.
;
	LD	B,C
	CALL	DOWN_GRID
	POP	DE		;P/U WID_BUF ptr
;
;	Check if last row is processed.
;
	LD	A,C
	CP	22
	JP	C,DISPLAY_LOOP_0
;
;	Load in Score into screen.
;
	LD	HL,$-$
SCORE_T: EQU	$-2
	LD	DE,TEXT_1+8
	SVC	@HEXDEC
	LD	HL,TEXT_1
	LD	DE,WID_BUF+704
	LD	BC,15
	LDIR
;
;	Load in LINE's completed score onto screen.
;
	LD	HL,(SCORE_L)
	LD	DE,TEXT_3+8
	SVC	@HEXDEC
	LD	HL,TEXT_3
	LD	DE,WID_BUF+736
	LD	BC,15
	LDIR
;
;	Get the play piece number.
;
DISPLAY_LOOP_9:
	LD	A,(BLOCK)
	CP	0FFH
	JR	Z,DISPLAY_LOOP_17
	CALL	DWN_SHAPE
;
;	Now compute the position number.
;
DISPLAY_LOOP_11:
	LD	A,(POSIT)
	AND	03H
	LD	E,A
	LD	D,00H
	ADD	HL,DE
	ADD	HL,DE
;
;	Now load the graphic address into DE.
;
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	PUSH	DE
;
;	Load the WID_BUF destination address in Reg Pair HL.
;
	LD	HL,WID_BUF
	LD	DE,32
	LD	A,(Y_POS)
	LD	B,A
;
DISPLAY_LOOP_12:
	ADD	HL,DE		;Count number of lines down to buffer.
	DJNZ	DISPLAY_LOOP_12
	LD	A,(X_POS)
	LD	E,A
	LD	D,0
	ADD	HL,DE		;Count over to start of BLOCK position
	ADD	HL,DE
;
;	Move BLOCK in play into grid field in WID_BUF.
;
	POP	DE		;Restore pointer to BLOCK graphic.
	LD	BC,0505H	;10 characters per line @ 5 lines.
DISPLAY_LOOP_13:
	LD	A,(DE)
	RLA
	RLA
	RLA
DSP_LP_13:
	RLA
	JR	NC,DISPLAY_LOOP_14 ;Check for spacing char in graphic
	LD	(HL),''
	INC	HL
	LD	(HL),''
	DEC	HL
DISPLAY_LOOP_14:
	INC	HL
	INC	HL
	DJNZ	DSP_LP_13
;
	PUSH	DE	;Save DE while we use it to update HL.
	LD	DE,22	;Increment WID_BUF pointer to next line.
	ADD	HL,DE	;HL points to beginning of next line.
	POP	DE	;Restore DE to original point in graphic.
;
	LD	B,05H	;Re-Initialize to 10 charactres/line
	INC	DE
	DEC	C
	JR	NZ,DISPLAY_LOOP_13
DISPLAY_LOOP_17:
	LD	HL,WID_BUF
	LD	B,5		;func: buffer to window
	SVC	@WINDOW
	RET
;
;	Line completed.  Update Line count and special line effects.
;
LINES:	LD	A,03H		;Start checking at line # 1.
	LD	(CHECKING_LINE),A
;
LINES_LOOP_1:
	LD	A,3
CHECKING_LINE:	EQU	$-1
	LD	B,A
	CALL	DOWN_GRID
	LD	(LINE_POINTER),HL
	LD	DE,0003H
	ADD	HL,DE		;HL = Pointer to start of grid line #
	LD	B,10		;LEN OF LINE
LINES_LOOP_3:
	LD	A,(HL)
	CP	'X'
	JR	NZ,LINES_LOOP_8	;Trap out if entire line not filled.
	INC	HL
	DJNZ	LINES_LOOP_3
	LD	A,'Y'
	CALL	LD_GRID_TBL
	LD	A,'Z'
	CALL	LD_GRID_TBL
;
LINES_LOOP_6:
	CALL	LD_GRID_TBL
;
;	Increment Line Score Counter.
;
	LD	HL,(SCORE_L)
	INC	HL
	LD	(SCORE_L),HL
;
;	Move all pieces above compleated line down by one.
;
	LD	A,(CHECKING_LINE)
	DEC	A
	LD	B,A
	LD	C,00H
	LD	HL,0000H
	LD	DE,0010H
LINES_LOOP_7:
	ADD	HL,DE
	DJNZ	LINES_LOOP_7
	PUSH	HL
	POP	BC
	LD	HL,0010H
	LD	DE,(LINE_POINTER)
	ADD	HL,DE
	EX	DE,HL		;DE=Line_Pointer+16
	LD	HL,(LINE_POINTER)
	LDDR
	CALL	DISPLAY
;
;	Check each line until limit is reached, otherwise increment line check.
;
LINES_LOOP_8:
	LD	A,(CHECKING_LINE)
	INC	A
	LD	(CHECKING_LINE),A
	CP	21
	JP	NZ,LINES_LOOP_1
;
;	Check to see if time delay needs to be changed.
;
	LD	HL,04FFH
	LD	DE,(SCORE_L)
	SLA	E		;DE = DE * 8
	RL	D
	SLA	E
	RL	D
	SLA	E
	RL	D
	XOR	A		;Clear carry bit.
	SBC	HL,DE		;HL = 1279 - LINES_Completed * 8
	RET	C		;GO IF NEGATIVE RESULTS
LINES_LOOP_9:
	LD	(TIME_L),HL	;Set time limit based on lines filled.
	RET
;
RANDOM3:
	LD	A,R
	PUSH	HL
	LD	HL,002DH
	XOR	(HL)
	POP	HL
	AND	03H
	RET
;
RANDOM6:
	LD	A,R
	PUSH	HL
	LD	HL,002CH
	XOR	(HL)
	POP	HL
	AND	07H
	CP	07H
	JR	Z,RANDOM6
	RET
;
;	LD_GRID_TBL -- Load char in a for 10 count in (HL) the grid table
LD_GRID_TBL:
	LD	HL,GRID
LINE_POINTER:	EQU	$-2
	INC	HL
	INC	HL
	INC	HL
	LD	B,10
LGT1:	LD	(HL),A
	INC	HL
	DJNZ	LGT1
	CALL	DISPLAY
	RET
;
;Space down shape table entry
;	A & B = COUNT
;	Return HL==>shape table entry
DWN_SHAPE:
	LD	HL,PIECE
DWN_SHAPE1:
	AND	0FH		;Mask A to 0-F
	LD	B,A		;Move count to B
	CP	00H
	RET	Z		;Back if already there
	LD	DE,8
DSLP1:	ADD	HL,DE
	DJNZ	DSLP1		;Loop through shape table until found.
	RET
;
;	space down grid
;	entry=num of lines in B
;	return HL==>grid location
DOWN_GRID:
	LD	DE,0010H
	LD	HL,GRID
DG_LP1:	ADD	HL,DE
	DJNZ	DG_LP1
	RET
;
QUIT:	LD	HL,10<8+10	;row 10, col 10
	LD	B,3		;funct: set cursor pos
	SVC	@WINDOW
	LD	HL,END_TXT
	LD	B,10		;func: display line
	SVC	@WINDOW
QUIT1:	SVC	@KEY		;WAIT FOR ENTER
	CP	CR
	JR	NZ,QUIT1
	LD	C,0		;NO EXPORT, ETC.
	LD	B,8		;func: close window
	SVC	@WINDOW
	RET			;quit program
;
LOAD_NEXT:			;LOAD RANDOM PIECE GENERATOR
	CALL	RANDOM6		;Use system heartbeat counter.
	LD	(NEXT_B),A
	CALL	RANDOM3
	LD	(NEXT_P),A
	RET
;
;	The shapes.
;
T_0_A	DEFB	00000100B	;'--x--'
	DEFB	00001110B	;'-xxx-'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_0_B	DEFB	00000100B	;'--x--'
	DEFB	00001100B	;'-xx--'
	DEFB	00000100B	;'--x--'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_0_C	DEFB	00000000B	;'-----'
	DEFB	00001110B	;'-xxx-'
	DEFB	00000100B	;'--x--'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_0_D	DEFB	00000100B	;'--x--'
	DEFB	00000110B	;'--xx-'
	DEFB	00000100B	;'--x--'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_1_A	DEFB	00001100B	;'-xx--'
	DEFB	00000110B	;'--xx-'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_1_B	DEFB	00000010B	;'---x-'
	DEFB	00000110B	;'--xx-'
	DEFB	00000100B	;'--x--'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_2_A	DEFB	00000110B	;'--xx-'
	DEFB	00001100B	;'-xx--'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_2_B	DEFB	00001000B	;'-x---'
	DEFB	00001100B	;'-xx--'
	DEFB	00000100B	;'--x--'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_3_A	DEFB	00000100B	;'--x--'
	DEFB	00000100B	;'--x--'
	DEFB	00000100B	;'--x--'
	DEFB	00000100B	;'--x--'
	DEFB	00000100B	;'--x--'
;
T_3_B	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
	DEFB	00011111B	;'xxxxx'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_4_A	DEFB	00000100B	;'--x--'
	DEFB	00000100B	;'--x--'
	DEFB	00000110B	;'--xx-'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_4_B	DEFB	00000010B	;'---x-'
	DEFB	00001110B	;'-xxx-'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_4_C	DEFB	00001100B	;'-xx--'
	DEFB	00000100B	;'--x--'
	DEFB	00000100B	;'--x--'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_4_D	DEFB	00000000B	;'-----'
	DEFB	00001110B	;'-xxx-'
	DEFB	00001000B	;'-x---'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_5_A	DEFB	00000100B	;'--x--'
	DEFB	00000100B	;'--x--'
	DEFB	00001100B	;'-xx--'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_5_B	DEFB	00000000B	;'-----'
	DEFB	00001110B	;'-xxx-'
	DEFB	00000010B	;'---x-'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_5_C	DEFB	00000110B	;'--xx-'
	DEFB	00000100B	;'--x--'
	DEFB	00000100B	;'--x--'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_5_D	DEFB	00001000B	;'-x---'
	DEFB	00001110B	;'-xxx-'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
T_6_A	DEFB	00000110B	;'--xx-'
	DEFB	00000110B	;'--xx-'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
	DEFB	00000000B	;'-----'
;
PIECE:
	DEFW	T_0_A,T_0_B,T_0_C,T_0_D	;T SHAPE
	DEFW	T_1_A,T_1_B,T_1_A,T_1_B	;LEFT Z
	DEFW	T_2_A,T_2_B,T_2_A,T_2_B	;RIGHT Z
	DEFW	T_3_A,T_3_B,T_3_A,T_3_B	;LONG BAR
	DEFW	T_4_A,T_4_B,T_4_C,T_4_D	;RIGHT L
	DEFW	T_5_A,T_5_B,T_5_C,T_5_D	;LEFT L
	DEFW	T_6_A,T_6_A,T_6_A,T_6_A	;MEDIUM SQUARE
;
WID_BUF:	EQU 	2400H	;Video Ram screen generation buffer.
;
;		 0123456789012345
	DEFB	'                '
	DEFB	'                '
	DEFB	'                '
GRID:	DEFB	'  +----------+  '	;Top
GRID_T:	DEFB	'  |..........|  '	;Row  1
	DEFB	'  |..........|  '	;Row  2
	DEFB	'  |..........|  '	;Row  3
	DEFB	'  |..........|  '	;Row  4
	DEFB	'  |..........|  '	;Row  5
	DEFB	'  |..........|  '	;Row  6
	DEFB	'  |..........|  '	;Row  7
	DEFB	'  |..........|  '	;Row  8
	DEFB	'  |..........|  '	;Row  9
	DEFB	'  |..........|  '	;Row 10
	DEFB	'  |..........|  '	;Row 11
	DEFB	'  |..........|  '	;Row 12
	DEFB	'  |..........|  '	;Row 13
	DEFB	'  |..........|  '	;Row 14
	DEFB	'  |..........|  '	;Row 15
	DEFB	'  |..........|  '	;Row 16
	DEFB	'  |..........|  '	;Row 17
	DEFB	'  |..........|  '	;Row 18
	DEFB	'  |..........|  '	;Row 19
	DEFB	'  |..........|  '	;Row 20
	DEFB	'  +----------+  '	;Bottom.
	DEFB	'                '
	DEFB	'                '
	DEFB	'                '
	DEFB	'                '	;Overlap area for templates.
;		    1234567890
;
;	Text and ASCII number storage for display.
;
TEXT_1:	DEFB	'Score:  xxxxx  '
TEXT_3:	DEFB	'Lines:  xxxxx  '
END_TXT:	DB	' Game Over ',ETX
PAUSE_TEXT:	DB	'Game Paused    ',ETX
;
;	Standard memory overflow check
;
	IF	$.GT.3000H	;Check on memory overflow
	ERR	'Memory overflow!!!'
	ENDIF
;
;	Zero last sector of application file - patch space
;
	IFLT	$,3000H
	DC	.HIGH.$.SHL.8-$+256,0	;Zero remainder of sector
	ENDIF
;
	END	START		;START must be 2800H
