	ORG	3000H
START	CALL	FRONT		;display name & copyright
START1	LD	HL,0500H	;line 5, column 0
	CALL	LOCATE
	LD	HL,ASKDRV
	CALL	DSPLY		;display drv message
	LD	B,1		;allow 1 chr
	CALL	KEYIN		;get keystroke
	CALL	NOCUR		;turn off cursor
	JP	C,EXIT		;jump on break
	CALL	DECHEX		;convert input to hex
	LD	A,C		;copy input in bc to a
	ADD	A,30H		;make it ascii
	CP	30H		;allow only 0 to 7
	JR	C,START1
	CP	38H
	JR	NC,START1
	CALL	CKDRV		;is drive available
	JR	Z,GOTDRV	;jump if available
;
	LD	HL,0700H	;line 7, column 0
	CALL	LOCATE
	LD	HL,NODRV	;display nodrv message
	CALL	DSPLY
NODRV1	CALL	KEY		;wait for keystroke
	CALL	NOCUR		;turn off cursor
	CP	13		;allow only enter
	JR	NZ,NODRV1
	JR	START		;enter - so back to start
NODRV	DB	'Drive is not available  -  press Enter ',14,3
;
GOTDRV	LD	(DRVNUM),A	;store drive number
	XOR	A		;a = 0
	LD	(CYLNUM),A	;store cylinder number
	LD	(SECNUM),A	;store sector number
	CALL	RDSEC		;read cyl 0, sec 0
	LD	HL,SECBUF+2	;point to directory byte
	LD	A,(HL)		;and copy it to a
	LD	(DIRTRK),A	;and to dirtrk buffer
GETCYL	LD	HL,0700H	;line 7, column 0
	CALL	LOCATE
	LD	HL,ASKCYL	;display askcyl message
	CALL	DSPLY
	LD	B,3		;allow 3 keystrokes
	CALL	KEYIN		;get user input
	CALL	NOCUR		;turn off cursor
	JP	C,START		;jump on break
	CALL	DECHEX		;convert input to hex
	LD	A,C		;copy to a
	LD	(CYLNUM),A	;and store it it cylnum
GETSEC	LD	HL,0900H	;line 9, column 0
	CALL	LOCATE
	LD	HL,ASKSEC	;display asksec message
	CALL	DSPLY
	LD	B,3		;allow 3 keystrokes
	CALL	KEYIN		;get uset input
	CALL	NOCUR		;turn off cursor
	JR	C,GETCYL	;jump on break
	CALL	DECHEX		;convert input to hex
	LD	A,C		;copy input to a
	LD	(SECNUM),A	;and to secnum
;
MAIN	CALL	BUFCLS		;erase buffer
	CALL	GTDCT
	LD	A,(DIRTRK)	;get dir track
	LD	B,A		;copy to b
	LD	A,(CYLNUM)	;get selected track
	CP	B		;
	JR	Z,DIRRD		;jump if dir track
	CALL	RDSEC		;read normal sector
	JR	GOHEX		;jump over system sector
DIRRD	CALL	RDSSC		;read system sector
GOHEX	CALL	HEXOUT		;convert info to hex & ascii
	CALL	SHOWIT		;send info to screen
MENU	CALL	ERA20		;erase from line 20 to end of screen
	CALL	KEY		;wait for key stroke
	CP	80H		;is it break
	JP	Z,START
	CP	8		;is it left arrow
	JR	NZ,RARROW	;no - go check for right arrow
	LD	A,(SECNUM)	;yes - so get sector number
	OR	A		;is it sector 0
	JR	Z,WRAPD		;yes - jump
	DEC	A		;no - so decrement sector number
	JR	SECDWN		;and jump over wrap around routine
WRAPD	CALL	FNDSEC		;go determine sector to wrap around to
SECDWN	LD	(SECNUM),A	;store new sector number in buffer
	JR	MAIN		;and display it
;
RARROW	CP	9		;is it right arrow
	JR	NZ,UARROW	;no - so go test for up arrow
	CALL	FNDSEC		;yes - so go determine sector to wrap to
	LD	B,A		;store highest sector in b
	LD	A,(SECNUM)	;get current sector number
	CP	B		;are they equal
	JR	Z,WRAPU		;yes - so jump to wrap around routine
	INC	A		;no - so increment sector number
	JR	SECUP		;and jump over wrap around routine
WRAPU	XOR	A		;sector number now 0
SECUP	LD	(SECNUM),A	;store new sector number in buffer
	JR	MAIN		;and go display it
;
UARROW	CP	11		;is it up arrow
	JR	NZ,DARROW	;no - test for down arrow
	CALL	FNDCYL		;go find highest cyl number
	LD	B,A		;store it in b
	LD	A,(CYLNUM)	;get current cyl number
	CP	B		;are we at top
	JR	NZ,CYLUP	;no - so jump
	XOR	A		;yes - reset cylinder to 0
	JR	CYLUP1
CYLUP	INC	A		;next higher cylinder number
CYLUP1	LD	(CYLNUM),A	;store it in buffer
	JR	MAIN		;go back and display new cyl
;
DARROW	CP	10		;is it down arrow
	JR	NZ,MOD		;no - go test for M key
	LD	A,(CYLNUM)	;get current cyl number
	OR	A		;is it cyl 0
	JR	NZ,CYLDN	;no - so jump
	CALL	FNDCYL		;go find highest cyl number
	JR	CYLDN1
CYLDN	DEC	A		;previous cyl number
CYLDN1	LD	(CYLNUM),A	;store new cyl number in buffer
	JP	MAIN
MOD	CP	77		;is it M
	JR	Z,MOD1		;yes - jump
	CP	109		;is it m
	JR	Z,MOD1		;yes - jump
	JR	MENU		;jump back - for now - maybe -----
;
MOD1	CALL	MODFY1		;display modify menu
MOD2	CALL	KEY		;get key stroke
	CP	80H		;is it break
	JP	Z,MENU
	CP	72		;is it H
	JR	Z,MODH
	CP	104		;is it h
	JR	Z,MODH
	CP	65		;is it A
	JP	Z,MODA
	CP	97		;is it a
	JP	Z,MODA
	CP	87		;is it W
	JP	Z,MODW
	CP	119		;is it w
	JP	Z,MODW
	JR	MOD2
;
MODH	CALL	ERA20
	LD	HL,0205H
	LD	A,H
	LD	(HXVPOS),A
	LD	A,L
	LD	(HXHPOS),A
	LD	A,1
	LD	(CURPOS),A
	LD	DE,SCREEN
MODH1	LD	A,(HXVPOS)
	LD	H,A
	LD	A,(HXHPOS)
	LD	L,A
	CALL	LOCATE
	LD	A,191
	CALL	CURCHR		;set cursor chr
	CALL	CURSOR
	CALL	KEY
	PUSH	AF
	LD	A,95		;normal cursor chr
	CALL	CURCHR
	POP	AF
	CP	80H		;is it break
	JR	Z,MOD1		;yes - back to modify menu
	CP	8
	JR	NZ,RARW
;
	LD	A,(HXHPOS)
	CP	5
	JR	Z,MODH2
	CP	6
	JR	NZ,MODH3
MODH2	LD	A,50
	LD	(HXHPOS),A
	LD	A,1
	LD	(CURPOS),A
	CALL	INCDE
	JR	MODH1
MODH3	LD	B,A
	LD	A,(CURPOS)
	CP	1
	LD	A,1
	LD	(CURPOS),A
	LD	A,B
	JR	NZ,BACK1
	DEC	A
	JR	BACK2
BACK1	DEC	A
	DEC	A
BACK2	DEC	A
	DEC	A
	LD	(HXHPOS),A
	DEC	DE
	JP	MODH1
;
RARW	CP	9		;is it right arrow
	JR	NZ,UARW
	LD	A,(HXHPOS)
	CP	51
	JR	NZ,RARW0
	LD	A,5
	LD	(HXHPOS),A
	LD	A,1
	LD	(CURPOS),A
	CALL	DECDE
	JR	MODH1
RARW0	LD	B,A
	LD	A,(CURPOS)
	CP	1
	JR	Z,FWD1
	LD	A,1
	LD	(CURPOS),A
	LD	A,B
	INC	A
	INC	A
	JR	RARW1
FWD1	INC	A
	LD	(CURPOS),A
	LD	A,B
	INC	A
RARW1	LD	(HXHPOS),A
	INC	DE
	JP	MODH1
;
UARW	CP	11		;is it up arrow
	JR	NZ,DARW
	LD	A,(HXVPOS)
	CP	2
	JR	NZ,UARW1
	CALL	INC16
	LD	A,17
UARW0	LD	(HXVPOS),A
	JP	MODH1
UARW1	DEC	A
	PUSH	HL
	EX	DE,HL
	LD	DE,16
	SBC	HL,DE
	EX	DE,HL
	POP	HL
	JR	UARW0
;
DARW	CP	10		;is it down arrow
	JR	NZ,CHRS
	LD	A,(HXVPOS)
	CP	17
	JR	NZ,DARW1
	CALL	DEC16
	LD	A,2
DARW0	LD	(HXVPOS),A
	JP	MODH1
DARW1	INC	A
	PUSH	HL
	EX	DE,HL
	LD	DE,16
	ADD	HL,DE
	EX	DE,HL
	POP	HL
	JR	DARW0
;
CHRS
;
MODA
;
MODW	LD	A,(IY+9)	;get dir track
	LD	B,A
	LD	A,(CYLNUM)	;get current track
	CP	B		;is it dir track
	JR	NZ,MODW1
	CALL	WRSSC
	JP	MOD2
MODW1	CALL	WRSEC
	JP	MOD2
;
	JP	MENU
;
EXIT	CALL	CLS
	CALL	CURSOR
	RET
;
ASKDRV	DB	'   Enter drive #: ',14,3
ASKCYL	DB	'Enter cylinder #: ',31,14,3
ASKSEC	DB	'  Enter sector #: ',31,14,3
;
;
;subroutines
;
BUFCLS	LD	HL,SCREEN
	LD	DE,SCREEN+1
	LD	BC,1919
	LD	(HL),32
	LDIR
	RET
;
CKDRV	LD	C,A
	LD	A,33
	RST	40
	LD	A,C
	RET
;
CLS	LD	A,105
	RST	40
	RET
;
CURCHR	LD	(0B98H),A
	RET
;
DECHEX	LD	A,96
	RST	40
	RET
;
DSP	PUSH	DE
	PUSH	BC
	LD	C,A
	LD	A,2
	RST	40
	POP	BC
	POP	DE
	RET
;
ERA20	LD	HL,1400H
	CALL	LOCATE
	LD	A,31
	JR	DSP
;
FNDCYL	LD	A,(IY+6)	;get max cyl count
	BIT	3,(IY+3)	;is it a hard drive
	RET	Z
	BIT	5,(IY+4)
	RET	Z
	ADD	A,A
	INC	A
REGCYL	RET
;
FNDSEC	LD	A,(IY+7)
	AND	31		;strip bits 5,6,7
	BIT	5,(IY+4)
	RET	Z
	ADD	A,A
	INC	A
	RET
;
DSPLY	PUSH	DE
	LD	A,10
	RST	40
	POP	DE
	RET
;
FRONT	CALL	NOCUR
	CALL	CLS
	LD	HL,FRTMSG
	CALL	DSPLY
	RET
;
FRTMSG	DB	'T R S Z A P 4'
	DB	'   copyright 1993 by Lance Wolstrup',13
;
GETASC	PUSH	BC
	PUSH	HL
	LD	HL,(BUFADR)
	LD	B,16
ASC1	LD	A,(HL)
	CP	32
	JR	C,DOT
	CP	192
	JR	NC,DOT
ASC2	LD	(DE),A
	INC	DE
	INC	HL
	DJNZ	ASC1
	LD	(BUFADR),HL
	POP	HL
	POP	BC
	RET
DOT	LD	A,46
	JR	ASC2
;
GTDCT	PUSH	BC
	LD	A,(DRVNUM)
	LD	C,A
	LD	A,81
	RST	40
	POP	BC
	RET
;
HEXDEC	PUSH	DE
	LD	DE,H2DBUF
	LD	A,97
	RST	40
	LD	HL,H2DBUF
	POP	DE
	RET
;
HEXOUT	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	DE,SCREEN+5
	LD	HL,HNUM
	LD	B,16
HEXH	PUSH	HL
	LD	A,(HL)
	CALL	HEX8
	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	DE
	LD	A,(HL)
	LD	(DE),A
	POP	HL
	INC	HL
	INC	DE
	INC	DE
	DJNZ	HEXH
	LD	HL,SCREEN+83
	LD	(HL),156
	INC	HL
	LD	DE,SCREEN+85
	LD	BC,47
	LD	(HL),140
	LDIR
	LD	DE,SCREEN+160
	LD	HL,VNUM
	LD	B,16
HEXV	PUSH	HL
	PUSH	DE
	LD	A,(HL)
	CALL	HEX8
	LD	A,(HL)
	LD	(DE),A
	INC	HL
	INC	DE
	LD	A,(HL)
	LD	(DE),A
	INC	DE
	INC	DE
	LD	A,149
	LD	(DE),A
	POP	DE
	EX	DE,HL
	LD	DE,80
	ADD	HL,DE
	EX	DE,HL
	POP	HL
	INC	HL
	DJNZ	HEXV
	LD	HL,SECBUF	;point to sector info
	LD	(BUFADR),HL
	LD	DE,SCREEN+165	;point to screen buffer
	LD	B,16		;counter vertical lines
HEX1	PUSH	BC		;save vertical
	PUSH	DE		;save screen pointer
	LD	B,16		;counter horizontal
HEX2	LD	A,(HL)		;get hex value
	PUSH	HL		;save pointer in sector buffer
	CALL	HEX8		;convert chr to hex
	LD	A,(HL)		;get first hex digit
	LD	(DE),A		;store it in screen buffer
	INC	DE		;next screen buffer position
	INC	HL		;point to next hex digit
	LD	A,(HL)		;get second hex digit
	LD	(DE),A		;store it in screen buffer
	INC	DE		;bump screen buffer position
	INC	DE		;bump again
	POP	HL		;restore pointer to sector buffer
	INC	HL		;bump sector buffer position
	DJNZ	HEX2		;loop 16 times
;
	INC	DE
	CALL	GETASC
	POP	DE
	PUSH	HL
	EX	DE,HL
	LD	DE,80
	ADD	HL,DE
	EX	DE,HL
	POP	HL
	POP	BC
	DJNZ	HEX1
	LD	DE,SCREEN+73
	LD	HL,DRVMSG
	LD	B,4
DLOOP1	LD	A,(HL)
	LD	(DE),A
	INC	DE
	INC	HL
	DJNZ	DLOOP1
	LD	A,(DRVNUM)
	LD	(DE),A
	LD	DE,SCREEN+153
	INC	HL
	LD	B,4
DLOOP2	LD	A,(HL)
	LD	(DE),A
	INC	DE
	INC	HL
	DJNZ	DLOOP2
	LD	A,(CYLNUM)
	LD	L,A
	LD	H,0
	CALL	HEXDEC
	LD	B,5
DLOOP3	LD	A,(HL)
	CP	32
	JR	Z,NXTCHR
	LD	(DE),A
	INC	DE
NXTCHR	INC	HL
	DJNZ	DLOOP3
	LD	DE,SCREEN+233
	LD	HL,SECMSG
	LD	B,4
DLOOP4	LD	A,(HL)
	LD	(DE),A
	INC	DE
	INC	HL
	DJNZ	DLOOP4
	LD	A,(SECNUM)
	LD	L,A
	LD	H,0
	CALL	HEXDEC
	LD	B,5
DLOOP5	LD	A,(HL)
	CP	32
	JR	Z,NXTCH2
	LD	(DE),A
	INC	DE
NXTCH2	INC	HL
	DJNZ	DLOOP5
	POP	HL
	POP	DE
	POP	BC
	RET
;
DRVMSG	DB	'drv ',3
CYLMSG	DB	'cyl ',3
SECMSG	DB	'sec ',3
;
HEX8	LD	C,A
	LD	HL,HEXBUF
	LD	A,98
	RST	40
	LD	HL,HEXBUF
	RET
;
INCDE	PUSH	BC
	LD	B,15
INCDE1	INC	DE
	DJNZ	INCDE1
	POP	BC
	RET
;
DECDE	PUSH	BC
	LD	B,15
DECDE1	DEC	DE
	DJNZ	DECDE1
	POP	BC
	RET
;
INC16	PUSH	BC
	PUSH	HL
	LD	B,15
	EX	DE,HL
	LD	DE,16
INC16A	ADD	HL,DE
	DJNZ	INC16A
	EX	DE,HL
	POP	HL
	POP	BC
	RET
;
DEC16	PUSH	BC
	PUSH	HL
	LD	B,15
	EX	DE,HL
	LD	DE,16
DEC16A	SBC	HL,DE
	DJNZ	DEC16A
	EX	DE,HL
	POP	HL
	POP	BC
	RET
;
;
KEY	PUSH	DE
	LD	A,1
	RST	40
	POP	DE
	RET
;
KEYIN	PUSH	BC
	PUSH	DE
	LD	C,0
	LD	HL,KEYBUF
	LD	A,9
	RST	40
	POP	DE
	POP	BC
	RET
;
;
LOCATE	PUSH	DE
	PUSH	BC
	LD	B,3
	LD	A,15
	RST	40
	POP	BC
	POP	DE
	RET
;
MODFY1	CALL	ERA20
	LD	HL,MODMN1
	CALL	DSPLY
	RET
MODMN1	DB	15,'Modify mode          (H)ex, (A)scii, (W)rite',3
;
;
CURSOR	LD	A,14
	JP	DSP
;
NOCUR	PUSH	AF
	PUSH	DE
	PUSH	BC
	LD	C,15
	LD	A,2
	RST	40
	POP	BC
	POP	DE
	POP	AF
	RET
;
RDSEC	LD	A,49		;@rdsec
	JR	IO
RDSSC	LD	A,85		;@rdssc
	JR	IO
WRSEC	LD	A,53		;@wrsec
	JR	IO
WRSSC	LD	A,54		;@wrssc
IO	LD	(IOTYP),A	;stuff read type for later
	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	HL,SECBUF
	LD	A,(CYLNUM)
	LD	D,A		;d = cylinder
	LD	A,(SECNUM)
	LD	E,A		;e = sector
	LD	A,(DRVNUM)
	LD	C,A		;c = drive
	LD	A,(IOTYP)	;determine type of read
	RST	40
	POP	BC
	POP	DE
	POP	HL
	RET
;
SHOWIT	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	HL,SCREEN
	LD	B,5
	LD	A,15
	RST	40
	POP	HL
	POP	DE
	POP	BC
	RET
;
;
IOTYP	DB	0
CYLNUM	DB	0
SECNUM	DB	0
DRVNUM	DB	0
SECBUF	DS	256
HEXBUF	DW	0
SCREEN	DS	1920
BUFADR	DW	0
DIRTRK	DB	0
KEYBUF	DS	4
H2DBUF	DS	5
HNUM	DB	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
VNUM	DB	00H,10H,20H,30H,40H,50H,60H,70H,80H,90H
	DB	0A0H,0B0H,0C0H,0D0H,0E0H,0F0H
HXVPOS	DB	0
HXHPOS	DB	0
ASVPOS	DB	0
ASHPOS	DB	0
CURPOS	DB	0
;
	END	START
