;	HDDE/ASM
;	(x'1b' + x'14' to put printer in condensed char mode)
;
;  written 02 Apr 90	revised 12 Feb 92
;  J.F.R. Slinkman, 1511 Old Compton Road, Richmond, VA  23233
;  (804) 741-0205, CompuServe ID 72411,650
;
;  revised 04 Jun 92 by Richard VanHouten
;
;  This program is in the public domain
;
;  Routines to switch between alternate directories on a hard drive partition,
;  and to perform the functions of the DIR command when a DIR listing including
;  non-resident directories is required.
;
;
*GET	EQUATES			;SVC and HD64180 definitions
;
	ORG	6000H		;must be >= 5200 because of DIR sort
;
RESBUF	DS	2200H		;holds resident directory
RQDBUF	DS	2200H		;holds requested directory
;
;  the first 12 bytes on the last sector of initialized directory tracks
;  contain the following information:
;
;	'HDDE'		an identifying header
;
;	HOWMANY		the number of active directories (range 2 to 7)
;
;	RESLETR		a 7-byte map consisting of the letters 'a' through 'g'.
;
;	The order of the letters in this map correspond to the physical
;	locations of the directories of those names on the directory track.
;
LASTSEC	DS	100H
HOWMANY	EQU	LASTSEC+4
RESLETR	EQU	LASTSEC+5
;
EDITBUF	DS	80		;command line editing workspace
;
;
BEGIN	PUSH	HL		;save ptr to command params
	LD	D,H
	LD	E,L		;copy ptr to DE
	LD	A,CR
	CPIR
	SBC	HL,DE
	LD	B,H
	LD	C,L		;BC = length of command string
	EX	DE,HL		;HL -> command string
	LD	A,':'
	CPIR			;is there a drive spec?
	JR	NZ,BGN040	;go if not
	LD	A,(HL)		;p/u char after ':'
	CP	'-'		;is it ':-d' command?
	JR	NZ,BGN010	;go if not
	INC	HL		;if so, skip over '-'
	LD	A,(HL)		;and p/u drive #
BGN010	CALL	@0TO7		;is drive number in legal range?
	JR	NC,BGN030	;go if so
	JP	ILDRIVE		;else generate 'illegal drive number' error
BGN020	LD	A,44		;generate 'parameter error'
	JP	ERROR
BGN030	INC	HL		;-> char after drive #
	LD	A,(HL)
	CP	'-'		;do we have a ':d-' or ':d-d' command?
	JR	Z,BGN040	;ok if so
	CP	' '		;followed by space? [i.e. ':5 (']
	JR	Z,BGN040	;ok if so
	CP	CR		;is drive # last char?
	JR	Z,BGN040	;ok if so -- else MUST be in range 'a' to 'z'
	CP	'A'
	JR	C,BGN020
	CP	'Z'+1
	JR	C,BGN040
	CP	'a'
	JR	C,BGN020
	CP	'z'+1
	JR	NC,BGN020
;
BGN040	LD	HL,1B0BH
	LD	DE,TERMCOD	;store EXIT svc sequence @ x'1b0b'
	LD	BC,3
	LDIR
	POP	HL
	LD	(SYSTACK),SP	;save for use with @cmndi
	LD	SP,STACK
	LD	DE,PARAMS	;copy all params, except [c], to PARAMS
	LD	A,(HL)
	CP	CR		;was command 'hdir' or '*' by itself?
	JR	NZ,BGN050	;go if not
	LD	(PARAMS-1),A	;   else copy the CR
	LD	C,0
	SVC	@GTDCT
	JP	FULLDIR		;   and do a full directory
BGN050	LD	A,(HL)		;p/u param character
	LD	(DE),A		; and copy to PARAM line
	INC	HL
	INC	DE		;advance pointers
	CP	':'		;is this the start of a drive spec?
	JP	NZ,BGN090	;go if not
	LD	(DOFULL),A	;disable JP to FULLDIR
	LD	A,(HL)		;p/u char after ':'
	CP	'-'		;is drivspec ':-x'?
	JR	NZ,BGN060	;go if not
	XOR	A		;if so, re-enable JP to FULLDIR
	LD	(DOFULL),A
	INC	HL
	LD	A,(HL)		;p/u drive #
	CALL	@0TO7
	JP	C,ILDRIVE	;error if not '0' to '7'
	XOR	30H		;convert to binary
	INC	A		;make range 1 to 8
	LD	(ITCTR),A	;   and set FULLDIR interation counter
	LD	A,'0'		;dummy drive number
;
BGN060	CALL	@0TO7
	JP	C,ILDRIVE	;error if not '0' to '7'
	LD	(DE),A		;copy it to PARAMS
	LD	(DRIVPTR),DE	;   and store address
	INC	HL
	INC	DE		;advance pointers
	LD	A,(HL)		;p/u char after drive #
	CP	CR		;check for end of command
	JR	Z,BGN050
	CP	'-'
	JR	NZ,BGN080	;here if ':x-' or ':x-y'
	XOR	A
	LD	(DOFULL),A	;re-enable JP to FULLDIR
	INC	HL
	LD	A,(HL)		;p/u char after '-'
	CALL	@0TO7		;is it ':x-y'?
	JR	C,BGN070	;go if not
	XOR	30H		;change end drive # to binary
	INC	A		;make range 1 to 8
	LD	C,A
	LD	IX,(DRIVPTR)
	LD	A,(IX)		;p/u start of drive range
	XOR	30H		;convert to binary (range: 0 to 7)
	SUB	C		;result range:  -8 to +8
	JP	P,ILDRIVE	;if start >= end
	NEG			;range 1 to 8
	LD	(ITCTR),A	;tell FULLDIR how many drives
	LD	A,(IX)
	LD	(DRVSPEC),A	;tell FULLDIR the starting drive #
	INC	HL
	LD	A,(HL)		;p/u next char
	JR	BGN080
;
BGN070	LD	IX,(DRIVPTR)	;here if ':x-'
	LD	A,(IX)		;p/u starting drive #
	LD	(DRVSPEC),A	;tell FULLDIR starting drive #
	XOR	30H		;convert to binary
	SUB	8		;range -8 to -1
	NEG			;change to 1 to 8
	LD	(ITCTR),A	;tell FULLDIR how many drives
	LD	A,(HL)
	CP	CR		;was the '-' the last character?
	JR	Z,BGN050	;finished if so
	INC	HL		;   else p/u next char
	LD	A,(HL)
;
BGN080	OR	20H		;if U/C alpha, convert to LC -- no effect if
				;   a space, a '(', or any other character
				;   likely to be encountered
	CP	'a'		;is it a [c] parameter?
	JP	C,BGN050	;do next char if not
	LD	(RQDDIR),A	;   else store name of requested directory
	INC	HL		;   and skip over it so it won't go to PARAMS
	JP	BGN050
BGN090	CP	CR		;at end of command line?
	JP	NZ,BGN050	;do next character if not
;
	LD	A,0
DOFULL	EQU	$-1		;is DIR of more than one drive necessary?
	OR	A
	JP	Z,FULLDIR	;go if so (falls thru if one drive spec'ed)
;
	LD	HL,(DRIVPTR)
	LD	A,(HL)		;p/u drive number
	XOR	'0'		;change ASCII '0'-'7' to binary
	LD	(DRIVNO),A	;   and store
	LD	C,A
	SVC	@GTDCT		;point IY to DCT
	LD	A,(IY)
	CP	0C3H		;is drive active?
	JP	NZ,ILDRIVE	;error if not
;
	SVC	@CKDRV		;is drive ready?
	JR	Z,BGN100	;go if so
	LD	A,8		;'Device not available'
	JP	ERROR
;
BGN100	LD	A,(RQDDIR)	;did command line contain a dir name spec?
	OR	A		;   (i.e., a letter code?)
	JP	Z,DODISK	;go if not
;
	CALL	GETLAST		;read last dir sector
	JR	Z,BGN110	;OK if initialized
	LD	HL,NOTSUBD
	JP	DSPOUT
;
BGN110	LD	A,(HOWMANY)	;p/u # of alternate directories
	ADD	A,'a'		;becomes ascii char one greater than limit
	LD	C,A
	LD	A,(RQDDIR)	;p/u name of requested directory
	CP	C
	JR	C,BGN120	;OK if in range
	LD	A,C		;else p/u test value
	DEC	A		;make it = the limit
	LD	(MAXLETR),A	;write to message
	LD	HL,RANGERR	;display message and end
	JP	DSPOUT
;
BGN120	LD	E,0
	LD	HL,RESBUF
	CALL	READDIR		;get resident directory into RESBUF
	CALL	SWAPEM
	CALL	PUTLAST
	LD	HL,0
	SVC	@EXIT
;
;  Entry:  resident directory must be in RESBUF, and letter name of requested
;	   directory in RQDDIR
;
SWAPEM	LD	HL,HOWMANY	;HL -> byte holding # of active directories
	LD	C,(HL)
	LD	B,0		;BC = # of map bytes to search
	INC	HL		;HL -> letter name of resident directory
	LD	A,(RQDDIR)	;value in C will correspond to letter's posi-
	CPIR			;   tion in the map, relative to (HOWMANY)
	LD	B,A		;store letter of requested directory
	LD	A,(HOWMANY)
	INC	C		;A = # of valid map entries -1
	SUB	C		;is requested directory already resident?
	RET	Z		;if so, nothing to do
;
	LD	C,A		;relative position is multiplier
	DEC	HL		;-> posn of requested dir in map
	LD	A,(RESLETR)	;p/u letter of resident directory
	LD	(RESDIR),A	;and store
	LD	(HL),A		;write to map position : to where it will go
	LD	A,B		;p/u letter of requested directory
	LD	(RESLETR),A	;write to resident position in map
	LD	E,34
	SVC	@MUL8		;A and E = sector address of requested directry
	LD	(RQDSECT),A
	LD	E,A
	LD	HL,RQDBUF
	CALL	READDIR		;read requested directory into RQDBUF
;
	LD	A,'a'		;p/u letter names of the two directories
RESDIR	EQU	$-1
	LD	(RESBUF+0D7H),A
	LD	A,(RQDDIR)	;and write to disk pack names in case they
	LD	(RQDBUF+0D7H),A	;   were changed via ATTRIB
;
	LD	HL,RESBUF	;update GAT of requested directory
	LD	DE,RQDBUF
	LD	BC,203
	LDIR
;
	LD	E,0
	LD	HL,RQDBUF
	CALL	WRITDIR		;make requested directory resident
	LD	A,(RQDSECT)
	LD	E,A
	LD	HL,RESBUF	;and write previously resident directory to
	CALL	WRITDIR		;   requested directory's old position
;
	LD	HL,RQDBUF	;contents of REQBUF now resident; so copy
	LD	DE,RESBUF	;   to RESBUF for possible next call from
	LD	BC,2200H	;   DISKDIR
	LDIR
	RET
;
;  Entry:  original directory must be in RESBUF, and letter name of requested
;	   directory in RQDDIR
;
GETIT	LD	A,$-$		;has original drive been overwritten?
OVRWRIT	EQU	$-1
	OR	A
	JR	NZ,GETIT2
	LD	A,(RQDDIR)	;Test if it's the one we want
	LD	B,A
	LD	A,(RESBUF+0D7H)
	CP	B
	RET	Z		;Return if not
;
GETIT2	LD	A,$-$		;if requested directory is the original,
ORIGNAL	EQU	$-1
	CP	B		;and it is no longer resident,
	JR	NZ,GETIT1
	LD	E,0
	LD	HL,RESBUF
	CALL	WRITDIR		;write the original back
	RET
;
GETIT1	LD	A,1
	LD	(OVRWRIT),A
	LD	HL,HOWMANY	;HL -> byte holding # of active directories
	LD	C,(HL)
	LD	B,0		;BC = # of map bytes to search
	INC	HL		;HL -> letter name of resident directory
	LD	A,(RQDDIR)	;value in C will correspond to letter's posi-
	CPIR			;   tion in the map, relative to (HOWMANY)
	LD	B,A		;store letter of requested directory
	LD	A,(HOWMANY)
	INC	C		;A = # of valid map entries -1
	SUB	C		;calculate relative position
;
	LD	C,A		;relative position is multiplier
	LD	E,34
	SVC	@MUL8		;A and E = sector address of requested directry
	LD	E,A
	LD	HL,RQDBUF
	CALL	READDIR		;read requested directory into RQDBUF
;
	LD	A,(RESDIR)	;p/u letter names of the two directories
	LD	(RESBUF+0D7H),A
	LD	A,(RQDDIR)	;and write to disk pack names in case they
	LD	(RQDBUF+0D7H),A	;   were changed via ATTRIB
;
	LD	HL,RESBUF	;update GAT of requested directory
	LD	DE,RQDBUF
	LD	BC,203
	LDIR
;
	LD	E,0
	LD	HL,RQDBUF
	CALL	WRITDIR		;make requested directory resident
	RET
;
;
DODISK	CALL	GETLAST
	JR	Z,DOD010
	LD	HL,NOTSUBD
	JP	DSPOUT
;
DOD010	LD	E,0
	LD	HL,RESBUF
	CALL	READDIR		;get resident dir into RESBUF for restoring
	CALL	SORTON
	CALL	DISKDIR
	CALL	SORTOFF
	LD	HL,0
	SVC	@EXIT
;
;  Routine to do listing of all directories on a drive
;
DISKDIR	LD	A,(RESLETR)	;p/u code for resident directory
	LD	(ORIGNAL),A	;store for its restoration at end
	LD	A,(HOWMANY)	;p/u # of dirs on drive
	LD	(DDR020),A	;value for calculating RQDDIR
	LD	B,A		;one iteration for each existing directory
;
DDR010	PUSH	BC
	LD	A,8
DDR020	EQU	$-1
	SUB	B		;range 0 to # of directories -1
	ADD	A,'a'		;convert to directory name
	LD	(RQDDIR),A
	CALL	GETIT		;get needed dir resident
	SVC	@CKBRKC		;did user press BREAK (twice, probably)
	JR	NZ,BREAK	;if so, restore original directory & exit
	CALL	PERFORM		;display directory
	POP	BC
	LD	A,H
	OR	L		;was there an error with the DIR command?
	JR	NZ,CMDERR	;go if so
	DJNZ	DDR010		;   else list next directory
;
DDR030	LD	E,0
	LD	HL,RESBUF
	CALL	WRITDIR
	RET
;
CMDERR	PUSH	HL		;preserve error # from DIR command
	CALL	DDR030		;restore dir which was resident at start
	CALL	SORTOFF		;restore SYS1/SYS
	CALL	PUTLAST		;update map
	POP	HL		;error #
	LD	A,63
	OR	A
	SVC	@EXIT
;
BREAK	CALL	DDR030		;see comments @ CMDERR + 1
	CALL	SORTOFF
	CALL	PUTLAST
	LD	HL,0
	SVC	@EXIT
;
;
;  Routine to do DIR listings of more than one disk
;
FULLDIR	LD	HL,PARAMS-1	;does COMMAND line contain a drive spec?
FDR010	LD	A,(HL)
	INC	HL
	CP	':'
	JR	Z,FDR110	;go if so
	CP	CR
	JR	NZ,FDR010	;falls thru if not
;
	LD	HL,COMMAND	;else must add drive spec to COMMAND lhne
	LD	DE,EDITBUF
FDR020	LD	A,(HL)		;p/u COMMAND char
	CP	CR		;is CR before space ('dir'+CR only)?
	JR	Z,FDR070	;add ' :0' if sn
	LD	(DE),A		;   else copy the character
	INC	HL		;   and advance the pointers
	INC	DE
	CP	20H		;is character a space?
	JR	NZ,FDR020	;do next if not
;
FDR030	LD	A,(HL)
	CP	20H		;multiple spaces?
	JR	NZ,FDR040
	INC	HL
	JR	FDR030
FDR040	LD	A,(HL)
	CP	'('
	JR	Z,FDR060	;go if no filespec|partspec
	CP	20H		;is it the space after a file|part spec?
	JR	Z,FDR050	;go if so
	CP	CR		;does CR immmdiately follow a file|part spec?
	JR	Z,FDR050	;go if so
	LD	(DE),A		;else copy the file|part spec character
	INC	HL		;advance pointers
	INC	DE
	JR	FDR040		;   and do next char
;
FDR050	EX	DE,HL		;here if adding ':0' immediately after a
	JR	FDR080		;   filespec|partspec
;
FDR060	DEC	HL		;here if adding ' :0' before ' (params)'
	DEC	DE		;back up to space before '('
	LD	A,(HL)		;   and pick it up
FDR070	EX	DE,HL		;entry point to add ' :0'
	LD	(HL),20H
	INC	HL
FDR080	LD	(HL),':'	;entry point to add ':0'
	INC	HL
	LD	(HL),'0'
DRVSPEC	EQU	$-1
	LD	(DRIVPTR),HL	;store address of drive spec
	INC	HL
	LD	(HL),A		;   and write original char read
;
	EX	DE,HL
FDR090	CP	CR
	JR	Z,FDR100	;go if finished
	INC	HL
	INC	DE
	LD	A,(HL)		;else write out rest of params
	LD	(DE),A
	JR	FDR090
;
FDR100	LD	HL,COMMAND
	LD	DE,EDITBUF
	OR	A
	SBC	HL,DE		;HL is offset between old & new commands
	LD	DE,(DRIVPTR)
	ADD	HL,DE
	LD	(DRIVPTR),HL	;calculate new drive number address
	LD	HL,EDITBUF	;copy new command to COMMAND line
	LD	DE,COMMAND
	LD	BC,80
	LDIR
;
FDR110	CALL	SORTON
;
	LD	B,8		;count drive slots
ITCTR	EQU	$-1
FDR120	PUSH	BC
	LD	HL,(DRIVPTR)
	LD	A,(HL)		;p/u drive spec
	XOR	30H		;convert to binary
	LD	(DRIVNO),A	;store it for use by READ/WRITDIR
	LD	C,A
	SVC	@GTDCT		;point IY to DCT for this drive
	LD	A,(IY)
	CP	0C3H		;is drive inactive?
	JR	NZ,FDR140	;go if so
	SVC	@CKDRV		;is drive ready?
	JR	NZ,FDR130	;go if not (displays 'No Disk')
	CALL	GETLAST
	JR	NZ,FDR130	;go if DIR/SYS not initialized
	LD	E,0
	LD	HL,RESBUF
	CALL	READDIR		;get resident dir into RESBUF for restoring
	CALL	DISKDIR		;do listing for all dir's on drive
	JR	FDR140
;
FDR130	CALL	PERFORM		;here if only one directory -- do normal list
	LD	A,H
	OR	L		;was there an error?
	JR	Z,FDR140	;go if not
	PUSH	HL
	CALL	SORTOFF
	POP	HL
	LD	A,63
	OR	A
	SVC	@EXIT		;   else exit w/error in HL
;
FDR140	LD	HL,(DRIVPTR)
	INC	(HL)
	POP	BC
	DJNZ	FDR120
	CALL	SORTOFF
	LD	HL,0
	SVC	@EXIT
;
ILDRIVE	LD	A,32		;'Illegal drive number' error
;
ERROR	OR	40H		;handle errors before SORTON has been called
	LD	C,A
	SVC	@ERROR
;
BOMB	PUSH	AF		;handles errors after SORTON has been called
	CALL	SORTOFF
	POP	AF
	JR	ERROR
;
DRIVNO	DB	0
RQDDIR	DB	0
RQDSECT	DB	0
DRIVPTR	DW	0
LSECNO	DB	0
;
READDIR	LD	A,(DRIVNO)	;entry:  HL -> buffer, E = 1st sector number
	LD	C,A
	LD	B,22H
	LD	D,(IY+9)	;p/u dir cyl number
RDIR10	SVC	@RDSSC
	CALL	NZ,REREAD	;if an error
	INC	E		;next sector to read
	INC	H		;-> next buffer page to read to
	DJNZ	RDIR10
	RET
;
REREAD	PUSH	BC		;save sector counter
	LD	B,5		;count 5 retries
RERD10	SVC	@RDSSC		;re-read the sector
	JR	NZ,RERD20	;if error, try again
	POP	BC		;if no error, restore sector counter
	RET			;   and return to read the rest
RERD20	DJNZ	RERD10		;perform next re-try
	POP	BC		;after 5 failures, clear stack, report error,
	POP	BC		;   and end
	JR	BOMB
;
WRITDIR	LD	A,(DRIVNO)	;entry:  HL -> buffer, E = 1st sector number
	LD	C,A
	LD	B,22H
	LD	D,(IY+9)
	PUSH	HL		;save registers for verification
	PUSH	DE
	PUSH	BC
WDIR10	SVC	@WRSSC		;write the buffer to the dir track
	CALL	NZ,REWRITE
	INC	E		;next sector
	INC	H		;next buffer page
	DJNZ	WDIR10
	POP	BC		;restore registers for verification
	POP	DE
	POP	HL
WDIR20	SVC	@VRSEC
	JR	Z,WDIR30
	CP	6
	CALL	NZ,VERIFY
WDIR30	INC	E
	INC	H		;follow buffer loc in case rewrite necessary
	DJNZ	WDIR20
	RET
;
REWRITE	PUSH	BC		;save counter
	LD	B,5		;count 5 retries
REWR10	SVC	@WRSSC		;write the sector again
	JR	NZ,REWR30	;try again if error
REWR20	PUSH	DE		;E is sector number
	EXX			;preserve registers
	POP	HL		;L is sector number
	LD	H,0		;isolate it
	LD	DE,NUMBUF
	LD	B,4
	SVC	@HEXD		;convert sector # to ASCII
	LD	HL,WARNING
	SVC	@DSPLY		;post warning message
	EXX			;restor registers
	POP	BC		;restore counter
	RET			;   and return for next sector write/verify
REWR30	DJNZ	REWR10		;perform next try
	POP	BC		;after 5 failures, clear stack, report the
	POP	BC		;   error, and end
	JR	BOMB
;
VERIFY	PUSH	BC		;save counter
	LD	B,5		;count 5 retries
VFY010	SVC	@WRSSC		;write the sector again
	JR	NZ,VFY020	;try again if error
	SVC	@VRSEC		;if it takes, verify sector
	JR	Z,REWR20	;if no error
	CP	6		;was error 'Attempt to read system record'?
	JR	Z,REWR20	;OK if so
VFY020	DJNZ	VFY010		;perform next try
	POP	BC		;after 5 failures, clear stack, report the
	POP	BC		;   error, and end
	JP	BOMB
;
@0TO7	CP	'0'		;Entry:  Drive # in A.  check if valid
	RET	C
	CP	'7'+1		;is number in range '0' to '7'?
	CCF
	RET			;on return:  C = invalid; NC = valid
;
GETLAST	LD	A,(IY+8)
	AND	0E0H
	RLCA
	RLCA
	RLCA
	INC	A
	LD	C,A		;grans/track is multiplier
	LD	A,(IY+8)
	AND	1FH
	INC	A
	LD	L,A
	LD	H,0		;sectors/gran is multiplicand
	SVC	@MUL16		;max possible product is 100H
	DEC	A		;A = # of last sector on a track
	LD	(LSECNO),A	;save for rewrite
	LD	E,A		;this is sector to read
	LD	D,(IY+9)	;p/u dir track number
	LD	A,(DRIVNO)
	LD	C,A		;   and drive number
	LD	HL,LASTSEC
	SVC	@RDSSC		;read last DIR/SYS sector into LASTSEC
	JP	NZ,ERROR
	LD	DE,MODNAME	;do 1st four bytes contain the header?
	LD	B,4
GTL010	LD	A,(DE)
	CP	(HL)
	RET	NZ		;ret w/ NZ means dir not initialized
	INC	DE		;	Z means it was, and:
	INC	HL		;	res dir code is in RESLETR
	DJNZ	GTL010		;	dir count is in HOWMANY
	RET
;
PUTLAST	LD	A,(LSECNO)
	LD	E,A
	LD	D,(IY+9)
	LD	A,(DRIVNO)
	LD	C,A
	LD	HL,LASTSEC
	SVC	@WRSSC
	RET	Z
	CP	6
	RET	Z
	JP	NZ,ERROR
;
PERFORM	LD	HL,PFRM010
	LD	(1B0CH),HL	;write as trap JP address
	LD	(PFRM020),SP	;save current stack pointer
	LD	SP,0		;load SP with initial value
SYSTACK	EQU	$-2
	LD	HL,COMMAND	;-> command string
	SVC	@CMNDI		;perform DOS command & RET to calling routine
PFRM010	LD	SP,0		;restore SP to program stack
PFRM020	EQU	$-2
	RET
	SVC	@ABORT		;   just in case...
;
SORTON	LD	A,0C3H		;convert EXIT svc to JP command to trap @cmndi
	LD	(1B0BH),A
	RET
;
SORTOFF	LD	HL,TERMCOD	;restore EXIT svc code
	LD	DE,01B0BH
	LD	BC,3
	LDIR
	RET
;
DSPOUT	SVC	@DSPLY
	SVC	@ABORT
;
TERMCOD	DB	3EH,93H,0EFH
;
COMMAND	DM	'dir '
PARAMS	DS	76
;
MODNAME	DM	'HDDE'
;
NOTHARD	DM	'Not a hard drive',LF,CR
;
NOTSUBD	DM	'Alternate directories have not been initialized on this drive',LF,CR
;
RANGERR	DM	'Alternate directory name out of range (highest available is "'
MAXLETR	DM	'e")',LF,CR
;
WARNING	DM	'WARNING:  It took more than one attempt to write to directory sector #'
NUMBUF	DM	'    !',LF,CR
;
STACK	EQU	NUMBUF+100H
;
	END	BEGIN
