/*	Expanded Memory Manager header file - EMM/H	*/

/*	Uses concepts adapted from an article in Dr. Dobb's Journal of Software
	Tools #138, May 1988 written by Mark Tichenor - "Virtual Arrays in C"
	and designed for virtual disk-based arrays. Also, uses concepts adapted
	from an	article in Byte, Volume 15, Number 9, September 1990 written by
	Rick Grehan - "Virtually Virtual Memory". These two articles pointed me
	in the right direction for writing an Expanded Memory Manager for the
	Tandy Model 4 utilizing MISOSYS C.

	Note(s):
	The registered version of EMM will grab up to 10 banks of alternate memory
	for use	as an extended heap by a C program. That represents 327,680 bytes
	minus the space utilized by the MAT (Memory Allocation Table) in each bank
	(256 bytes) leaving 325,120 bytes for data (317.5K). Each element (or
	record) cannot exceed 32,763 bytes if longs are used in cache addressing or
	32,765 if ints are used (as in the demo version). The number of elements
	may be up to 32,765 in the registered version, though, there are
	a maximum of 325,120 one-byte elements that could be available if the
	presently configured maximum of 10 banks was obtained. If the source code
	to EMM is purchased, EMM may be recompiled to obtain as many banks of
	alternate memory that can be addressed through @BANK.

	If you have registered the demo version of EMM and purchased the source
	code, EMM may be recompiled to utilize longs instead of integers to address
	elements thus increasing the number of elements able to be addressed. The
	registered version is provided utilizing integer addressing for elements.

	The demo version can only address one bank of alternate memory and
	addressing is provided utilizing integers.

	Copyright (C) 1991 by David A. Huelsmann
	Version 02.00.00 January 5, 1991
*/

#include <malloc/h>
#include <memory/h>

/* Expanded Memory Node typedef	*/

typedef struct node	{		/* memory node	*/
	int status;				/* 0 = block free, 1 = block used	*/
	int bank;				/* starting bank from MAT entry	*/
	int mat;				/* starting MAT entry	*/
	int blklength;			/* # of 256 byte paragraphs available/allocated	*/
	struct node *nextptr;	/* pointer to next NODE	*/
}NODE;						/* expanded memory node type name	*/

/* Expanded Memory Control Block typedef */

typedef struct {
	NODE *emptr;			/* memory node pointer for this control block	*/
	int elsize;				/* number of bytes in each element (<=32765) */
	int elnumber;			/* number of elements (<=32767) */
	char *cache;			/* pointer to array cache */
	int cach_elsize;		/* size of element in cache including index */
	int cach_size;			/* number of elements in cache	*/
}EMCB;						/* expanded memory control block type name */

/* Expanded Memory Access Prototypes */

extern long emminit();
extern EMCB *emmalloc();
extern EMCB *emmacc();
extern void emmfree();
extern long emmavail();
