	COM	'Copyright 1990/91 Lamar Owen/ LORC Enterprises.'
	TITLE	'<320 K @BANK driver V 1.1>'
	SUBTTL	'<PROGRAM Header>'

; 320K Modification @BANK driver
;
; Copyright 1990/91 Lamar Owen.
; Modify at will; may not be sold.
; Fixes LS-DOS for banks 3-8 for 320K Modification
; Operating System: LS-DOS 6.3.0 or later, for model 4 only.
; Requires 80 Micro 320K modification or similar mod.
;
; Bank switch format:
; A PORT is defined to enable switching of 64K blocks of memory.
; The 80 micro mod uses port 00H.  My mod uses port 94H (an internal decoder
; already decodes that port).  The data output to this port enables which 64K
; block is mapped onto the extra 64K.  Either 32K bank of this block may then
; be selected using the standard model 4 memory switch mechanism.
;
; The driver may be modified to work with nearly any memory access scheme by
; simply changing the access method inside the block labeled "device dependent
; code."  The present bank number limits are 0-32, however, by changing the
; access code in the driver, any number of banks up to 256 can be supportted
; (0-255, limited only by the size of register C)
;
;=====================REVISION HISTORY=============================
; Any User modifications must be recorded here.  Please let me know
; of any bugs/features that are found, as well as giving me suggestions
; on improving driver/installer operation.  I can be contacted via mail at
; LAMAR OWEN
; STAR ROUTE BOX 620
; ROSMAN, NC  28772
;
; Version .90--Beta test.  Original code, not released.  Operational.
;		Implemented on MZAL assembler under LS-DOS 6.3.0L
;
; Version 1.0--Released Spring 1990.  Full operation assured, direct calls
;		to @BANK now trapped and sent to XB.  32 Bit BAR and BUR
;		implemented for future memory size expansion.
;		Translated to MRAS assembler format under LSDOS 6.3.1F
;
; Version 1.1--10/20/90  Added extensive comments.  Corrected the SYSGEN
;		problem.  The XB driver can now be SYSGENed.  The @ICNFG
;		vector chain is linked into for setup of the @BANK SVC
;		address.  @BANK direct call trap is installed here.
;		Implemented on MRAS assembler, LS-DOS 6.3.1G.
;
;MACROS
;
SVC	MACRO	#NUM		;Macro to invoke a SVC
	LD	A,#NUM
	RST	28H
	ENDM
;
; MEMORY SWITCH PORT EQUATE (use 00H for 80 Micro mod)
;
PORT	EQU	00H		;either 94H or 9CH for my 320K mod.
;
; SVC EQUates
;
@ABORT	EQU	15H
@BANK	EQU	66H
@DSPLY	EQU	0AH
@ERROR	EQU	1AH
@EXIT	EQU	16H
@FLAGS	EQU	65H
@GTDCB	EQU	52H
@GTMOD	EQU	53H
; Misc. equates
@ICNFG	EQU	28
;
	ORG	3000H
;
	PAGE
	SUBTTL	'<Main Line Code>'
BEGIN	LD	HL,STMSG	;Ok, start by telling human that we are here
	SVC	@DSPLY
	SVC	@FLAGS		;get our flag pointer
	BIT	3,(IY+2)	;CHECK FOR SET OR SYSTEM(DRIVER= COMMAND
	JR	NZ,NOSET	;ERROR IF SO
	LD	DE,HBNAME	;LOOK FOR MODULE @XB
	SVC	@GTMOD
	JR	NZ,GO		;ALREADY INSTALLED, PRINT ERROR
	LD	HL,ALREDY	;
	DB	0DDH		;CAUSE SKIP OVER NEXT INSTRUCTION
NOMEM	LD	HL,NOLOW	;NO LOW MEMORY SPACE LEFT
	DB	0DDH
NOSET   LD      HL,USERUN       ;CAN'T INSTALL VIA SET OR SYSTEM
ABORT	SVC	@DSPLY
	SVC	@ABORT
;
;	At this point, we are ready to calculate where the driver will go.
;
GO	LD	DE,'IK' 	;LOMEM POINTER RIGHT BEFORE *KI DCB
	SVC	@GTDCB		;(in this context, LOMEM is the driver area
	DEC	HL		;between about 0FF4H and 1300H.)
	LD	D,(HL)
	DEC	HL
	LD	E,(HL)
	PUSH	DE		;DE HAS ADDRESS OF FIRST FREE BYTE IN LOW
	PUSH	HL		;HL HAS LOMEM POINTER
	LD	HL,DVRLEN	;GET DRIVER LENGTH AND ADD TO LOMEM
	ADD	HL,DE
	PUSH	HL
	DEC	HL
	LD	(DVREND),HL	;LAST ADDRESS USED BY @XB
	POP	HL
	PUSH	HL		;We now need to see if @XB will fit or not.
	LD	BC,1300H	;END OF LOMEM AREA
	OR	A
	SBC	HL,BC
	POP	HL
	JR	NC,NOMEM	;END OF DRIVER BEYOND END OF LOMEM
;
;	Now, the major errors have been handled, so we can actually install XB.
;
	POP	DE
	EX	DE,HL
	LD	(HL),E		;SETUP NEW AVAILABLE LOMEM POINTER
	INC	HL
	LD	(HL),D
;
;	Now we calculate the SVC address of @BANK, which XB will replace.
;
	LD	A,@BANK
	ADD	A,A		;SET UP NEW @BANK SVC DRIVER
	LD	L,A
	LD	H,(IY+1AH)	;SVCTABPTR$
	LD	(BANKSVC),HL
	POP	HL
;
;	Ok, now we have to generate a relocation offset.  This offset will
;	be added to every relocation address stored in the table.
;	The formula for this address is (LOMEM Start)-(DRIVER Start). This
;	number will ALWAYS be negative, thus it is ADDed to the relo address
;	rather than SUBtracted.
;
	PUSH	HL
	LD	BC,DRIVER
	OR	A
	SBC	HL,BC
	LD	C,L
	LD	B,H
;
;	The @ICNFG vector INIT address has to be separately reloed, so we do it
;	now, while BC contains the proper offset.
;
	PUSH	HL
	LD	HL,INIT
	ADD	HL,BC		;FIXUP RINIT VALUE FOR ICNFG STUFF
	LD	(RINIT),HL
	POP	HL
;
;	Now the fun begins.  IX initially points to the start of the relo
;	table.  If the word pointed to by IX is 0000h, we are done. Otherwise,
;	we follow the following algorithm:
;	The data pointed to by IX and IX+1 is in fact an address.
;	The data pointed to by this address then has the offset
;	added to it, and it is stored back at its address.
;
	LD	IX,RELTAB	;FIX RELOCATION ADDRESSES
AGAIN	LD	L,(IX+0)
	LD	H,(IX+1)
	LD	A,H
	OR	A		;END OF TABLE IS A ZERO
	JR	Z,INSTALL
	PUSH	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	POP	HL
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	IX		;RELOCATION FINISHED, GO
	INC	IX		;BACK FOR NEXT ADDRESS
	JR	AGAIN
;
;	Ok, all of the data in the driver that needs relocating has been
;	relocated, so we can move the driver down.  First, however, there
;	is a minor detail to be taken care of: @ICNFG vector and linkage.
;	This is done as per the Tech Ref manual example.
;
INSTALL POP	DE
	DI			;Cannot stand an interrupt now!!!!
	CALL	ICNFG		;INITIALIZE BANK SVC
	SVC	@FLAGS
	LD	HL,0
RINIT	EQU	$-2		;SET UP @ICNFG VECTOR
	LD	A,(IY+@ICNFG+1)	;SET UP INIT LINK TO EXISTING ICNFG
	LD	(LINK+1),A
	LD	A,(IY+@ICNFG+2)
	LD	(LINK+2),A
	LD	A,(IY+@ICNFG)
	LD	(LINK),A
	LD	(IY+@ICNFG),0C3H	;LINK IN XBANK INIT INTO @ICNFG
	LD	(IY+@ICNFG+1),L
	LD	(IY+@ICNFG+2),H
;
;	Now, after all that work, we can move the driver.  Note that since
;	the system's original @BANK code has already been modified and that
;	the SVC address now points to XBANK instead, we must make sure that
;	nothing interrupts us before the driver movement is complete.  This
;	is what that DI was for.
;
	LD	HL,DRIVER	;MOVE DRIVER
	LD	BC,DVRLEN
	LDIR
	EI			;XBANK is in place, so reenable interrupts.
EXIT    LD      HL,SUCCESS      ;WE'RE DONE, TELL HUMAN GOOD NEWS
	SVC	@DSPLY
        LD      HL,0            ;DON'T WANT TO ABORT JCL!
	SVC	@EXIT
;
;	INSTALL DONE.... INSTALLATION MESSAGES:
;
ALREDY	DB 0AH,'@XB Already installed: install aborted.',0AH,0DH
NOLOW	DB 0AH,'Low memory driver area FULL: install aborted.',0AH,0DH
USERUN	DB 0AH,'Can''t install via SET or SYSTEM: install aborted.',0AH,0DH
SUCCESS DB 0AH,'@XB successfully installed. BANKS 3-8 enabled.',0AH,0DH
STMSG	DB 0AH,'@XB-Extended memory modification @BANK driver version 1.1'
	DB 0AH,0AH,'Copyright 1990 Lamar Owen.  All rights reserved.'
	DB 0AH,'It is permissible to distribute copies of both object'
	DB 0AH,'and source code under the condition that no profit is made.'
	DB 0AH,'All copies distributed must include source and docs, including'
	DB 0AH,'any modifications that have been made.  Modification and'
	DB 0AH,'customization of this driver is permitted and encouraged.',0DH
;
	PAGE
	SUBTTL	'<@XB Driver Section>'
; @XB DRIVER
;RELOCATES TO LOW MEMORY
;
DRIVER	JR	DVRBGN
DVREND	DEFW	0
	DEFB	3
HBNAME	DEFM	'$XB'
	DEFW	0303H		;LS-DOS SPARE POINTERS
	DEFW	0
BAR	DEFW	0		;32 BIT BANK AVAILABLE RAM
BARL	DEFW	0FF01H		;LOW WORD 000001FFH GIVES 9 BANKS
BUR	DEFW	0FFFFH		;32 BIT BANK IN USE RAM
BURL	DEFW	00FEH		;LOW WORD. FFFFFE00H GIVES 9 USABLE BANKS
CURBNK	EQU	0202H		;CURRENT BANK NUMBER SELECTED
DVRBGN	AND	7FH		;STRIP BIT 7
	CP	09H		;ONLY 0-8 ALLOWED WITH 320K
	JR	NC,SYSERR	;RETURN ERROR 2B IF ABOVE
	DEC	B
	JP	M,SWITCH	;SWITCHIT IF B=0
REL01	EQU	$-2
	PUSH	HL
	JR	Z,RESET 	;B=1, RESET BUR BIT
	DEC	B
	JR	Z,TEST		;B=2, TEST BUR BIT
	DEC	B
	JR	Z,SETBUR	;B=3, SET BUR BIT
	LD	A,(CURBNK)	;B=4,RETURN CURRENT BANK NUMBER
	CP	A
	POP	HL
	RET
SYSERR	LD	A,2BH		;SVC PARAMETER ERROR
	OR	A
	RET
RESET	CALL	GETBUR		;GET ADDRESS OF PROPER BUR BYTE IN HL,
REL03	EQU	$-2
	PUSH	AF		;MASK FOR BUR IN A
	PUSH	HL
	DEC	HL
	DEC	HL
	DEC	HL
	DEC	HL		;GET APPROPRIATE BAR BYTE
	AND	(HL)		;IF ZERO, THAT BIT IN BAR IS ZERO
	POP	HL
	JR	Z,NOBNK 	;BANK NOT PRESENT
	POP	AF
	CPL			;COMPLEMENT A FOR ANDING
	AND	(HL)		;RESET BIT
	LD	(HL),A
	XOR	A		;SUCCESS
	POP	HL
	RET
NOBNK	POP	AF
	CP	A
	POP	HL
	RET			;SET A NZ CONDITION FOR BANK UNAVAILABLE
TEST	CALL	GETBUR		;GET ADDRESS AND MASK FOR BUR
REL04	EQU	$-2
	AND	(HL)
	POP	HL
	RET
SETBUR	CALL GETBUR		;GET ADDRESS AND MASK FOR BUR
REL05	EQU	$-2
	PUSH	AF
	AND	(HL)		;ALREADY IN USE?
	JR	NZ,NOBNK	;BANK UNAVAILABLE
	POP	AF
	OR	(HL)		;SET BUR BIT
	LD	(HL),A		;STORE
	XOR	A		;NO ERRORS
	POP	HL
	RET
GETBUR	PUSH	BC
	PUSH	AF
	AND	38H		;STRIP LOW THREE BITS
	RRCA
	RRCA
	RRCA			;PUT BANK BUR SEL IN LOW BITS
	LD	HL,BUR+3	;GET LOW ORDER BYTE OF BUR
REL06	EQU	$-2
	OR	A		;SET UP FOR SBC
	LD	B,0
	LD	C,A
	SBC	HL,BC		;GET BUR ADDRESS FOR BANK
	POP	AF
        AND     07H             ;CAN'T GO MORE THAN 7 BITS!
	LD	B,A		;MUST PUT COUNT IN B
	INC	B		;MUST INC FOR FIRST DJNZ
	LD	A,80H		;SET UP FOR 2 TO THE POWER X
GLOOP	RLCA			;8-BIT ROTATE A
	DJNZ	GLOOP		;CONTINUE UNTIL X
	POP	BC
	RET			;DONE. MASK IN A, ADDRESS IN HL
SWITCH	PUSH	HL		;SAVE FOR SP CHECK
	LD	HL,8005H
	ADD	HL,SP
	POP	HL
	JR	C,SYSERR	;STACK TOO HIGH!!
	LD	A,(CURBNK)	;SAVE CURRENT BANK
	LD	(BNKSAV),A
REL08	EQU	$-2
;
;***************************************************************************
; DEVICE DEPENDENT CODE STARTS HERE.  Register C contains the desired bank.
; The current bank has been saved in BNKSAV for return to caller.
;
	LD	A,C
	AND	7FH		;Strip the "transfer" bit
	LD	B,0		;Is the bank number 0?? (Special case)
	JR	Z,BANK0
	DEC	A		;No, so select proper 64K block.
	SRL	A		;Dvide bank number by 2
	OUT	(PORT),A	;OUTPUT UPPER BITS OF BANK TO PORT
	LD	A,C
	AND	01H		;SETUP PORT 84H OUT
	OR	02H		;FIX ENABLE PAGE MAP (Map to upper 32K)
	RLCA
	RLCA			;Rotate into proper position for port 84H
	RLCA
	RLCA
	LD	B,A
BANK0	LD	A,(0078H)	;CURRENT MEM MAP (0078 may change in future DOS
	AND	8FH		;SET FOR MAP TO UPPER BANK
	OR	B
	LD	(0078H),A	;RESTORE MAP (0078H location MAY CHANGE!)
	OUT	(84H),A 	;MAP BANK
;
; END OF DEVICE DEPENDENT CODE.  Following code sets up current bank number
; and acts upon the transfer bit (bit 7) being set.  All @BANK calling
; conventions must be supportted.
;***************************************************************************
;
	LD	A,C
	AND	7FH
	LD	(CURBNK),A
	XOR	C
	OR	0		;LAST BANK NUMBER
BNKSAV	EQU	$-1
	LD	C,A
	BIT	7,C
	LD	B,00H
	RET	Z
	EX	(SP),HL 	;HL TRANSFER ADDRESS SWAP
	CP	A
	RET
;
;	@ICNFG ROUTINE AND LINK
;
INIT	DI
	CALL	ICNFG
REL10	EQU	$-2
	EI
LINK	DC	3,0C9H
ICNFG	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	DE,DVRBGN
REL09	EQU	$-2
	LD	HL,$-$		;VALUE AT WHICH THE SVC ADDRESS FOR @BANK IS
BANKSVC	EQU	$-2
	LD	C,(HL)		;WE NEED TO SAVE THIS ADDRESS TIL LATER
	LD	(HL),E
	INC	HL
	LD	B,(HL)
	LD	(HL),D
	LD	H,B		;NOW, STUFF A JUMP OP CODE
	LD	L,C
	LD	(HL),0C3H	;INTO THE FIRST 3 BYTES OF THE @BANK HANDLER
	INC	HL
	LD	(HL),E		;TO MAKE SURE SYSTEM ROUTINES THAT CALL @BANK
	INC	HL
	LD	(HL),D		;DIRECTLY WILL ACCESS XBANK INSTEAD
	POP	BC
	POP	DE
	POP	HL
	RET
;
DVRLEN	EQU	$-DRIVER
;
;  RELOCATION TABLE
;
RELTAB	DW	REL01,REL03,REL04,REL05,REL06,REL08,REL09,REL10
	DW	0
	END	BEGIN
