;DBLDUTY3/ASM Copyright (c) 1990 by Richard VanHouten.  All rights reserved
;Permission to use for educational purposes.
;ASCII equates
LF	EQU	0AH
CR	EQU	0DH
;Port equates
OPREG	EQU	84H		;Paging/video mode control port
BOOT	EQU	9CH		;boot rom control port (4p)
MODOUT	EQU	0ECH		;speed control port (among other things)
;Memory equates
@CTL	EQU	002BH		;DEVICE CONTROL ROUTINE
@CLS	EQU	01C9H		;Clear screen routine in ROM
@BANK	EQU	3012H		;Bank control routine (Hardware interface kit)
COUNT1	EQU	3542H		;countdown timer values in ROM
COUNT2	EQU	355DH		;ditto
KEYROW7	EQU	3880H		;keyboard row with shift and control keys
VIDEO	EQU	3C00H		;start of model 3 mode video
LOWRAM	EQU	4000H		;start of standard model 3 RAM
INTVEC	EQU	4012H		;interrupt vector
KIDCB$	EQU	4015H		;keyboard DCB
@EXIT	EQU	402DH		;DOS normal exit vector
@ABORT	EQU	4030H		;DOS abnormal exit vector
OPREG$	EQU	40ADH		;image of OPREG port (5.3 only)
JPSAV	EQU	4065H		;Save area for DOS exits during DO processing
MODOUT$	EQU	4210H		;image of modout port
TIME$	EQU	4217H		;DOS time area
JFCB$	EQU	4265H		;FCB for DO processing
KFLAG$	EQU	429FH		;Keyboard flags
KIVSAV	EQU	42BEH		;Keyboard vector save area for DO processing
@DEBUG	EQU	440DH		;DEBUG invoke vector
HIGH$	EQU	4411H		;top of unprotected memory
OSVER$	EQU	441FH		;DOS version
SFLAG$	EQU	442BH		;System flags
@PARAM	EQU	4454H		;Parameter parsing vector
@DSPLY	EQU	4467H		;Line display routine
DCT$	EQU	4700H		;Drive control tables
HIBANK	EQU	8000H		;start of upper bank
PAGE2	EQU	0F800H		;start of second video page (not seen in 64x16)
PAGE1	EQU	0FC00H		;start of first video page (normal 64x16 page)
	ORG	5300H
INIT	LD	SP,INIT
	PUSH	HL		;Save command line pointer
	CALL	@CLS		;clear screen
	LD	HL,MESS2	;display title
	CALL	@DSPLY
	LD	A,(INTVEC+2)	;is a non-dos interrupt handler
	CP	44H		;installed?
	JR	Z,CONT		;if so,
	LD	HL,MESS3	;abort: interrupt conflict
ERR	LD	A,(OSVER$)	;if LDOS 5.3,
	CP	53H
	LD	A,(OPREG$)	;use OPREG image
	JR	Z,VER53
	XOR	A		;else use mode 0
VER53	OUT	(84H),A		;restore memory map
	CALL	@DSPLY		;display error message
	EI			;enable interrupts
	JP	@ABORT		;and abort
CONT	LD	HL,(HIGH$)	;get old high$
	LD	DE,CPYBUF+MODLEN+8000H
	OR	A		;do we have enough room
	SBC	HL,DE		;to copy the high memory
	LD	HL,MESS4	;routines?
	JR	C,ERR		;no, go tell user and abort
;check for presence of extended memory
CONT3	LD	A,(OSVER$)	;if ldos 5.3,
	CP	53H
	LD	A,(OPREG$)	;use modout image
	JR	Z,V53
	XOR	A		;else use mode 0
V53	AND	1
	LD	B,A		;B will map in banks 0 and 1
	LD	A,20H		;A will map in banks 0 and 2
	LD	C,84H
	OUT	(C),B		;map in banks 0 and 1
	LD	HL,-1		;memory location to use in test
	LD	D,(HL)		;save char at that location
	LD	(HL),55H	;put a test value there
	OUT	(C),A		;map in banks 0 and 2
	LD	E,(HL)		;save char at top of memory
	LD	(HL),A		;put second test value here
	OUT	(C),B		;map in banks 0 and 1
	CP	(HL)		;was first test value kept?
	LD	(HL),D		;restore overwritten bytes
	OUT	(C),A		;in banks 1 and 2
	LD	(HL),E
	OUT	(C),B
	LD	HL,MESS5
	JR	Z,ERR
	BIT	0,B		;is hardware interface kit installed?
	JR	Z,CONT4		;no, skip bank reserve
	LD	B,2		;test if bank 2 free
	LD	C,1
	CALL	@BANK
	JR	NZ,ERR1		;abort on error
	LD	B,3		;reserve bank 3
	LD	C,2
	CALL	@BANK
ERR1	LD	HL,MESS6	;abort on error
	JR	NZ,ERR
	LD	B,3		;reserve bank 2
	LD	C,1
	CALL	@BANK
	LD	A,(OPREG$)
	AND	8EH
	LD	B,A
	LD	A,(CHG7)
	OR	B
	LD	(CHG7),A
	LD	A,(CHG9)
	OR	B
	LD	(CHG9),A
CONT4	POP	HL		;restore command line pointer
	LD	DE,PARAMS	;parse parameters
	CALL	@PARAM
	LD	DE,0		;does the user want us to
FAST	EQU	$-2		;invoke fast mode?
	DI
	LD	HL,MODOUT$	;get modout port image
	LD	A,D		;set fast mode?
	OR	E
	JR	Z,CONT2
	SET	6,(HL)		;yes, set fast bit
	LD	A,(HL)		;in port images
	OUT	(MODOUT),A	;and set fast mode
	LD	A,01H		;make rom image writeable
	OUT	(OPREG),A
	LD	HL,SFLAG$
	SET	3,(HL)		;Set fast flag in system flags
	LD	A,(OSVER$)	;Is this 5.1 or 5.3?
	CP	51H
	JR	Z,V51
	LD	A,55H		;if 5.3,
	LD	(4762H),A	;Adjust clock timer in sys0
	JR	CONT2		;else
V51	LD	A,0CH		;Adjust clock and blink
	LD	(COUNT1),A	;Timers in rom image
	LD	A,3CH
	LD	(COUNT2),A
CONT2	LD	A,02H		;map video into highmem
	OUT	(OPREG),A
	LD	HL,PAGE2	;clear page 2
	LD	DE,PAGE2+1
	LD	BC,3FFH
	LD	(HL),' '
	LDIR
	LD	HL,MESS1	;and put partition 2 notice
	LD	DE,PAGE2	;there.
	LD	BC,LENM1
	LDIR
	XOR	A		;return to normal map
	OUT	(OPREG),A
	LD	HL,@EXIT	;put @exit on the stack
	PUSH	HL
	LD	HL,(HIGH$)	;get old high$
	LD	(NEXTMOD),HL	;save it in module header
	PUSH	HL		;save it on stack
	LD	BC,MODEND-PART3-1
	SBC	HL,BC		;Start patching absolute
	LD	(REL2),HL	;references to module
	POP	HL
	LD	BC,MODLEN
	LD	(OLDSTK),SP	;save current stack pointer
	SBC	HL,BC		;in module
	LD	(HIGH$),HL	;set new high$
	INC	HL
	PUSH	HL
	PUSH	HL
	PUSH	HL
	LD	DE,REBOOT-MODULE
	ADD	HL,DE
	LD	(REL10),HL
	LD	DE,OLDSTK-REBOOT
	ADD	HL,DE
	LD	(REL6),HL
	POP	DE
	LD	A,(INTVEC)	;save old interrupt vector
	LD	HL,(INTVEC+1)
	LD	(OLDVEC),A
	LD	(OLDVEC+1),HL
	LD	A,0C3H		;and set ours
	LD	(INTVEC),A
	LD	(INTVEC+1),DE
	LD	(INTHLD),DE	;and save it for soft reset
	LD	HL,MODULE	;copy module to high memory
	LDIR
	LD	DE,CPYBUF	;copy high memory
	LD	HL,0
	POP	BC
	SBC	HL,BC
	PUSH	HL
	POP	BC
	POP	HL
	PUSH	BC
	LDIR			;to low memory
	LD	A,30H		;copy patched high memory
	OUT	(OPREG),A	;routines to bank 3
	LD	HL,CPYBUF
	LD	DE,(HIGH$)
	INC	DE
	POP	BC
	LDIR
	LD	A,23H		;switch in bank 2 and switch
	OUT	(OPREG),A	;out video
	LD	HL,LOWRAM
	LD	DE,HIBANK+4000H
	LD	BC,4000H
	LDIR
	LD	HL,PART4	;copy part 4 to ram shadowed by
	LD	DE,VIDEO	;video
	LD	BC,LENP4
	LDIR
;PATCH BOOT CODE FOR SWITCHING BANK 0 AND 1 AND ROM BACK IN
	LD	A,01H
	OUT	(OPREG),A	;Make rom image writeable
	LD	A,0C3H		;patch reset code
	LD	HL,(HIGH$)	;to call routine in module
	LD	DE,REBOOT-MODULE+1
	ADD	HL,DE		;that will switch the rom back
	LD	(0),A		;in
	LD	(1),HL
	LD	A,(OPREG$)
	OUT	(OPREG),A	;swap in "normal" memory map
;Is DO active?
	LD	HL,SFLAG$
	BIT	5,(HL)
	JR	Z,NODO
;Yes, do we want to cancel it in partition 2?
	LD	DE,-1
ABORTF	EQU	$-2
	LD	A,D
	OR	E
	JR	Z,NODO
;Cancel active DO in partition 2
	RES	5,(HL)		;mark DO inactive
	XOR	A
	LD	(JFCB$),A	;Mark job FCB closed
	LD	HL,(KIVSAV)	;Restore *KI vector
	LD	(KIDCB$+1),HL
	LD	DE,KIDCB$	;clear typeahead buffer
	CALL	@CTL
	LD	HL,JPSAV
	LD	DE,@EXIT	;Restore @EXIT and @ABORT
	LD	BC,6		;vectors
	LDIR
	LD	A,(KFLAG$)
	AND	0F8H		;make sure enter, break, pause
	LD	(KFLAG$),A	;flags are off
	LD	A,3		;map out video
	OUT	(OPREG),A
	XOR	A
	CALL	VIDEO
NODO	LD	A,0		;switch in partition 1
CHG9	EQU	$-1
	OUT	(OPREG),A
	EI
	JP	@EXIT
;REL TABLE
RELS	DW	REL2,REL6
	DW	REL10
	DW	0
;
;	PART 2
;
MODULE	JR	START		;module header: skip to main code
NEXTMOD	DW	$-$		;end of module goes here
	DB	6,'DDUTY3'	;module name length and name
STKHDR	DW	0,0,0,0,0,0,0	;space to store all registers
	DW	0,0,0,0,0
REBOOT	DI			;reboot routine: disable interrupts
	XOR	A		;set mode 0 memory map
	OUT	(OPREG),A	;with lower 64k mapped in
	INC	A		;map in 4P boot rom
	OUT	(BOOT),A
	RST	0		;and execute reboot
START	PUSH	AF
	LD	A,(KEYROW7)	;has control-right-shift
	AND	6
	CP	06H		;been pressed?
	JR	NZ,INTT		;no, continue with interrupt processing
	POP	AF		;restore af
	PUSH	HL		;save hl
	LD	HL,PART3	;get start of part 3
REL2	EQU	$-2
	EX	(SP),HL		;and put it on stack, restoring HL
	JR	OLDVEC		;and continue with interrupt processing
INTT	POP	AF
OLDVEC	JP	$-$
;
;	PART 3.1
;
PART3	DI			;disable interrupts
	PUSH	AF		;save af
LOOP	LD	A,(KEYROW7)	;scan row 7
	BIT	0,A		;is left shift pressed also?
	JR	NZ,RESET	;go soft reset if so
	OR	A		;have the keys been released?
	JR	NZ,LOOP		;loop til they have
	XOR	A
	OUT	(0E4H),A
	POP	AF
	LD	(OLDSTK),SP
REL6	EQU	$-2
	LD	SP,REBOOT
REL10	EQU	$-2
	PUSH	AF
	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	IX
	PUSH	IY
	EX	AF,AF'
	PUSH	AF
	EXX
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	A,03H
	OUT	(OPREG),A
	CALL	VIDEO
	LD	A,0
CHG7	EQU	$-1
	OUT	(OPREG),A
	LD	A,(MODOUT$)
	OUT	(MODOUT),A
	POP	HL
	POP	DE
	POP	BC
	EXX
	POP	AF
	EX	AF,AF'
	POP	IY
	POP	IX
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	LD	SP,$-$
OLDSTK	EQU	$-2
	EI
	RET
RESET	LD	A,(KEYROW7)
	CP	00H
	JR	NZ,RESET
	POP	AF
	LD	A,0C3H
	LD	HL,$-$
INTHLD	EQU	$-2
	LD	(INTVEC),A
	LD	(INTVEC+1),HL
	EI
	JP	@EXIT
MODEND	EQU	$
MODLEN	EQU	$-MODULE
;
;	PART 4
;
PART4	POP	HL
	LD	(RETURN),HL
	LD	HL,TIME$	;copy current time to storage
	LD	DE,TIMSTR
	LD	BC,6
	LDIR
	LD	HL,DCT$		;copy current DCT's to storage
	LD	BC,8*10
	LDIR
	LD	A,23H		;put bank 2 in high memory
	OUT	(OPREG),A
	LD	HL,LOWRAM	;copy high half of low memory
	LD	DE,HIBANK	;to bottom half of bank 2
	LD	BC,4000H	;we now have a large workspace
	LDIR			;cleared
	LD	A,03H		;map bank 1 into high mem
	OUT	(OPREG),A
	LD	HL,HIBANK	;copy 1st quarter of high mem
	LD	DE,LOWRAM	;to low mem
	LD	BC,2000H
	LDIR
	LD	A,33H		;map bank 3 into high mem
	OUT	(OPREG),A
	LD	HL,HIBANK	;copy 1st quarter of saved bank
	LD	BC,2000H	;to low mem
	LDIR
	LD	HL,LOWRAM	;copy 1st quarter of high mem
	LD	DE,HIBANK	;from low mem to saved bank
	LD	BC,2000H
	LDIR
	LD	A,3		;map bank 1 into high mem
	OUT	(OPREG),A
	LD	DE,HIBANK	;copy 1st quarter of saved bank
	LD	BC,2000H	;from low mem to high mem
	LDIR
	EX	DE,HL		;copy 2nd quarter of saved bank
	LD	DE,LOWRAM	;to low mem
	LD	BC,2000H
	LDIR
	LD	A,33H		;map bank 3 into high mem
	OUT	(OPREG),A
	LD	HL,HIBANK+2000H	;copy 2nd quarter of saved bank
	LD	BC,2000H	;to low mem
	LDIR
	LD	HL,LOWRAM	;copy 2nd quarter of high mem
	LD	DE,HIBANK+2000H	;from low mem to saved bank
	LD	BC,2000H
	LDIR
	LD	A,03H		;map bank 1 into high mem
	OUT	(OPREG),A
	LD	DE,HIBANK+2000H	;copy 2nd quarter of saved bank
	LD	BC,2000H	;from low mem to high mem
	LDIR
	EX	DE,HL		;copy 3rd quarter of high mem
	LD	DE,LOWRAM	;to low mem
	LD	BC,2000H
	LDIR
	LD	A,33H		;map bank 3 into high mem
	OUT	(OPREG),A
	LD	HL,HIBANK+4000H	;copy 3rd quarter of saved bank
	LD	BC,2000H	;to low mem
	LDIR
	LD	HL,LOWRAM	;copy 3rd quarter of high ram
	LD	DE,HIBANK+4000H	;from low mem to saved bank
	LD	BC,2000H
	LDIR
	LD	A,03H
	OUT	(OPREG),A
	LD	DE,HIBANK+4000H	;copy 3rd quarter of saved bank
	LD	BC,2000H	;from low mem to high mem
	LDIR
	EX	DE,HL		;copy 4th quarter of high mem
	LD	DE,LOWRAM	;to low mem
	LD	BC,2000H
	LDIR
	LD	A,33H		;switch in bank 3
	OUT	(OPREG),A
	LD	HL,HIBANK+6000H	;copy 4th quarter of saved bank
	LD	BC,2000H	;to low mem
	LDIR
	LD	HL,LOWRAM	;copy 4th quarter of high mem
	LD	DE,HIBANK+6000H	;from low mem to saved bank
	LD	BC,2000H
	LDIR
	LD	A,3		;switch in bank 1
	OUT	(OPREG),A
	LD	DE,HIBANK+6000H	;copy 4th quarter of saved bank
	LD	BC,2000H	;from low mem to high mem
	LDIR
	LD	A,02H		;map video into high memory
	OUT	(OPREG),A
	LD	DE,LOWRAM	;copy current screen
	LD	HL,PAGE1	;to low memory
	LD	BC,400H
	LDIR
	LD	DE,PAGE1	;copy saved screen
	LD	HL,PAGE2	;to current screen
	LD	BC,400H
	LDIR
	LD	HL,LOWRAM	;copy shadow ram to
	LD	DE,PAGE2	;saved screen
	LD	BC,400H
	LDIR
	LD	A,23H		;SWAP IN BANKS 0 AND 2
	OUT	(OPREG),A
	LD	HL,HIBANK+4000H	;copy saved low ram area
	LD	DE,LOWRAM	;to low mem
	LD	BC,4000H
	LDIR
	LD	HL,HIBANK	;copy original low ram area
	LD	DE,HIBANK+4000H	;to upper half of bank 2
	LD	BC,4000H
	LDIR
	LD	HL,TIMSTR	;copy stored time to time$
	LD	DE,TIME$
	LD	BC,6
	LDIR
	LD	A,03H		;swap in bank 1
	OUT	(OPREG),A
	LD	IX,DCTSTR
	LD	C,8
MAINLP	LD	IY,DCT$
	LD	B,8
	LD	A,(IX)
	CP	0C3H
	JR	NZ,NXTDRV
	BIT	3,(IX+3)
	JR	NZ,NXTDRV
	LD	A,(IX+4)
	AND	0FH
	JR	Z,NXTDRV
	LD	H,A
INNRLP	LD	A,(IY)
	CP	0C3H
	JR	NZ,NEXTDR
	BIT	3,(IY+3)
	JR	NZ,NEXTDR
	LD	A,(IY+4)
	AND	0FH
	CP	H
	JR	NZ,NEXTDR
	LD	A,(IX+3)
	LD	(IY+3),A
	LD	A,(IX+4)
	LD	(IY+4),A
	LD	A,(IX+5)
	LD	(IY+5),A
	LD	A,(IX+6)
	LD	(IY+6),A
	LD	A,(IX+7)
	LD	(IY+7),A
	LD	A,(IX+8)
	LD	(IY+8),A
	LD	A,(IX+9)
	LD	(IY+9),A
	JR	NXTDRV
NEXTDR	LD	DE,10
	ADD	IY,DE
	DJNZ	INNRLP
NXTDRV	LD	DE,10
	ADD	IX,DE
	DEC	C
	JR	NZ,MAINLP
	LD	HL,$-$
RETURN	EQU	VIDEO+$-PART4-2
	JP	(HL)
TIMSTR	EQU	$-PART4+VIDEO
	DS	6
DCTSTR	EQU	$-PART4+VIDEO
	DS	8*10
LENP4	EQU	$-PART4
MESS1	DB	'***  Partition Two  ***'
LENM1	EQU	$-MESS1
MESS2	DB	' <<< DOUBLE DUTY 3 - Copyright (c) 1990 by Richard VanHouten>>>',LF
	DB	'  <<< Based on the program originally by E. Cameron Snyder>>>',LF
	DB	'           <<<Please register this program!!!>>>',CR
MESS3	DB	'DDUTY3 already resident or other CONFLICTING routine resident.  Push RESET and reload.',CR
MESS4	DB	'Too much high memory reserved.  Push RESET and reload.',CR
MESS5	DB	'Extended memory not available.  128k Model 4 required!',CR
MESS6	DB	'Banks 1 and 2 in use!  They are required by this program.',CR
PARAMS	DB	'F     '
	DW	FAST
	DB	'ABORT '
	DW	ABORTF
	DB	0
CPYBUF	EQU	6000H
	END	INIT
