$ ; RAMDV366/ASM - Ram Disk Driver 
. ; REQUIRES - RDEQV364/ASM - Equates file...
, ;	LNW Team - HD64180ROP CPU With 256K Ram
# ;	Model 4/4P  - Z80 CPU 128K Ram
 ;
 ;	UPDATED	9/02/87
$ ; ADDED Support for 2048K Model 4
6 ; ADDED support for Corvus - Writes PDRIVE/DAT file
' ;			     to Floppy - Corvus Support.
* ; Fix   Correct Message Displays again.
% ; Fix   Correctly handles Port 84H
* ; Fix   Corrected Write Return Code ...
 ;
 		5200H
; ;*******************************************************
 ;		Type Flags
@LNW		0	; 1=LNW Computer
! ;			  0=Model 4 or 4P Computer
@MOD4		LNW-1
 ;
-@HD64180		0	; 1=HD64180 Processor 256K Ram
% ;			   MMU will be Used (LNW ONLY)
( ;			   Sorry Model IV Not Written Yet
 ;
' ;			  0=Z80 Cpu With 128K Ram Banked
! ;			   for Low address 0-8000H
  ;			   Model 4 Supported only
@Z80		HD64180-1
+@MUXMEM		1	; Added MUX Memory - Port 148
 ;			  1=Yes 0=No
4 ;                         Memory Support to 2048k
 ;
)@DISP		0	; Display Patch # when called
6 ;                         Used for Debuging Program
: ;******************************************************

 ;		Equates
% 		RDEQV366/ASM	; Get Equates file
: ;******************************************************

 		HD64180
* ;	Find Type of Processor We are Running
 ;		HD64180/Z80H Cpu
 ;
 ;
0HDSTART		0EDH,38H,18H ; HD64180 INO (18H),A
'		3H	     ; IF HD64180 THEN INC BC
 3YR		START 	; HD64180 SYSTEM
 ;
3
R		Z80CPU	; Z80 SYSTEM
 ;
 ;
 ;
s!RZ80CPU		,MTYPEER
3gD		4467H	; DISPLAY ERROR
3-@		402DH
 ;
B*MTYPEER		'***** This MUST be a HD64180ROP Processor ****',0DH
 ;
 	
 ;
< ;********************************************************
#W		'Written By D. Huffman ',0DH
< ;********************************************************
& 		LNW	; Check For Correct Computer
-s:'DSTART		,(4427H) ; Check for NewDos/80
		82H	; Version 2.0 ?
 B		,VERERR
3:+D		,(442BH)
		1	; MODEL 1 NewDos/80 ?
 D		,DOS1ER
$3:1F		,(4631H)	; Corvus Check ..
		88H
3½R		,CORVER	; NOP.....
 ; ALL is Ok Now proceed....
 	 
 ;
' 		MOD4	; Check For Correct Computer
-s:'DSTART		,(4427H) ; Check for NewDos/80
		82H	; Version 2.0 ?
 <		,VERERR
3:+D		,(442BH)
		3	; MODEL 1 NewDos/80 ?
 G		,DOS3ER
$3:E		,(45DCH)	; Corvus Check ..
		88H
3uR		,CORVER	; NOP.....
 ; ALL is Ok Now proceed....
 	 
 ;
 ;	Get Drive # for Ramdisk
 ;
~      		,	; GET Command

		0DH
(
		,CMDER 	; ERROR
+sfSGETCMD1		GETCMD		; GET First Command
 ; Ah Finaly
0		30H	; CONV TO BIN
		5	; Drive 0-4
3uS		,GETCMD2	; GO IF OK
& ; Oh .. Error . Ok display Messages
's!_YCMDER		,MESS1 	; Version Prompt
3̓]		MESOUT
 ;
	 		LNW
3!  		,MESSHD	; LNW MESSAGE
3  		MESOUT
 	
 ;
 ;
 		,LNW
 		MUXMEM
3!Z		,MESS4M	; Mux Message
3̓]		MESOUT
 	
 		,MUXMEM
%3!#Y		,MESS4	; Model 4 Unmodifyed
3͆\		MESOUT
!3!TY		,MESS4P	; 4P Unmodifyed
3͆\		MESOUT
 	
 	
 ;
(3![		,MESER	; And the Error Message
3̓]		MESOUT
3-@		402DH
 ;
-s!\NOMEMER		,MESMER	; ERROR FOR Port 148
3̓]		MESOUT
3-@		402DH
's!~RVERERR		,MESVER	; Display Error
3gD		4467H
3-@		402DH
 ;
)s!RDOS1ER		,MESDOS1	; Dos Error Type
3gD		4467H
3-@		402DH
 ;
(s!RDOS3ER		,MESDOS3	; Dos III Error
3gD		4467H
3-@		402DH
 ;
1s!+SCORVER		,MESCVER	; Corvus error Check Mes
3gD		4467H
3-@		402DH
 ;
E*MESVER		'***** This Program MUST Run on NewDos/80 2.0 *****',0DH
O*MESDOS1		'**  This Version of RamDisk is for Model I NewDos/80 2.0 **',0DH
Q*MESDOS3		'* This Version of RamDisk is for Model III/IV NewDos/80 2.0 *',0DH
N*MESCVER		'* This Version of RamDisk MUST Run on the Floppy ....    *',0DH
 ;
 ;
 A~GETCMD 		,	; Get Commands
#		
 		' '
(		,GETCMD 
,		','
(		,GETCMD 
:		':'
(		,GETCMD 
	
 ;
 ;
/s2VGETCMD2		(DRIVE),	; SET IN DRIVE VALUES
%3fS		GETCMD		; GET next Command ?

		0DH		; IS CR?
$(		,GETCMD3	; NO more Commands
W		'W'
-(		,WRITEPD ; Set flag for PDRIVE Write
w		'w'
(		,WRITEPD ; DIDO
3<R		CMDER		; BAD Command
 ;
 R>
WRITEPD		,10	; WRITE FLAG
32^Y		(PDWRITE),	; Set it
 ;
2 ; JUST for My Sanity We will Attempt to set 148
+R۔GETCMD3		,(148)	; Get Port if exists
:		0,
Ӕ		(148),
 ;
 		MOD4
 ; Removed Port Mask Setup
 ;
 		MUXMEM
/۔      		,(148)		; Check for more memory 
 ;				  Mux is Installed ?
		255		; Assume No Memory
3QR		,NOMEMER; NOP
 	
' ; Setup and relocate to top of himem
4*D		,(HIMEM)	; GET HIMEM
3 ; BUT FIRST Check if we are already installed...
~		,+4)
$		0CDH		; Check for CALL 4723H
% 		,GETLA	; NOP USE NEW ADDRESS
~		,+5)
#		23H		; ?
 		,GETLA
~		,+6)
G		47H		; ? 4723H
 		,GETLA
 ; OK IS US.....
n		,+2)
!f		,+3)	; Old Himem value

		GETLB
s*DGETLA		,(HIMEM)
*s
GETLB		,PGMEN-PGM	; PROGRAM LENGTH
(3" 		(HIMEM1),	; Save for Next boot
		
"R		,		; HL=NEW START OF PGM
3"V		(NEWLOC),	; SAVE IT
+		
+				; SUB 2
3"D		(HIMEM),	; SAVE HIMEM
#		
#				; PUT IT BACK
3 		,PGM
		
R		,		; HL = OFFSET
3"V		(OFFSET),	; SAVE IT
#3:T		,(RELNM)	; GET # IN TABLE
G		,
%4!
T      		,RELTBL 	; GET TABLE
BGETLP1				; SAVE IT
4"S		(IXBYTE),
%*		LDIX  		; LD IX,(XX) - OPCODE

@IXBYTE		2
4"S		(LOCBYTE),	; SAVE
4"S		(LOCBYT1),
[		LDDE		; LD DE,(LOCBYTE)
@LOCBYTE		2
3*V		,(OFFSET)
		,		; ADD OFFSET
"		STHL		; LD (LOCBYT1),HL
@LOCBYT1		2
				; GET IT BACK
	#		
#				; BUMP +2
		GETLP1		; DO LOOP
 ;
3UT		GETLPEN		; CONTINUE
 ;
< ;--------------------------------------------------------
 ;		Relocation Table
 ;
 		MUXMEM
&$RELNM		36	; # OF ENTERYS IN TABLE
 	
 		,MUXMEM
"RELNM		34
 	
 ;
 ; Relocation the Hard Way...
+TRELTBL		ADDR1+1		; Relocation address
CU		ADDR2+1
IU		ADDR3+1
LU		ADDR4+1
OU		ADDR5+1
RU		ADDR6+1
UU		ADDR7+1
XU		ADDR8+1
^U		ADDR9+1
iU		ADDR10+1
tU		ADDR11+1
U		ADDR12+1
U		ADDR13+1
		ADDR14+1
		ADDR15+1
Z		ADDR16+1
		ADDR17+1
		ADDR18+1
		ADDR19+1
		ADDR20+1
		ADDR21+1
		ADDR22+1
E		ADDR23+1
		ADDR24+1
		ADDR25+1
ҁ		ADDR26+1
		ADDR27+1
(		ADDR28+1
=		ADDR29+1
O		ADDR30+1
U		ADDR31+1
		ADDR32+1
 		MUXMEM
d		ADDR33+1
V		ADDR34+1
 	
 ;
		SEC3+1
7		PATCH2A+1
 ;
 ;
A GETLPEN				; CONTINUE HERE
 	
 ;
' ; Get Fourth Pdrive for New Drive #4
9 ; This will be the prive for the Ram Driver no matter 
 ; where we install it.
 ;
(3!HW		,BOOTSYS	; GET BOOT/SYS Sector
3V		,FCB
#3D		441CH		; Extract File spec
3
V		,BOOTER	; Got error
3V		,FCB
3!HV		,BUFFER
 		,0		; 256 Byte sectors
3$D		4424H		; Open Boot/sys
3
V		,BOOTER
36D		4436H		; Sector 1
3
V		,BOOTER
36D		4436H		;        2
3
V		,BOOTER
36D		4436H		;        3
3
V		,BOOTER
3(D		4428H		; Close it
3
V		,BOOTER
 ;
 ;
+3:^Y		,(PDWRITE)	; CHECK if we need to 

		10		; write the file
 H		,CONT1	; NOPE
 ;
( ; Print Message for Pdrive Write.....
 ;
3!a]		,PDMESS
3gD		4467H
 ;
 ;

		,255
> 		,0		; ZERO out Buffer
!3!\W		,BUFFER1	; CLEAR Buffer
AwLOOPPD		,
#		
		LOOPPD
 ;
# ; Open Pdrive/dat on Floppy Disk
)3!QW		,PDFILE  	; GET PDRIVE/DAT FILE
3V		,FCB 
#3D		441CH		; Extract File spec
3
V		,BOOTER	; Got error
3V		,FCB 
3!\W		,BUFFER1	; NEW BUFFER
 		,0		; 256 Byte sectors
3 D		4420H		; Open the file
3
V		,BOOTER
. ; Ok now move Pdrive data to current buffer
13!V		,BUFFER+40H ; Start of buffer #4 Pdrive
$3\W     		,BUFFER1	; NEW Buffer
&3 		,16		; We only Need first 10
 ;				  What the Hay
				; MOVE IT
 ;
3V		,FCB
3!\X		,BUFFER0
"39D		4439H		; Write the Sector
3
V		,BOOTER
 ;
3(D		4428H		; Close it
3
V		,BOOTER
 ;
 ; Now get Fourth Pdrive
ACONT1			; For safety
 		MOD4
< ;********************************************************
; ;***** Ok now Move New Copy of Ramdisk to Correct Loc **
3! 		,PGM		; START
+4[V		,(NEWLOC)	; NEW ADDRESS LOCATION
3
		,PGMEN-PGM
				; MOVE IT
 	
 ;
13!V		,BUFFER+40H ; Start of buffer #4 Pdrive
+sADDR1		,PDRIVE	; Pdrive for Slot #4

3 		,16
				; MOVE IT
 ;
 		Z80	; MODEL 4 WITH Z80
 		MOD4
 		MUXMEM	; MUX MEMORY ADDED
/۔      		,(148)		; Check for more memory 
 ;				  Mux is Installed ?
		255		; Assume No Memory
3QR		,NOMEMER; NOP
 ; AH We do have more memory
(:˿		7,	; Enable Z80 Port Addressing
&:		0,	; Enable First bank of Mux
Ӕ		(148),
$3!Z		,MESS4M	; Message for disp
'3"\Y		(MESS44P),	; SAVE FOR DISPLAY
3 ;                      		 Maximum # of sectors .
  ;				  For Safety in case the
 ;				  Pdrive is set wrong
3! 		,7936		; 2048K  2 MEG

;		ADDR2
 	
 ; Now Check if Model 4 or 4P
s:  NOMORE 		,(0)
G		,	; SAVE THE BYTE
>     		,1
ӄ		(84H),
32  		(0),
		
ӄ		(84H),
3:  		,(0)	; GET THE BYTE
			1
(		,MODEL4P ; IS A 4P
 ;

@MODEL4		$
3:L		,(PORTMSK)
ӄ		(84H),		; RESET PORT
3! Z      		,MESS4
'3"\Y		(MESS44P),	; SAVE FOR DISPLAY
%3!@		,320		; # OF SECTORS MAX 4 
&		ADDR2 		; GO CHECK IF MORE MEM
 ;
R>MODEL4P		,1
ӄ		(84H),	; BANK IN RAM
x		,	; GET BYTE 
32  		(0),	; PUT IT BACK
$3:L	 	,(PORTMSK); GET PORT MASK
+ӄ		(84H),	; BANK IN ROM/WRITE PROTECT
 ;
3!QZ		,MESS4P
'3"\Y		(MESS44P),	; SAVE FOR DISPLAY
$3! 		,256		; MAX # OF SECTORS 4
 	
 	
* ; MAKE CHANGES HERE FOR HD64180 IN 4/4P

 		HD64180
"3! 		,768		; MAX # OF SECTORS
 	
 ;
	 		LNW
"3! 		,768		; MAX # OF SECTORS
 	
 ;
$s"ADDR2		(SECTOR+1),	; SAVE IT
 ;

 		HD64180
; ;*******************************************************
 ;		HD64180 MMU
, ;	Config MMU for 32K Boundrys 8000H-FFFFH
 ;
 >     		,128		; CBAR VALUE
 		0EDH	; OPCODE  OUTO (m),g
9		39H
!:		3AH	; PORT 3AH CBAR OF MMU
 ;
; ;*******************************************************
 	
 ;patch Ramdrive into DOS
/s:VPATCH		,(DRIVE)	; Get Drive # for Patch
0s2
ADDR3  		(PAT0+1),	; SET IN DRIVE VALUES
s2ADDR4  		(PAT1+1),
s2)ADDR5		(PAT2+1),
s2ADDR6		(PAT3+1),
s2ADDR7		(PAT4+1),
 ;
s!ADDR8		,PATCH0
3"G		(PATAD0),
 ;
&s!ADDR9  		,PATCH1	; FIRST PATCH
>		,0C3H		; JP
32#G		(PATAD1),
3"$G		(PATAD1A),
 ;
s!%ADDR10 		,PATCH2
>		,0CDH		; CALL BYTE
32^G		(PATAD2),
3"_G		(PATAD2A),
 ;
s!ADDR11		,PATCH3
3"F		(PATAD3),
 ;
0 ; Is Drive 4 - Now Patch Pdrive Check routine
 ;
>		,0CDH		; CALL
32TG		(PATAD4),
s!ADDR12		,PATCH4
"3"UG		(PATAD4A),	; CALL PATCH4
 ;
>		,0CDH
32IG		(PATAD5),
s!ADDR13		,PATCH5
3"JG		(PATAD5A),
 ;
%>		,0C3H		; Patch 6 for SYS6TES
32	D  		(PATAD6),
s!ADDR31		,PATCH6
3"
D  		(PATAD6A),
 ;
>		,5		; 4 DRIVES
32'G		(SYAL),
32B		(SYAL1),
 ;
	
 ;
' ; Check if Ramdisk will be drive 0 ?
&3:V		,(DRIVE)	; get current drive
# 		0		; Are we setting up Dr 0
 H		,PATCHDN	; Nop
4 ; Yes it is .. So we need to copy the Pdrive for 
) ; the Physical drive 0 to the Ram Disk
 ;
3 ; BUFFER Still has Physical Drive 0 Rel Sector 3
) ; And We are Now ON the Ramdisk.......
 ;
 ;
 ; Open Boot/sys on Ramdisk
)3!HW		,BOOTSYS 	; GET BOOT/SYS Sector
3V		,FCB 
#3D		441CH		; Extract File spec
3
V		,BOOTER	; Got error
3V		,FCB 
3!\X		,BUFFER0	; NEW BUFFER
 		,0		; 256 Byte sectors
3$D		4424H		; Open Boot/sys
 J		,BOOTER
36D		4436H		; Sector 1
 E		,BOOTER
36D		4436H		;        2
 @		,BOOTER
36D		4436H		;        3
 ;		,BOOTER
+ ; Ok now copy over old Pdrive to Ramdisk
3!HV		,BUFFER	; Source
3\X		,BUFFER0	; Dest
3 		,16		; 16 Bytes
				; Move them
 ;
3V		,FCB
3ED		4445H		; Backup 1
! (		,BOOTER	; Error recovery
 ;
3!\X		,BUFFER0
"39D		4439H		; Write the Sector
  		,BOOTER
 ;
3(D		4428H		; Close it
 		,BOOTER
 ;
5s:vBPATCHDN		,(LDRV0TK)	; Get Last Track Accessed
-32yB		(LDRV4TK),	; Move to Drive # 4 Slot
! ;				  This is so Dos can find
 ;				  the correct track the
 ;				   first time
 ;
3!_Y		,MESS1	; MESSAGE INIT
3̓]		MESOUT
	 		Z80
*3*\Y		,(MESS44P)	; GET CORRECT MESSAGE
3̓]		MESOUT
 	

 		HD64180
3!Y		,MESSHD
3͆\		MESOUT
 	
3!Z		,MESS2
3̓]		MESOUT
3-@		402DH		; Done
 ;
"s	DBOOTER		4409H		; ERROR EXIT
 ;
'@NEWLOC		2		; NEW ADDRESS FOR RAMDRV
@OFFSET		2		; OFFSET STORAGE
@DRIVE		2		; Patch Drive #
@FCB		50		; FCB BUFFER
'@BUFFER		256		; DOS BUFFER - PDRIVE 
-BBOOTSYS		'BOOT/SYS',0DH ; Boot/sys file 
4PPDFILE		'PDRIVE/DAT',0DH ; File for Pdrive/dat 
 ;				   Written on floppy
 ;
+@BUFFER1		256		; DOS BUFFER - PDRIVE/DAT
(@BUFFER0 	256		; DOS BUFFER - PDRIVE 
 ;
)@MESS44P		2		; Model 4/4P Display Mess
. PDWRITE		0	; Pdrive/dat Write Flag 10=Yes
 ;
A*MESS1		'***********************************************',0DH
A E    		'*        Ramdisk Version 3.66 Installed       *',0DH
<*		'*            Written By D. Huffman            *',0DH
 		MOD4
<*		'*  Bit Mask for Port 84H is at Address 4CFFH  *',0DH
 	
! 		0	; END OF MESSAGE SEGMENT
 ;
C*MESS4		'*        Model 4 - 320 Sectors Maximum        *',0DH,0
 ;
D*MESS4P		'*        Model 4P - 256 Sectors Maximum       *',0DH,0
D*MESS4M		'* Model4/4P-Mux Memory Added-7936 Sectors Max *',0DH,0
D*MESSHD		'*        LNW Team - 768 Sectors Maximum       *',0DH,0
A*MESS2		'***********************************************',0DH

		0DH,0
 ;
O*MESER		'*************************************************************',0DH
O*     		'*                  Illegal Drive Specifyied                 *',0DH
J*		'*  Parameters  --->  RAMDISK <Dn>,<W>                       *',0DH
J*		'*  Example     --->  RAMDISK 4 W                            *',0DH
J*		'*   Creates a RamDisk in Slot #4 and writes PDRIVE/DAT      *',0DH
J*		'*     The RamDisk uses Pdrive #4 in the Pdrive table        *',0DH
F*		'*************************************************************'

		0DH,0
 ;
P*MESMER		'************ PORT 148 (94H) RETURNS 255 (FFH)  **************',0DH
E 		' I Must Assume that the Memory Expansion Doesnt exist   ',0DH
. 		'              I Cannot Proceed ',0DH,0
 ;
4WPDMESS		'Writing Pdrive/dat File to Disk..',0DH
 ;
 ;
A~MESOUT		,	; GET BYTE
	 		0
			; DONE

33 		033H
#		
		MESOUT
 ;
 ;
 ;
; ;*******************************************************
( 		LNW	; Lnw has Ram from 3000H-37DFH
& ;			; But the Illegal Emulator code
 ;			; Starts at 3500H
 		3000H
 	
 		MOD4
 		8000H
 	
 ;
#@PGM		$	;****** START OF RAMDISK
; ;*******************************************************
< ;************* Do Not Change the next 6 Bytes ***********
"@HIMEM1		2	; OLD HIMEM LOCATION
< ;********************************************************
 ;		47ECH		4792H
5 ; * Bypass Drive Select & Test routine IF Ram Disk
1 ;  This Routine is called by SYS6/SYS Directly
s#GPATCH0		PAT0RCM
		
 		DISP

>0		,'0'
$32?		(3FF7H),	; Display Patch #
 	
'3:~B		,(CURDRV)	; GET CURRENT DRIVE
%PAT0		0FEH		; CHECK FOR MEMDRIVE
 		1  		; CP DN#
$ 		,RET0 	;jmp if not Ramdrive
; ; Now check if system 6 is active - We may be Formatting
0s?ADDR14		SYS6TES		; If system 6 then patch
 ;
 				;pop call off of stack

ARET0 		
	
< ;********************************************************
 ;		4776H		4723H
4 ; * Bypass Drive Select If Ram Disk - Normal Call
APATCH1				; SAVE IT
'3:~B		,(CURDRV)	; GET CURRENT DRIVE
%PAT1		0FEH		; CHECK FOR MEMDRIVE
 		1  		; CP DN#
$ 		,RET1 	;jmp if not Ramdrive
 		DISP

>1		,'1'
$32?		(3FF8H),	; Display Patch #
 	
$ ; Now check if system 6 is active
0s?ADDR15		SYS6TES		; If system 6 then patch
 ;
ARET1				;pop AF back ...
     				; Replace cmd
		
		
+3&G		PAT1END 	; GO we replaced the cmds
< ;********************************************************
 ;	47ADH		475EH
; ;* Bypass Controller Init for the Read/Write IF Ram Disk
-s:~BPATCH2		,(CURDRV)	; GET CURRENT DRIVE
%PAT2		0FEH		; CHECK FOR MEMDRIVE
 		1  		; CP DN#
 ;
	 		LNW
 3!7		,37ECH 	; Replaced Cmd
 	
 ;
 		MOD4
"3:B		,(4286H)	; Replaced Cmd 
 	
 ;
			;ret if no Ramdrive
 ;
 		DISP

>2		,'2'
$32?		(3FF9H),	; Display Patch #
 	
 		MOD4
(		,(0F0H)	; Get current FDC state
:		7,		; Is it active
 		,PATCH2A
* ; AH Drives are running - shut them off
&		(0F4H),	; Reset drive latches
 	
 ;
	 		LNW
		
' ;	LD	(37E0H),A	; Reset drive latches
 	
 ;
9 ; Is Ram Disk - now check if Drive 0  If so dont patch
 ;
 ;
0s?PATCH2A		SYS6TES	; If system 6 then patch
 ;
+ARET20			;pop calls & pushes off stack
		
		
3ÃG    		PAT2END		;continue
 ;
 ;	SYS6/SYS - Format bypass
6 ; Called if Current drive to be accessed to Ramdisk
2s:~BSYS6TES		,(CURDRV)	; Get current drive agn
	 		0
		 		; Dont patch if 0
13:B        	,(CONFLG1)	; Overlay Address Clt
:_		3,
(<		,SYS6A		; Not SYS6
,3:	M		,(SYS6ID)	; Check if sys is called
 ;				  another overlay
h		68H
				; OOPS Don't patch
+3:lb		,(626CH)	; GET Secondary Check PT
& 		20H		; Has SYS6 Bin Reloaded ?
 		,SYS6T1	; Yes Repatch
,s:ADDR16		,(SYS6FLG)	; PATCH SYS6 FLAG

		10
 		       	; RET IF PATCHED
* ; Ah is active so patch it for Ramdrive
0R>SYS6T1		,0C9H	; By pass Source Dest Check
32oN		(4E6FH),
 ;
!>		,94H	; Change Check Flag
32N		(4EB6H),
,> 		,20H	; Patch Bypass Secondary Check
32lb		(626CH),
 ;
>		,18H	; By pass Prompts
32U		(55BFH),
 ;
# ; 	LD	A,0A0H	; Force Option DDND
 ;   	LD	(5994H),A
 ;
 			; By Pass Format Verify
32Uf		(6655H),
32Vf		(6656H),
32Wf		(6657H),
 ;
#>		,0C9H	; By Pass Formatting
32h      		(SY6BF),
 ;
 		DISP

>P		,'P'
32?		(3FFEH),
 	
>
		,10
+s2ADDR17		(SYS6FLG),	; SET PATCH FLAG
 ;
	

ASYS6A		
's2ADDR18		(SYS6FLG),	; Reset flag
 		DISP

>U		,'U'
32?		(3FFEH),
 	
	
 ;
; ;*******************************************************
$@SYS6FLG		2	; System 6 Patch flag
; ;*******************************************************
 ;	465CH		4607H
5 ;* This The Actual Ramdisk Sector Read/Write Patch
-s:~BPATCH3		,(CURDRV)	; GET CURRENT DRIVE
%PAT3		0FEH		; Check for Ramdisk 
 		1  		; CP DN#
&3 G		,PAT3END	;jmp if not ramdisk
 ;
 		DISP

>3		,'3'
$32?		(3FFAH),	; Display Patch #
 	
 				;pop call off of stack
				;save registers
			; Rel sector
			; Buffer area
				;disable interrupt
&		,	;HL=relative sector to read
SECTOR		11H		; LD DE,XXXXX
 		2		; SECTOR MAX
		
		
R		,
		
4s5ADDR22		,BADREC;jmp if sector not in Ramdisk
1 ; Check IF We are accessing  Directory Sectors
				; Save it
				; DE=HL
		
"3:B		,(DIRLMP)	; Get Dir Lump
O		,
				; Zero a
b		,
G		,
#			,		; Multiply Dir Lump * 5
)		,
)		,
			,
$3:B		,(DIRGRN)	; Grans per Lump
=		
		
		
)A	SECLP1		,		; Multiply dir Lump/Sec
=		
 		,SECLP1
6 ; HL=Starting Sector of DIR ( DL * GRANS/LUMP * 5 )
			18H		; Compare HL TO DE
 (		,SECDIR	; IS DIR sector
0		,SEC3A	; Before Dir
0 ; Sector is beyond the start of the Directory
		
		
 3	 		,9		; Offset in Pdrive
,3*B		,(PDRADD)	; Address of current pdr
		,		; Point to DDGA
~		,		; Get it
		
		
G		,		; Multiply * 5
		,
		,
		,
O		,
 		,0
			,
			18H		; Compare HL to DE
(		,SEC3A		; Past end
8		,SEC3A		; Past end
"R> SECDIR		,32		; Read Protect
		SEC3
R> SEC3A		,0
3s22SEC3 		(STATUS+1),	; Reset Read Protect Sec
				; Get it back
 ; Cal bank value
3 		,128	; # Sectors/Bank
		,1	; set first bank
ASEC1		
R		,	; Sub 128
 8		,SEC2	; Go if less than
			; bump bank ptr
		SEC1
$AySEC2		,		; A = BANK # 1 to 14
0s^ADDR19		CALPAGE		; Find Byte for bank Cmd
/s2!ADDR20		(READ+1),	; A = Command for MMU
 		MOD4
#3:L		,(PORTMSK)	; Get Bit Mask
#s2ADDR27		(PORT84),	; Save it
 	
 ; Now Cal Rel Sec in bank
		
		,		; Get Rel Sec
 ; HL=Rel Sector in Bank

 ; C=Bank #
, ; Now set HL=to address of Sector in Bank
 ; HL Cannot be > 128
				; Zero a
				; is 0 ?
'(		,SEC5		; Is start of next bank
E		,  		; # of Sectors
#3 		,256		; # of Bytes/Sector
3!  		,00H  	; Base Address
    		
ASEC4		,
		SEC4		; HL=B*256
 ;
! 		HD64180		; Bank High by MMU
's SEC5 		,8000H	; Offset to 8000H
		
		,
 	
 		,HD64180
A SEC5	
 ;HL=Rel address from 0000H
 	
 ;HL=Address of Sector
				;pop buffer address
		
 ;
&3:F		,(CURFDC)	; BYTE FOR FDC CMD
 		20H
$ 		,WRITE	;jmp if write sector
 ;
< ;********************************************************
 ;		READ A SECTOR
 		,0
*R> READ		,0	;A=bank to read/write from
< ;--------------------------------------------------------

 		HD64180
 		0EDH	; OPCODE  OUTO (m),g
9		39H
 8		38H	; PORT 38H CBR OF MMU
 ;			  Bank in Ram
 	
	 		Z80
ӄ		(84H),	; BANK IN RAM
 	
< ;--------------------------------------------------------
N		,		;get character
##			;add 1 to Ramdrive address
		 		; PAGE IN 0
< ;--------------------------------------------------------

 		HD64180
 		0EDH	; OPCODE  OUTO (m),g
9		39H
 8		38H	; PORT 38H CBR OF MMU
 ;			 Bank it out
 	
	 		Z80
 		MOD4
's:ADDR28		,(PORT84)	; Normal Mask
 	
ӄ		(84H),	; BANK OUT RAM
 	
< ;--------------------------------------------------------
y		,
 		,		;save byte to buffer
"				;add 1 to buffer address
&		READ	;continue  256 bytes read
; ;*******************************************************
 ;
3R> STATUS		,0	;read protect status if directory
		RET3 		;continue in DOS
"R>BADREC		,0C1H		;Error code 
		RET3		;continue in DOS
 ;
< ;********************************************************
 ;	WRITE A SECTOR
R WRITE		,0
AWRITE1		
< ;--------------------------------------------------------

 		HD64180
 		0EDH	; OPCODE  OUTO (m),g
9		39H
 8		38H	; PORT 38H CBR OF MMU
 ;			  Bank it out
 	
	 		Z80
 		MOD4
's:ADDR29		,(PORT84)	; Normal Mask
 	
$ӄ		(84H),	; BANK OUT RAM IF IN
 	
; ;-------------------------------------------------------
#		,		;get character to write
O		,
				;add 1 to buffer
s:!ADDR23 		,(READ+1)
; ;-------------------------------------------------------

 		HD64180
 		0EDH	; OPCODE  OUTO (m),g
9		39H
 8		38H	; PORT 38H CBR OF MMU
 ;			  Bank it in
 	
	 		Z80
ӄ		(84H),	; BANK IN RAM
 	
< ;--------------------------------------------------------
q		,		;write character
##			;add 1 to Ramdrive address
(		WRITE1	;continue write 256 times
		
< ;--------------------------------------------------------

 		HD64180
 		0EDH	; OPCODE  OUTO (m),g
9		39H
 8		38H	; PORT 38H CBR OF MMU
 ;			   Bank it out
 	
	 		Z80
 		MOD4
's:ADDR30		,(PORT84)	; Normal Mask
 	
ӄ		(84H),	; BANK OUT RAM
 	
 ;
< ;--------------------------------------------------------
 ;
 				; Set Good Return Code
 ;
#A RET3				; Patch Area for Debug
	 		Z80
 		MUXMEM	; Added Memory
 			; SAVE READ STATUS FLAG
*s:ADDR34		,(PORT148)	; GET ORIG BITS
Ӕ		(148),
		
 	
 	
&3F    		PAT3CON		;continue in DOS
 ;
	 		Z80
 		MOD4
! 		,MUXMEM	; ADDED MUX MEMORY
< ;********************************************************
" ;		CALPAGE - SETUP PAGE FOR MMU
& ;		   96K 1 to 3  Pages for Model 4
' ;		   64K 1 to 2  Pages for Model 4P
 ;	ENTER	A = PAGE # 1TO3 
' ;	EXIT	A = Command Byte for Port 84H
 ;
 ;
ACALPAGE		
.c		,63H	; Bank 1
			1
(		,CALEN
.s		,73H	; Bank 2
			2
(		,CALEN
.		,3H	; Bank 3
1s:LCALEN		,(PORTMSK)	; GET PORT  84 bit mask
		
		
	
 	
 	
 	
< ;********************************************************

 		HD64180
< ;********************************************************
" ;		CALPAGE - SETUP PAGE FOR MMU
 ;		  256K =  1 TO 14 PAGES
 ;	ENTER	A = PAGE # 1TO14
" ;	EXIT	A = Command Byte for MMU
 ;
 ;
ACALPAGE		
o		,
&       		,8		; FACTOR
		0EDH		; MLT - MULTIPLY
l		6CH		; H X L
 ; HL HAS RESULTS
}		,		; GET LSB
 ;
		
	
 ;
< ;********************************************************
 	
	 		Z80
( 		MUXMEM	; ADDED Mux Memory Port 148
< ;********************************************************
" ;		CALPAGE - SETUP PAGE FOR MMU
6 ;          1 TO 31 Pages 2,031,616 Bytes of Ramdisk
 ;
 ;
 ;	ENTER	A = PAGE # 1TO3 
' ;	EXIT	A = Command Byte for Port 84H
 ;
 ;
ACALPAGE		
		
o		,	; SAVE IT
۔		,(148) ; GET BITS
0s2ADDR33		(PORT148), ; Save Bits for later
g		,	; SAVE H
}		,	; PUT A BACK
 ;
.c		,63H	; Bank 1
			1
(		,CALEN
.s		,73H	; Bank 2
			2
(		,CALEN
5 ; OK Its more that 64K We will assume extra Memory
 ;
.s		,73H	; Even page
:G		0,	; Is it an even # ?
(		,CALEVEN
 ; IS AN ODD #
.c		,63H	; Odd page
<			; BUMP UP TO EVEN #
)RCALEVEN		31  	; Mask off upper bits
! 			; Just incase we screwed up
			; Clear Carry if set
			; Divide / 2
O		,	; Save bottom 5 Bits
|		,
!		224	; Mask off lower bits
			; Mix together
 ; Ah .... about time ....
&Ӕ		(148),	; Set Extra Memory Mux
 		MOD4	; Is Z80 & MOD4
1s:LCALEN		,(PORTMSK)	; GET PORT  84 bit mask
			; Mix A & L
		
		
	
 	
 		,MOD4
A}CALEN		,
		
		
	
 	
 ;
< ;********************************************************
 	
 	
 ;
; ;*******************************************************
 ;	47A3H		4754H
; ;* Patch in Pdrive Prammeters IF Ramdisk or Swaped Drive
 ;
APATCH4			; Save AF
)3:~B		,(CURDRV)	; Check Current Drive
#PAT4		0FEH		; Check if Ramdisk
 		1		; Patch byte
 		,PATCH41	; Nop
 ;
 		DISP

>4		,'4'
$32?		(3FFBH),	; Display Patch #
 	
/ ; Is us - Load in ower Pdrive for Mem Drive 
/s!ADDR21		,PDRIVE	; SET HL=DRIVE 4 PDRIVE
APATCH42		
3"B		(PDRADD),
				; CONTINUE
 ;
 RPATCH41		4		; IS DRIVE 4 ?
 		,PATCH42	; NOP
/ ; Is Drive # 4 - AND This is not the Ramdisk
( ; - Now set Pdrive for Replaced drive
 3!B		,PDRTBL	; Pdrive Table
-s:ADDR24		,(PAT1+1)	; Get patched drive
 		0		; Is it drive 0 ?
%(		,PATCH42	; HL=DRIVE 0 PDRIVE
				; Save it
		
3
 		,10		; # of enterys
G		,		; Set up counter
APAT4LP1		,		; BUMP 10
		PAT4LP1
       		
		
		PATCH42
< ;********************************************************
 ;	4798H			4749H
5 ;* Patch in Physical Drive Latches IF Swaped Drive
AoPATCH5		,	; Save it
1s:ADDR25		,(PAT1+1)	; Get current Mem drive
		4		; Swap flag
!( 		,PATCH51	; NOTHING TO DO
 ;
 		DISP

>5		,'5'
$32?		(3FFCH),	; Display Patch #
 	
 ; Now check current drive
'3:~B		,(CURDRV)	; Get current drive
			4
 		,PATCH51	; DO NOTHING
		
.3:B		,(CURDCMD)	; Get Current bit setting
$		0F0H		; Mask of low bits 0-3
O		,		; save
-s:ADDR26 		,(PAT1+1)	; Get Swaped Drive
 G		,		; Save to B for loop
 		0		; Is it dr0 ?
>		,1
(		,PATCH54	; IS drive 0
"ZPATCH52				; ROTATE 1 2 4 8
		PATCH52
!APATCH54				; OR in bits 4-7
       		
		PATCH53
A}PATCH51 	,
%s2BPATCH53		(CURDCMD),	; DO INST
	
 ;
: ;******************************************************
 ;	4C19H		4BBEH
: ; Patch for SYS6 incase we get an error and reload SYS6
 ;
APATCH6		
 		DISP

> 		,'6'
32?		(3FFDH),
 	
		
s2ADDR32		(SYS6FLG),
 ;

>&		,26H
 ;
3D		PAT6END 
 ;
: ;******************************************************
 		MOD4
%@PORT84		2	; Port Mask for Model 4
 		MUXMEM
0@PORT148		2	; Port Mask for Extra Memory bank
 	
 	
)@PDRIVE		17	; Pdrive Table for Drive 4
 		3
,A PGMEN			; END OF PROGRAM FOR RELOCATION
< ;********************************************************

 		HD64180
 ;			MMU CHART
< ;********************************************************
 ; 			CBAR = 128
 ;		0 TO 32K = BASE AREA
 ;		32 TO 64K = COMMON AREA 1
 ;			BBR = 0
 ;		BANK AREA - NOT USED
 ;
 ;			CBR
 ;
 ; 256 128 64K 32K
9 ; 64  32  16  8  4  2  1    MEM RANGE    BYTE   BANK #
4 ;  0   0   0  0  0  0  0    32 TO 64K    0      1
4 ;  0   0   0  1  0  0  0    64 TO 96K    8      2
4 ;  0   0   1  0  0  0  0    96 TO 128K   16     3
4 ;  0   0   1  1  0  0  0    128 TO 160K  24     4
4 ;  0   1   0  0  0  0  0    160 TO 192K  32     5
4 ;  0   1   0  1  0  0  0    192 TO 224K  40     6
4 ;  0   1   1  0  0  0  0    224 TO 256K  48     7
 ;

 		HDSTART
 	
	 		Z80
 		START
 	
                                                                                                                               