MOD4	EQU	@@4
MOD3	EQU	MOD4.EQ.0
CR	EQU	0DH
SVC	MACRO	#CODE
	LD	A,#CODE
	RST	28H
	ENDM
@CKDRV	EQU	33
@CLOSE	EQU	60
@DIRRD	EQU	87
@DSPLY	EQU	10
@ERROR	EQU	26
@FSPEC	EQU	78
@FEXT	EQU	79
@GTDCT	EQU	81
@OPEN	EQU	59
@RDSEC	EQU	49
@RDSSC	EQU	85
@READ	EQU	67
@REMOV	EQU	57
@SLCT	EQU	41
@WRSEC	EQU	53
@WRSSC	EQU	54
	OPTION	+GC
	IF	MOD4
	ORG	2600H
	ELSE
	ORG	5200H
	ENDIF
RMDIR	LD	(OLDSTK),SP
	LD	A,(HL)
	CP	0DH
	JR	NZ,GOTARGS
	LD	HL,USAGE
	SVC	@DSPLY
	RET
GOTARGS	LD	BC,ERROR
	PUSH	BC
	LD	DE,FCB		;copy dir name to fcb
	SVC	@FSPEC
	LD	A,13H
	RET	NZ		;abort on error
	LD	HL,DEFEXT	;add extension
	SVC	@FEXT
	LD	HL,FCB-1
	LD	DE,DEFEXT
SCAN	INC	HL		;look for drive spec
	LD	A,(HL)
	CP	':'
	JR	Z,FNDDRV	;go if found
	CP	03H
	JR	Z,ADDDRV	;go if no drive found
	CP	'/'
	JR	NZ,SCAN
	LD	B,3
EXTLP	INC	HL
	LD	A,(DE)
	CP	(HL)
	LD	A,19
	RET	NZ
	INC	DE
	DJNZ	EXTLP
	JR	SCAN
ADDDRV	PUSH	HL
	LD	(HL),':'	;add default drive spec
	INC	HL
	LD	(HL),'0'
	INC	HL
	LD	(HL),03H
	POP	HL
FNDDRV	INC	HL
	LD	A,(HL)		;get drive
	SUB	'0'		;convert to binary
	LD	C,A		;and put in C
	SVC	@SLCT		;select the drive
	RET	NZ
	SVC	@CKDRV		;make sure it's ready
	LD	A,08H
	RET	NZ		;abort if not ready
	LD	A,0FH
	RET	C		;or write protected
	SVC	@GTDCT
	LD	HL,GAT		;open the subdir file
	LD	DE,FCB
	LD	B,00H
	SVC	@OPEN
	RET	NZ
	LD	BC,(FCB+6)
	SVC	@DIRRD
	BIT	5,(HL)		;check PDS bit
	LD	HL,NOTSD
	JP	Z,ABORT		;abort if not set
	LD	A,(FCB+7)	;get DEC
	AND	0FEH		;check if 0 or 1
	LD	HL,YURINIT
	JP	Z,ABORT		;abort if parent or current directory
	INC	DE
	LD	A,(DE)		;get status flags
	AND 0F8H		;give ourselves permission
	LD	(DE),A		;to kill it
	DEC	DE
	SVC	@READ		;read gat
	RET	NZ		;abort on error
	LD	HL,HIT		;patch buffer address
	LD	(FCB+3),HL
	SVC	@READ		;read hit
	RET	NZ		;abort on error
	LD	HL,HIT+2	;check to see if the directory is empty
	LD	B,0FEH		;check 254 entries starting after dir entry
CKLP	LD	A,(HL)		;get an entry
	OR	A
	JR	NZ,NOTMPTY	;check if DEC is assigned
	INC	HL
	DJNZ	CKLP
	JR	EMPTY
NOTMPTY	LD	HL,PURGIT	;abort if directory not empty
	JP	ABORT
EMPTY	LD	D,(IY+9)	;get current directory cylinder
	LD	E,00H		;read parent gat
	LD	HL,PRNTGAT
	SVC	@RDSSC
	RET	NZ		;abort on error
	LD	A,(PRNTGAT+0CDH);get grans/cyl
	AND	07H
	INC	A
	BIT	5,(IY+04H)	;check if double sided
	JR	Z,SINGLE
	ADD	A,A		;double grans if double sided
SINGLE	LD	B,A
	LD	A,0FFH		;create mask
SHLP	SLA	A
	DJNZ	SHLP
	LD	(MASK),A
	LD	A,(FCB+14)	;get starting cylinder
	LD	E,A
	LD	D,00H
	ADD	HL,DE		;point to its image in the gat
	LD	A,(MASK)
	LD	(HL),A		;free the track
	LD	A,(PRNTGAT+0CCH);get track count
	ADD	A,35		;add offset
	LD	B,A		;store in B
	LD	HL,GAT
	LD	DE,PRNTGAT
	LD	A,00H		;get mask
MASK	EQU	$-1
SRCHFRE	CP	(HL)		;look for free track in subdir
	JR	NZ,NOTFREE
	LD	(DE),A		;free it in parent
NOTFREE	INC	HL
	INC	DE
	DJNZ	SRCHFRE		;loop til done
	LD	D,(IY+9)	;get parent dir cylinder
	LD	E,00H
	LD	HL,PRNTGAT
	SVC	@WRSSC		;update gat
	RET	NZ		;abort on error
	PUSH	BC
	LD	HL,HIT		;clear hit
	PUSH	HL
	LD	DE,HIT+1
	LD	BC,255
	LD	(HL),00H
	LDIR
	POP	HL
	POP	BC
	LD	A,(FCB+12)	;get ERN
	LD	B,A		;this is number of sectors to write
	LD	A,(FCB+14)	;get cylinder
	LD	D,A
	LD	E,00H
ERASE	SVC	@WRSEC		;erase directory, clearing DAM on floppies
	RET	NZ
	INC	E
	DJNZ	ERASE
	LD	DE,FCB		;kill the record
	SVC	@REMOV
	RET	NZ
	LD	HL,0
EXIT	LD	SP,$-$
OLDSTK	EQU	$-2
	RET
ABORT	PUSH	HL
	LD	HL,NAME
	SVC	@DSPLY
	POP	HL
	SVC	@DSPLY
	POP	HL
	LD	HL,3FH
	JR	EXIT
ERROR	PUSH	AF
	LD	HL,NAME
	SVC	@DSPLY
	POP	AF
	LD	L,A
	LD	H,0
	OR	0C0H
	LD	C,A
	SVC	@ERROR
	JR	EXIT
DEFEXT	DB	'DIR'
NAME	DB	'rmdir: ',03H
PURGIT	DB	'Non-empty directory -- please purge files',0DH
YURINIT	DB	'Can''t remove -- current or parent directory',0DH
NOTSD	DB	'Can''t remove -- not a subdirectory',0DH
USAGE	DB	'Usage: rmdir dir_name:d',0DH
FCB	DS	32
PRNTGAT	DS	256
GAT	DS	256
HIT	DS	256
LAST	EQU	$
	END	RMDIR
