MOD4	EQU	@@4
MOD3	EQU	MOD4.EQ.0
CR	EQU	0DH
SVC	MACRO	#CODE
	LD	A,#CODE
	RST	28H
	ENDM
@CKDRV	EQU	33
@DIRRD	EQU	87
@DSP	EQU	2
@DSPLY	EQU	10
@ERROR	EQU	26
@GTDCT	EQU	81
	OPTION	+GC
	IF	MOD4
	ORG	2600H
	ELSE
	ORG	5200H
	ENDIF
PWD	LD	(OLDSTK),SP	;save stack
	LD	BC,8<8		;B=count of drives to check, C= drive 0
MNLP	LD	(BCSAV),BC	;save current count/drive
	SVC	@GTDCT		;get pointer to current drive's DCT
	LD	A,(IY)		;check if drive is active
	CP	0C9H
	JP	Z,SKIP		;go if it isn't
	LD	A,C
	ADD	A,'0'		;convert drive code to ascii
	LD	(DRIVE),A
	LD	HL,PROMPT	;display current drive name
	SVC	@DSPLY
	SVC	@CKDRV
	JR	Z,DRVOK
	LD	HL,NODISK
	SVC	@DSPLY
	JP	SKIP
DRVOK	LD	HL,PATHSTK
	LD	A,(IY+09H)	;get current working directory
	LD	(HL),A
	INC	HL
	LD	(PATHPTR),HL
	XOR	A
	LD	(PATHLEN),A
TRAVERS	LD	B,00H		;read parent dir record
	SVC	@DIRRD
	JR	NZ,ERROR	;abort on error
	LD	DE,22		;point to starting cyl
	ADD	HL,DE
	LD	A,(HL)
TRAV1	OR	A		;check if in root
	JR	Z,FNDROOT	;go if in root
	LD	HL,$-$		;get path stack pointer
PATHPTR	EQU	$-2
	LD	(HL),A		;save dir cyl in stack
	INC	HL
	LD	(PATHPTR),HL
	LD	(IY+09H),A	;put new dir cyl in DCT
	LD	HL,PATHLEN	;add one to path length
	INC	(HL)
	JR	TRAVERS		;and look for the next one
FNDROOT	LD	B,$-$		;get path length
PATHLEN	EQU	$-1
	LD	HL,(PATHPTR)	;get path pointer
	DEC	HL		;drop root dir entry
	JR	DROP
LOOP	LD	HL,(PATHPTR)
DROP	DEC	HL		;pop a cyl from stack
	LD	A,(HL)
	LD	(IY+09H),A	;stuff it in DCT
	LD	(PATHPTR),HL	;save new stack pointer
	PUSH	BC
	LD	C,'\'		;display a slash
	SVC	@DSP
	POP	BC
	LD	A,(PATHLEN)	;get path length remaining
	OR	A
	JR	Z,DRVDON	;go if drive path is completely displayed
	PUSH	BC
	LD	B,01H		;read current directory record
	SVC	@DIRRD
	POP	BC
	JR	NZ,ERROR	;abort on error
	LD	DE,5		;skip to directory name
	ADD	HL,DE
	PUSH	BC
	LD	B,08H		;count of chars to display
DSPLP	LD	A,(HL)
	CP	' '
	JR	Z,XITLP
	CP	'A'
	JR	C,LOWER		;convert to lower case
	CP	'Z'+1
	JR	NC,LOWER
	OR	' '
LOWER	LD	C,A		;display it
	SVC	@DSP
	INC	HL
	DJNZ	DSPLP
XITLP	POP	BC
	DJNZ	LOOP
DRVDON	LD	C,0DH		;start new line
	SVC	@DSP
	LD	A,(WORKDIR)	;restore original working directory
	LD	(IY+09H),A
SKIP	LD	BC,$-$		;get drive/count
BCSAV	EQU	$-2
	INC	C		;bump drive
	DEC	B
	JP	NZ,MNLP		;count down
	LD	HL,0
EXIT	LD	SP,$-$
OLDSTK	EQU	$-2
	RET
ERROR	OR	0C0H
	PUSH	AF
	LD	HL,NAME
	SVC	@DSPLY
	POP	AF
	LD	C,A
	SVC	@ERROR
	JR	EXIT
NAME	DB	0AH,'pwd: ',03H
PROMPT	DB	'Drive x:  ',03H
DRIVE	EQU	$-5
NODISK	DB	'[No disk]',0DH
WORKDIR	EQU	$
PATHSTK	EQU	$
	END	PWD
