@CKDRV	EQU	33
@CLOSE	EQU	60
@DATE	EQU	18
@DIRRD	EQU	87
@DIRWR	EQU	88
@DSPLY	EQU	10
@ERROR	EQU	26
@FEXT	EQU	79
@FSPEC	EQU	78
@GTDCT	EQU	81
@INIT	EQU	58
@PARAM	EQU	17
@RDSSC	EQU	85
@SLCT	EQU	41
@WRSSC	EQU	54
SVC	MACRO	#CODE
	LD	A,#CODE
	RST	28H
	ENDM
	OPTION	+GC
MOD4	EQU	@@4
MOD3	EQU	MOD4.EQ.0
	IF	MOD4
	ORG	2600H
	ELSE
	ORG	5200H
	ENDIF
MKDIR	LD	(OLDSTK),SP
	LD	A,(HL)		;check for args
	CP	' '
	JR	NC,GOTNAM	;go if args given
	LD	HL,USAGE
	SVC	@DSPLY		;display usage
	LD	HL,0
	RET			;exit
GOTNAM	LD	BC,ERROR	;push error address
	PUSH	BC
	LD	DE,FCB		;check filename for legality
	SVC	@FSPEC
	JR	Z,GOODNAM
	LD	HL,BADNAME	;abort if illegal name
	JP	ABORT
GOODNAM	PUSH	DE		;check for extension
	PUSH	HL
	LD	HL,DEFEXT
	LD	B,3
FNDEXT	LD	A,(DE)		;look until extension or end of string found
	CP	03H
	JR	Z,CKDEV
	INC	DE
	CP	'/'
	JR	NZ,FNDEXT
CKEXT	LD	A,(DE)		;if extension found,
	CP	(HL)		;make sure extension is /DIR
	JR	NZ,EXTBAD
	INC	DE
	INC	HL
	DJNZ	CKEXT
	JR	CKDEV
EXTBAD	POP	HL		;if extension is given and it's not dir, abort
	POP	DE
	LD	HL,BADEXT
	JP	ABORT
CKDEV	POP	HL		;check to see if it was a device
	POP	DE
	LD	A,(DE)
	CP	'*'
	JR	NZ,NAMOK
	LD	HL,DEVIC	;abort if it was a device
	JP	ABORT
NAMOK	PUSH	HL		;add extension if needed (/DIR)
	LD	HL,DEFEXT
	SVC	@FEXT
	POP	HL
	LD	A,(HL)
	CP	0DH		;check for parameters
	JR	Z,NOPARMS
	CP	'('
	JR	Z,CKPARMS
BADPARM:
	IF	MOD4
	LD	A,2CH
	RET
	ELSE
	LD	HL,PARMBAD
	JP	ABORT
	ENDIF
CKPARMS	LD	DE,PARMTAB	;parse parameters
	SVC	@PARAM
	RET	NZ
NOPARMS	LD	HL,BADCYLS	;check parameter for validity
	LD	DE,10
CYLPARM	EQU	$-2
	LD	A,D
	OR	A
	JP	NZ,ABORT
	LD	A,E
	OR	A
	JP	Z,ABORT
	CP	205
	JP	NC,ABORT
	LD	HL,FCB-1	;find drive spec
FDSPEC	INC	HL
	LD	A,(HL)
	CP	':'
	JR	Z,FNDDRV
	CP	03H
	JR	NZ,FDSPEC
	PUSH	HL		;if none, force drive 0
	LD	(HL),':'
	INC	HL
	LD	(HL),'0'
	INC	HL
	LD	(HL),03H
	POP	HL
FNDDRV	INC	HL		;convert drivespec to binary and store in C
	LD	A,(HL)
	SUB	'0'
	LD	C,A
	SVC	@SLCT		;select that drive
	RET	NZ		;abort on error
	SVC	@CKDRV		;check drive
	LD	A,08H
	RET	NZ		;error if not ready
	LD	A,0FH
	RET	C		;or write protected
	LD	B,01H		;read dir/sys record
	SVC	@DIRRD
	RET	NZ
	LD	DE,DIRSYS	;copy it to buffer
	PUSH	BC
	LD	BC,32
	LDIR
	POP	BC
	SVC	@GTDCT
	LD	A,(IY+9)	;get directory cylinder
	LD	(DIRCYL),A	;save it
	LD	D,A
	LD	E,00H
	LD	HL,PRNTGAT	;read parent directory gat
	SVC	@RDSSC
	RET	NZ
	LD	A,(PRNTGAT+0CDH);get # of grans
	LD	B,A
	AND	07H
	INC	A
	BIT	5,B		;check if double sided
	JR	Z,SS
	ADD	A,A		;double it if double sided
SS	LD	B,A		;create mask for free track
	LD	A,0FFH
SHLP	SLA	A
	DJNZ	SHLP
	LD	(GRANMSK),A
	CALL	FNDFREE		;find first free track
	RET	NZ
	LD	A,C		;save it
	LD	(SDCYL),A
	LD	(HL),0FFH	;allocate it
	LD	HL,PRNTGAT	;copy parent's gat to subdir's gat
	LD	DE,SDGAT
	LD	BC,256
	LDIR
	LD	HL,FCB		;copy directory name to subdir's gat
	LD	DE,SDGAT+0D0H
	LD	B,08H
CPYNAM	LD	A,(HL)
	CP	'/'
	JR	Z,PADNAM
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	CPYNAM
	JR	CPYDON
PADNAM	LD	A,' '		;pad with spaces if necessary
PADLP	LD	(DE),A
	INC	DE
	DJNZ	PADLP
CPYDON	LD	HL,SDGAT+0D8H	;add datestamp to subdir's gat
	SVC	@DATE
	LD	(HL),0DH	;put CR at start of AUTO region
	INC	HL
	LD	(HL),00H	;and pad with nulls
	PUSH	HL
	POP	DE
	INC	DE
	LD	BC,30
	LDIR
	LD	HL,SDGAT	;pre-allocate entire disk
	LD	DE,SDGAT+1
	LD	B,00H
	LD	A,(PRNTGAT+0CCH)
	ADD	A,35
	LD	C,A
	DEC	C
	LD	(HL),0FFH
	LDIR
	LD	B,A
	LD	HL,PRNTGAT	;find an empty track in parent
	LD	DE,SDGAT
	LD	A,00H
GRANMSK	EQU	$-1
ALLOC	CP	(HL)
	JR	NZ,CKNEXT
	LD	(HL),0FFH	;allocate it in parent
	LD	(DE),A		;free it in subdir
	PUSH	HL
	LD	HL,CYLPARM	;count down tracks to allocate
	DEC	(HL)
	POP	HL
	JR	Z,ALOCDON	;go if done allocating
CKNEXT	INC	HL
	INC	DE
	DJNZ	ALLOC
	LD	A,1BH		;disk full error if can't find a track to use
	RET
ALOCDON	LD	B,00H		;open subdir
	LD	DE,FCB
	SVC	@INIT
	RET	NZ		;go on error
	LD	BC,(FCB+6)	;get DEC in BC
	PUSH	AF		;save flags from init
	SVC	@CLOSE		;close subdir
	POP	AF		;retrieve flags
	LD	HL,EXISTS
	JP	NC,ABORT	;abort if subdir already exists
	LD	A,-1
DIRCYL	EQU	$-1
	LD	D,A
	LD	E,00H
	LD	HL,PRNTGAT	;save new parent gat
	SVC	@WRSSC
	RET	NZ		;abort on error
	PUSH	BC		;save DEC
	LD	A,(DIRCYL)	;read HIT
	LD	D,A
	LD	E,01H
	LD	HL,HIT
	SVC	@RDSSC
	POP	BC		;retrieve DEC
	RET	NZ		;abort on error
	PUSH	BC		;save DEC
	PUSH	HL		;save HIT pointer
	LD	DE,HIT0IM	;copy SYS hit entries
	LD	BC,8		;boot,dir,sys0-sys5
	PUSH	BC		;to save area
	LDIR
	POP	BC
	LD	HL,HIT+32	;copy SYS hit entries
	LDIR			;sys6-13
	POP	HL		;retrieve start of hit
	POP	BC		;retrieve DEC
	LD	A,(HIT+1)	;copy parent dir entry
	LD	(HIT0IM),A	;over boot image entry
	LD	E,B
	LD	D,00H
	ADD	HL,DE
	LD	A,(HL)		;copy subdir entry
	LD	(HIT0IM+1),A	;to dir entry image
	SVC	@DIRRD		;read subdir entry from parent directory
	RET	NZ		;abort on error
	PUSH	BC		;save regs
	PUSH	DE
	PUSH	HL
	LD	A,(DIRSYS)	;get access level from dirsys
	AND	07H
	OR	78H		;mark as in use, system, invisible, PDS
	LD	(HL),A
	INC	HL
	LD	(HL),00H	;clear date
	INC	HL
	LD	(HL),00H
	LD	DE,14		;move to password
	ADD	HL,DE
	LD	DE,DIRSYS+16	;copy owner password, user password, ERN
	EX	DE,HL		;from parent directory
	LD	BC,6
	LDIR
	LD	A,00H
SDCYL	EQU	$-1		;stuff subdir cylinder
	LD	(DE),A
	INC	DE
	INC	HL
	LD	A,(HL)		;copy starting gran/grans used from parent
	LD	(DE),A
	POP	HL
	PUSH	HL
	LD	DE,FCB		;copy it into FCB area
	LD	BC,32
	LDIR
	POP	HL	;write revised subdir record to parent directory
	POP	DE
	POP	BC
	SVC	@DIRWR
	RET	NZ		;abort on error
	LD	B,20H		;read sys6 record
	LD	DE,SYS6		;copy to hold area if system
	CALL	CPYREC
	LD	B,21H		;read sys7 record
	LD	DE,SYS7		;copy it if system
	CALL	CPYREC
	LD	B,02H		;read sys0 record
	LD	DE,SYS0		;copy it if system
	CALL	CPYREC
	LD	B,22H		;read sys8 record
	LD	DE,SYS8
	CALL	CPYREC		;copy it if system
	LD	B,03H		;read sys1 record
	LD	DE,SYS1		;copy it if system
	CALL	CPYREC
	LD	B,23H		;read sys9 record
	LD	DE,SYS9		;copy it if system
	CALL	CPYREC
	LD	B,04H		;read sys2 record
	LD	DE,SYS2		;copy it if system
	CALL	CPYREC
	LD	B,24H		;read sys10 record
	LD	DE,SYS10	;copy it if system
	CALL	CPYREC
	LD	B,05H		;read sys3 record
	LD	DE,SYS3		;copy it if system
	CALL	CPYREC
	LD	B,25H		;read sys11 record
	LD	DE,SYS11	;copy it if system
	CALL	CPYREC
	LD	B,06H		;read sys4 record
	LD	DE,SYS4		;copy it if system
	CALL	CPYREC
	LD	B,26H		;read sys12 record
	LD	DE,SYS12	;copy it if system
	CALL	CPYREC
	LD	B,07H		;read sys5 record
	LD	DE,SYS5		;copy it if system
	CALL	CPYREC
	LD	B,27H		;read sys13 entry
	LD	DE,SYS13	;copy it if system
	CALL	CPYREC
	LD	A,(SDCYL)
	LD	(IY+9),A	;make sure wrssc will use the right cylinder
	LD	D,A
	LD	E,00H
	LD	HL,SDGAT	;write subdirectory gat
	SVC	@WRSSC
	RET	NZ
	INC	E		;hit sector
	LD	HL,HIT		;point to hit
	PUSH	HL
	PUSH	BC
	PUSH	DE
	LD	DE,HIT+1	;clear hit
	LD	BC,255
	LD	(HL),00H
	LDIR
	LD	HL,HIT0IM	;copy system images
	LD	DE,HIT		;boot,dir,sys0-sys5
	LD	BC,8
	PUSH	BC
	LDIR
	POP	BC
	LD	DE,HIT+32	;sys6-sys13
	LDIR
	POP	DE
	POP	BC
	POP	HL
	SVC	@WRSSC		;write hit
	RET	NZ		;abort on error
	INC	E		;bump to first dir sector
	PUSH	DE
	PUSH	BC
	LD	HL,DIRSYS	;copy parent and sys6
	LD	DE,HIT
	PUSH	DE
	LD	BC,64
	LDIR
	POP	HL
	POP	BC
	POP	DE
	SVC	@WRSSC		;write sector
	RET	NZ		;abort on error
	INC	E		;second dir sector
	PUSH	DE
	PUSH	BC
	LD	HL,FCB		;copy subdir and sys7
	LD	DE,HIT
	PUSH	DE
	LD	BC,64
	LDIR
	POP	HL
	POP	BC
	POP	DE
	SVC	@WRSSC		;write sector
	RET	NZ
	INC	E		;third directory sector
	PUSH	DE
	PUSH	BC
	LD	HL,SYS0		;copy sys0 and sys8
	LD	DE,HIT
	PUSH	DE
	LD	BC,64
	LDIR
	POP	HL
	POP	BC
	POP	DE
	SVC	@WRSSC		;write sector
	RET	NZ
	INC	E		;fourth directory sector
	PUSH	DE
	PUSH	BC
	LD	HL,SYS1		;copy sys1 and sys9
	LD	DE,HIT
	PUSH	DE
	LD	BC,64
	LDIR
	POP	HL
	POP	BC
	POP	DE
	SVC	@WRSSC		;write sector
	RET	NZ
	INC	E		;fifth dir sector
	PUSH	DE
	PUSH	BC
	LD	HL,SYS2		;copy sys2 and sys10
	LD	DE,HIT
	PUSH	DE
	LD	BC,64
	LDIR
	POP	HL
	POP	BC
	POP	DE
	SVC	@WRSSC		;write sector
	RET	NZ
	INC	E		;sixth directory sector
	PUSH	DE
	PUSH	BC
	LD	HL,SYS3		;copy sys3 and sys11
	LD	DE,HIT
	PUSH	DE
	LD	BC,64
	LDIR
	POP	HL
	POP	BC
	POP	DE
	SVC	@WRSSC		;write sector
	RET	NZ
	INC	E		;seventh directory sector
	PUSH	DE
	PUSH	BC
	LD	HL,SYS4		;copy sys4 and sys12
	LD	DE,HIT
	PUSH	DE
	LD	BC,64
	LDIR
	POP	HL
	POP	BC
	POP	DE
	SVC	@WRSSC		;write sector
	RET	NZ
	INC	E		;eighth dir sector
	PUSH	DE
	PUSH	BC
	LD	HL,SYS5		;copy sys5 and sys13
	LD	DE,HIT
	PUSH	DE
	LD	BC,64
	LDIR
	POP	HL
	POP	BC
	POP	DE
	SVC	@WRSSC		;write sector
	RET	NZ
	INC	E
	LD	A,(FCB+20)	;null out remainder of dir
	SUB	0AH
	LD	B,A		;b=number of sectors to zero
	PUSH	DE
	PUSH	BC
	LD	HL,HIT		;clear buffer
	PUSH	HL
	LD	DE,HIT+1
	LD	BC,255
	LD	(HL),00H
	LDIR
	POP	HL
	POP	BC
	POP	DE
	LD	A,B		;skip if clear done
	OR	A
	JR	Z,WRTDON
WRTLP	PUSH	BC		;save BC
	SVC	@WRSSC		;write sector
	POP	BC		;restore BC
	RET	NZ		;abort on error
	INC	E		;bump sector pointer
	DJNZ	WRTLP
WRTDON	POP	HL
	LD	HL,MKDIR$	;say we're done
	SVC	@DSPLY
	LD	HL,DONE
	SVC	@DSPLY
	LD	HL,0
EXIT	LD	SP,$-$
OLDSTK	EQU	$-2
	LD	A,(DIRCYL)
	CP	0FFH
	RET	Z
	LD	(IY+9),A
	RET
ABORT	PUSH	HL
	LD	HL,MKDIR$
	SVC	@DSPLY
	POP	HL
	SVC	@DSPLY
	LD	HL,3FH
	JR	EXIT
ERROR	PUSH	AF
	LD	HL,MKDIR$
	SVC	@DSPLY
	POP	AF
	LD	L,A
	LD	H,0
	OR	0C0H
	LD	C,A
	SVC	@ERROR
	JR	EXIT
CPYREC	SVC	@DIRRD
	JR	NZ,ERROR
	BIT	6,(HL)
	JR	NZ,COPYIT
	PUSH	BC
	LD	L,E
	LD	H,D
	INC	DE
	LD	BC,31
	LD	(HL),0
	LDIR
	POP	BC
	LD	A,B
	CP	8
	JR	C,OFSETOK
	SUB	18H
OFSETOK	LD	E,A
	LD	D,0
	LD	HL,HIT0IM
	ADD	HL,DE
	LD	(HL),0
	RET
COPYIT	PUSH	BC		;copy dir record
	LD	BC,32
	LDIR
	POP	BC
	RET
FNDFREE	LD	A,(PRNTGAT+0CCH)	;get # of tracks
	ADD	A,35			;excess 35
	LD	B,A
	LD	C,00H
	LD	HL,PRNTGAT		;find first free track
FREELP	LD	A,(GRANMSK)
	CP	(HL)
	RET	Z
	INC	HL
	INC	C
	DJNZ	FREELP
	LD	A,1BH			;if no free tracks, return error
	OR	A
	RET
PARMTAB	DB	'CYL   '
	DW	CYLPARM
	DB	'C     '
	DW	CYLPARM
	DB	00H
DEFEXT	DB	'DIR'
MKDIR$	DB	'mkdir: ',03H
BADNAME	DB	'Illegal directory name',0DH
DEVIC	DB	'Must be a directory name -- not a device name',0DH
BADEXT	DB	'Illegal directory name extension',0DH
	IF	MOD3
PARMBAD	DB	'Bad parameter(s)',0DH
	ENDIF
BADCYLS	DB	'Cylinder count out of range (cyl=x, 0 < x < 256)',0DH
EXISTS	DB	'Directory already exists',0DH
USAGE	DB	'Usage: mkdir filename:d (cyl=x)',0AH
	DB	'filename = 1 to 8 char name, 1st char A-Z, others 0-9, A-Z',0AH
	DB	'       d = drive number, must be in the range of 0-7',0AH
	DB	'       x = cylinder count; 0 > x > 204',0DH
DONE	DB	'Directory created',0DH
HIT0IM	DS	16
DIRSYS	DS	32
SYS6	DS	32
FCB	DS	32
SYS7	DS	32
SYS0	DS	32
SYS8	DS	32
SYS1	DS	32
SYS9	DS	32
PRNTGAT	EQU	$
SYS2	DS	32
SYS10	DS	32
SYS3	DS	32
SYS11	DS	32
SYS4	DS	32
SYS12	DS	32
SYS5	DS	32
SYS13	DS	32
SDGAT	DS	256
HIT	DS	256
LAST	EQU	$
	END	MKDIR
