MOD4	EQU	@@4
MOD3	EQU	MOD4.EQ.0
CR	EQU	0DH
SVC	MACRO	#CODE
	LD	A,#CODE
	RST	28H
	ENDM
@CKDRV	EQU	33
@CLOSE	EQU	60
@DIRRD	EQU	87
@DSPLY	EQU	10
@ERROR	EQU	26
@FEXT	EQU	79
@GTDCT	EQU	81
@OPEN	EQU	59
@RDSEC	EQU	49
@SLCT	EQU	41
	OPTION	+GC
	IF	MOD4
	ORG	2600H
	ELSE
	ORG	5200H
	ENDIF
CD	LD	(OLDSTK),SP
	LD	A,(HL)		;check for arguments
	CP	CR
	JR	NZ,GOTARGS
	LD	HL,USAGE	;if none found, give usage
	SVC	@DSPLY
	RET
GOTARGS	LD	BC,ERROR	;push error exit
	PUSH	BC
	LD	C,00H		;default drive is 0
	PUSH	HL		;save start of path name
GTDRV	LD	A,(HL)		;get a char
	INC	HL
	CP	':'		;check for drivespec delimiter
	JR	Z,FNDDRV	;go if found
	CP	CR		;check for end of string
	JR	NZ,GTDRV	;loop if not found
	JR	DEFDRV		;use default drive
FNDDRV	LD	A,(HL)		;got drive: get ascii value
	LD	(DRIVE),A	;save it for later
	SUB	'0'
	LD	C,A		;put binary value of drive in C
DEFDRV	SVC	@GTDCT		;get pointer to selected drive's DCT
	POP	HL
	LD	A,(IY+9)	;pick up original directory cylinder
	LD	(DIRCYL),A	;save it for error exit
	SVC	@SLCT		;select drive
	RET	NZ
	SVC	@CKDRV		;make sure it's ready
	LD	A,08H
	RET	NZ		;abort if error
	LD	A,(HL)
	CP	':'		;start from root if ':' or '\'
	JR	Z,USEROOT
	CP	'\'
	JR	NZ,USECURR	;else start from current directory
	INC	HL
USEROOT	PUSH	HL
	LD	HL,BOOTSEC	;read boot sector
	LD	DE,0
	SVC	@RDSEC
	POP	HL
	RET	NZ		;abort on error
	LD	A,(BOOTSEC+2)	;get root directory cylinder
	LD	(IY+09H),A	;stuff it in dct
USECURR	LD	(PATHPTR),HL	;save pointer to path string
TRAVERS	LD	HL,0
PATHPTR	EQU	$-2
	LD	A,(HL)		;check for end of string
	CP	CR
	JR	Z,EXIT		;exit if at end of path
	CP	':'
	JR	Z,EXIT
	CP	'\'
	JR	NZ,NOSLASH
	INC	HL
NOSLASH	LD	B,08H		;b=max count of chars
	LD	DE,FCB
	DEC	HL		;set up for loop
FSPEC	INC	HL
	LD	A,(HL)		;copy dir name to fcb
	CP	CR
	JR	Z,XIT		;go if subdir name
	CP	':'
	JR	Z,XIT
	CP	'\'
	JR	Z,XIT
	CP	'a'		;convert to upper case
	JR	C,UPPER
	CP	'z'+1
	JR	NC,UPPER
	AND	'_'
UPPER	LD	(DE),A		;stuff char
	INC	DE
	DJNZ	FSPEC		;and loop
XIT	LD	(PATHPTR),HL
	EX	DE,HL
	LD	(HL),':'		;add drive spec
	INC	HL
	LD	(HL),'0'
DRIVE	EQU	$-1
	INC	HL
	LD	(HL),03H
	LD	DE,FCB		;point to fcb
	LD	HL,DEFEXT	;add extension
	PUSH	HL
	SVC	@FEXT
	POP	HL
	PUSH	DE		;check extension
	LD	B,3
FEXTLP	LD	A,(DE)
	INC	DE
	CP	'/'		;look for extension delimiter
	JR	NZ,FEXTLP;since we just executed @FEXT, it has to be there
EXTLP	LD	A,(DE)		;make sure it's the right extension
	INC	DE
	CP	(HL)
	LD	A,19		;illegal filename if not
	RET	NZ
	INC	HL
	DJNZ	EXTLP
	POP	DE
	LD	HL,BUFFER	;open subdir file
	LD	B,00H
	SVC	@OPEN
	RET	NZ		;abort on error
	LD	BC,(FCB+6)
	SVC	@DIRRD
	BIT	5,(HL)		;check PDS bit
	LD	HL,NOTSD
	JR	Z,ABORT		;illegal if not set
	LD	A,(FCB+14)	;get starting cylinder
	PUSH	AF
	SVC	@CLOSE		;close file
	POP	AF
	LD	(IY+09H),A	;save new dir cylinder in DCT
	JP	TRAVERS		;loop until done
EXIT	LD	HL,0
EXIT1	LD	SP,$-$
OLDSTK	EQU	$-2
	RET
ABORT	PUSH	HL
	LD	HL,NAME
	SVC	@DSPLY
	POP	HL
	SVC	@DSPLY
	LD	HL,3FH
	JR	EXIT2
ERROR	PUSH	AF
	LD	HL,NAME		;display program name
	SVC	@DSPLY
	POP	AF
	LD	L,A		;put error number in HL
	LD	H,0
	OR	0C0H		;set return and short bits
	LD	C,A
	SVC	@ERROR		;issue error message
EXIT2	LD	A,-1		;check if we got far enough to get the DCT
DIRCYL	EQU	$-1
	CP	-1
	JR	Z,EXIT1		;leave now if we didn't
	LD	(IY+9),A	;restore original directory cylinder
	JR	EXIT1
DEFEXT	DB	'DIR'
NAME	DB	'cd: ',03H
NOTSD	DB	'File in path not a directory',CR
USAGE	DB	'Usage: cd directory_name',CR
BUFFER	DS	256
FCB	DS	32
BOOTSEC	DS	256
LAST	EQU	$
	END	CD
