;*******************************************
;**** PRINT/CMD - Version 1.0 - (C)1989 ****
;****        By Charles W. Smith        ****
;****   91 Tarryton Ct.W. / Cols, Ohio  **** 
;****            43228-1513             ****
;*******************************************
;
; This program may be distributed free so long
; as the Source Code and my name remains on
; the program heading and Source code listing
; with no modifications unless authorized.
;
;
	ORG	3000H		; Model III address is 5200H
				; The SVC table is a little different
;				; for the Model III
;
LF	EQU	0AH		; Line Feed
CR	EQU	0DH		; Carage Return
@PRINT	EQU	14		; Model 4
;@PRT	EQU	003BH		; Model III
@DSPLY	EQU	10		; Model 4
;@DSPLY	EQU	4467H		; Model III
@ABORT	EQU	21		; Model 4
;@ABORT	EQU	4030H		; Model III
@EXIT	EQU	22		; Model 4
;@EXIT	EQU	402DH		; Model III
@CKBRKC	EQU	106		; Model 4
@CTL	EQU	5		; Model 4
;
SVC	MACRO	#ROUTINE
	LD	A,#ROUTINE
	RST	28H
	ENDM
;
START	LD	A,0DH		; Load A with <CR> to Check
	CP	(HL)		; Check for Parameter
	JR	Z,PARERR	; Jump to PARERR if none
CKPRST	PUSH	HL		; Save pointer to text
	LD	C,0		; Code to get status of device
	LD	DE,218H		; DCB address or printer
	SVC	@CTL
	JR	Z,PRINT		; If available, go on
	LD	HL,MSG7		; Else post message and
	SVC	@DSPLY
LOOP	SVC	@CKBRKC		; loop until BREAK or
	JR	NZ,EXIT
	LD	C,0
	LD	DE,218H
	SVC	@CTL
	JR	NZ,LOOP		; ready (Z set)
PRINT	POP	HL
	SVC	@PRINT		; Print Line
ENDIT	LD	HL,MSG6 	; Load the Completed message
	SVC	@DSPLY		; Show the message
EXIT	LD	HL,CLEAR	; Clear out HL
	SVC	@EXIT		; Exit
ABORT	SVC	@ABORT
PARERR	LD	HL,MSG1		; This area shows the Parameter 
	SVC	@DSPLY		; error and how to operate the
	LD	HL,MSG2		; program. Also shows the (C)
	SVC	@DSPLY		; and address. This program
	LD	HL,MSG3		; can be distributed freely but
	SVC	@DSPLY		; it MUST show the COPYRIGHT notice
	LD	HL,MSG4		; and all other information. Any
	SVC	@DSPLY		; Changes or additions must be sent
	LD	HL,MSG5		; to me for a constant update.
	SVC	@DSPLY
	LD	HL,0
	SVC	@ABORT
;
;******** Message Area ********
; Some lines to long for the Model III as is.
; You should List or List to printer to see all
; lines that are missing endings if using a
; Model III.
;
FEED	DEFB	0AH,0AH,0DH,0DH,03H
CLEAR	DEFB	0H,03H		; This will error M3 but it works
MSG1	DEFM	'Print/Cmd v.1.0 (C)1989 '
	DEFB	03H
MSG2	DEFM	'By Charles W. Smith'
	DEFB	0DH
MSG3	DEFM	'91 Tarryton Ct.W. Columbus, Ohio 43228-1513'
	DEFB	LF,0DH
MSG4	DEFM	'** Parameter Error - Example:'
	DEFB	0DH
MSG5	DEFM	'PRINT "Characters to print in this area only!"'
	DEFB	LF,0DH
MSG6	DEFM	'Printing Completed!'
	DEFB	LF,0DH
MSG7	DEFB	'Printer not available. Place printer on line or press <BREAK>'
	DEFB	0DH
	END	START
