;*******************************************
;**** PRINT/CMD - Version 1.0 - (C)1989 ****
;****        By Charles W. Smith        ****
;****   91 Tarryton Ct.W. / Cols, Ohio  **** 
;****            43228-1513             ****
;*******************************************
;
; This program may be distributed free so long
; as the Source Code and my name remains on
; the program heading and Source code listing
; with no modifications unless authorized.
;
;
	ORG	2FFFH		; Model III address is 5200H
				; The SVC table is a little different
;				; for the Model III
;
LF	EQU	0AH		; Line Feed
CR	EQU	0DH		; Carage Return
@PRT	EQU	6		; Model 4
;@PRT	EQU	003BH		; Model III
@DSPLY	EQU	10		; Model 4
;@DSPLY	EQU	4467H		; Model III
@ABORT	EQU	21		; Model 4
;@ABORT	EQU	4030H		; Model III
@EXIT	EQU	22		; Model 4
;@EXIT	EQU	402DH		; Model III
@CTL	EQU	5		; Model 4
@CKBRKC	EQU	106		; Model 4
@GTDCB	EQU	82		; Model 4
;
SVC	MACRO	#CALL
	LD	A,#CALL
	RST	28H
	ENDM
;
START	LD	A,'"'		; Load A with '"' to Check
	CP	(HL)		; Check for Parameter
	JR	NZ,PARERR	; Jump to PARERR if incorrect
	INC	HL		; Increment HL
CKPRST	PUSH	HL		; Save pointer to text
	LD	D,'R'		; Put device name in DE
	LD	E,'P'
	SVC	@GTDCB		; PR DCB is 218H in TRSDOS 6x, but just in
;				  case, we get it legitimately
	JR	NZ,ABORT	; Get out if error
	EX	DE,HL		; Get DCB address into DE
	LD	C,0		; Status request
	SVC	@CTL
	JR	Z,PRINT		; Printer ready - proceed
	PUSH	DE		; Save DCB address pointer
	LD	HL,MSG7		; Else display error message
	SVC	@DSPLY
	POP	DE		; Retrieve DCB pointer
LOOP1	SVC	@CKBRKC		; Check BREAK key
	JR	NZ,END		; Exit if BREAK was detected
	LD	C,0
	SVC	@CTL
	JR	NZ,LOOP1	; Keep trying until ready or BREAK
PRINT	POP	HL		; Retrieve text pointer
	LD	A,(HL)		; Load A with HL
	OR	A
	LD	C,A		; Load C with A
	SVC	@PRT		; Print Character in C
	INC	HL		; Increment HL by 1
LOOP	PUSH	HL		; Save what is left in HL
	LD	A,'"'		; As before, Load A with '"'
	CP	(HL)		; Check HL to continue or stop
	JR	Z,ENDIT 	; If zero, then jump to End
	POP	HL		; Pop HL to continue
	LD	A,(HL)		; Load A with (HL)
	OR	A
	LD	C,A		; Load C with A
	SVC	@PRT		; Send to Printer
	INC	HL		; Increment HL by 1
	JR	LOOP		; Start the Loop again
ENDIT	LD	HL,FEED		; Load HL with a Line Feed
	LD	A,(HL)
	OR	A
	LD	C,A
	SVC	@PRT		; Send it to the Printer
	LD	HL,MSG6 	; Load the Completed message
	SVC	@DSPLY		; Show the message
END	LD	HL,CLEAR	; Clear out HL
	SVC	@EXIT		; Clear exit
ABORT	SVC	@ABORT		; Exit with error
PARERR	LD	HL,MSG1		; This area shows the Parameter 
	SVC	@DSPLY		; error and how to operate the
	LD	HL,MSG2		; program. Also shows the (C)
	SVC	@DSPLY		; and address. This program
	LD	HL,MSG3		; can be distributed freely but
	SVC	@DSPLY		; it MUST show the COPYRIGHT notice
	LD	HL,MSG4		; and all other information. Any
	SVC	@DSPLY		; Changes or additions must be sent
	LD	HL,MSG5		; to me for a constant update.
	SVC	@DSPLY
	LD	HL,0
	SVC	@ABORT
;
;******** Message Area ********
; Some lines to long for the Model III as is.
; You should List or List to printer to see all
; lines that are missing endings if using a
; Model III.
;
FEED	DEFB	0AH,0AH,0DH,0DH,03H
CLEAR	DEFB	0H,03H		; This will error M3 but it works
MSG1	DEFM	'Print/Cmd v.1.0 (C)1989 '
	DEFB	03H
MSG2	DEFM	'By Charles W. Smith'
	DEFB	0DH
MSG3	DEFM	'91 Tarryton Ct.W. Columbus, Ohio 43228-1513'
	DEFB	LF,0DH
MSG4	DEFM	'** Parameter Error - Example:'
	DEFB	0DH
MSG5	DEFM	'PRINT "Characters to print in this area only!"'
	DEFB	LF,0DH
MSG6	DEFM	'Printing Completed!'
	DEFB	LF,0DH
MSG7	DEFB	'Printer not ready. Place printer on line or press <BREAK>.'
	DEFB	0DH
	END	START
