;*******************************************
;**** PRINT/CMD - Version 1.0 - (C)1989 ****
;****        By Charles W. Smith        ****
;****   91 Tarryton Ct.W. / Cols, Ohio  **** 
;****            43228-1513             ****
;*******************************************
;
; This program may be distributed free so long
; as the Source Code and my name remains on
; the program heading and Source code listing
; with no modifications unless authorized.
;
;
	ORG	5200H		; Model III address is 5200H
				; The SVC table is a little different
;				; for the Model III
;
LF	EQU	0AH		; Line Feed
CR	EQU	0DH		; Carriage Return
;@PRT	EQU	6		; Model 4
$PRCHAR	EQU	003BH		; Model III
;@DSPLY	EQU	10		; Model 4
$VDLINE	EQU	021BH		; Model III
;@ABORT	EQU	21		; Model 4
$ABORT	EQU	4030H		; Model III
;@EXIT	EQU	22		; Model 4
$EXIT	EQU	402DH		; Model III
$PRSTAT	EQU	37E8H		; Model III
$KBBRK	EQU	028DH		; Model III
;SVC	MACRO	#N		; Macro for Model 4 
;	LD	A,#N
;	RST	28H
;	ENDM
;
START	LD	A,0DH		; Load A with CR to Check
	CP	(HL)		; Check for Parameter
	JR	NZ,PARERR	; Jump to PARERR if incorrect
	PUSH	HL		; Save text pointer
	LD	A,($PRSTAT)
	AND	0F0H		; Mask out bits 0 - 3
	CP	30H
	JR	Z,PRINT		; Go if ready
	LD	HL,MSG7
	CALL	$VDLINE		; Else display error message
LOOP1	CALL	$KBBRK		; Check BREAK key
	JR	NZ,END
	LD	A,($PRSTAT)
	AND	0F0H		; Mask out bits 0 - 3
	CP	30H
	JR	NZ,LOOP1	; Continue until ready or BREAK
PRINT	POP	HL		; Retrieve text pointer
	LD	A,(HL)		; Load A with HL
	OR	A
	CALL	$PRCHAR		; Print Character in C
	INC	HL		; Increment HL by 1
LOOP	PUSH	HL		; Save what is left in HL
	LD	A,0DH		; As before, Load A with CR
	CP	(HL)		; Check HL to continue or stop
	JR	Z,ENDIT 	; If zero, then jump to End
	POP	HL		; Pop HL to continue
	LD	A,(HL)		; Load A with (HL)
	OR	A
	CALL	$PRCHAR		; Send to Printer
	INC	HL		; Increment HL by 1
	JR	LOOP		; Start the Loop again
ENDIT	LD	HL,FEED		; Load HL with a Line Feed
	LD	A,(HL)
	OR	A
	LD	C,A
	CALL	$PRCHAR		; Send it to the Printer
	LD	HL,MSG6 	; Load the Completed message
	CALL	$VDLINE		; Show the message
END	LD	HL,CLEAR	; Clear out HL
	CALL	$EXIT		; Exit
PARERR	LD	HL,MSG1		; This area shows the Parameter 
	CALL	$VDLINE		; error and how to operate the
	LD	HL,MSG2		; program. Also shows the (C)
	CALL	$VDLINE		; and address. This program
	LD	HL,MSG3		; can be distributed freely but
	CALL	$VDLINE		; it MUST show the COPYRIGHT notice
	LD	HL,MSG4		; and all other information. Any
	CALL	$VDLINE		; Changes or additions must be sent
	LD	HL,MSG5		; to me for a constant update.
	CALL	$VDLINE
	LD	HL,0
	CALL	$ABORT
;
;******** Message Area ********
; Some lines to long for the Model III as is.
; You should List or List to printer to see all
; lines that are missing endings if using a
; Model III.
;
FEED	DEFB	0AH,0AH,0DH,0DH,03H
CLEAR	DEFB	0H,03H		; This will error M3 but it works
MSG1	DEFM	'Print/Cmd v.1.0 (C)1989 '
	DEFB	03H
MSG2	DEFM	'By Charles W. Smith'
	DEFB	0DH
MSG3	DEFM	'91 Tarryton Ct.W. Columbus, Ohio 43228-1513'
	DEFB	LF,0DH
MSG4	DEFM	'** Parameter Error - Example:'
	DEFB	0DH
MSG5	DEFM	'PRINT "Characters to print in this area only!"'
	DEFB	LF,0DH
MSG6	DEFM	'Printing Completed!'
	DEFB	LF,0DH
MSG7	DEFB	'Printer not ready. Place printer on line or press <BREAK>'
	DEFB	0DH
	END	START
