*LIST OFF;
;*TITLE ' Tri-Dos Section One Demo program. '
;
;	This is version 1.0 of the TRI-DOS kernal implementation test.
;
;
	ORG	8000H
;
START	CALL	SYSTEM
	LD	(TEXT01),A	; Display the operating mode.  1,3,4
;
	LD	HL,TEXT00	; Display the intro.
	CALL	VDLINE
;
	LD	HL,TEXT02
LOOP01	LD	A,(HL)
	CALL	VDCHAR
	INC	HL
	CP	0DH
	JR	NZ,LOOP01
;
	LD	HL,TEXT04
	CALL	DATE
;
	LD	HL,TEXT05
	CALL	TIME
;
	LD	HL,TEXT03
	CALL	VDLINE
;
	CALL	KBCHAR
	LD	HL,TEXT06
	CALL	VDLINE
;
	CALL	VDLOC
	LD	A,L
	OR	A
	JR	Z,LOOP03
;
LOOP02	LD	HL,TEXT07
	CALL	VDLINE
	RET
;
LOOP03	LD	A,H
	CP	02H
	JR	NZ,LOOP02
;
	LD	HL,TEXT08
	CALL	VDLINE
;
	LD	HL,0409H	; Row 5 character 9.
	CALL	VDPOS
	LD	A,'x'
	CALL	VDCHAR
;
	LD	HL,0409H
	CALL	VDPEK
	CP	'x'
	JR	Z,LOOP04
;
	LD	HL,TEXT09
	CALL	VDLINE
	RET
;
LOOP04	LD	HL,TEXT10
	CALL	VDLINE
;
	CALL	PRSTAT
	JR	Z,LOOP05
;
	LD	HL,TEXT11
	CALL	VDLINE
	JP	LOOP07
;
LOOP05	LD	HL,TEXT12
	CALL	PRLINE
;
	LD	HL,TEXT13
LOOP06	LD	A,(HL)
	CALL	PRCHAR
	INC	HL
	CP	0DH
	JR	NZ,LOOP06
;
LOOP07	LD	HL,TEXT14
	CALL	VDLINE
;
	LD	B,05H		; 300 BAUD .
	LD	C,6FH		; No Parity, 8 Bits, 1 stop bit.
	CALL	RSINIT
;
LOOP08	CALL	INKEY
	JR	Z,LOOP09
	CP	03H
	JR	Z,LOOP10
	CALL	ROCHAR
;
LOOP09	CALL	KBREAK
	JR	NZ,LOOP10
	CALL	RIKEY
	JR	Z,LOOP08
	CALL	VDCHAR
	JR	LOOP08
;
LOOP10	LD	HL,TEXT15
	CALL	VDLINE
;
	RET
;
TEXT00	DEFB	1CH		; Home character
	DEFB	1FH		; Clear video to end of screen.
	DEFM	'Tri-Dos Section One demo program. Running in a Model '
TEXT01	DEFB	'?'
	DEFW	0A0AH
	DEFM	'This program should load and run in all hardware and'
	DEFB	0AH
	DEFM	'software configurations of TRS-80 Model 1, III, 4,'
	DEFB	0AH
	DEFM	'LNW, and MAX-80 computers. These programs are intended'
	DEFB	0AH
	DEFM	'to operate on any all DOS configurations since they do'
	DEFB	0AH
	DEFM	'not rely on DOS functions particular to one specific DOS.'
	DEFB	0AH
	DEFM	'Send failure reports and comments to CompuServe ID: 72245,703'
	DEFW	0A0AH
	DEFM	'TEST OF VDLINE CALL.   Test # 1.'
	DEFB	0DH
;
TEXT02	DEFM	'TEST OF VDCHAR CALL.   Test # 2.'
	DEFB	0DH
;
TEXT03	DEFM	'TEST OF TIME AND DATE CALLS. Test # 3.'
	DEFB	0AH
	DEFM	'Date: '
TEXT04	DEFS	8
	DEFM	'     Time: '
TEXT05	DEFS	8
	DEFB	0AH
	DEFM	'--------------------------<Hit any Key to Continue>---------'
	DEFB	0DH
;
TEXT06	DEFB	1CH	; Home
	DEFB	1FH	; Clear to end of video.
	DEFM	'TEST OF KBCHAR OK.  Test # 4.'
	DEFB	0AH
	DEFM	'Beginning test of  VDLOC. Test # 5.'
	DEFB	0DH
;
TEXT07	DEFM	'VDLOC ERROR. SEND FAILURE REPORT. Test # 5.'
	DEFB	0DH
;
TEXT08	DEFM	'TEST OF VDLOC OK. Test # 5.'
	DEFB	0AH
	DEFM	'.........|'    ; Under IDLE is Row 5, character 9.
	DEFB	0DH
;
TEXT09	DEFM	'* <- Note the position of this asterick.'
	DEFB	0AH
	DEFM	'If it is unter the | then the problem is with VDPEK'
	DEFB	0AH
	DEFM	'Otherwise there is a problem with VDPOS.'
	DEFB	0DH
;
TEXT10	DEFM	'TEST OF VDPOS & VDPEK OK. Test # 6.'
	DEFB	0DH
;
TEXT11	DEFM	'NO PRINTER IS DETECTED. PRINTER Test 7 and 8 are skiped.'
	DEFB	0DH
;
TEXT12	DEFM	'Sample printing of the PRLINE routine. Text # 7.'
	DEFB	0DH
;
TEXT13	DEFM	'Sample printing of the PRCHAR routine. Test # 8.'
	DEFB	0DH
;
TEXT14	DEFM	'Starting tests of the RS232 routines. Initialized'
	DEFB	0AH
	DEFM	'at 300 Baud, 8 bits, no Parity, 1 stop bit. Use it'
	DEFB	0AH
	DEFM	'to try to talk to your SmartModem. <BREAK> to quit.'
	DEFB	0DH
;
TEXT15	DEFM	'End of test of ROCHAR, RSINIT, RIKEY, and KBREAK.'
	DEFB	0AH
	DEFM	'The following calls were not tested by this program.'
	DEFB	0AH
	DEFM	'RILINE, ROLINE, VDCRS, and VDSCR.'
	DEFB	0DH
;
;	A Series of calls that allow programs to be used in
;	either Models 1, 3 or 4 TRSDOS as functional calls
;	instead of making dirrect calls or SVC's to the DOS.
;
;		Part 1	Base system calls.
;		Part 2	Disk I/O calls. Needs part 1.
;		Part 3	Graphic Calls.
;**************************************************************
;*   Name :  $SYSTEM	Find type of TRS-80 machine.	      *
;*   Conditions of entry ?   None.			      *
;*   Conditions on return ? Reg A contains system type. ASCII *
;**************************************************************
SYSTEM LD	A,(0029H)	; Test for Model 4 mode.
	CP	30H		; Less then 30H ?
	LD	A,'4'           ; MODEL 4 MODE.
	RET	C		; RETURN if so.
	LD	A,(0125H)	; Test for Model 3 mode.
	LD	A,'3'           ; Model 3 mode.
	RET	Z		; Return if so.
	LD	A,'1'           ; ELSE must be in Model 1.
	RET			; Return to caller.
;
;
;**************************************************************
;*   Name :  DATE	Get date in format "mm/dd/yy" 8 bytes.*
;*   Conditions of entry ?   (HL) points to start of 8 bytes. *
;*   Conditions on return ? No change to registers.	      *
;**************************************************************
DATE	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	AF
;
	CALL	SYSTEM	; Get mode.
	CP	'4'             ; Model 4 Mode ?
	JR	Z,DATE01	; Yes, go to that routine.
;
	CALL	3033H		; Model 1 & 3 Date call.
	JR	DATE02 	; Skip over Model 4 stuff.
;
DATE01 LD	A,12H		; SVC # 18 Date Call. Model 4.
	RST	28H		; Execute SVC.
;
DATE02 POP	AF		; Restore all registers and return.
	POP	BC
	POP	DE
	POP	HL
	RET
;
;**************************************************************
;*   Name :  TIME	Get time in format "hh/mm/ss" 8 bytes.*
;*   Conditions of entry ?   (HL) points to start of 8 bytes. *
;*   Conditions on return ? No change to registers.	      *
;**************************************************************
TIME	PUSH	HL
	PUSH	DE
	PUSH	BC
	PUSH	AF
;
	CALL	SYSTEM	; Get mode.
	CP	'4'             ; Model 4 Mode ?
	JR	Z,TIME01	; Yes, go to that routine.
;
	CALL	3036H		; Model 1 & 3 Time call.
	JR	TIME02 	; Skip over Model 4 stuff.
;
TIME01 LD	A,13H		; SVC # 19 Date Call. Model 4.
	RST	28H		; Execute SVC.
;
TIME02 POP	AF		; Restore all registers and return.
	POP	BC
	POP	DE
	POP	HL
	RET
;
;**************************************************************
;*   Name :  HIGH$	Get the address of highest usable mem.*
;*   Conditions of entry ?  HL contains new HiMem to be set.  *
;*			    If HL equals 0000H on entry then  *
;*			    routine does not set HiMem	      *
;*   Conditions on return ? HL contains High Memory address.  *
;**************************************************************
HIGH	PUSH	AF
;
	CALL	SYSTEM	; Get mode.
	CP	'4'             ; Model 4 Mode ?
	JR	Z,HIGH02	; Yes, go to that routine.
;
	LD	A,L
	CP	00H
	JR	NZ,HIGH01
	LD	A,H
	CP	00H
	JR	NZ,HIGH01
;
	LD	HL,(40B1H)	; Get Model 1/3 High Memory address.
	JR	HIGH03
;
HIGH01 LD	(40B1H),HL
	JR	HIGH03
;
HIGH02	PUSH	BC
	LD	B,00H		; Set-Up SVC for using High Memory.
	LD	A,64H		; SVC # 100 @HIGH$
	RST	28H		; Execute SVC.
	POP	BC
;
HIGH03 POP	AF
	RET
;
;==============================================================
; START of KEYBOARD Call routines.
;		INKEY$		Check for keyboard character.
;		$KBWAIT 	Wait for keyboard character.
;		$KBLINE 	Accept line from keyboard.
;		$KBREAK 	Check if <BREAK> key pressed.
;**************************************************************
;*   Name :  INKEY$	Checks the keyboard for typed char.   *
;*   Conditions of entry ?  None.			      *
;*   Conditions on return ? A contains character typed.       *
;*		Zero Flag = Z Then no character was typed.    *
;*		Zero Flag = NZ then character was typed.      *
;**************************************************************
INKEY	PUSH	DE
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	JR	Z,INKEY1	; Yes, do Model 4 routine.
;
	CALL	002BH		; Model 1/3 KBCHAR call.
	JR	INKEY2
;
INKEY1 LD	A,08H		; SVC # 8 @KBD
	RST	28H		; Execute SVC.
;
INKEY2 POP	DE
	OR	A
	RET
;
;**************************************************************
;*   Name :  KBCHAR	Waits for character from keyboard.    *
;*   Conditions of entry ?  None.			      *
;*   Conditions on return ? A contains character typed.       *
;**************************************************************
KBCHAR PUSH	DE
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	JR	Z,KBCHR1	; Yes, do Model 4 routine.
;
	CALL	0049H		; Model 1/3 KBWAIT call.
	JR	KBCHR2
;
KBCHR1 LD	A,01H		; SVC # 1 @KEY
	RST	28H		; Execute SVC.
;
KBCHR2 POP	DE
	RET
;
;
;**************************************************************
;*   Name :  KBLINE	Accepts line of text from keyboard.   *
;*   Conditions of entry ? B = Maximum length of line entered *
;*			  HL = Address of storage buffer of   *
;*				length B+1		      *
;*   Conditions on return ? B = Numbers of characters entered.*
;*			   HL = Start of storage buffer that  *
;*				contains text entered.	      *
;*		   Carry Flag = Set if Break Key pressed.     *
;**************************************************************
KBLINE PUSH	DE
	LD	D,A		; Save contents of Reg A.
	LD	E,C		; Save contents of Reg C.
	PUSH	DE
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	JR	Z,KBLIN1	; Yes, do Model 4 routine.
;
	CALL	0040H		; Model 1/3 KBLINE call.
	JR	KBLIN2
;
KBLIN1 LD	A,09H		; SVC # 9 @KEY
	LD	C,00H		; Set-Up for SVC.
	RST	28H		; Execute SVC.
;
KBLIN2 POP	DE
	LD	A,D
	LD	C,E
	POP	DE
	RET
;
;**************************************************************
;*   Name :  KBREAK$	Checks if <BREAK> key was pressed.    *
;*   Conditions of entry ?  None.			      *
;*   Conditions on return ? Zero Flag not set if break pressed*
;**************************************************************
KBREAK PUSH	DE
	LD	D,A
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	JR	Z,KBREK1	; Yes, do Model 4 routine.
;
	CALL	028DH		; Model 1/3 KBBRK call.
	JR	KBREK2
;
KBREK1 LD	A,6AH		; SVC # 106 @CKBRKC (TRSDOS 6.2 only)
	RST	28H		; Execute SVC.
;
KBREK2 LD	A,D
	POP	DE
	RET
;
;===================================================================
;  START of Video CALL routines.
;		$VDCHAR 	Send one character to Video.
;		$VDLINE 	Send one line to Video.
;		$VDLOC		Returns curser position.
;		$VDPOS		Sets curser position.
;		$VDCRS		Sets curser character.
;		$VDSCR		Sets video scroll protect.
;		$VDPEK		Peek character from display.
;**************************************************************
;*   Name :  VDCHAR	Sends one character to video.	      *
;*   Conditions of entry ?  A contains character to display.  *
;*   Conditions on return ? No registers changed.	      *
;**************************************************************
VDCHAR PUSH	DE
	LD	D,A
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	LD	A,D
	JR	Z,VDCHR1	; Yes, do Model 4 routine.
;
	CALL	0033H		; Model 1/3 VDCHAR call.
	JR	VDCHR2
;
VDCHR1 PUSH	BC
	LD	C,A		; Set-Up send character.
	LD	A,02H		; SVC # 2 @DSP
	RST	28H		; Execute SVC.
	POP	BC
;
VDCHR2 POP	DE
	RET
;
;
;**************************************************************
;*   Name :  VDLINE	Displays lines of text to video.      *
;*   Conditions of entry ? HL = Address of start of display   *
;*   Conditions on return ? No change to registers.	      *
;**************************************************************
VDLINE PUSH	HL
	PUSH	DE
	PUSH	AF
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	JR	Z,VDLIN1	; Yes, do Model 4 routine.
;
	CALL	021BH		; Model 1/3 VDLINE call.
	JR	VDLIN2
;
VDLIN1 LD	A,0AH		; SVC # 10 @DSPLY a line
	RST	28H		; Execute SVC.
;
VDLIN2 POP	AF
	POP	DE
	POP	HL
	RET
;
;
*LIST ON
;**************************************************************
;*   Name :  VDLOC	     Returns video curser position.   *
;*   Conditions of entry ? No parameters.		      *
;*   Conditions on return ? HL = Current curser position.     *
;*							      *
;*  H = Y axis cordinate (Virtical)    Lines number	      *
;*  L = X axis cordinate (Horizontal)  Line position number.  *
;**************************************************************
VDLOC	PUSH	AF
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	JR	Z,VDLOC1	; Yes, do Model 4 routine.
;
	LD	HL,(4020H)	; Model 1/3 curser position address.
	LD	A,H
	AND	03H		; Strip off base address.
	LD	H,A
	LD	A,L
	SLA	A
	RL	H
	SLA	A
	RL	H
	LD	A,L
	AND	3FH		; Strip off Y axis from L and save.
	LD	L,A
	JR	VDLOC2
;
VDLOC1 PUSH	BC
	LD	B,04H		; Set-Up for SVC finding screen position.
	LD	A,0FH		; SVC # 15 @VDCTL video control.
	RST	28H	       ; Execute SVC.
	POP	BC
;
VDLOC2 POP	AF
	RET
;
;
;**************************************************************
;*   Name :  VDPOS	Sets video curser position.	      *
;*   Conditions of entry ? HL = Curser position to set.       *
;*   Conditions on return ? No changes to registers.	      *
;*							      *
;*  H = Y axis cordinate (Virtical)    Lines number	      *
;*  L = X axis cordinate (Horizontal)  Line position number.  *
;**************************************************************
VDPOS	PUSH	AF
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	JR	Z,VDPOS1	; Yes, do Model 4 routine.
;
	LD	A,H
	AND	03H
	SLA	A
	SLA	A
	SLA	A
	SLA	A
	SLA	A
	SLA	A
	OR	L
	LD	L,A
	LD	A,H
	SRL	A
	SRL	A
	ADD	A,3CH
	LD	H,A
	LD	(4020H),HL
	JR	VDPOS2
;
VDPOS1 PUSH	BC
	LD	B,03H		; Set-Up for SVC setting screen position.
	LD	A,0FH		; SVC # 15 @VDCTL video control.
	RST	28H		; Execute SVC.
	POP	BC
;
VDPOS2 POP	AF
	RET
;
;
;**************************************************************
;*   Name :  VDCRS	Sets curser character.		      *
;*   Conditions of entry ?  A = ASCII code for new character. *
;*   Conditions on return ? Carry Flag set if A<CHR$(32).     *
;*   If new A >CHR$(31) THEN A = Previous curser character.   *
;**************************************************************
VDCRS	CP	20H		; Check if space character.
	RET	C		; Return if less then CHR$(32)
	PUSH	BC
	LD	B,A
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	LD	A,B
	JR	Z,VDCRS1	; Yes, do Model 4 routine.
;
	LD	B,A
	LD	A,(4023H)
	LD	C,A
	LD	A,B
	LD	(4023H),A	; Model 1/3 curser character.
	LD	A,C
	JR	VDCRS2
;
VDCRS1 PUSH	DE
	PUSH	AF
	LD	C,A		; Set-Up send character.
	LD	B,09H
	LD	A,0FH		; SVC # 15 @VDCLT
	RST	028H		; Execute SVC.
	POP	AF
	POP	DE
;
VDCRS2 POP	BC
	RET
;
;
;**************************************************************
;*   Name :  VDSCR	Sets Scroll protect lines.	      *
;*   Conditions of entry ?  A = Number of lines to protect.   *
;*   Conditions on return ? No changes to registers	.     *
;*   Model 3 and Model 4 modes only. Model 1 has no function. *
;**************************************************************
VDSCR	PUSH	BC
	LD	C,A		; Get new value out of the way.
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	JR	Z,VDSCR1	; Yes, do Model 4 routine.
;
	CP	'3'             ; Model 3 Mode ?
	LD	A,C
	JR	NZ,VDSCR2	; Nope, Model 1 mode. Get out quietly.
;
	LD	A,(4214H)
	LD	B,A
	LD	A,C
	LD	(4214H),A	; Model 3 scroll protect address.
	LD	A,B
	JR	VDSCR2
;
VDSCR1 PUSH	DE
	LD	B,08H		; @VDCLT set scroll mode.
	LD	A,0FH		; SVC # 15 @VDCLT
	RST	028H		; Execute SVC.
	POP	DE
VDSCR2 POP	BC
	RET
;
;
;**************************************************************
;*   Name :  VDPEK	Returns character at vidio position.  *
;*   Conditions of entry ? HL = Screen position to peek.      *
;*   Conditions on return ? A = Character at position..       *
;*							      *
;*  H = Y axis cordinate (Virtical)    Lines number	      *
;*  L = X axis cordinate (Horizontal)  Line position number.  *
;**************************************************************
VDPEK	PUSH	HL
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	JR	Z,VDPEK1	; Yes, do Model 4 routine.
;
	LD	A,H
	AND	03H
	SLA	A
	SLA	A
	SLA	A
	SLA	A
	SLA	A
	SLA	A
	ADD	A,L
	LD	L,A
	LD	A,H
	SRL	A
	SRL	A
	ADD	A,3CH
	LD	H,A
	LD	A,(HL)
	JR	VDPEK2
;
VDPEK1 PUSH	BC
	PUSH	DE
	LD	B,01H		; Set-Up for SVC to return character.
	LD	A,0FH		; SVC # 15 @VDCTL video control.
	RST	028H		; Execute SVC.
	POP	DE
	POP	BC
;
VDPEK2 POP	HL
	RET
;
;===================================================================
;  START of Printer CALL routines.
;		PRCHAR 	Send one character to Printer
;		PRLINE 	Send one line to Printer.
;		PRSTAT 	Returns Printer Status.
;**************************************************************
;*   Name :  PRCHAR	Sends one character to Printer.       *
;*   Conditions of entry ?  A contains character to print.    *
;*   Conditions on return ? No registers changed.	      *
;**************************************************************
PRCHAR PUSH	DE
	LD	D,A
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	LD	A,D
	JR	Z,PRCHR1	; Yes, do Model 4 routine.
;
	CALL	003BH		; Model 1/3 PRCHAR call.
	JR	PRCHR2
;
PRCHR1 PUSH	BC
	LD	B,A
	LD	C,A		; Set-Up send character.
	LD	A,06H		; SVC # 6 @PRT to print character.
	RST	28H		; Execute SVC.
	LD	A,B
	POP	BC
;
PRCHR2 POP	DE
	RET
;
;
;**************************************************************
;*   Name :  PRLINE	Sends one line of text to printer     *
;*   Conditions of entry ?  HL = Address of text to print.    *
;*   Conditions on return ? No registers changed.	      *
;**************************************************************
PRLINE PUSH	AF
	CALL	SYSTEM
	CP	'4'             ; Model 4 Mode ?
	JR	Z,PRLIN3	; Yes, do Model 4 routine.
;
	PUSH	HL
PRLIN1 LD	A,(HL)
	CP	03H		; EXE character ?
	JR	Z,PRLIN2
	CALL	PRCHAR
	INC	HL
	CP	0DH		; Carrage Return ?
	JR	NZ,PRLIN1
PRLIN2 POP	HL
	JR	PRLIN4
;
PRLIN3 PUSH	DE
	LD	A,0EH		; SVC # 14 @PRINT to print line.
	RST	28H		; Execute SVC.
	POP	DE
;
PRLIN4 POP	AF
	RET
;
;
;**************************************************************
;*   Name :  PRSTAT	Returns Printer Status. 	      *
;*   Conditions of entry ?  No parameters.		      *
;*   Conditions on return ? Z FLAG set if clear to print.     *
;**************************************************************
PRSTAT PUSH	DE
	LD	D,A
	IN	A,(0F8H)
	AND	0F0H
	CP	30H
	LD	A,D
	POP	DE
	RET
;
;
;**************************************************************
;*   Name :  ROCHAR	Sends one character out RS232-C       *
;*   Conditions of entry ?  A contains character to output.   *
;*   Conditions on return ? No registers changed.	      *
;**************************************************************
ROCHAR PUSH	AF
ROCHR1 IN	A,(234) 	; Read RS232 control register.
	AND	40H		; Check TRANSMIT BUFFER EMPTY.
	JR	Z,ROCHR1
	POP	AF
	OUT	(235),A 	; Transmit the character.
	RET
;
;
;**************************************************************
;*   Name :  ROLINE	Output a line of text to the RS232-C  *
;*   Conditions of entry ? HL = Address of start of display   *
;*   Conditions on return ? No change to registers.	      *
;**************************************************************
ROLINE PUSH	HL
	PUSH	AF
;
ROLIN1 LD	A,(HL)		; Read character from buffer.
	CP	03H		; Is it an <ETX> character ?
	JR	Z,ROLIN2	; Jump out if so.
	CALL	ROCHAR 	; Display character.
	INC	HL		; Increment pointer.
	CP	0DH		; Was last character a <CR> ?
	JR	NZ,ROLIN1	; Repeat if not.
;
ROLIN2 POP	AF
	POP	HL
	RET
;
;
;**************************************************************
;*   Name :  RS$INIT	Initialize the RS232 communications.  *
;*   Conditions of entry ?  B = Baud rate code from 00 to 0F. *
;*			    C = Command status code.	      *
;*   Conditions on return ? No change to registers.	      *
;**************************************************************
RSINIT PUSH	AF
	LD	A,C
	OUT	(232),A 	; Reset UART control register.
	OUT	(234),A 	; Set UART control register.
	LD	A,B	;\
	SLA	A	; \
	SLA	A	;  \ _	Double the nible. 03h => 33h
	SLA	A	;  /
	SLA	A	; /
	OR	B	;/
	OUT	(233),A 	; Set baud rate. Rec = Xmit rate.
	POP	AF
	RET
;
;
;**************************************************************
;*   Name :  ROKEY	Checks the RS232 for an input char.   *
;*   Conditions of entry ?  None.			      *
;*   Conditions on return ? A contains character RECIEVED.    *
;*		  Zero Flag = Z then no character available.  *
;*		  Zero Flag = NZ then character recieved.     *
;**************************************************************
RIKEY	IN	A,(234)
	AND	80H
	RET	Z
	IN	A,(235)
	RET
;
;**************************************************************
;*   Name :  RICHAR	Waits for character from RS232 input. *
;*   Conditions of entry ?  None.			      *
;*   Conditions on return ? A contains character recieved.    *
;*		ZERO FLAG = Z if character recieved is 00H.   *
;**************************************************************
RICHAR IN	A,(234)
	AND	80H
	JR	Z,RICHAR      ; Loop back until Character ready.
	LD	A,(235)
	OR	A
	RET
;
;
;**************************************************************
;*   Name :  ROLINE	Accepts line of text from RS232-C.    *
;*   Conditions of entry ? B = Maximum length of line entered *
;*			  HL = Address of storage buffer of   *
;*				length B+1		      *
;*   Conditions on return ? B = Numbers of characters entered.*
;*		   Carry Flag = C If Control-C Recieved.      *
;**************************************************************
RILINE PUSH	HL
	PUSH	DE
	LD	D,00H		; Character counter.
	LD	E,A
	XOR	A
;
RILIN1 CALL	RICHAR 	; Get character.
	JR	Z,RILIN1	; Ignore Nulls.
	CP	03H
	JR	Z,RILIN5	; Get out if CONTROL-C recieved.
;
	CP	08		; Backup character.
	JR	Z,RILIN2	;
	CP	7FH		; Delete character.
	JR	NZ,RILIN3	;
;
RILIN2 LD	A,D		; Delete previous character routine.
	OR	A
	JR	Z,RILIN1	; Biginning of line. No more deleates.
;
	DEC	HL		; Change counters for deleate.
	DEC	D
	INC	B
	LD	A,08H		; Send out backspace character. B
	JR	RILIN4
;
RILIN3 LD	(HL),A		; Save character to buffer.
	LD	A,B
	OR	A
	JR	Z,RILIN1	; Nope, We've taken out limit per line.
;
	LD	A,(HL)
	INC	HL		; Increment character counters.
	INC	D
	DEC	B
;
RILIN4 CALL	ROCHAR 	; Echo back character to sender.
	CP	0DH		; Carrage return ?
	JR	NZ,RILIN1	; Nope, get another character.
	XOR	A		; Turn off the CARRY flag.
	JR	RILIN6
;
RILIN5 LD	A,0DH		; Process the recieved CONTROL-C.
	LD	(HL),A
	SCF			; Set the carry flag.
;
RILIN6 LD	B,D		; Set up registers for exit.
	LD	A,E
	POP	DE
	POP	HL
	RET
;
;
	END	START
