*TITLE ' Tri-Dos Version 2  System environment call.'
;
;**************************************************************
;*   Name :  $SYSTEM	Find type of TRS-80 machine.	      *
;*   Conditions of entry ?   None.			      *
;*   Conditions on return ?  None. data in internal Registers.*
;**************************************************************
$SYSTEM:	PUSH	HL
		PUSH	DE
		PUSH	BC
		PUSH	AF
;
		XOR	A		; Clear Carry flag.
		LD	HL,(0029H)	;
		LD	DE,400CH	; Test of RST 28 address.
		SBC	HL,DE
		JR	NZ,Sys4 	; If not equal then Model 4. Jump.
;
		LD	A,(0125H)	; Test for Model 3 mode.
		CP	'I'		; Middle I of III text.
		LD	A,'3'
		JR	Z,$SysL1	 ; Return if so.
		LD	A,'1'
$SysL1		LD	(@MODE),A
		LD	A,(400CH)
		CP	0C9H		; Test of RETURN command for RST 28H.
		JR	NZ,$SysL2	; Nope, Its a Jump instruction.
$SysBad 	XOR	A
;		LD	(@DOS),A	; Indicate no-Dos by 00H character.
		JP	$SysDone
;
$SysL2		LD	HL,@Mod13	; Pointer to top of list.
		LD	BC,0000H	   ; Initialize counter.
$SysL3		LD	A,(400DH)	; Get DOS jump LSB address for RST 28H.
		CP	(HL)		; Test byte in list.
		JR	Z,$SysL4	; Found it ?  Jump if yes.
		INC	BC		; Increment counter.
		XOR	A
		CP	(HL)		; Test for end of list ?
		INC	HL		; Increment list pointer.
		JR	NZ,$SysL3	; Jump if not at end of list.
;
		JP	$SysBad 	; System was not in list.
					; Treat as Cassette system.
;
;===================================================
;	Dos BYTE table matched to @Dos13 table.
@Mod13		DEFB	82H   ; MODEL 3 TRSDOS 1.3
		DEFB	63H   ; MODEL 3 TRSDOS 1.2
		DEFB	0CCH   ; MODEL 3 LDOS 5.*
		DEFB	0B3H   ; MODEL 3 DOSPLUS 3.3
		DEFB	57H   ; MODEL 3 DOSPLUS 3.4
		DEFB	8EH   ; MODEL 3 DOSPLUS 3.5
		DEFB	67H   ; MODEL 3 NEWDOS80/V2
		DEFB	0A2H  ; Model 1 TRSDOS 2.3
		DEFB	00H   ; MODEL 1/3 CASSETTE.
;
$SysL4		LD	HL,@Dos13	; Point to DOS type table
		ADD	HL,BC		; Add offset to address.
		LD	A,(HL)		; Get DOS version.
		LD	(@DOS),A	; Save it in internal register.
;
		CP	50H		; LDOS 5.* ?
		JR	NZ,$SysL5	; Skip if not.
		LD	A,(441FH)	; Get LDOS version number,
		LD	(@DOS),A	; and save it in internal register.

$SysL5		JP	$SysDone	; Put additional DOS variant checks here.

;===================================================
;	Dos type table matched to @MOD13 table.
@Dos13		DEFB	13H   ; MODEL 3 TRSDOS 1.3
		DEFB	12H   ; MODEL 3 TRSDOS 1.2
		DEFB	50H   ; MODEL 3 LDOS 5.*
		DEFB	33H   ; MODEL 3 DOSPLUS 3.3
		DEFB	34H   ; MODEL 3 DOSPLUS 3.4
		DEFB	35H   ; MODEL 3 DOSPLUS 3.5
		DEFB	80H   ; MODEL 3 NEWDOS80/V2
		DEFB	23H   ; Model 1 TRSDOS 2.3
		DEFB	00H   ; MODEL 1/3 CASSETTE.
;
$Sys4:		LD	A,'4'		; MODEL 4 MODE.
		LD	(@MODE),A

		LD	HL,@Mod4	; Pointer to top of list.
		LD	BC,0000H	; Initialize counter.

$SysL6		LD	A,(0029H)	; Get DOS jump LSB address for RST 28H.
		CP	(HL)		; Test byte in list.
		JR	Z,$SysL7	; Found it ?  Jump if yes.

		INC	BC		; Increment counter.
		XOR	A
		CP	(HL)		; Test for end of list ?
		INC	HL		; Increment list pointer.
		JR	NZ,$SysL6	; Jump if not at end of list.
;
		JP	$SysBad 	; System was not in list.
					; Treat as Model 4 Cassette system.
;
;===================================================
;	Dos BYTE table matched to @Dos13 table.
@Mod4		DEFB	4EH   ; MODEL 4 TRSDOS 6.0
		DEFB	4FH   ; MODEL 4 TRSDOS 6.1
		DEFB	5BH   ; MODEL 4 TRSDOS 6.2 & LS-DOS 6.3
		DEFB	4BH   ; MODEL 4 DOSPLUS-4
		DEFB	58H   ; MODEL 4 Multidos 4 Version 1.71
		DEFB	00H   ; MODEL 4 Unknown.
;
$SysL7		LD	HL,@Dos4	; Point to DOS type table
		ADD	HL,BC		; Add offset to address.
		LD	A,(HL)		; Get DOS version.
		LD	(@DOS),A	; Save it in internal register.
;
		CP	62H		; LS-DOS 6.2 or maybe 6.3 ?
		JR	NZ,$SysL8	; Skip if not.
		PUSH	IY
		LD	A,65H		; $FLAG SVC call.
		LD	A,(IY+27)	; Get 6.2 or 6.3 version byte.
		POP	IY
		LD	(@DOS),A	; and save it in internal register.

$SysL8		JP	$SysDone	; Put additional DOS variant checks here.

;===================================================
;	Dos type table matched to @MOD13 table.
@Dos4		DEFB	60H   ; MODEL 4 TRSDOS 6.0
		DEFB	61H   ; MODEL 4 TRSDOS 6.1
		DEFB	62H   ; MODEL 4 TRSDOS 6.2 & LS-DOS 6.3
		DEFB	40H   ; MODEL 4 DOSPLUS-4
		DEFB	17H   ; MODEL 4 Multidos 4 Version 1.71
		DEFB	00H   ; MODEL 4 Unknown.
;
$SysDone	POP	AF
		POP	BC
		POP	DE
		POP	HL
		RET
;
@MODE:		DEFB	00H	; Ascii value of mode 1,3,4
@DOS:		DEFB	00H	; Hex equavelent DOS code.

		END

; TRI-DOS system environment code. Written July 14, 1987 by David Arcand.
