;HIRES/CMD - for working with the MicroLabs HIRES board.
;Allows display, printing directions, and other features
;Copyright 1987 by Mel Patrick
;
	ORG	3000H
	GET	MASTER/SVC
ptype	DB	0		;0=Epson/Roland, 1=Prowriter/Imagewriter
begin	CALL	resoff		;turn off HIRES board display
	LD	HL,p1		;point to Epson/Roland
	LD	A,(ptype)	;test for type
	CP	1		;1=prowriter
	JR	NZ,begin0	;continue if not
	LD	HL,p2		;else its a prowriter
begin0	LD	DE,printer	;point to destination
	LD	BC,14		;bytes to move
	LDIR			;and do it
begin1	LD	A,@cls
	RST	svc
	XOR	A
	LD	(link),A	;turn of page link
	LD	HL,menu		;get a selection
	CALL	disply		;show on normal video
	LD	A,@key
	RST	svc
	CP	80H		;back to DOS?
	JP	Z,todos
	AND	5fH		;convert to upper case
	PUSH	AF
	LD	C,A
	LD	A,@dsp
	RST	svc
	POP	AF		;get back character
	CP	'E'		;else erase it all
	JP	Z,erase		;go if yes
	CP	'I'		;special
	JP	Z,invert	;do inverse
	CP	'P'		;print it sideways?
	JP	Z,print1	;go if yes
	CP	'R'		;read a MACPAINT file?
	JP	Z,domac		;try it if yes
	CP	'V'		;just view the pix
	JP	Z,view		;go if yes
	CP	'D'		;display current screen
	JP	Z,trydsp	;go if yes
	CP	'G'		;get standard file 19.5K type?
	JP	Z,rdsta		;go if yes
	CP	'S'		;save the image
	JP	Z,dosave	;try it anyways
	CP	'L'		;do a load?
	JP	Z,doload	;go if yes
	CP	'C'		;catalog
	JP	Z,docat		;go if yes
	CP	'H'		;try this one
	JP	Z,printv	;print vertical image
	CP	'X'		;toggle printer types
	JR	Z,togprt	;go if yes
	JR	begin1		;back if none the the above
;
togprt	LD	A,(ptype)	;get printer type
	XOR	1		;toggle it on/off
	LD	(ptype),A	;save it
	JP	begin		;and restart routine
;
dosave	LD	HL,fprom	;filename prompt
	CALL	disply
	LD	HL,inbuff	;input buffer
	LD	B,32		;maximum allowed
	LD	A,@keyin	;get input
	RST	svc
	JP	C,begin		;back if out wanted
	LD	A,B		;else check length
	OR	A		;Z=nothing
	JP	Z,begin		;back on no entry
	LD	HL,inbuff	;else point to entry
	LD	DE,fbuff	;point to file buffer
	LD	A,@fspec	;create the file
	RST	svc
	JP	NZ,dskerr	;go if disk error
	LD	HL,dummy	;point to buffer
	LD	DE,fbuff	;point to FCB
	LD	B,0		;set LRL=256
	LD	A,@init		;create or overwrite
	RST	svc
	JP	NZ,dskerr	;go if disk error
	LD	HL,0		;set x/y to 0
	LD	(cor),HL	;save them
svlp	LD	HL,wrtbuf	;erase buffer first
	PUSH	HL
	POP	DE
	INC	DE
	LD	BC,99		;trial for now
	LD	(HL),0		;zero it out
	LDIR	 		;before using it
	CALL	rdline		;read in a line of graphics
	LD	DE,wrtbuf	;point to disk output buffer (WRTBUF)
	PUSH	DE		;move to IX
	POP	IX		;used for patterns
	LD	HL,grbuff	;point to data read in GRBUFF
	LD	C,80		;bytes per line max
mainlp	LD	A,(HL)		;get byte from buffer read in
	INC	HL		;add 1 to it
	DEC	C		;minus 1 from it
	JR	Z,wr2dsk	;go if 80 bytes done
	CP	(HL)		;see if same pattern or repeating
	JR	NZ,onepat	;go if single byte pattern
	INC	DE		;else point to location to save pattern
	LD	(DE),A		;save it
	INC	(IX)		;add 1 for first one found
same	SET	7,(IX)		;set bit 7 to show repeating
	INC	(IX)		;add 1 to count
	INC	HL		;point to next character
	DEC	C		;minus 1 from counter
	JP	Z,wr2dsk	;go if all done
	CP	(HL)		;else check next pattern
	JR	Z,same		;if same, repeat here
	JR	bmain0		;else skip decrement
bmain	DEC	HL		;else back up one in the buffer
bmain0	INC	DE		;point to next location
	PUSH	DE		;make IX=DE
	POP	IX		;ix=start of next byte location
	JR	mainlp		;and back to main loop
onepat	INC	(IX)		;single pattern routine, count them
	INC	DE		;point to where to store it
	LD	(DE),A		;save it
	LD	A,(HL)		;get this new byte
	INC	HL		;point to next character in buffer
	DEC	C		;minus 1 from count
	JR	Z,ego		;go if all done
	CP	(HL)		;else see if same
	JR	NZ,onepat	;add 1 to count if different
	INC	C		;add 1 to C
	JR	bmain		;else reset pointers and continue
ego	INC	(IX)		;add 1 for last character
	INC	DE		;point to next location
	LD	(DE),A		;save last character on line
wr2dsk	INC	DE		;point to 1 past buffer
	LD	HL,wrtbuf	;point to start of buffer
	EX	DE,HL		;hl=higher address now
	OR	A		;clear the carry
	SBC	HL,DE		;HL-DE=size (length) OF BUFFER
	LD	B,L		;move into loop
	LD	HL,wrtbuf	;point to buffer
wr2lp	LD	DE,fbuff	;point to filespec
	LD	C,(HL)		;get a byte
	LD	A,@put		;write to disk
	RST	svc
	JP	NZ,dskerr	;go if disk error in write
	INC	HL		;else point to next
	DJNZ	wr2lp		;loop til whole data line written out
	LD	HL,(cor)	;see if all done
	LD	A,H		;if A=240, then complete
	CP	240		;number of rows max
	JP	NZ,svlp		;loop for more if not done
	LD	DE,fbuff	;else close the file
	LD	A,@close
	RST	svc
	JP	begin		;and back to menu
;
doload	LD	HL,lprom	;load prompt
	CALL	disply
	LD	HL,inbuff	;input buffer
	LD	B,32		;maximum allowed
	LD	A,@keyin	;get input
	RST	svc
	JP	C,begin		;back if out wanted
	LD	A,B		;else check length
	OR	A		;Z=nothing
	JP	Z,begin		;back on no entry
	LD	HL,inbuff	;else point to entry
	LD	DE,fbuff	;point to file buffer
	LD	A,@fspec	;create the file
	RST	svc
	JP	NZ,dskerr	;go if disk error
	LD	HL,dummy	;point to buffer
	LD	DE,fbuff	;point to FCB
	LD	B,0		;set LRL=256
	LD	A,@init		;create or overwrite
	RST	svc
	JP	NZ,dskerr	;go if disk error
	CALL	clrhi		;erase board first
	CALL	reson		;turn on hi res board
	LD	HL,0		;set x/y to 0
	LD	(cor),HL	;save them
ldlp0	XOR	A		;remove counter
	LD	(char),A	;so we can see when to move to next line
ldlp	LD	DE,fbuff	;and read from disk
	LD	A,@get		;character in A
	RST	svc
	JP	NZ,dskerr	;go if disk error
	BIT	7,A		;see if repeating pattern, or single
	JR	Z,ldsing	;go if single bytes
	AND	7FH		;mask out total for repeat count
	LD	B,A		;subtract 128 from it (gives 0-80)
	CALL	addchr		;add to count
	PUSH	BC		;save count
	LD	DE,fbuff	;point to read pattern
	LD	A,@get		;and get the next character
	RST	svc
	POP	BC		;restore counter
	JP	NZ,dskerr	;go if error
	LD	(pattern),A	;else save pattern
prtdup	CALL	write		;and write a character to screen
	CALL	addx		;add to step across screen
	DJNZ	prtdup		;and continue
	JR	ldend		;see if end of line
ldsing	LD	B,A		;move to loop for reading
	CALL	addchr		;add to character count
ldslp	PUSH	BC		;save counter
	LD	DE,fbuff	;then read in that many characters
	LD	A,@get
	RST	svc
	POP	BC		;get back counter
	JP	NZ,dskerr	;exit if error in read
	LD	(pattern),A	;save next pattern
	CALL	write		;write to video display
	CALL	addx		;add to horz position
	DJNZ	ldslp		;loop til all read in
ldend	LD	A,(char)	;get character count
	CP	80		;end of line?
	JP	NZ,ldlp		;continue if not end of line
	CALL	addy		;step down to next row
	LD	A,H		;see if past end of screen (240)
	CP	240		;if yes, all loaded
	JP	Z,waitb		;wait if all loaded
	JP	ldlp0		;else back for more
;
rdsta	LD	HL,rprom	;load prompt
	CALL	disply
	LD	HL,inbuff	;input buffer
	LD	B,32		;maximum allowed
	LD	A,@keyin	;get input
	RST	svc
	JP	C,begin		;back if out wanted
	LD	A,B		;else check length
	OR	A		;Z=nothing
	JP	Z,begin		;back on no entry
	LD	HL,inbuff	;else point to entry
	LD	DE,fbuff	;point to file buffer
	LD	A,@fspec	;create the file
	RST	svc
	JP	NZ,dskerr	;go if disk error
	LD	HL,dummy	;point to buffer
	LD	DE,fbuff	;point to FCB
	LD	B,0		;set LRL=256
	LD	A,@init		;create or overwrite
	RST	svc
	JP	NZ,dskerr	;go if disk error
	CALL	reson		;turn on hi res board
	CALL	clrhi		;erase board first
	LD	HL,0		;set x/y to 0
	LD	(cor),HL	;save them
stand	LD	DE,fbuff	;point to buffer
	LD	A,@get		;read a byte
	RST	svc
	JP	NZ,dskerr	;go if disk error
	LD	(pattern),A	;save pattern to write to video
	CALL	write		;write to video display
	CALL	addx		;add 1 to column
	LD	A,L		;get X position
	CP	80		;right side of video?
	JR	NZ,stand	;loop for more if not there yet
	CALL	addy		;else step to next row
	LD	A,H		;get MSB of row
	CP	240		;at max pix?
	JR	NZ,stand	;loop for more if not
	JP	waitb		;else beep and wait
;
printv	LD	HL,res		;normal or expanded?
	CALL	disply		;show it
	LD	A,@key		;wait for input
	RST	svc
	JP	C,begin		;back if break
	AND	5fH		;else convert to upper case
	CP	'N'		;normal?
	JR	Z,vnorm
	CP	'E'		;else expanded
	JR	Z,vdbl		;if expanded
	JR	printv		;else set NZ and print it
vnorm	XOR	A		;Z=normal 1 to 1
vdbl	LD	(exp),A		;save flag
	CALL	reson		;turn on hi res board
	CALL	pstart		;set line spacing for printer
prtsub	LD	HL,0		;set co-ordinates
	LD	(cor),HL	;save it
	LD	(temp1),HL	;save for restore
	LD	B,30		;allows 30 lines to be processed
outside PUSH	BC		;save it
	LD	IX,vbuff	;point to vertical buffer
	LD	IY,vbuff2	;in case we want a double size image
	LD	B,80		;allow 80 bytes per line of info
linelp	PUSH	BC		;save for line loop
	LD	B,8		;read off 8 bytes vertically
	LD	DE,temp		;point to temp buffer to read
rdcell	CALL	read		;read a byte from screen
	LD	(DE),A		;save in buffer
	INC	DE		;point to next
	CALL	doxor0		;complement what was read in
	CALL	write		;and write, shows progress
	CALL	yonly		;step down to next line (Y+1)
	DJNZ	rdcell		;read in one 8x8 cell
	LD	B,8		;move out 8 bytes
fmtcl	PUSH	BC		;for the 8 cells
	CALL	mapbit		;go map the bits
	INC	IX		;point to next in buffer
	INC	IY		;even if we don't use it
	POP	BC		;get back cell counter 8x8
	DJNZ	fmtcl		;loop for 8 bits
	LD	HL,(temp1)	;get last starting position
	INC	L		;add 1 to X position
	LD	(temp1),HL	;save it
	LD	(cor),HL	;save it again
	POP	BC		;get line position counter
	DJNZ	linelp		;loop for the 80 bytes on the line
	LD	HL,(temp1)	;get last start
	LD	L,0		;set for start again
	LD	A,H		;get last video location
	ADD	A,8		;add 8 to it
	LD	H,A		;stuff it back in
	LD	(temp1),HL	;save it for next loops
	LD	(cor),HL	;again
	CALL	pvline		;and print 1 vertical line
	POP	BC		;get back line counter
	DJNZ	outside		;and loop for next set
	LD	A,(link)	;see if calling from TRYDSP
	OR	A		;Z=no, NZ=YES
	RET	NZ		;back if from a CALL
	JP	invert		;restore video, then back to menu
;
pvline	CALL	vsub		;send out first line to ptype
	LD	HL,vbuff	;point to buffer to send out
	CALL	pvsub		;print a line (always)
	LD	A,(exp)		;see if exp or normal
	OR	A		;Z=nromal, NZ=exp
	RET	Z		;back if 1 to 1
	CALL	vsub0		;then see if double wanted
	LD	HL,vbuff2	;point to second buffer
pvsub	LD	BC,640		;bytes to print
pvlp	PUSH	BC		;save it
	LD	C,(HL)		;get a byte
	LD	A,@prt		;send to printer
	RST	svc
	INC	HL		;point to next
	POP	BC
	DEC	BC		;minus 1 from count
	LD	A,B
	OR	C		;see if all done
	JR	NZ,pvlp		;else loop for more
	LD	C,13		;then send a c/r
	LD	A,@prt
	RST	svc
	RET				;send a c/r and return
;
mapbit	LD	A,(exp)		;test for exp or normal
	OR	A		;Z=normal, NZ=exp
	JR	NZ,vdouble	;go if double size wanted
	LD	DE,temp		;point to bytes read in
	LD	B,8		;this is for the rows in the cells
	LD	C,0		;start with C=0 for rotate
fmtcel	CALL	grfmt		;format the graphics
	DJNZ	fmtcel		;and format the cell to the buffer
	LD	(IX),C		;insert this byte in buffer
	RET				;and back from 1 to 1 routine
vdouble LD	DE,temp		;point to 8 bit buffer
	LD	B,4		;only want top four bits
	LD	C,0		;set C to use
vdlp	CALL	grfmtd		;and double format it
	DJNZ	vdlp		;loop for 4 bytes
	LD	(IX),C		;insert in buffer now
	LD	B,4		;now we work with the bottom 4 bits
	LD	C,0		;setup again
vdlp0	CALL	grfmtd		;and double format in second part
	DJNZ	vdlp0		;loop for bottom four bits
	LD	(IY),C		;then insert in second buffer
	RET				;and go back all done
;
print1	LD	HL,res		;normal or expanded?
	CALL	disply		;show it
	LD	A,@key		;wait for input
	RST	svc
	JP	C,begin		;back if break
	AND	5fH		;else convert to upper case
	CP	'N'		;normal?
	JR	Z,donorm
	CP	'E'		;else expanded
	JR	NZ,print1	;skip if not expanded
	JR	doprt		;else set NZ and print it
donorm	XOR	A		;Z=normal 1 to 1
doprt	LD	(exp),A		;save flag
	CALL	reson		;turn on hi res board
	CALL	pstart		;set line spacing for printer
	LD	HL,0		;gets changed
	LD	(cor),HL	;save
	LD	B,80		;columns to read
prlp2	LD	A,B		;stuff it in for read
	DEC	A		;make it 79-0
	LD	(cor),A		;save X value
	LD	DE,pbuff	;point to printer buffer
	PUSH	BC		;save it
	LD	B,240		;rows to read in
prlp0	CALL	read		;read byte from hi res
	CALL	doxor0		;set the pattern to write back
	CALL	write		;and write it back to screen
	PUSH	BC		;save counter
	LD	B,8		;bits to barrel rotate
	LD	C,0		;set c reg to zero A--->C backwards
	LD	A,(ptype)	;test for printer type
	CP	1		;=prowriter
	JR	NZ,notpro	;go if not prowriter
	LD	A,(byte)	;else read byte
	JR	trick		;and skip rotate (not needed)
notpro	LD	A,(byte)	;get character read off video
tricky	SLA	A		;shift a to the left through carry
	RR	C		;and rotate bits back into C reg
	DJNZ	tricky		;loop for 8 bits
	LD	A,C		;get back value, reversed order
trick	LD	(DE),A		;add to buffer
	INC	DE
	POP	BC		;get back counter
	LD	A,(exp)		;see if expanded print wanted
	OR	A		;Z=normal, 1 to 1, NZ=double size
	JR	Z,std		;go if standard size
	DEC	DE		;else backup to get previous char
	LD	A,(DE)		;get original character
	INC	DE		;point to new location
	LD	(DE),A		;save it for double width
	INC	DE		;point to next new location
std	LD	A,(cor+1)	;get Y value
	INC	A		;add 1 from it
	LD	(cor+1),A	;save it again
	DJNZ	prlp0		;loop for 1 column
	CALL	pgraph		;set for single width
	LD	A,(exp)		;Z=normal, NZ=exp
	OR	A		;test flag
	JR	Z,setprt	;and set printer code up
	CALL	p1gr		;set for double width
setprt	CALL	lprint		;send to printer
	LD	HL,pbuff	;point to first part of buffer
	LD	B,240		;characters to send out
	CALL	lprint		;send line to printer
	LD	A,(exp)		;see if expanded or normal
	OR	A		;Z=normal NZ=expanded
	JR	Z,endn		;go if normal end
	LD	HL,pbuff1	;else send second part
	LD	B,240		;else its expanded do rest of line
	CALL	lprint		;and print it
endn	LD	C,13		;then a c/r
	LD	A,@prt
	RST	svc		;in case we need it
	LD	HL,(cor)	;get current X/Y
	LD	HL,0		;reset to 0,0 (changed later)
	LD	(cor),HL	;save it
	POP	BC		;get back outside loop
	DJNZ	prlp2		;loop til all done
	CALL	pset		;see which kind of reset to use
	JP	invert		;restore image then menu
;
erase	CALL	reson		;turn on board
	CALL	clrhi		;erase hi res screen
	JP	wait		;and then wait
;
clrhi	LD	BC,0		;set x,y (row/col)
clrcol	LD	A,C		;get column
	OUT	(80H),A		;set position
	LD	A,B		;get row
	OUT	(81H),A		;set column we want (starts at 0,0)
	XOR	A		;remove anything in A for write
	OUT	(82H),A		;send to graphics board
	DJNZ	clrcol		;and clear 1 column
	INC	C		;add 1 to column to clear
	LD	A,C		;get it
	CP	80		;see if all done
	JR	NZ,clrcol	;advance to next column if not done
	RET				;and then go back
;
invert	CALL	reson		;turn on hires
	LD	B,80		;columns max to use
loop0	LD	L,B		;get columns to use
	DEC	L		;make it 0-79
	PUSH	BC		;save counter
	LD	B,240		;inside loop (vertical)
loop1	LD	H,B		;get inside location
	DEC	H		;make it 0-239
	LD	(cor),HL	;save row/col to use
	CALL	doxor		;toggle byte
	CALL	write		;and write pattern to video
	LD	HL,(cor)	;get back xy positon
	DJNZ	loop1		;loop for 1 vertical row
	POP	BC		;get back outside loop counter
	DJNZ	loop0		;and loop back for another column 80 max
	JP	wait		;and wait
;
trydsp	CALL	resoff		;turn off res board
	LD	A,(flflag)	;see if file in memory to display
	OR	A		;Z=no, NZ=yes
	JR	NZ,grdisp	;continue if yes
	CALL	resoff		;else turn off hires
	LD	HL,sorry	;dislay sorry message
	CALL	disply
	JP	wait		;and wait
grdisp	LD	HL,type		;get type of display want
	CALL	disply		;show it
	LD	A,@key
	RST	svc
	AND	5fH
	CP	'P'		;positive
	JR	Z,dopos
	LD	A,1		;else negative
	JR	dopos0		;go and set and save
dopos	XOR	A		;zero out A
dopos0	LD	(dtype),A	;save it
reask	LD	HL,dopaint	;see if paint wanted
	CALL	disply
	LD	A,@key
	RST	svc
	JP	C,begin		;out on break
	AND	5FH		;else make it upper
	CP	'Y'		;hardcopy?
	JR	Z,dohard	;go if yes
	CP	'N'		;else no?
	JR	NZ,reask	;reask if not
	XOR	A		;remove hardcopy flag
dohard	LD	(link),A	;save flag if required
	XOR	A		;set for NORMAL print, not expand
	LD	(exp),A		;save it
	LD	A,(link)	;see if printer needs setting
	OR	A		;Z=no, NZ=yes
	JR	Z,noset		;skip if not
	CALL	pstart		;set line spacing for printer
noset	CALL	reson		;turn on board
	XOR	A		;remove char per line counter
	LD	(char),A	;save it
	LD	(line),A	;save lines counter
	LD	(page),A	;save page counter too
	CALL	clrhi		;erase any pix there now
	LD	HL,0		;start at top of video
	LD	(cor),HL	;save it for X,Y addressing
	LD	DE,macbuf	;point to the buffer
slate	LD	A,(DE)		;see if empty for first part
	OR	A		;Z=yes, NZ=start of something
	JR	NZ,okst		;go if ok to start
	LD	HL,80H		;possible offset to use
	ADD	HL,DE		;HL points half way through the sector
	EX	DE,HL		;swap them and start display routine
okst	LD	(pix),DE	;else save start of the picture
grlp	LD	A,(DE)		;read byte from memory info
	BIT	7,A		;Z=single characters, NZ=repeat ones
	JR	NZ,repeat	;go if repeat routine wanted
	LD	B,A		;else move to loop counter
	INC	B		;add 1 to it to get total to print
	INC	DE		;point to first character
	CALL	addchr		;add to char per line count
single	LD	A,(DE)		;get a byte
	CALL	doxor1		;toggle pattern
	LD	(pattern),A	;save it
	CALL	write		;write to video
	CALL	addx		;add 1 to x value
	INC	DE		;point to next character to use
	DJNZ	single		;loop for B characters
	JR	chkend		;go see if end of line
repeat	LD	B,A		;move value to B for subtract
	LD	A,1		;use formula A-B (or 1-#)
	SUB	B		;will return a value from 1-72
	LD	B,A		;move answer back to B for loop
	CALL	addchr		;add to char per line count
	INC	DE		;point to repeating data
	LD	A,(DE)		;get the bit pattern
	CALL	doxor1		;toggle pattern
	LD	(pattern),A	;save for writing
replp	CALL	write		;and write it to video
	CALL	addx		;add 1 to horizontal position
	DJNZ	replp		;loop for B characters
	INC	DE		;add 1 to pointer
chkend	LD	A,(char)	;get characters we have on the line
	CP	72		;if 72, then must go to next line
	JP	NZ,grlp		;loop back if not
	XOR	A		;else remove char counter
	LD	(char),A	;save it
	CALL	addy		;step to next line
	LD	A,(line)	;get current line we are on 0-239
	INC	A		;add 1 to line
	LD	(line),A	;save it
	CP	240		;see if at max
	JP	NZ,grlp		;back for more if not
	XOR	A		;else remove line counter
	LD	(line),A	;save it
	LD	A,(link)	;see if in routine for hardcopy
	OR	A		;Z=no, NZ=yes
	JR	NZ,skpkey	;skip this prompt
	PUSH	DE
	LD	A,@key		;else better wait for a key
	RST	svc
	POP	DE		;save reg
	CP	80h		;if break, back to menu
	JP	Z,begin		;back if yes
skpkey	LD	A,(page)	;else get page we are on 0-2
	INC	A		;add 1 to page count
	LD	(page),A	;save it
	CP	3		;end of thing?
	JR	NZ,pcont	;continue if not
	LD	A,(link)	;see if paghe dump on
	OR	A		;Z=no, NZ=yes
	CALL	NZ,prtsub	;print it out if yes
	LD	A,(link)	;then check it again
	OR	A		;Z=continue, NZ=all done, back to menu
	JP	NZ,begin	;back to menu if done
	XOR	A		;else remove page count
	LD	(page),A	;save it
	LD	DE,(pix)	;get start of image
pcont	LD	(page1),DE	;save it for later
	LD	A,(link)	;see if hardcopy wanted
	OR	A		;Z=no, NZ=yes
	CALL	NZ,prtsub	;print out the screen if YES
	CALL	clrhi		;clear hi res board
	LD	HL,0		;start x,y
	LD	(cor),HL	;reset points
	LD	DE,(page1)	;get start of image again
	JP	grlp		;and back for more
;
addx	LD	HL,(cor)	;get x/y
	INC	L		;add 1 to X
	LD	(cor),HL	;save it for next time
	RET				;and back to caller
;
addy	LD	HL,(cor)	;get current X,Y (L=X, H=Y)
	LD	L,0		;reset L to start of column
	INC	H		;add 1 to Y position
	LD	(cor),HL	;save it
	RET				;and go back
;
yonly	LD	HL,(cor)	;get current x/y
	INC	H		;add 1 to h only
	LD	(cor),HL	;save it
	RET				;and go back
;
rdline	LD	DE,grbuff	;point to storage location
	LD	B,80		;bytes to read in
rdgrln	CALL	read		;read in one byte from screen
	LD	A,(byte)	;get it
	LD	(DE),A		;save in buffer
	INC	DE		;point to next
	CALL	addx		;step to next location
	DJNZ	rdgrln		;and loop for 80 columns
	CALL	addy		;then step to next row
	RET				;and go back
;
addchr	LD	A,(char)	;get characters on line so far
	ADD	A,B		;add current total to display
	LD	(char),A	;save the new total
	RET				;and go back
;
waitb	LD	B,3
	LD	A,@sound
	RST	svc
	JR	wait		;beep and wait
view	CALL	reson		;turn on hires board
wait	LD	A,@key
	RST	svc
	JP	begin		;back to menu
;
resoff	LD	A,252		;code to disable it
	OUT	(131),A		;send it out
	RET				;and go back
;
reson	LD	A,255		;on code
	OUT	(131),A		;send it out
	RET				;and go back
;
write	PUSH	HL		;save all regs
	PUSH	BC		;first
	LD	C,128		;X corrdinate
	LD	HL,(cor)	;L=X, H=Y
	LD	A,(pattern)	;A=byte to write out
	OUT	(C),L		;send to board
	INC	C		;C=129 (Y Cord)
	OUT	(C),H		;send to board
	INC	C		;C=130 (data bits)
	OUT	(C),A		;send it
	POP	BC		;restore them now
	POP	HL		;before returning
	RET				;and go back
;
read	PUSH	HL		;save it
	PUSH	BC		;and this
	LD	C,128		;X
	LD	HL,(cor)	;get x,y first
	OUT	(C),L
	INC	C
	OUT	(C),H		;set X,Y first
	LD	C,131		;then set it back now
	IN	A,(C)		;read from graphic screen
	LD	(byte),A	;save it
	POP	BC
	POP	HL		;restore regs
	RET				;and go back
;
domac	LD	HL,prompt	;point to prompt
	CALL	disply
	LD	HL,dummy	;point to buffer
	LD	B,32		;maximum allowable
	LD	A,@keyin	;get input
	RST	svc
	JP	C,begin		;back on break
	LD	A,B		;else check length
	OR	A		;Z=nothing
	JP	Z,begin
	LD	HL,dummy	;else point to buffer
	LD	DE,fbuff	;point to FCB
	LD	A,@fspec	;create the filename
	RST	svc
	JP	NZ,dskerr	;go if disk error
	LD	HL,dummy	;else OPEN the file
	LD	DE,fbuff
	LD	B,0		;SET LRL=256
	LD	A,@open
	RST	svc
	JP	NZ,dskerr	;go if error
	LD	DE,fbuff	;else move to 513 byte block (2 sectors)
	LD	A,@read		;and do it
	RST	svc
	JP	NZ,dskerr
	LD	DE,fbuff
	LD	A,@read
	RST	svc
	JP	NZ,dskerr
	LD	HL,macbuf	;point to buffer for reading
image	LD	DE,fbuff	;point to FCB
	LD	A,@read		;read in the data
	RST	svc
	JR	NZ,eof		;go if end of file?
	LD	DE,dummy	;set up for exchange
	EX	DE,HL		;HL=source, DE=destination
	LD	BC,256		;copy out this many bytes
	LDIR				;and move them out of the buffer
	EX	DE,HL		;point HL back to start of next location
	LD	C,'.'		;show something while we wait
	LD	A,@dsp
	RST	svc
	JR	image		;loop for how many blocks it takes
eof	CP	1CH		;end of file?
	JR	Z,ldok		;go if loaded ok
	CP	1DH		;else split record load?
	JP	NZ,dskerr	;go if not split, error
ldok	LD	HL,sucess	;else its all loaded
	CALL	disply
	LD	A,1		;turn on loaded flag
	LD	(flflag),A	;save it
	LD	A,@key
	RST	svc
	AND	5fH		;convert to upper case
	CP	'V'		;view the file
	JP	Z,trydsp	;display it if yes
	CP	'M'		;menu
	JP	Z,begin		;go if yes
	CP	'L'		;else load another?
	JP	Z,doload	;go if yes
	JR	ldok		;else wrong key
;
docat	LD	HL,cprom	;which drive?
	CALL	disply
	LD	A,@key
	RST	svc
	CP	'0'		;checklimits
	JP	C,begin
	CP	'8'		;too high?
	JP	NC,begin
	LD	(cat),A		;else save it
	LD	C,A		;display it
	LD	A,@dsp
	RST	svc		;for the heck of it
	LD	C,13
	LD	A,@dsp
	RST	svc
	LD	A,@flags
	RST	svc
	SET	4,(IY+2)	;allow TRSDOS commands only
	LD	HL,catcmd	;point to string
	LD	A,@cmndr	;execute and resume
	RST	svc
	LD	A,@flags
	RST	svc
	RES	4,(IY+2)	;back to normal
	JP	waitb		;and wait
;
dskerr	OR	0C0H		;set return bits in A
	LD	C,A		;then move for display
	LD	A,@error	;display the error received
	RST	svc
	XOR	A		;turn off flag for loaded ok
	LD	(flflag),A	;save it
	JP	wait		;and wait
;
doxor	CALL	read		;read the byte first
	LD	A,(byte)	;get byte read in
doxor0	CPL			;toggle all the bits
	LD	(pattern),A	;save it and return
	RET			;with new characters
;
doxor1	LD	C,A		;save character
	LD	A,(dtype)	;Z=normal , NZ=toggle
	OR	A
	LD	A,C		;get byte back
	RET	NZ		;back if normal
	JR	doxor0		;else toggle and return
;
pstart	LD	HL,pinit	;point to epson/roland
	LD	B,3		;send out line spacing adjustment
	LD	A,(ptype)	;test for printer type
	OR	A		;0=Epson/Roland
	JR	Z,doinit	;and go
	LD	B,7		;bytes to send out
	LD	HL,p1init	;else its prowriter/imagewriter
doinit	CALL	lprint		;so we can set up the printer
	RET			;and go back all done now
;
pgraph	LD	HL,pcmd1	;epson/roland normal length
	LD	B,4		;bytes to send out
	LD	A,(ptype)	;test for type of printer
	OR	A		;Z=roland/epson
	RET	Z		;back if yes
	LD	HL,p1cmd1	;else its a prowriter/imagewriter
	LD	B,6		;send out six bytes
	RET			;else back with it
;
p1gr	LD	HL,pcmd		;else check next style
	LD	B,4		;bytes to send
	LD	A,(ptype)	;check type
	OR	A		;Z=epson/roland
	RET	Z		;back if yes
	LD	HL,p1cmd	;else its double
	LD	B,6		;bytes to send out
	RET			;and go back
;
pset	LD	HL,preset	;epson/roland reset
	LD	B,3		;bytes to send
	LD	A,(ptype)	;test for type of printer
	OR	A		;0=epson,roland
	JR	Z,doinit	;go if this one
	LD	HL,p1reset	;else it prowriter reset
	LD	B,5		;bytes to send out
	JR	doinit		;and do it
;
vsub	LD	HL,vprt		;epson/roland
	LD	B,5		;bytes to print
	LD	A,(ptype)	;test for printer type
	OR	A		;Z=epson roland type
	JP	Z,doinit	;and do it
	LD	HL,v1prt	;else its prowriter type
	LD	B,6		;bytes to send
	JP	doinit		;and do it
;
vsub0	LD	HL,vprt2	;else see if double wanted
	LD	B,5		;bytes to send
	LD	A,(ptype)	;test type to use
	OR	A		;Z=epson roland
	JP	Z,doinit	;go if epson
	LD	HL,v1prt2	;else use prowriter
	LD	B,6		;send out six bytes
	JP	doinit		;and continue
;
grfmt	LD	A,(ptype)	;check printer type
	CP	1		;prowriter?
	JR	Z,grtp1		;go if yes
	LD	A,(DE)		;else read a byte
	SLA	A		;shift them one
	LD	(DE),A		;save it for next time
	RL	C		;shift them into C
	INC	DE		;point to next
	RET			;and go back
grtp1	LD	A,(DE)		;get a byte
	SLA	A		;shift it
	LD	(DE),A		;save it for next time
	RR	C		;shift in the opposite direction
	INC	DE		;point to next
	RET			;and go back
;
grfmtd	LD	A,(ptype)	;get type of printer to use
	CP	1		;see if prowriter
	JR	Z,grt1d		;go if yes
	LD	A,(DE)		;else read a byte
	SLA	A		;shift a
	LD	(DE),A		;save it
	PUSH	AF		;save for next time
	RL	C		;shift back into C
	POP	AF		;restore it
	RL	C		;shift it in to double image
	INC	DE		;point to next
	RET			;and go back all done
grt1d	LD	A,(DE)		;read a byte
	SLA	A		;shift it
	LD	(DE),A		;save for next time
	PUSH	AF		;save it for double shift
	RR	C		;shift into C
	POP	AF		;get back for second shift
	RR	C		;do it again
	INC	DE		;point to next
	RET			;and go back
;
disply	LD	A,(HL)
	CP	3
	RET	Z
	LD	C,A		;simple 1 character display routine
	LD	A,@dsp
	RST	svc
	INC	HL
	JR	disply		;loop til 3 found
;
pause	DJNZ	pause		;loop for whatever value is in B
	RET			;and go bck
;
lprint	LD	C,(HL)		;get a byte
	LD	A,@prt		;send to printer
	RST	svc
	INC	HL		;point to next
	DJNZ	lprint		;loop til done
	RET			;and go back
;
todos	CALL	resoff		;turn off hi res
	LD	HL,0
	LD	A,@exit
	RST	svc
;
menu	DM	' Hires/CMD - Copyright 1987 by Mel Patrick',13
	DM	'    Printer Driver - '
printer DM	'12345678901234',13
	DM	'               Version - 4.1',13,13
	DM	'Erase - will clear the hires display',13
	DM	' INV	- Flip screen positive to negative',13
	DM	'Print - Horizontal Hardcopy of Screen to Printer',13
	DM	'HardCopy - Vertical Hardcopy of Screen to Printer',13
	DM	' View - view the current hires board picture',13
	DM	'Dsply - Hardcopy/Display a loaded MacPaint Image',13
	DM	' Read - will read a MacPaint file from disk to memory',13
	DM	' Save - WILL ENCODE and SAVE a HIRES Screen',13
	DM	'  GET - will load a standard /HR file (19.5K types)',13
	DM	' Load - will READ and DECODE an ENCODED Hires Screen',13
	DM	' Xchn - Toggle printer DRIVER: EPSON:ROLAND <-> PROWRITER',13
	DM	'BREAK - exit back to LSDOS Ready',13,13
	DM	'Select <E>rase  / <H>copy / <X>chn',13
	DM	'       <I>nvert / <V>iew  / <P>rint',13
	DM	'       <R>ead   / <L>oad  / <S>ave : ',13
	DM	'       <D>sply  / <G>et   / <C>atalog ....: ',3
;
p1	DM	'Epson & Roland'
p2	DM	'Prowriter Only'
;
prompt	DM	13,13,'MacPaint File to Load : ',3
sucess	DM	13,13,'File Loaded!',13
	DM	'Press <V>iew / <M>enu / <L>oad : ',3
sorry	DM	13,13,'Sorry, there is no file in memory to display!',13
	DM	'Press any key for menu....',3
type	DM	13,'<P>ositive or <N>egative : ',3
res	DM	13,'Print <E>xpanded or <N>ormal : ',3
dopaint DM	13,'HardCopy of Complete Image (Y/N) : ',3
fprom	DM	13,'Save Encoded Image Filename : ',3
lprom	DM	13,'Encoded Filename to Load : ',3
rprom	DM	13,'Standard 19.5K /HR Filespec to Load : ',3
cprom	DM	13,'Drive (0-7) : ',3
catcmd	DM	'CAT :'
cat	DM	'0',13
;
cor	DW	0000		;X,Y value LSB,MSB
pattern DB	0		;pattern to write on the screen
byte	DB	0		;byte read from video
flflag	DB	0		;Z=no file to display, NZ=can display
dtype	DB	0
exp	DB	0		;type of printout
;
page	DB	0		;current page count (3 Max)
char	DB	0		;characters per line (max 72)
line	DB	0		;lines per screen (240 MAX)
pix	DW	0
page1	DW	0
link	DB	0
;
;*************************************************************
;This information works for the Epson RX/FX and
;Roland Series printers.
;*************************************************************
pinit	DB	27,51,24	;sets line spacing 24/216"
pcmd	DB	27,'K',224,1
pcmd1	DB	27,'K',240,0	;normal res
pbuff	DS	240		;send sideways
pbuff1	DS	240		;total=480 per line max
	DW	0000		;just a gap
preset	DB	27,'@',13	;reset printer first
;
vprt	DB	27,'*',4,128,2	;printer command line
vbuff	DS	641		;buffer to use
vprt2	DB	27,'*',4,128,2
vbuff2	DS	641		;for the second line in case
;*************************************************************
;
;*************************************************************
;This information is for the Prowriter/Apple Imagewriter
;series printers.
;*************************************************************
p1init	DB	27,84,'1','6'	;sets line spacing to 16/144"
	DB	27,3EH,0DH
p1cmd	DM	27,'S0480'	;into hi res and print 480 characters
p1cmd1	DM	27,'S0240'	;into hi res, print 240 characters
;Uses standard pbuff from Epson/Roland routines
p1reset DB	27,'N',27,'A',13	;restore printing style
v1prt	DM	27,'S0640'	;hi res, 640 dots per line
;Uses standard VBUFF from Epson routine
v1prt2	DM	27,'S0640'	;printing routine for second line
;*************************************************************
;
temp	DS	10		;temp buffer
temp1	DW	0		;holds variable
inbuff	DS	33
fbuff	DS	32
dummy	DS	256
grbuff	DS	80		;width of screen
	DB	0FFH		;see if extra one sent out
wrtbuf	DS	150		;maximum per line I think (worst 133)
;
macbuf	DB	0		;MUST be BELOW 357FH for total buffer
	END	begin
