;**** MODULE05/ASM ****
;
;THIS ROUTINE DETERMINES IF A "CMD" DISK FILE
;IS TO BE LOADED
;
LDSK:CALL WL  ;DISPLAY AN "L" AND A SPACE
XOR A  ;SET TO LOAD MODE
LD (INBYT),A
LD HL,0  ;SET LOAD OFST TO ZERO
LD (OFST),HL
LD (HIGH),HL ;SET LOWEST ADDRESS TO ZERO
DEC HL  ;SET HIGHEST ADDRESS TO
LD (LO),HL  ;0FFFFH
KY2G:CALL HXINP  ;GET A KEY
JR Z,KY3G  ;JUMP IF HEX
CP 0DH  ;CARRIAGE RETURN?
JR Z,V02Z  ;JUMP IF SO
JR KY2G  ;GET ANOTHER KEY IF NOT "D"
KY3G:CALL GTA  ;GET REST OF OFST ADDRESS
LD (OFST),HL ;SAVE IT
V02Z:CALL PFNA  ;GET THE FILE NAME AND OPEN
   ;THE EXISTING FILE
LD1:LD A,8  ;SVC #8
RST 28H  ;Do SVC
DEC A  ;Z set if <BREAK>
JP Z,BFDRW  ;JUMP IF SO
CALL BFD  ;GET A BYTE
CP 1  ;LOAD IDENT?
JR Z,LD2  ;JUMP IF SO
CP 2  ;END OF FILE IDENT?
JR Z,LD3  ;JUMP IF SO
OR A  ;SKIP DATA MARKER?
JR Z,LD4  ;JUMP IF SO
CP 3  ;SKIP DATA MARKER?
JP M,ERR1  ;DO AN ERROR IF NOT
CP 20H  ;SKIP DATA MARKER?
JP P,ERR1  ;DO AN ERROR IF NOT
;
;THIS ROUTINE SKIPS "X" NUMBER OF BYTES FROM A DISK FILE.
;
LD4:CALL BFD  ;GET A BYTE FROM DISK.
;THIS VALUE IS THE
;NUMBER OF BYTES TO READ IN THIS BLOCK
SUB 2  ;SUBTRACT 2 FOR THE LOAD ADR.
LD B,A  ;SAVE COUNTER IN B
CALL BFD  ;GET LSB OF LOAD ADDRESS
CALL BFD  ;GET MSB OF LOAD ADDRESS
LD5:CALL BFD  ;READ A BYTE
DJNZ LD5  ;DO ANOTHER?
JR LD1  ;GO GET ANOTHER DATA MARKER
;
;THIS ROUTINE LOADS FROM DISK INTO MEMORY
;
LD2:CALL BFD  ;GET NUMBER OF BYTES TO LOAD
SUB 2  ;ACCOUNT FOR LOAD ADDRESS
LD B,A  ;SAVE COUNTER IN B
CALL BFD  ;GET LSB OF LOAD ADDRESS
LD L,A  ;SAVE IN L
CALL BFD  ;GET MSB OF LOAD ADDRESS
LD H,A  ;SAVE IN H
LD DE,(OFST) ;GET THE LOAD OFST
ADD HL,DE  ;COMPUTE LOAD LOCATION
LD DE,(LO)  ;GET THE CURRENT LOW LOAD ADDRESS
EX DE,HL  ;SWITCH CURRENT LOAD ADDRESS
   ;AND THE CURRENT LOW LOAD ADDRESS
CALL LOCH  ;REPLACE THE LOW LOAD ADDRESS
   ;IF THE CURENT LOAD ADDRESS IS SMALLER
EX DE,HL  ;SWITCH THEM BACK
LD6:CALL BFD  ;GET A DATA BYTE
PUSH AF  ;SAVE IT
LD A,(INBYT) ;VIEWING?
OR A
JR Z,LD6Z  ;JUMP IF LOADING
POP AF  ;CLEAR THE STACK
JR LD7Z  ;CONTINUE ON
LD6Z:POP AF  ;RESTORE THE DATA BYTE
LD (HL),A  ;PUT IT IN MEMORY
LD7Z:INC HL  ;INCREMENT LOAD ADDRESS
DJNZ LD6  ;DONE WITH THIS BLOCK?
DEC HL  ;POINT TO LAST LOAD ADDRESS
LD DE,(HIGH) ;GET CURRENT HIGH LOAD ADDRESS
EX DE,HL  ;SWITCH THE CURRENT HIGHEST LOAD
   ;ADDRESS AND THE CURRENT LOAD ADDRESS
CALL HICH  ;REPLACE THE HIGH ADDRESS IF THE
   ;CURRENT ADDRESS IS GREATER
EX DE,HL  ;SWITCH THEM BACK
JR LD1  ;GO READ ANOTHER DATA MARKER
;
;THIS ROUTINE READS THE TRANSFER ADDRESS OF THE FILE
;
LD3:CALL BFD  ;GET THE NUMBER OF BYTES TO READ
   ;IN THIS BLOCK
CALL BFD  ;GET LSB OF TRANSFER ADDRESS
LD L,A  ;SAVE IT IN L
CALL BFD  ;GET MSB OF TRANSFER ADDRESS
LD H,A  ;SAVE IT IN H
LD DE,(OFST) ;GET THE LOAD OFST
ADD HL,DE  ;COMPUTE THE TRANSFER ADDRESS
PUSH HL  ;SAVE THE TRANSFER ADDRESS
LD DE,DCB  ;CLOSE THE FILE
LD A,60  ;SVC #60
RST 28H  ;Do SVC
JP NZ,ERROR ;JUMP ON AN ERROR
DLAD:LD HL,(LO)  ;DISPLAY THE LOWEST LOAD ADDRESS
CALL REGHEX
CALL SPC
LD HL,(HIGH) ;DISPLAY THE HIGHEST LOAD ADDRESS
CALL REGHEX
CALL SPC
POP HL  ;GET THE TRANSFER ADDRESS
CALL REGHEX  ;DISPLAY IT
JP BREAK
;
;THIS ROUTINE IS EXECUTED WHEN THE BREAK KEY IS
;PRESSED WHILE DISASSEMBLING TO DISK, READING
;OR WRITING A FILE.
;
BFDRW:XOR A  ;CLEAR DISASS. TO DISK FLAG
LD (ARTN),A
JP CFL1  ;CLOSE THE FILE
;
;THIS ROUTINE READS A BYTE FROM DISK
;
BFD:PUSH DE  ;SAVE DE
LD DE,DCB  ;POINT TO FILE'S DCB
LD A,3  ;SVC #3
RST 28H  ;Do SVC
POP DE  ;RESTORE DE
JP NZ,ERROR ;JUMP ON AN ERROR
RET
ERR1:LD A,34  ;DISPLAY ERROR CODE 34 -
   ;LOAD FILE FORMAT ERROR
JP ERROR
;
;THIS DETERMINES IF A FILE IS TO BE WRITTEN TO DISK.
;
WFILE:CALL WL  ;DISPLAY A "W" AND A SPACE
CALL GTPAR  ;GET THE STARTING, ENDING
   ;AND TRANSFER ADDRESSES
CALL FNM  ;GET FILE NAME AND OPEN FILE
LD DE,(HIGH) ;GET THE STARTING ADDRESS
LD HL,(LO)  ;GET THE ENDING ADDRESS
XOR A  ;CLEAR THE CARRY FLAG
SBC HL,DE  ;NUMBER OF BYTES TO WRITE
INC HL
WF1:DEC H  ;WRITE A 256 BYTE BLOCK?
JP M,WF2  ;JUMP IF NOT ENOUGH LEFT
LD B,0  ;SET B TO 256 BYTES
CALL FWR1  ;GO WRITE THE BLOCK
JR WF1  ;GO CHECK FOR ANOTHER BLOCK
WF2:LD B,L  ;GET NUMBER OF BYTES IN BLOCK
XOR A  ;SET A TO ZERO
CP L  ;FILE ENDS ON A SECTOR BOUNDARY?
CALL NZ,FWR1  ;WRITE THE BLOCK IF NOT
LD A,2  ;WRITE THE EOF MARKER
CALL FWR2
LD A,2  ;NUMBER OF BYTES TO READ
CALL FWR2
LD A,(TADD) ;GET LSB OF TRANSFER ADDRESS
CALL FWR2  ;WRITE IT OUT
LD A,(TADD+1) ;GET MSB OF TRANSFER ADDRESS
CALL FWR2  ;WRITE IT OUT
CFL1:LD DE,DCB  ;POINT TO FILE'S DCB
LD A,60  ;SVC #60
RST 28H  ;Do SVC
JP Z,BREAK  ;JUMP IF NO ERROR
ERROR:PUSH AF  ;SAVE THE ERROR CODE
XOR A  ;CLEAR TAPE/DISK WRITE FLAG
LD (ARTN),A
INC A  ;SET DISPLAY ON
LD (PRINT),A
CALL CKSCR  ;SCROLL THE SCREEN
LD HL,ERR  ;DISPLAY THE ERROR MESSAGE
CALL WRT
POP AF  ;RESTORE THE ERROR CODE
CALL SHEX2  ;DISPLAY THE ERROR CODE
JP BREAK
;
;THIS ROUTINE WRITES A BLOCK TO DISK
;
FWR1:CALL BRCK  ;<BREAK> HIT?
JP NZ,BFDRW ;JUMP IF BREAK HELD DOWN
LD A,1  ;WRITE THE DATA MARKER
CALL FWR2
LD A,2  ;WRITE THE BLOCK LENGTH
ADD A,B
CALL FWR2
LD A,E  ;WRITE LOAD ADDRESS OF THE BLOCK
CALL FWR2
LD A,D
CALL FWR2
FLP1:LD A,(DE)  ;GET A DATA BYTE
CALL FWR2  ;WRITE TO DISK
INC DE  ;POINT TO NEXT ONE
DJNZ FLP1  ;DONE WITH THIS BLOCK?
RET
;
;THIS ROUTINE WRITES A BYTE TO DISK
;
FWR2:PUSH DE  ;SAVE DE
LD DE,DCB  ;POINT TO FILE'S DCB
LD C,A  ;Byte to C from A
LD A,4  ;SVC #4
RST 28H  ;Do SVC
JR NZ,ERROR ;JUMP ON AN ERROR
POP DE  ;RESTORE DE
RET
FNM:CALL PFN1  ;GET THE FILE NAME
LD A,58  ;SVC #58
RST 28H  ;Do SVC
JP NZ,ERROR ;JUMP ON AN ERROR
RET
PFNA:CALL PFN1  ;GET THE FILE NAME
LD A,59  ;SVC #59
RST 28H  ;Do SVC
JP NZ,ERROR ;JUMP ON AN ERROR
JP CKSCR  ;SCROLL THE SCREEN
;
;THIS ROUTINE INPUTS A FILE NAME
;
PFN1:CALL CKSCR  ;SCROLL THE SCREEN
LD HL,DCB  ;POINT TO FILE'S DCB
LD B,22  ;MAX NUMBER OF CHARACTERS
CALL K0  ;GET THE FILE NAME
LD DE,DCB  ;POINT TO FILE'S DCB
LD B,0  ;FILE'S LOGICAL RECORD LENGTH
LD HL,FLBUF ;FILE BUFFER
RET
;
;This routine writes out the A register and inputs
;3 four digit hex values.
;
GTPAR:CALL GETHEX  ;Get a value
LD (HIGH),HL ;SAVE IT
CALL SPC  ;Display a space
CALL GETHEX  ;Get a value
LD (LO),HL  ;Save it
CALL SPC  ;Display a space
CALL GETHEX  ;Get a value
LD (TADD),HL ;SAVE IT
RET
;
;THIS ROUTINE MOVES THE USER'S PC FORWARD ONE
;INSTRUCTION
;
SINS:LD A,94  ;DISPLAY A RIGHT ARROW
CALL WR
LD HL,(RD+22) ;GET USER'S PC
LD BC,1  ;DO ONE INSTRUCTION
XOR A  ;TURN DISPLAY FLAG OFF
CALL DISASS  ;DISASSEMBLE IT
LD HL,(STDIS) ;GET NEW PC
LD (RD+22),HL ;SAVE IT
JP DSPRG  ;GO DISPLAY THE REGISTERS
;
;THIS ROUTINE BACKS UP THE USER'S PC ONE INSTRUCTION
;
BINS:LD A,93  ;DISPLAY A LEFT ARROW
CALL WR
LD HL,(RD+22) ;GET THE USER'S PC
CALL BINS10  ;BACK UP ONE INSTRUCTION
LD (RD+22),HL ;SAVE USER'S NEW PC
JP DSPRG  ;GO DISPLAY THE REGISTERS
;
;THIS ROUTINE WILL BACK THE INSTRUCTION POINTED TO
;BY HL ONE INSTRUCTION AND RETURN THE NEW ADDRESS
;IN HL.
;
BINS10:LD (BINTXT),HL ;SAVE THE ADDRESS
LD BC,10  ;BACK UP 10 BYTES
SBC HL,BC
BN1:LD BC,1  ;DO ONE INSTRUCTION
XOR A  ;TURN DISPLAY OFF
LD (LO),HL  ;SAVE THE CURRENT ADDRESS
CALL DISASS  ;DISASSEMBLE IT
LD HL,(STDIS) ;GET CURRENT ADDRESS
LD BC,(BINTXT) ;GET SAVED ADDRESS
XOR A  ;CLEAR CARRY FLAG
SBC HL,BC  ;IS THE ADDRESS OF THE NEXT
   ;INSTRUCTION = THE ORIGINAL ADDRESS?
JR Z,GTIT  ;JUMP IF SO
LD HL,(STDIS) ;GET THE NEXT INSTR. ADDRESS
JP M,BN1  ;DO ANOTHER IF WE HAVEN'T
   ;GONE TOO FAR
GTIT:LD HL,(LO)  ;GET THE LAST INSTR. ADDRESS
RET
;
;THIS ROUTINE UPDATE THE LOWEST LOAD VALUE FOR
;DISK READ ROUTINES
;
LOCH:CALL CHECK  ;HL>DE?
RET Z  ;RETURN IF TRUE
LD (LO),DE  ;SAVE NEW LOW ADDRESS
RET
;
;THIS ROUTINE UPDATE THE HIGHEST LOAD ADDRESS FOR
;DISK READ ROUTINES.
;
HICH:CALL CHECK  ;DE>HL?
RET NZ  ;RETURN IF FALSE
LD (HIGH),DE ;SAVE NEW HIGH VALUE
RET
;
;THIS ROUTINE CHECKS IF HL>DE AND SETS THE "Z" FLAG
;IF HL>DE
;
CHECK:PUSH HL  ;SAVE HL
OR A  ;CLEAR THE CARRY FLAG
SBC HL,DE  ;SUBTRACT THEM
POP HL  ;RESTORE HL
JR C,HLDE  ;JUMP IF HL>DE
DEHL:LD A,1  ;CLEAR THE "Z" FLAG
OR A
RET
HLDE:XOR A  ;SET THE "Z" FLAG
RET
;
;THIS ROUTINE RELOCATES MEMORY
;
RMEM:CALL WL  ;DISPLAY "X" AND A SPACE
CALL GTPAR  ;GET THE STARTING, ENDING AND
   ;TRANSFER ADDRESSES OF THE RELOCATION
LD DE,(HIGH) ;GET THE START ADDRESS
LD HL,(LO)  ;GET THE ENDING ADDRESS
CALL CHECK  ;END > START?
JP Z,BREAK  ;DO A BREAK IF NOT
XOR A  ;CLEAR CARRY FLAG
SBC HL,DE  ;NUMBER OF BYTES TO MOVE
INC HL
PUSH HL  ;SAVE NUMBER TO MOVE
LD (ENDADD),HL ;SAVE IT AGAIN
LD HL,(TADD) ;GET THE TRANSFER ADDRESS
LD DE,(HIGH) ;GET THE SOURCE ADDRESS
XOR A  ;CLEAR THE CARRY FLAG
SBC HL,DE  ;FIND THE OFST OF THE LOAD
LD (OFST),HL ;SAVE THE OFST
POP BC  ;NUMBER OF BYTES TO MOVE
LD HL,(HIGH) ;GET THE SOURCE ADDRESS
LD DE,(TADD) ;GET THE DESTINATION ADDRESS
CALL MOVE  ;MOVE THE BLOCK
LD HL,(TADD) ;GET THE TRANSFER ADDRESS
LD (STDIS),HL ;SAVE IT
RLP1:LD A,(HL)  ;GET A BYTE
CP 0EDH  ;"ED" TYPE INSTRUCTION?
JR Z,ED1  ;JUMP IF SO
CP 0DDH  ;"IX" TYPE INSTRUCTION?
JR Z,PDD1  ;JUMP IF SO
CP 0FDH  ;"IY" TYPE INSTRUCTION?
JR Z,PDD1  ;JUMP IF SO
LD IX,STBL1 ;POINT TO 16 BIT COMPARE TABLE.
   ;THIS TABLE HOLDS THE FIRST BYTE OF EVERY
   ;16 BIT REFERENCE INSTRUCTION.  FOR
   ;EXAMPLE, 21H IS THE 1ST BYTE OF A
   ;"LD HL,NN" INSTRUCTION.
LD B,26  ;NUMBER TO CHECK
RLP2:CP (IX+0)  ;DOES IT MATCH?
JR Z,RLP6  ;JUMP IF SO
INC IX  ;POINT TO NEXT COMPARE VALUE
DJNZ RLP2  ;DO ANOTHER?
RL1:LD BC,1  ;SKIP THIS INSTRUCTION - DO
   ;ONE INSTRUCTION
LD HL,(STDIS) ;GET THE ADDRESS BEING CHECKED
XOR A  ;DISPLAY FLAG OFF
CALL DISASS  ;DISASSEMBLE IT
RL3:LD HL,(ENDADD) ;NUMBER OF BYTES MOVED
LD C,A  ;NUMBER OF BYTES THIS INSTRUCTION
LD B,0
XOR A  ;CLEAR THE CARRY FLAG
SBC HL,BC  ;DONE YET?
LD (ENDADD),HL ;SAVE NEW NUMBER OF BYTES
JP M,BREAK  ;JUMP IF DONE RELOCATING
LD HL,(STDIS) ;GET ADDRESS OF NEXT INSTR.
JR RLP1  ;GO DO ANOTHER
;
;THIS ROUTINE CHECKS IF ANY "ED" TYPE INSTRUCTIONS
;ARE TO BE CHANGED.
;
ED1:INC HL  ;POINT TO THE INSTR. BYTE
LD A,(HL)  ;GET THE INSTR. BYTE
LD IX,STBL2 ;POINT TO THE COMPARE TABLE
LD B,8  ;NUMBER TO CHECK
RLP4:CP (IX+0)  ;DOES IT MATCH?
JR Z,RLP5  ;JUMP IF A MATCH
INC IX  ;POINT TO NEXT COMPARE VALUE
DJNZ RLP4  ;DO ANOTHER?
JR RL1  ;GO SKIP THIS INSTRUCTION
RLP5:LD A,4  ;NUMBER OF BYTES IN INSTRUCTION
JR RLP3  ;CHECK IF ADDRESS SHOULD BE
   ;CHANGED.  THE ONLY ADDRESSES WHICH
   ;SHOULD BE CHANGED ARE ONES > STARTING
   ;ADDRESS AND < THE ENDING ADDRESS
RLP6:LD A,3  ;NUMBER OF BYTES THIS INSTRUCTION
JR RLP3  ;SHOULD ADDRESS BE CHANGED?
PDD1:INC HL  ;POINT TO INSTRUCTION IDENTIFIER
LD A,(HL)  ;GET THE BYTE
CP 21H  ;"LD IX/IY,NN"?
JR Z,RLP5  ;JUMP IF SO
CP 22H  ;"LD (NN),IX/IY"?
JR Z,RLP5  ;JUMP IF SO
CP 2AH  ;"LD IX/IY,(NN)"?
JR Z,RLP5  ;JUMP IF SO
JR RL1  ;GO SKIP THIS INSTRUCTION
RLP3:PUSH AF  ;SAVE NUMBER OF BYTES THIS INST.
INC HL  ;POINT TO THE ADDRESS
PUSH HL  ;SAVE THE LOCATION
LD E,(HL)  ;PUT THE ADDRESS IN DE
INC HL
LD D,(HL)
LD HL,(LO)  ;GET THE STARTING ADDRESS
CALL CHECK  ;ADDRESS < STARTING ADDRESS?
JP Z,NOPE  ;JUMP IF SO
LD HL,(HIGH) ;GET THE ENDING ADDRESS
CALL CHECK  ;ADDRESS > ENDING ADDRESS?
JP NZ,NOPE  ;JUMP IF SO
LD HL,(OFST) ;GET THE RELOCATION OFST
ADD HL,DE  ;COMPUTE THE NEW 16 BIT VALUE
PUSH HL  ;SAVE IT
POP DE  ;PUT IN DE
POP HL  ;RESTORE THE ADDRESS LOCATION
LD (HL),E  ;REPLACE IT
INC HL
LD (HL),D
INC HL
LD (STDIS),HL ;SAVE NEW ADDRESS TO CHECK
POP AF  ;RESTORE THE NUMBER OF BYTES
   ;IN THIS INSTRUCTION
JP RL3  ;GO CHECK IF DONE
NOPE:POP HL  ;ADDRESS WAS NOT WITHIN THE RANGE:
   ;STARTING ADDRESS < ADDRESS < ENDING
   ;ADDRESS SO THE ADDRESS IS SKIPPED
INC HL  ;INCREMENT THE LOCATION
INC HL  ;POINTER
LD (STDIS),HL ;SAVE NEW ADDRESS TO CHECK
POP AF  ;GET # OF BYTES THIS INSTRUCTION
JP RL3  ;GO SKIP IT
;
;THIS ROUTINE IS THE BLOCK MOVE COMMAND
;
MOVIT:CALL WL  ;DISPLAY "Y" AND A SPACE
CALL GTPAR  ;GET THE STARTING, ENDING
   ;AND TRANSFER ADDRESSES
LD HL,(LO)  ;GET ENDING ADDRESS
LD DE,(HIGH) ;GET STARTING ADDRESS
XOR A  ;CLEAR THE CARRY FLAG
SBC HL,DE  ;NUMBER OF BYTES TO MOVE
INC HL
PUSH HL  ;COPY IT TO BC
POP BC
LD HL,(HIGH) ;GET THE SOURCE ADDRESS
LD DE,(TADD) ;GET THE DESTINATION ADDRESS
;
;THIS ROUTINE DOES A BLOCK MOVE WITH "SMARTS" ENOUGH
;TO ALLOW OVERLAPPING OF THE BLOCK.  THE ROUTINE
;ENTERS WITH HL-> SOURCE ADDRESS, DE-> DESTINATION
;ADDRESS AND BC-> NUMBER OF BYTES TO MOVE
;
MOVE:PUSH HL  ;SAVE SOURCE ADDRESS
OR A  ;CLEAR CARRY FLAG
SBC HL,DE  ;DESTINATION > SOURCE?
POP HL  ;RESTORE SOURCE ADDRESS
JR C,MOV10  ;JUMP IF DEST.>SOURCE
LDIR   ;DO THE BLOCK MOVE
RET
MOV10:ADD HL,BC  ;GET ENDING ADDRESS OF BLOCK
DEC HL
EX DE,HL  ;SWITCH SOURCE AND DESTINATION
ADD HL,BC  ;GET THE ENDING ADDRESS OF
   ;THE DESTINATION BLOCK
DEC HL
EX DE,HL  ;SWITCH THEM BACK
LDDR   ;MOVE THE BLOCK
RET
;
;NEW KEYBOARD INPUT ROUTINE FOR TASMON IV.
;JDY 03/11/85 -- SUPPORTS THE SYSTEM CURSOR
;CHARACTER, ALLOWS <SHIFT>+BACKSPACE TO
;START LINE OVER.
;ENTRY:
;HL=POINTER TO LINE BUFFER,
;B=MAXIMUM # OF CHARS. TO INPUT
;
K0:LD C,B  ;SAVE # OF KEYS
LD A,0EH  ;CURSOR ON CODE
CALL WR  ;DISPLAY IT
K1:CALL KYBORD  ;SCAN FOR A KEY
OR A  ;TEST FOR NO KEY
JR Z,K1  ;LOOP IF NO KEY PRESSED
CP 0DH  ;<ENTER> KEY
JR Z,K5  ;GO IF <ENTER>
CP 80H  ;<BREAK> KEY
JR Z,K4  ;GO IF <BREAK>
CP 8  ;BACKSPACE KEY
JR Z,K3  ;GO IF BACKSPACE
CP 18H  ;<SHIFT>+BACKSPACE
JR Z,K6  ;GO IF <SHIFT>+BACKSPACE
CP 20H  ;TEST FOR LESS THAN 20H
JR C,K1  ;LOOP IF CTRL CHARACTER
CP 5BH  ;TEST FOR LOWER CASE
JR C,K2  ;GO IF UPPER CASE
AND 5FH  ;FORCE LOWER CASE TO UPPER CASE
K2:LD (HL),A  ;SAVE KEY INTO BUFFER
LD A,B  ;GET KEY COUNTER
OR A  ;IS IT ZERO?
JR Z,K1  ;LOOP IF AT MAXIMUM KEYS
LD A,(HL)  ;GET KEY WE JUST SAVED
INC HL  ;POINT TO NEXT BUFFER ADDRESS
CALL WR  ;DISPLAY KEY IN BUFFER
DEC B  ;DECREMENT COUNTER
JR K1  ;GET MORE KEYS
K3:LD A,B  ;GET CURRENT KEY #
CP C  ;COMPARE WITH MAX. KEY #
JR Z,K1  ;LOOP IF NO KEYS IN BUFFER
DEC HL  ;DECREMENT BUFFER ADDRESS
LD A,8  ;BACKSPACE CODE
CALL WR  ;DO A VIDEO BACKSPACE
INC B  ;INCREMENT COUNTER
JR K1  ;GET MORE KEYS
K4:LD A,0FH  ;TURN OFF CURSOR CODE
CALL WR  ;TURN OFF CURSOR
JP BREAK  ;JUMP TO COMMAND MODE
K5:LD (HL),A  ;SAVE 0DH (<ENTER> CODE)
LD A,0FH  ;TURN OFF CURSOR CODE
CALL WR  ;TURN IT OFF!
RET   ;RETURN
K6:LD A,B  ;GET # OF KEYS LEFT
CP C  ;COMPARE WITH MAX. # OF KEYS
JR Z,K1  ;GET KEYS IF DONE
DEC HL  ;DECREMENT BUFFER ADDRESS
LD A,8  ;BACKSPACE CODE
CALL WR  ;BACKSPACE ON VIDEO
INC B  ;INCREMENT KEY COUNTER
JR K6  ;LOOP BACK UNTIL DONE
;
;ROUTINE TO INPUT A KEY FROM THE KEYBOARD
;
KYBORD:PUSH DE  ;SAVE DE
LD A,8  ;@KBD SVC
RST 28H  ;DO SVC CALL, A=CHARACTER
POP DE  ;RESTORE DE
RET
;
;THIS ROUTINE IS THE VIEW COMMAND
;
VIEW:CALL WL  ;DISPLAY A "V" AND A SPACE
LD A,1  ;SET TO VIEW MODE
LD (INBYT),A
LD HL,0  ;SET THE LOAD OFST TO ZERO
LD (OFST),HL
LD (HIGH),HL ;SET HIGH TO ZERO
DEC HL  ;SET LO TO FFFF
LD (LO),HL
JP V02Z  ;GO TO V02Z

                   