;**** MODULE04/ASM ****
;
;THIS IS THE ROUTINE TO ROUTE DISASSEMBLY TO DISK
;
DDSK:CALL WL  ;DISPLAY AN "O" AND A SPACE
CALL GTPAR  ;GET THE OUTPUT PARAMETERS
LD B,0  ;CODE FOR HIGH$
LD HL,0  ;GET IT, RATHER THAN SET IT
LD A,100  ;SVC #100
RST 28H  ;DO SVC
LD (SYM),HL ;SAVE AS THE HIGH ADDRESS
;OF THE SYMBOL TABLE
LD HL,0  ;SET NUMBER OF LABELS
;GENERATED SO FAR TO ZERO
LD (NSYM),HL
LD DE,(HIGH) ;GET STARTING ADDRESS
LD HL,(LO)  ;GET ENDING ADDRESS
CALL CHECK  ;ENDING > STARTING?
JP Z,BREAK  ;RETURN IF NOT
CALL FNM  ;GET THE FILE NAME
CALL GENTBL  ;GENERATE THE SYMBOL TABLE
LD A,0D3H  ;WRITE OUT E/A IDENT BYTE
CALL BTDALT
LD B,6  ;WRITE OUT A 6 CHARACTER
;DUMMY NAME
DD1:LD A,'A'  ;CHARACTER TO WRITE
CALL BTDALT  ;WRITE IT
DJNZ DD1  ;DO ANOTHER?
CALL SCUR  ;SET TASMON'S CURSOR
CALL CLS  ;CLEAR THE SCREEN
CALL WLN  ;WRITE AN E/A LINE NUMBER
LD HL,ORGX  ;WRITE "ORG"
LD A,1
LD (ARTN),A
LD (PRINT),A
CALL W0
LD HL,(HIGH) ;GET THE "ORG" ADDRESS
CALL DTH1  ;WRITE IT
XOR A
LD (PRINT),A
LD A,0DH  ;WRITE A CARRIAGE RETURN
CALL BTD
LD (STDIS),HL ;SAVE STARTING ADDRESS
LD HL,(HIGH) ;GET THE STARTING ADDRESS
LD (STDIS),HL ;SAVE IT
CALL DD2  ;WRITE THE DISASSEMBLY OUT
CALL WLN  ;WRITE AN E/A LINE NUMBER
LD HL,ENDX  ;WRITE THE "END" TEXT
CALL W0
LD HL,(TADD) ;GET THE "END" ADDRESS
CALL DTH1  ;WRITE IT OUT
XOR A  ;TURN OFF THE DISASSEMBLY
LD (ARTN),A
LD A,13  ;WRITE OUT A CARRIAGE RETURN
CALL BTD
LD A,1AH  ;WRITE OUT END OF FILE BYTE
CALL BTD
LD DE,DCB  ;CLOSE THE FILE
LD A,60  ;CLOSE FILE
RST 28H
JP NZ,ERROR
JP BREAK
;
;THIS ROUTINE GENERATES THE SYMBOL TABLE
;
GENTBL:XOR A  ;CLEAR THE DISPLAY FLAG
LD (PRINT),A
INC A  ;SET GENERATE SYMBOL FLAG
LD (HRTN),A
LD HL,(HIGH) ;GET STARTING ADDRESS
LD (STDIS),HL ;SAVE IT
CALL DD2  ;GENERATE THE TABLE
XOR A  ;CLEAR THE GENERATE SYMBOL
;TABLE FLAG
LD (HRTN),A
RET
;
;THIS ROUTINE OUTPUTS A BYTE TO DISK
;
BTD:PUSH AF  ;SAVE THE BYTE
CP 9  ;TAB CHARACTER?
JR NZ,ECSCR1 ;JUMP IF NOT
CALL WAZ  ;DO A TAB
JR ECSCR2  ;CONTINUE ON
ECSCR1:CALL WR  ;DISPLAY THE CHARACTER
ECSCR2:POP AF  ;RESTORE THE CHARACTER
BTDALT:CALL FWR2  ;WRITE TO DISK
CALL BRCK  ;<BREAK> HIT?
JP NZ,BFDRW ;JUMP IF BREAK
RET
;
;
;THIS ROUTINE RUNS THROUGH MEMORY FROM THE STARTING
;ADDRESS TO THE ENDING ADDRESS AND GENERATES THE
;SYMBOL TABLE OR WRITES THE OUTPUT TO DISK.
;
DD2:LD HL,(STDIS) ;GET THE STARTING ADDRESS
LD A,(ARTN) ;WRITING TO TAPE/DISK?
OR A
JR Z,DD4  ;JUMP IF NOT WRITING
CALL WLN  ;MAKE A LINE NUMBER
DD4:LD BC,1  ;DO ONE INSTRUCTION
XOR A  ;DISPLAY FLAG OFF
CALL DISASS  ;GO DISASSEMBLE IT
CALL INCHL  ;POINT TO NEXT BYTE
LD A,(ARTN) ;WRITING OUT?
OR A
JR Z,DD3  ;JUMP IF NOT WRITING
LD A,13  ;DO A CARRIAGE RETURN
CALL BTD
DD3:LD HL,(STDIS) ;GET INSTRUCTION ADDRESS
LD DE,(LO)  ;GET ENDING ADDRESS
CALL CHECK  ;DONE?
JR Z,DD2  ;DO ANOTHER IF NOT
RET
;
;THIS ROUTINE WRITES OUT THE E/A LINE NUMBER
;
WLN:LD B,5  ;NUMBER TO WRITE
WL1:LD A,0B0H  ;BYTE TO OUTPUT
CALL BTDALT  ;WRITE IT OUT
DJNZ WL1  ;DO ANOTHER?
LD A,20H  ;WRITE A SPACE
JP BTDALT
;
;THIS ROUTINE BUILDS THE SYMBOL TABLE
;
BTBL:PUSH DE  ;SAVE DE
LD DE,(HIGH) ;GET THE LOW ADDRESS
CALL CHECK  ;VALUE IN QUESTION TOO LOW?
JR Z,NOGO  ;JUMP IF TOO LOW
LD DE,(LO)  ;GET THE HIGH ADDRESS
CALL CHECK  ;VALUE TOO HIGH?
JR NZ,NOGO  ;JUMP IF SO
POP DE  ;RESTORE DE
CALL CKLST  ;IS THE VALUE ALREADY IN
;THE SYMBOL TABLE?
RET Z  ;RETURN IF SO
LD (STK),SP ;SAVE TASMON'S STACK
LD SP,(SYM) ;GET THE SYMBOL TABLE POINTER
PUSH HL  ;PUT THE SYMBOL IN THE TABLE
LD (SYM),SP ;SAVE THE SYMBOL TABLE POINTER
LD SP,(STK) ;RESTORE TASMON'S STACK
PUSH BC  ;SAVE BC
LD BC,(NSYM) ;GET THE NUMBER OF SYMBOLS
INC BC  ;ADD ONE TO IT
LD (NSYM),BC ;SAVE THE COUNTER
POP BC  ;RESTORE BC
RET
NOGO:POP DE  ;RESTORE DE
RET
;
;THIS ROUTINE CHECKS IF THE VALUE IN HL IS IN THE
;SYMBOL TABLE.
;
CKLST:PUSH BC  ;SAVE BC
PUSH DE  ;SAVE DE
LD (STK),SP ;SAVE TASMON'S STACK
LD SP,(SYM) ;GET SYMBOL TABLE POINTER
LD BC,(NSYM) ;GET THE NUMBER OF SYMBOLS
LD A,B  ;NONE GENERATED SO FAR?
OR C
JR Z,NTHERE ;JUMP IF NONE SO FAR
LS1:POP DE  ;GET A SYMBOL VALUE
EX DE,HL  ;PUT VALUE IN QUESTION IN
;DE AND THE SYMBOL IN HL
XOR A  ;CLEAR THE CARRY FLAG
SBC HL,DE  ;MATCH?
EX DE,HL
JR Z,THERE  ;JUMP IF SAME
DEC BC  ;DECREMENT THE SYMBOL COUNTER
LD A,B  ;SCANNED ALL SYMBOLS?
OR C
JR NZ,LS1  ;DO ANOTHER IF NOT THROUGH
NTHERE:LD SP,(STK) ;RESTORE TASMON'S STACK
POP DE  ;RESTORE DE
POP BC  ;RESTORE BC
LD A,1  ;CLEAR THE "Z" FLAG
OR A
RET
THERE:LD SP,(STK) ;RESET TASMON'S STACK
POP DE  ;RESTORE DE
POP BC  ;RESTORE BC
XOR A  ;SET THE "Z" FLAG
RET
;
;THIS ROUTINE CHECKS IF THE VALUE IN HL IS A SYMBOL.
;IF IT IS, IT IS WRITTEN OUT.
;
DWD1:CALL CKLST  ;IN THE SYMBOL TABLE?
RET NZ  ;RETURN IF NOT THERE
JR NTD  ;JUMP IF THERE
;
;THIS ROUTINE CHECKS IF THE VALUE IN HL IS IN THE
;SYMBOL TABLE AND WRITES IT OUT AS A LABEL IF IT WAS
;FOUND.  IT DISPLAYS IT AS A REGULAR NUMBER IF NOT
;IN THE TABLE.
;
DWD2:CALL CKLST  ;IN THE SYMBOL TABLE?
JR NZ,DTH1  ;JUMP IF NOT IN THE TABLE
NTD:LD A,'Z'  ;WRITE OUT A "Z"
CALL BTD
JR DTH2  ;CONTINUE ON
DTH1:LD A,H  ;GET THE MSB
SRL A  ;CHECK IF FIRST BYTE
;GREATER THAN 9FH (WHICH WOULD
;REQUIRE A LEADING 0, I.E. 0A8DFH)
CP 80
JR C,DTH2  ;JUMP IF NO LEADING ZERO
LD A,'0'  ;WRITE A ZERO
CALL BTD
DTH2:CALL RHDSK  ;WRITE OUT THE NUMBER
LD A,'H'  ;WRITE OUT AN "H"
JP BTD
;
;THIS ROUTINE WRITES OUT THE VALUE IN THE "A" REGISTER
;WITH A LEADING ZERO IF NEEDED.
;
DWD5:POP AF  ;GET THE VALUE
PUSH AF  ;SAVE IT
SRL A  ;NEED A LEADING ZERO?
CP 80
JR C,DTS1  ;JUMP IF NO LEADING ZERO
LD A,'0'  ;WRITE OUT A ZERO
CALL BTD
DTS1:POP AF  ;GET THE VALUE
CALL SHEX3  ;WRITE IT OUT
LD A,'H'  ;WRITE OUT AN "H"
JP BTD
;
;THIS ROUTINE LOADS HL WITH THE VALUE POINTED TO
;BY HL AND TRYS TO ADD THE VALUE TO THE SYMBOL TABLE
;
BL1:LD A,(HL)  ;GET THE LSB
PUSH AF  ;SAVE IT
INC HL  ;POINT TO THE MSB
LD A,(HL)  ;GET IT
LD H,A  ;PUT MSB IN H
POP AF  ;GET THE LSB
LD L,A  ;PUT IT IN L
PUSH HL  ;SAVE THE VALUE
CALL INCHL  ;POINT TO NEXT INSTRUCTION ADDRESS
POP HL  ;RESTORE THE VALUE
JP BTBL  ;GO BUILD THE TABLE
;
;THIS ROUTINE LOADS HL WITH THE VALUE POINTED TO BY HL AND
;WRITES IT OUT AS A SYMBOL IF IN THE SYMBOL TABLE OR AS A
;REGULAR VALUE IF NOT IN THE TABLE.
;
BL2:LD A,(HL)  ;GET THE LSB
PUSH AF  ;SAVE IT
INC HL  ;POINT TO MSB
LD A,(HL)  ;GET MSB
LD H,A  ;PUT IT IN H
POP AF  ;GET THE LSB
LD L,A  ;PUT IT IN L
PUSH HL  ;SAVE THE VALUE
CALL INCHL  ;POINT TO NEXT INSTRUCTION
POP HL  ;GET VALUE BACK
JP DWD2  ;GO WRITE IT

                                                                                                                                                                                                                   