;**** MODULE03/ASM ****
;
;THIS ROUTINE IS THE DISASSEMBLER
;
;ENTER:
;HL-> STARTING ADDRESS OF DISASSEMBLY
;BC-> NUMBER OF INSTRUCTIONS TO DISASSEMBLE
;A-> 0 - DON'T DISPLAY THE DISASSEMBLY
;A-> 1 - DISPLAY THE DISASSEMBLY
;
;EXIT:
;A-> NUMBER OF BYTES IN LAST INSTRUCTION
;DISASSEMBLED
;
DISASS:LD (STDIS),HL ;SAVE STARTING ADDRESS
LD (S1),HL
LD (NMDIS),BC ;SAVE NUMBER TO DO
LD (PRINT),A ;SAVE DISPLAY STATUS
XOR A  ;CLEAR BAD CODE FLAG
LD (BDCODE),A
LD (JPFLAG),A ;CLEAR PC MODIFIER FLAG
C02:LD A,(ARTN) ;DISASSEMBLING TO DISK/TAPE?
OR A
JR Z,ZC02  ;JUMP IF NOT
CALL DWD1  ;CHECK IF THIS
;ADDRESS WAS A PREVIOUSLY
;GENERATED SYMBOL.  IF IT WAS, THEN WRITE
;THE LABEL OUT.  IF NOT A SYMBOL, THEN
;DON'T WRITE THE ADDRESS OUT AS A LABEL.
JR C02A  ;CONTINUE ON
ZC02:LD A,(ADPR) ;DISPLAYING THE ADDRESS?
CP 1
JR Z,C02A  ;JUMP IF NOT DISPLAYING
LD A,(HRTN) ;GENERATING A SYMBOL TABLE?
OR A
JR NZ,C02A  ;JUMP IF GENERATING
CALL REGHEX  ;DISPLAY THE ADDRESS
CALL SPCD  ;DISPLAY A SPACE
C02A:LD A,(PRINT) ;GET DISPLAY STATUS
PUSH AF  ;SAVE IT
XOR A  ;TURN DISPLAY OFF
;SO WE CAN FIND THE NUMBER
;OF BYTES ARE IN THIS INSTRUCTION)
LD (PRINT),A
CALL BDIS  ;DISASSEMBLE IT
POP AF  ;RESTORE DISPLAY STATUS
LD (PRINT),A
LD A,(ARTN) ;DISASSEMBLING TO DISK/TAPE?
OR A
RET NZ  ;RETURN IF SO
LD A,(HRTN) ;GENERATING A SYMBOL TABLE?
OR A
RET NZ  ;RETURN IF SO
CALL INCHL  ;INCREMENT THE ADDRESS
LD HL,(STDIS) ;GET THE NEXT INSTR. ADDRESS
LD DE,(S1)  ;GET LAST INSTR. ADDRESS
SBC HL,DE  ;NUMBER OF BYTES IN THIS INSTR.
LD B,L  ;SAVE IN B
LD A,(PRINT) ;GET DISPLAY STATUS
OR A
LD A,B
RET Z  ;RETURN IF NO DISPLAY
LD HL,(S1)  ;GET LAST INSTR. ADDRESS
LD (STDIS),HL ;MAKE IT THE CURRENT INSTR.
LD A,(ADPR) ;DISPLAYING HEX BYTES OF INSTR?
CP 1
JR Z,C02B  ;JUMP IF NOT DISPLAYING
WRLOOP:PUSH HL  ;SAVE HL
PUSH BC  ;SAVE DE
QALP1:CALL SHEX1  ;WRITE A BYTE OF INSTRCTN
INC HL  ;POINT TO NEXT ONE
DJNZ QALP1  ;WRITE ANOTHER
POP BC  ;RESTORE BC
POP HL  ;RESTORE HL
PUSH BC  ;RE-SAVE BC
CALL WAZ  ;TAB OVER
POP BC  ;RESTORE BC
QALP2:LD A,(HL)  ;GET BYTE OF INSTRUCTION
CP 20H  ;UNPRINTABLE CONTROL CHR?
JR C,USESPC ;SUBSTITUTE SPACE IF SO
CP 80H  ;NOT AN ASCII CHARACTER?
JR NC,USESPC ;SUBSTITUTE SPACE IF SO
CALL BYTOUT  ;DISPLAY THE CHARACTER
NXTBYT:INC HL  ;BUMP POINTER
DJNZ QALP2  ;DISPLAY REMAINING BYTES
C02B:CALL BDIS  ;DISASSEMBLE THE INSTRUCTION
CALL INCHL  ;POINT TO NEXT BYTE
LD A,(PRINT) ;GET DISPLAY STATUS
OR A
JR Z,C02D  ;JUMP IF NOT DISPLAYING
LD A,(ADPR) ;DISPLAYING THE ADDRESS?
CP 1
JR NZ,C02C  ;JUMP IF NOT DISPLAYING
CALL CRRET  ;DO A CARRIAGE RETURN
JR C02D  ;CONTINUE ON
USESPC:CALL SPCD1  ;DISPLAY A SPACE
JR NXTBYT  ;BACK TO MAIN ROUTINE
C02C:LD A,0DH  ;DO A CARRIAGE RETURN
CALL WR
C02D:LD BC,(NMDIS) ;GET NUMBER TO DISASSEMBLE
DEC BC  ;DECREMENT IT
LD (NMDIS),BC ;SAVE THE COUNTER
LD DE,(S1)  ;GET STARTING ADDRESS
XOR A  ;CLEAR CARRY FLAG
SBC HL,DE  ;NUMBER OF BYTES IN INSTR.
LD A,B  ;COUNTER DOWN TO ZERO?
OR C
JR NZ,C01  ;DO ANOTHER INSTRUCTION IF NOT
LD A,L  ;GET NUMBER OF BYTES IN
;THE LAST INSTRUCTION EXECUTED
RET
C01:LD HL,(STDIS) ;GET STARTING ADDRESS OF
;THE NEXT INSTRUCTION
LD (S1),HL  ;SAVE AS NEW STARTING ADDRESS
JP C02  ;GO DO ANOTHER ONE
;
;THE FOLLOWING CODE DOES THE ACTUAL INTERPRETATION
;OF THE INSTRUCTIONS AND DISPLAYS THE APPROPRIATE
;Z-80 MNEMONIC.
;
BDIS:LD HL,(STDIS) ;GET STARTING ADDRESS
LD A,(HL)  ;GET THE BYTE AT THE
;STARTING ADDRESS
LD HL,SBITBL ;POINT TO THE LIST OF
;SINGLE BYTE INSTRUCTIONS
LD B,21  ;NUMBER TO CHECK
LD DE,SBITXT ;POINT TO SINGLE BYTE
;INSTRUCTION TEXT DESCRIPTION TABLE
CALL MST  ;IS IT A SINGLE BYTE INSTR.?
RET Z  ;RETURN IF SO
XOR A  ;CLEAR THE "IX/IY" FLAGS
LD (TYPE),A
LD (TYPE2),A
LD A,(HL)  ;GET THE STARTING BYTE
CP 0DDH  ;"IX" INSTRUCTION?
JR Z,NS10  ;JUMP IF SO
CP 0FDH  ;"IY" INSTRUCTION?
JR NZ,NS20  ;JUMP IF NOT
NS10:LD (TYPE),A ;SET "IX/IY" FLAG
LD B,A  ;ALSO SAVE IT
CALL INCHL  ;POINT TO NEXT BYTE
LD A,(HL)  ;GET THE STARTING BYTE
CP 66H  ;CHECK FOR
JR Z,NS20  ;EXCEPTIONS
CP 6EH  ;TO NORMAL
JR Z,NS20  ;HANDLING OF
CP 74H  ;"HX", "HY",
JR Z,NS20  ;"IX", AND
CP 75H  ;"IY"
JR Z,NS20
LD A,B  ;GET TYPE FLAG
LD (TYPE2),A ;SAVE TYPE FLAG 2
NS20:LD A,(HL)  ;GET THE STARTING BYTE
AND 192  ;"LD R,R'" INSTRUCTION?
CP 64
JR NZ,N07  ;JUMP IF NOT
LD A,(HL)  ;GET THE STARTING BYTE
PUSH AF  ;SAVE IT
LD HL,LDTXT ;DISPLAY "LD" TEXT
CALL W0
POP AF  ;RESTORE STARTING BYTE
PUSH AF  ;SAVE AGAIN
CALL REGXTA  ;DISPLAY THE 1ST REGISTER
CALL COMMA  ;DISPLAY A COMMA
POP AF  ;RESTORE THE STARTING BYTE
JP RGEXTA  ;DISPLAY THE 2ND REGISTER
N07:LD A,(HL)  ;GET THE STARTING BYTE
CP 3AH  ;"LD A,(NN)" INSTRUCTION?
JR NZ,N10  ;JUMP IF NOT
LD HL,LDA  ;DISPLAY "LD A,"
CALL W0
CALL INCHL  ;POINT TO THE ADDRESS
JP RHEX  ;DISPLAY IT
N10:CP 32H  ;"LD (NN),A" INSTRUCTION?
JR NZ,N12  ;JUMP IF NOT
LD HL,LDTXT ;DISPLAY "LD"
CALL W0
LD A,'('  ;DISPLAY A "("
CALL BYTOUT
CALL INCHL  ;POINT TO THE ADDRESS
CALL THEX  ;DISPLAY IT
LD HL,PA  ;DISPLAY "),A"
JP WRT
N12:CP 2AH  ;"LD HL,(NN)" INSTRUCTION?
JR NZ,N13  ;JUMP IF NOT
LD HL,LDTXT ;DISPLAY "LD"
CALL W0
CALL HIXIY  ;DISPLAY AN "HL" OR "IX" OR "IY"
;DEPENDING ON THE "IX/IY" FLAG.  ALL Z-80
;INSTRUCTIONS REFERING TO HL OR (HL) THAT
;ARE PRECEDED BY A 0DDH BYTE BECOME "IX"
;OR "(IX+D" INSTRUCTIONS.  IF PRECEDED BY
;A 0FDH BYTE, IT BECOMES AN "IY" OR
;"(IY+D)" INSTRUCTION
CALL COMMA  ;DISPLAY A COMMA
CALL INCHL  ;POINT TO THE ADDRESS
JP RHEX  ;DISPLAY IT
N13:CP 22H  ;"LD (NN),HL"?
JR NZ,N22  ;JUMP IF NOT
LD HL,LDTXT ;DISPLAY "LD"
CALL W0
CALL INCHL  ;POINT TO THE ADDRESS
CALL RHEX  ;DISPLAY IT
CALL COMMA  ;DISPLAY A COMMA
JP HIXIY  ;DISPLAY "HL/IX/IY"
N22:CP 0C6H  ;"ADD A,N"?
JR NZ,N41  ;JUMP IF NOT
LD HL,ADDA  ;DISPLAY "ADD A,"
CALL W0
CALL INCHL  ;POINT TO THE NUMBER
JP SHEX  ;DISPLAY IT
N41:CP 0C3H  ;"JP NN"?
JR NZ,N43  ;JUMP IF NOT
LD A,1  ;SET PC MOD. FLAG
LD (JPFLAG),A
LD HL,JPTX  ;DISPLAY "JP"
CALL W0
N41A:CALL INCHL  ;POINT TO ADDRESS
JP THEX  ;DISPLAY IT
N43:CP 18H  ;"JR E"?
JR NZ,N44  ;JUMP IF NOT
LD A,3  ;SET PC MOD FLAG
LD (JPFLAG),A
LD HL,JRTX  ;DISPLAY "JR"
JR S03  ;GO DISPLAY THE ADDRESS
N44:CP 38H  ;"JR C,E"?
JR NZ,N45  ;JUMP IF NOT
LD HL,JRCTX ;DISPLAY "JR C,"
CALL JRSET  ;SET PC MOD FLAG
JR S03  ;GO DISPLAY THE ADDRESS
JRSET:LD A,5  ;SET PC MOD FLAG
LD (JPFLAG),A
RET
N45:CP 30H  ;"JR NC,E"?
JR NZ,N46  ;JUMP IF NOT
LD HL,JRNCTX ;DISPLAY "JR NC,"
CALL JRSET  ;SET PC MOD FLAG
S03:CALL W0  ;DISPLAY THE TEXT
CALL INCHL  ;POINT TO INDEX
JP JRADD  ;DISPLAY THE ADDRESS
N46:CP 28H  ;"JR Z,E" ?
JR NZ,N47  ;JUMP IF NOT
LD HL,JRZTX ;DISPLAY "JR Z,"
CALL JRSET  ;SET PC MOD FLAG
JR S03  ;DISPLAY THE ADDRESS
N47:CP 20H  ;"JR NZ,E"?
JR NZ,N48  ;JUMP IF NOT
LD HL,JRNZTX ;DISPLAY "JR NZ,"
CALL JRSET  ;SET PC MOD FLAG
JR S03  ;DISPLAY THE ADDRESS
N48:CP 0E9H  ;"JP (HL)"?
JR NZ,N49  ;JUMP IF NOT
LD HL,JPTX  ;DISPLAY "JP"
LD A,6  ;SET PC MOD FLAG
LD (JPFLAG),A
CALL W0
LD A,'('  ;DISPLAY A "("
CALL BYTOUT
CALL HIXIY  ;DISPLAY "HL/IX/IY"
LD A,29H  ;DISPLAY A ")"
JP BYTOUT
N49:CP 10H  ;"DJNZ E"?
JR NZ,N50  ;JUMP IF NOT
LD HL,DJNZTX ;DISPLAY "DJNZ"
LD A,4  ;SET PC MOD FLAG
LD (JPFLAG),A
JR S03  ;DISPLAY THE ADDRESS
N50:CP 0CDH  ;"CALL NN"?
JR NZ,N52  ;JUMP IF NOT
LD HL,CALLTX ;DISPLAY "CALL"
LD A,7  ;SET PC MOD FLAG
LD (JPFLAG),A
CALL W0
N50A:CALL INCHL  ;POINT TO THE ADDRESS
JP THEX  ;DISPLAY IT
N52:CP 0C9H  ;"RET"?
JR NZ,N55  ;JUMP IF NOT
LD HL,RETTX ;DISPLAY "RET"
LD A,9  ;SET PC MOD FLAG
LD (JPFLAG),A
JP W0
N55:CP 0DBH  ;"IN A,N"?
JR NZ,N56  ;JUMP IF NOT
LD HL,INAN  ;DISPLAY "IN A,"
CALL W0
CALL INCHL  ;POINT TO NUMBER
CALL SHEX  ;DISPLAY IT
LD A,29H  ;DISPLAY A ")"
JP BYTOUT
N56:CP 0D3H  ;"OUT (N),A"?
JR NZ,N58  ;JUMP IF NOT
LD HL,OUTNA ;DISPLAY "OUT ("
CALL W0
CALL INCHL  ;POINT TO NUMBER
CALL SHEX  ;DISPLAY IT
LD HL,PA  ;DISPLAY "),A"
JP WRT
N58:CP 0CEH  ;"ADC A,N"?
JR NZ,N59  ;JUMP IF NOT
LD HL,ADCA  ;DISPLAY "ADC A,"
JR N63A  ;GO DISPLAY IT
N59:CP 0D6H  ;"SUB N"?
JR NZ,N62  ;JUMP IF NOT
LD HL,SUBTX ;DISPLAY "SUB"
JR N63A  ;GO DISPLAY IT
N62:CP 0DEH  ;"SBC A,N"?
JR NZ,N63  ;JUMP IF NOT
LD HL,SBCA  ;POINT TO "SBC A,"
JR N63A  ;GO DISPLAY IT
N63:CP 0E6H  ;"AND N"?
JR NZ,N66  ;JUMP IF NOT
LD HL,ANDTX ;POINT TO "AND"
N63A:CALL W0  ;DISPLAY THE TEXT
CALL INCHL  ;POINT TO THE NUMBER
JP SHEX  ;DISPLAY IT
N66:CP 0F6H  ;"OR N"?
JR NZ,N67  ;JUMP IF NOT
LD HL,ORTX  ;POINT TO "OR"
JR N63A  ;GO DISPLAY IT
N67:CP 0EEH  ;"XOR N"?
JR NZ,N70  ;JUMP IF NOT
LD HL,XORTX ;POINT TO "XOR"
JR N63A  ;GO DISPLAY IT
N70:CP 0FEH  ;"CP N" ?
JR NZ,N01  ;JUMP IF NOT
LD HL,CPTX  ;POINT TO "CP"
JR N63A  ;GO DISPLAY IT
N01:AND 199  ;MASK OUT BITS
CP 6  ;"LD R,N"?
JR NZ,N24  ;JUMP IF NOT
LD HL,LDTXT ;DISPLAY "LD"
CALL W0
CALL REGXT  ;DISPLAY THE REGISTER
CALL COMMA  ;DISPLAY A COMMA
CALL INCHL  ;POINT TO THE NUMBER
JP SHEX  ;DISPLAY IT
N24:CP 4  ;"INC R"?
JR NZ,N42  ;JUMP IF NOT
LD HL,INCTX ;DISPLAY "INC"
CALL W0
JP REGXT  ;DISPLAY THE REGISTER
N42:CP 194  ;"JP CC,NN"?
JR NZ,N51  ;JUMP IF NOT
LD A,2  ;SET PC MOD FLAG
LD (JPFLAG),A
LD HL,JPTX  ;DISPLAY "JP"
CALL W0
CALL CONEXT  ;DISPLAY THE CONDITION CODE
CALL COMMA  ;DISPLAY A COMMA
JP N41A  ;GO DISPLAY THE ADDRESS
N51:CP 196  ;"CALL CC,NN"?
JR NZ,N53  ;JUMP IF NOT
LD HL,CALLTX ;DISPLAY "CALL"
LD A,8  ;SET PC MOD FLAG
LD (JPFLAG),A
CALL W0
CALL CONEXT  ;DISPLAY THE CONDITION CODE
CALL COMMA  ;DISPLAY A COMMA
JP N50A  ;GO DISPLAY THE ADDRESS
N53:CP 192  ;"RET CC"?
JR NZ,N54  ;JUMP IF NOT
LD HL,RETTX ;DISPLAY "RET"
LD A,10  ;SET PC MOD FLAG
LD (JPFLAG),A
CALL W0
JP CONEXT  ;DISPLAY THE CONDITION CODE
N54:CP 199  ;"RST Q" ?
JR NZ,N71  ;JUMP IF NOT
LD A,11  ;SET PC MOD FLAG
LD (JPFLAG),A
LD HL,RSTTX ;DISPLAY "RST"
CALL W0
LD HL,(STDIS) ;GET INSTR. ADDRESS
LD A,(HL)  ;GET THE STARTING BYTE
AND 56  ;MASK OUT THE ADDRESS
JP SHEX2  ;DISPLAY IT
N71:CP 5  ;"DEC R"?
JR NZ,N11  ;JUMP IF NOT
LD HL,DECTX ;DISPLAY "DEC"
CALL W0
JP REGXT  ;DISPLAY THE REGISTER
N11:LD A,(HL)  ;GET THE STARTING BYTE
AND 207  ;MASK OUT SOME BITS
CP 1  ;"LD DD,NN"?
JR NZ,N15  ;JUMP IF NOT
LD HL,LDTXT ;DISPLAY "LD"
CALL W0
CALL PEXT  ;DISPLAY THE REGISTER
CALL INCHL  ;POINT TO THE ADDRESS
CALL COMMA  ;DISPLAY A COMMA
JP THEX  ;DISPLAY THE ADDRESS
N15:CP 197  ;"PUSH DD"?
JR NZ,N16  ;JUMP IF NOT
LD HL,PUSHTX ;DISPLAY "PUSH"
JR N16A
RET
N16:CP 193  ;"POP DD"?
JR NZ,N21  ;JUMP IF NOT
LD HL,POPTX ;POINT TO "POP"
N16A:CALL W0  ;DISPLAY THE TEXT
JP QEXT  ;DISPLAY THE REGISTER
N21:LD A,(HL)  ;GET THE STARTING BYTE
AND 248  ;MASK OUT SOME BITS
CP 128  ;"ADD A,R"?
JR NZ,N57  ;JUMP IF NOT
LD HL,ADDA  ;DISPLAY "ADD A,"
CALL W0
JP RGEXT  ;DISPLAY THE REGISTER
N57:CP 136  ;"ADC A,R"?
JR NZ,N60  ;JUMP IF NOT
LD HL,ADCA  ;DISPLAY "ADC A,"
JR N64A  ;GO DO IT
N60:CP 144  ;"SUB R"?
JR NZ,N61  ;JUMP IF NOT
LD HL,SUBTX ;POINT TO "SUB"
JR N64A  ;GO DISPLAY IT
N61:CP 152  ;"SBC A,R"?
JR NZ,N64  ;JUMP IF NOT
LD HL,SBCA  ;POINT TO "SBC A,"
JR N64A  ;GO DISPLAY IT
N64:CP 160  ;"AND R"?
JR NZ,N65  ;JUMP IF NOT
LD HL,ANDTX ;POINT TO "AND"
N64A:CALL W0  ;DISPLAY THE TEXT
JP RGEXT  ;DISPLAY THE REGISTER
N65:CP 176  ;"OR R"?
JR NZ,N68  ;JUMP IF NOT
LD HL,ORTX  ;POINT TO "OR"
JR N64A  ;GO DISPLAY IT
N68:CP 168  ;"XOR R"?
JR NZ,N69  ;JUMP IF NOT
LD HL,XORTX ;POINT TO "XOR"
JR N64A  ;GO DISPLAY IT
N69:CP 184  ;"CP R"?
JR NZ,N34  ;JUMP IF NOT
LD HL,CPTX  ;POINT TO "CP"
JR N64A  ;GO DISPLAY IT
N34:LD A,(HL)  ;GET THE STARTING BYTE
AND 207  ;MASK OUT SOME BITS
CP 9  ;"ADD HL,DD"?
JR NZ,N35  ;JUMP IF NOT
LD HL,ADTX  ;DISPLAY "ADD"
CALL W0
CALL HIXIY  ;DISPLAY "HL/IX/IY"
CALL COMMA  ;DISPLAY A COMMA
JP PEXT  ;DISPLAY THE REGISTER
N34A:CALL W0  ;DISPLAY THE TEXT
JP PEXT  ;DISPLAY THE REGISTER
N35:CP 3  ;"INC DD"?
JR NZ,N36  ;JUMP IF NOT
LD HL,INCTX ;POINT TO "INC"
JR N34A  ;GO DISPLAY IT
N36:CP 11  ;"DEC DD"?
JR NZ,N72  ;JUMP IF NOT
LD HL,DECTX ;POINT TO "DEC"
JR N34A  ;GO DISPLAY IT
N72:LD A,(HL)  ;GET THE STARTING BYTE
CP 0CBH  ;"CB" TYPE INSTRUCTION?
JP NZ,EDSTUF ;JUMP IF NOT
CALL INCHL  ;POINT TO NEXT BYTE
LD A,(TYPE) ;"IX/IY" INSTRUCTION?
OR A
CALL NZ,INCHL ;POINT TO NEXT BYTE IF SO
LD A,(HL)  ;GET THE STARTING BYTE
AND 248  ;MASK OUT SOME BITS
JR NZ,N73  ;JUMP IF NOT "RLC"
LD HL,RLCTX ;POINT TO "RLC"
JR N76A  ;GO DISPLAY IT
N73:CP 16  ;"RL R"?
JR NZ,N74  ;JUMP IF NOT
LD HL,RLTX  ;POINT TO "RL"
JR N76A  ;GO DISPLAY IT
N74:CP 8  ;"RRC R"?
JR NZ,N75  ;JUMP IF NOT
LD HL,RRCTX ;POINT TO "RRC"
JR N76A  ;GO DISPLAY IT
N75:CP 24  ;"RR R"?
JR NZ,N76  ;JUMP IF NOT
LD HL,RRTX  ;POINT TO "RR"
JR N76A  ;GO DISPLAY IT
N76:CP 32  ;"SLA R"?
JR NZ,N77  ;JUMP IF NOT
LD HL,SLATX ;POINT TO "SLA"
N76A:CALL W0  ;DISPLAY THE TEXT
LD A,(TYPE) ;GET THE "IX/IY" FLAG
OR A
JP Z,RGEXT  ;JUMP IF NOT "IX/IY"
N76B:LD HL,(STDIS)  ;GET INSTRUCTION BYTE
LD A,(HL)  ;GET ACTUAL INSTRUCTION
AND 7  ;MASK OUT HIGH BITS
CP 6  ;IS OPERAND (HL)
JR Z,N76C  ;GO IF SO
CALL RPRNT  ;DISPLAY REGISTER
CALL COMMA  ;DISPLAY COMMA
N76C:CALL TDEC  ;BACK UP TWO BYTES
CALL RIXIY  ;DISPLAY THE REGISTER
JP INCHL  ;CONTINUE ON
N77:CP 40  ;"SRA R"?
JR NZ,N77A  ;JUMP IF NOT
LD HL,SRATX ;POINT TO "SRA"
JR N76A  ;GO DISPLAY IT
N77A:CP 48  ;"SLS R"?
JR NZ,N78  ;JUMP IF NOT
LD HL,SLSTX  ;POINT TO "SLS"
JR N76  ;GO DISPLAY IT
N78:CP 56  ;"SRL R"?
JR NZ,N79  ;JUMP IF NOT
LD HL,SRLTX ;POINT TO "SRL"
JR N76A  ;GO DISPLAY IT
N79:LD A,(HL)  ;GET THE STARTING BYTE
AND 192  ;MASK OUT SOME BITS
CP 64  ;"BIT N,R"?
JR NZ,N80  ;JUMP IF NOT
LD HL,BITTX ;POINT TO "BIT"
CALL W0  ;DISPLAY THE TEXT
CALL BEXT  ;DISPLAY THE BIT
LD A,(TYPE) ;"IX" OR "IY"?
OR A
JP Z,RGEXT  ;DISPLAY THE REGISTER
JR N76C  ;GO DISPLAY "(IX+D)"
N80:CP 192  ;"SET N,R"?
JR NZ,N81  ;JUMP IF NOT
LD HL,SETTX ;POINT TO "SET"
N80A:CALL W0  ;DISPLAY THE TEXT
CALL BEXT  ;DISPLAY THE REGISTER
LD A,(TYPE) ;GET "IX/IY" FLAG
OR A
JP Z,RGEXT  ;JUMP IF NOT "IX/IY"
JR N76B
N81:CP 128  ;"RES B,R"?
JP NZ,NOFIND ;JUMP IF NOT
LD HL,RESTX ;POINT TO "RES"
JR N80A  ;GO DISPLAY IT
EDSTUF:LD A,(TYPE) ;GET THE "IX/IY" FLAG
OR A
JR Z,EDS10  ;JUMP IF NOT "IX/IY"
LD A,(HL)  ;GET THE INSTRUCTION BYTE
CP 0F9H  ;"LD SP,IX" OR "LD SP,IY"?
JR NZ,IXS10 ;JUMP IF NOT
LD HL,SPTX  ;POINT TO "LD SP,"
JR IXS20  ;GO DISPLAY IT
IXS10:CP 0E3H  ;"EX (SP),IX/IY"?
JP NZ,NOFIND ;JUMP IF NOT
LD HL,EXSP  ;POINT TO "EX (SP),"
IXS20:CALL W0  ;DISPLAY THE TEXT
JP IXIY  ;DISPLAY "IX" OR "IY"
EDS10:LD A,(HL)  ;GET THE INSTRUCTION BYTE
CP 0EDH  ;IS THIS AN "ED" INSTRUCTION?
JP NZ,NOFIND ;JUMP IF NOT
CALL INCHL  ;POINT TO NEXT BYTE
LD A,(HL)  ;GET THE BYTE
LD HL,EDTBL ;POINT TO THE 2 BYTE "ED"
;INSTRUCTION TABLE
LD B,28  ;NUMBER TO CHECK
LD DE,EDTXT ;POINT TO THE 2 BYTE "ED"
;INSTRUCTION DESCRIPTION TEXT
CALL MST  ;GO CHECK FOR A MATCH
RET Z  ;RETURN IF A MATCH WAS MADE
LD A,(HL)  ;GET THE STARTING BYTE
AND 207  ;MASK OUT SOME BITS
CP 75  ;"LD DD,(NN)"?
JR NZ,E05  ;JUMP IF NOT
LD HL,LDTXT ;DISPLAY "LD"
CALL W0
CALL PEXT  ;DISPLAY THE REGISTER
CALL COMMA  ;DISPLAY A COMMA
CALL INCHL  ;POINT TO THE ADDRESS
JP RHEX  ;GO DISPLAY IT
E05:CP 67  ;"LD (NN),DD"?
JR NZ,E18  ;JUMP IF NOT
LD HL,LDTXT ;DISPLAY "LD"
CALL W0
CALL INCHL  ;POINT TO THE ADDRESS
CALL RHEX  ;DISPLAY IT
CALL TDEC  ;POINT BACK TO THE REGISTER
CALL COMMA  ;DISPLAY A COMMA
CALL PEXT  ;DISPLAY THE REGISTER
CALL INCHL  ;SKIP AHEAD
JP INCHL
E18:LD A,(HL)  ;GET THE STARTING BYTE
AND 207  ;MASK OUT SOME BITS
CP 74  ;"ADC HL,DD"?
JR NZ,E19  ;JUMP IF NOT
LD HL,ADCHL ;POINT TO "ADC HL,"
JR E19A  ;GO DISPLAY IT
E19:CP 66  ;"SBC HL,DD"?
JR NZ,E22  ;JUMP IF NOT
LD HL,SBCHL ;POINT TO "SBC HL,"
E19A:CALL W0  ;DISPLAY THE TEXT
JP PEXT  ;DISPLAY THE REGISTER
E22:LD A,(HL)  ;GET THE INSTRUCTION BYTE
CP 4DH  ;"RETI"?
JR NZ,E23  ;JUMP IF NOT
LD HL,RETITX ;POINT TO "RETI"
E22A:LD A,9  ;SET THE PC MOD FLAG
LD (JPFLAG),A
JP W0  ;DISPLAY THE TEXT
E23:CP 45H  ;"RETN"?
JR NZ,E25  ;JUMP IF NOT
LD HL,RETNTX ;POINT TO "RETN"
JR E22A  ;GO DISPLAY IT
E25:AND 199  ;MASK OUT SOME BITS
CP 64  ;"IN R,(C)"?
JR NZ,E29  ;JUMP IF NOT
LD HL,INTX  ;DISPLAY "IN"
CALL W0
CALL REGXT  ;DISPLAY THE REGISTER
CALL COMMA  ;DISPLAY A COMMA
LD HL,RC  ;DISPLAY "(C)"
JP WRT
E29:LD A,(HL)  ;GET THE INSTRUCTION BYTE
AND 199  ;MASK OUT SOME BITS
CP 65  ;"OUT (C),R"?
JP NZ,NOFIND ;JUMP IF NOT
LD HL,OUTTX ;DISPLAY "OUT (C),"
CALL W0
JP REGXT  ;DISPLAY THE REGISTER
;
;THIS ROUTINE WRITES A MESSAGE TERMINATED WITH A
;0DH OR 03H BYTE TO THE SCREEN, PRINTER, DISK OR
;TAPE.  THE "WO" ROUTINE DISPLAYS A TAB CHARACTER (09)
;BEFORE DISPLAYING ANY TEXT.  THE "WRT" ROUTINE
;SIMPLY WRITES THE TEXT OUT.
;
W0:DEC HL  ;POINT BACK ONE BYTE
LD A,(ARTN) ;DISASSEMBLING TO DISK/TAPE?
OR A
JR NZ,TBDSK ;JUMP IF SO
LD A,(PRINT) ;DISPLAYING?
OR A
RET Z  ;RETURN IF NOT
JR WAZA  ;GO DO A TAB
WRT:LD A,(ARTN) ;DISASSEMBLING TO DISK/TAPE?
OR A
JR NZ,WRITE ;JUMP IF SO
LD A,(PRINT) ;DISPLAYING?
OR A
RET Z  ;RETURN IF NOT DISPLAYING
WRITE:LD A,(HL)  ;GET A BYTE
CP 03  ;END OF TEXT?
RET Z  ;RETURN IF SO
CP 09  ;TAB CHARACTER?
JR NZ,W01  ;JUMP IF NOT A TAB
LD A,(ARTN) ;DISASSEMBLING TO DISK/TAPE?
OR A
JR Z,WAZA  ;JUMP IF NOT
TBDSK:LD A,9  ;WRITE OUT A TAB CHARACTER
CALL BTD
JR W02  ;CONTINUE ON
WAZA:CALL WAZ  ;TAB OVER BY DISPLAYING SPACES
JR W02  ;CONTINUE ON
WAZ:PUSH HL  ;SAVE POINTER
LD B,4  ;FUNCTION #4 OF
LD A,15  ;SVC #15
RST 28H  ;DO SVC
LD A,L  ;GET COL #
LD B,A  ;SAVE IN B
AND 120  ;MASK OUT FOR COLUMNS OF 8
OR A  ;CURSOR LESS THAN COLUMN 8?
JR NZ,W04  ;JUMP IF NOT
ADD A,16  ;TAB OVER 16 CHARACTERS
JR W05  ;GO DO IT
W04:ADD A,8  ;TAB OVER 8 CHARACTERS
W05:SUB B  ;NUMBER OF SPACES TO WRITE
LD B,A  ;SAVE IN B
TB1:CALL SPCD  ;DO A SPACE
DJNZ TB1  ;DO ANOTHER?
POP HL  ;RETURN POINTER
RET
W01:LD A,(HL)  ;GET THE CHARACTER
CALL BYTOUT  ;DISPLAY IT
W02:INC HL  ;POINT TO THE NEXT ONE
CP 0DH  ;END OF TEXT?
RET Z  ;RETURN IF SO
JR WRITE  ;GO DO ANOTHER IF NOT DONE
BYTOUT:PUSH AF  ;SAVE CHARACTER TO DISPLAY
LD A,(ARTN) ;DISASS. TO DISK/TAPE?
OR A
JR Z,BT1A  ;JUMP IF NOT
POP AF  ;RESTORE THE CHARACTER
JP BTD  ;WRITE IT OUT
BT1A:LD A,(PRINT) ;DISPLAYING?
OR A
JR NZ,BT1  ;JUMP IF DISPLAYING
BT2:POP AF  ;RESTORE THE CHARACTER
RET
BT1:POP AF  ;RESTORE THE CHARACTER
CALL WR  ;DISPLAY IT
PUSH AF  ;SAVE IT AGAIN
LD A,(PFG)  ;ECHOING TO PRINTER?
OR A
JR Z,BT2  ;JUMP IF NOT ECHOING
POP AF  ;RESTORE THE CHARACTER
JP PNTIT  ;GO PRINT IT
;
;ROUTINES RPRNT & REGPRT WILL DISPLAY A REGISTER
;NAME.  FOR RPRNT, THE FOLLOWING CODES ARE USED:
;0=B, 1=C, 2=D, 3=E, 4=H, 5=L, 6=(HL), 7=A
;REGPRT IS THE SAME EXCEPT 4=HX OR HY, 5=LX OR
;LY (USED TO DISPLAY "UNDOCUMENTED" INSTRUCTIONS).
;
RPRNT:CP 4  ;IS REGISTER B,C,D OR E?
JR C,BCDE  ;GO IF SO
JR NZ,NOTH  ;GO IF NOT H
LD A,'H'  ;"H" CHARACTER IN A REG.
JR BYTOUT  ;GO OUTPUT IT
NOTH:CP 5  ;IS REGISTER L?
JR NZ,ITSHLA ;GO IF NOT L
LD A,'L'  ;"L" CHARACTER IN A REG.
JR BYTOUT  ;GO OUTPUT IT
REGPRT:CP 4  ;IS REGISTER B,C,D, OR E?
JR NC,ITSHLA ;GO IF NOT
BCDE:ADD A,'B'  ;CHANGE TO ASCII CHAR.
JR BYTOUT  ;GO OUTPUT IT
ITSHLA:CP 7  ;IS REGISTER A?
JR C,NOTA  ;GO IF NOT
LD A,'A'  ;CHANGE TO ASCII CHAR.
JR BYTOUT  ;GO OUTPUT IT
NOTA:CP 5  ;IS REG. H, L, OR (HL)?
JR Z,ITSL  ;GO IF L
JR NC,ITSHL ;GO IF (HL)
LD A,'H'  ;CHANGE TO ASCII CHAR.
JR DSPHL  ;GO OUTPUT IT
ITSL:LD A,'L'  ;LOAD A WITH ASCII "L"
DSPHL:CALL BYTOUT  ;OUTPUT "H" OR "L"
LD A,(TYPE2) ;PART OF "UNDOCUMENTED"
CP 0DDH  ;INSTRUCTION?
RET C  ;GO IF NORMAL INSTRUCTION
LD A,'X'  ;LOAD A WITH ASCII "X"
JR Z,BYTOUT ;DISPLAY IF PART"HX"/"LX"
INC A  ;A CONTAINS ASCII "Y"
JR BYTOUT  ;DISPLAY-PRT OF "HY"/"IY"
ITSHL:LD A,(TYPE) ;GET THE "IX/IY" FLAG
OR A
JP NZ,RIXIY ;DISPLAY "(IX/IY+D)" IF SET
LD HL,RHL  ;DISPLAY "(HL)"
JP WRT
;
;THIS ROUTINE MASKS OUT REGISTER NAMES
;
REGXT:LD HL,(STDIS) ;GET THE INSTRUCTION ADDRESS
LD A,(HL)  ;GET THE INSTRUCTION BYTE
REGXTA:AND 56  ;MASK OUT THE REGISTER
SRL A  ;MAKE IT A 0-7 VALUE
SRL A
SRL A
JP REGPRT  ;GO DISPLAY IT
;
;THIS ROUTINE MASKS OUT AND DISPLAYS REGISTER NAMES
;
RGEXT:LD HL,(STDIS) ;GET THE INSTRUCTION ADDRESS
LD A,(HL)  ;GET THE INSTRUCTION BYTE
RGEXTA:AND 7  ;MASK IT OUT
JR REGPRT  ;GO DISPLAY IT
;
;THIS ROUTINE INCREMENTS THE INSTRUCTION ADDRESS
;POINTER
;
INCHL:LD HL,(STDIS) ;GET THE INSTRUCTION ADDRESS
INC HL  ;INCREMENT IT
LD (STDIS),HL ;SAVE IT
RET
;
;THIS ROUTINE OUTPUTS THE "A" REGISTER IN HEX
;
SHEX:LD HL,(STDIS) ;GET THE INSTRUCTION ADDRESS
SHEX1:LD A,(HL)  ;GET THE INSTRUCTION BYTE
SHEX2:PUSH AF  ;SAVE IT
LD A,(ARTN) ;DISASSEMBLING TO DISK/TAPE?
OR A
JP NZ,DWD5  ;JUMP IF OUTPUTTING
POP AF  ;RESTORE THE BYTE
SHEX3:PUSH AF  ;SAVE IT AGAIN
SRL A  ;GET THE MOST SIGNIFICANT NIBBLE
SRL A
SRL A
SRL A
CALL HEXIT  ;MAKE IT A HEX DIGIT
POP AF  ;RESTORE THE BYTE
AND 15  ;MASK OUT THE LEAST
;SIGNIFICANT NIBBLE
HEXIT:ADD A,90H  ;CONVERT HEXADECIMAL
DAA   ;TO DISPLAYABLE
ADC A,40H  ;ASCII
DAA
S01:JP BYTOUT  ;DISPLAY IT
;
;THIS ROUTINE DISPLAYS PARENTHESIS AROUND THE HEX
;VALUE OF THE HL REGISTER PAIR.
;
RHEX:LD A,'('  ;DISPLAY A "("
CALL BYTOUT
CALL THEX  ;DISPLAY (HL)
LD A,29H  ;DISPLAY A ")"
JP BYTOUT
;
;THIS ROUTINE WRITES OUT (HL) IN HEX
;
THEX:LD A,(HRTN) ;GENERATING A SYMBOL TABLE?
OR A
JP NZ,BL1  ;JUMP IF GENERATING
LD A,(ARTN) ;DISASS. TO DISK/TAPE?
OR A
JP NZ,BL2  ;JUMP IF SO
INC HL  ;POINT TO MSB
CALL SHEX1  ;DISPLAY IT
DEC HL  ;POINT TO LSB
CALL SHEX1  ;DISPLAY IT
JP INCHL  ;POINT BACK TO MSB
;
;
;THIS ROUTINE WILL DISPLAY AN "HL" OR "IX" OR "IY"
;DEPENDING ON THE STATUS OF THE "IX/IY" FLAG "(TYPE)"
;
HIXIY:LD B,0  ;POINT TO "HL" TEXT
LD C,4
LD HL,REG2  ;POINT TO REGISTER NAMES
JP NS40  ;GO DISPLAY IT
;
;MASK OUT BITS AND DISPLAY A 16 BIT REGISTER NAME
;
PEXT:LD HL,(STDIS) ;GET INSTRUCTION ADDRESS
LD A,(HL)  ;GET INSTRUCTION BYTE
AND 48  ;MASK OUT THE REGISTER NAME
SRL A  ;MAKE IT A 0-3
SRL A
SRL A
LD C,A  ;SET UP FOR A TABLE LOOK UP
LD B,0
LD HL,REG3  ;POINT TO REGISTER NAMES
SS10:CP 4  ;"HL" REGISTER NAME?
JR Z,NS40  ;JUMP IF SO
S02:ADD HL,BC  ;POINT TO THE REGISTER NAME
LD A,(HL)  ;GET THE 1ST CHARACTER
CALL BYTOUT  ;DISPLAY IT
INC HL  ;POINT TO THE 2ND CHARACTER
LD A,(HL)  ;GET THE 2ND CHARACTER
JP BYTOUT  ;DISPLAY IT
NS40:LD A,(TYPE) ;GET THE "IX/IY" FLAG
OR A
JR Z,S02  ;JUMP IF NOT "IX/IY"
JP IXIY  ;JUMP IF "IX/IY"
;
;THIS ROUTINE MASKS OUT BITS AND DISPLAYS 16 BIT
;REGISTER NAMES
;
QEXT:LD HL,(STDIS) ;GET INSTRUCTION ADDRESS
LD A,(HL)  ;GET INSTRUCTION BYTE
AND 48  ;MASK OUT SOME BITS
SRL A  ;MAKE IT A 0-3
SRL A
SRL A
LD C,A  ;SET UP FOR TABLE LOOK UP
LD B,0
LD HL,REG2  ;POINT TO REGISTER NAME TABLE
JR SS10  ;GO DISPLAY IT
;
;THIS ROUTINE DISPLAYS THE CONDITION CODES (Z, PO, ETC.)
;
CONEXT:LD HL,(STDIS) ;GET INSTRUCTION ADDRESS
LD A,(HL)  ;GET INSTRUCTION BYTE
AND 56  ;MASK OUT THE CONDITION
SRL A  ;MAKE IT A 0-8
SRL A
LD C,A  ;SET UP FOR TABLE LOOK UP
LD B,0
LD HL,CC  ;POINT TO CONDITION NAMES
JR S02  ;GO DISPLAY IT
;
;THIS ROUTINE EXTRACTS AND DISPLAYS THE BIT NUMBER
;OF A "SET", "RES" OR "BIT" INSTRUCTION
;
BEXT:LD HL,(STDIS) ;GET INSTRUCTION ADDRESS
LD A,(HL)  ;GET INSTRUCTION BYTE
AND 56  ;MASK OUT THE BIT
SRL A  ;MAKE IT A 0-7
SRL A
SRL A
ADD A,30H  ;MAKE IT ASCII
CALL BYTOUT  ;DISPLAY THE BIT NUMBER
JP COMMA  ;DISPLAY A COMMA
;
;THIS ROUTINE COMPUTES THE ABSOLUTE ADDRESS OF A
;RELATIVE JUMP
;
JRADD:LD HL,(STDIS) ;GET INSTRUCTION ADDRESS
LD A,(HL)  ;GET INSTRUCTION BYTE
LD C,A  ;SET UP TO ADD IT
LD B,0
INC BC  ;FIX THE "E-2" METHOD OF
;STORING THE INDEX VALUE
LD A,C
BIT 7,A  ;JUMPING BACKWARDS?
JR Z,JA1  ;JUMP IF NOT
DEC H  ;BACK UP 256 BYTES
JA1:ADD HL,BC  ;COMPUTE THE ADDRESS
JP REGHEX  ;GO DISPLAY IT
;
;THIS ROUTINE SUBTRACTS TWO FROM THE INSTRUCTION
;ADDRESS
;
TDEC:LD HL,(STDIS) ;GET THE INSTRUCTION ADDRESS
DEC HL  ;BACK UP TWO
DEC HL
LD (STDIS),HL ;SAVE IT
RET
;
;THIS ROUTINE DISPLAYS AN "(IX+D)" OR "(IY+D)"
;
RIXIY:LD A,'('  ;DISPLAY A "("
CALL BYTOUT
LD A,(TYPE) ;GET "IX/IY" FLAG
CP 0DDH  ;"IX"?
LD HL,IXPL  ;POINT TO "IX+" TEXT
JR Z,IY2  ;JUMP IF "IX"
IY1:LD HL,IYPL  ;POINT TO "IY+"
IY2:CALL WRT  ;DISPLAY THE TEXT
CALL INCHL  ;INCREMENT INSTRUCTION ADDRESS
CALL SHEX  ;DISPLAY THE BYTE
LD A,29H  ;DISPLAY A ")"
JP BYTOUT
;
;THIS ROUTINE DISPLAYS AN "IX" OR "IY"
;
IXIY:LD A,(TYPE) ;GET THE "IX/IY" FLAG
CP 0DDH  ;"IX"?
LD HL,IXTX  ;POINT TO "IX"
JR Z,IY4  ;JUMP IF "IX"
LD HL,IYTX  ;POINT TO "IY"
IY4:JP WRT  ;DISPLAY THE TEXT
;
;THIS ROUTINE WRITES OUT HL IN HEX
;
REGHEX:LD A,(ARTN) ;DISASS. TO DISK/TAPE?
OR A
JP NZ,DWD2  ;JUMP IF SO
LD A,(HRTN) ;GENERATING A SYMBOL TABLE?
OR A
JP NZ,BTBL  ;JUMP IF SO
RHDSK:LD A,H  ;GET THE MSB
SRL A  ;GET THE MOST SIGNIFICANT NIBBLE
SRL A
SRL A
SRL A
CALL HEXIT  ;MAKE IT ASCII AND DISPLAY
LD A,H  ;GET MSB AGAIN
AND 15  ;MASK OUT LEAST SIGNIFICANT NIBBLE
CALL HEXIT  ;MAKE IT ASCII AND DISPLAY
LD A,L  ;GET LSB
SRL A  ;MASK OUT MOST SIGNIFICANT NIBBLE
SRL A
SRL A
SRL A
CALL HEXIT  ;MAKE IT ASCII AND DISPLAY
LD A,L  ;GET LSB AGAIN
AND 15  ;MASK OUT LEAST SIGNIFICANT NIBBLE
JP HEXIT  ;MAKE IT ASCII AND DISPLAY
;
;THIS ROUTINE DECREMENTS THE INSTRUCTION ADDRESS
;
DECHL:LD HL,(STDIS) ;GET INSTRUCTION ADDRESS
DEC HL  ;DECREMENT IT
LD (STDIS),HL ;SAVE IT
RET
;
;THIS ROUTINE DISPLAYS A COMMA
;
COMMA:LD A,2CH  ;DISPLAY A COMMA
JP BYTOUT
;
;THIS ROUTINE DISPLAYS A SPACE
;
SPC:LD A,32  ;GET A SPACE
JP WR  ;DISPLAY IT
;
;THIS ROUTINE DISPLAYS A SPACE AND ECHOS TO THE
;PRINTER
;
SPCD:LD A,(ARTN) ;DISASS. TO DISK/TAPE?
OR A
JR NZ,SPCD1 ;JUMP IF SO
LD A,(PRINT) ;DISPLAYING?
OR A
RET Z  ;RETURN IF NOT DISPLAYING
SPCD1:LD A,32  ;GET A SPACE
CALL WR  ;DISPLAY IT
LD A,(PFG)  ;ECHOING TO PRINTER?
OR A
RET Z  ;RETURN IF NOT ECHOING
LD A,32  ;GET A SPACE
JP PNTIT  ;PRINT IT
;
;THIS IS THE BAD CODE ROUTINE FROM THE DISASSEMBLER.
;BAD CODE IS DISPLAYED AS A "DEFB H" WHERE "H" IS THE
;OFFENDING BYTE.
;
NOFIND:LD A,1  ;SET BAD CODE FLAG
LD (BDCODE),A
LD HL,(S1)  ;GET ORIGINAL INSTRUCTION
;ADDRESS
LD (STDIS),HL ;SAVE IT
LD HL,NOINST ;POINT TO "DEFB" TEXT
CALL W0  ;DISPLAY IT
JP SHEX
;
;THIS ROUTINE WILL SEARCH A TABLE POINTED TO BY HL
;FOR THE VALUE IN THE A REGISTER A MAXIMUM NUMBER OF
;TIMES HELD IN THE B REGISTER.  IF A MATCH IS FOUND
;THE TEXT POINTED TO BY THE DE REGISTER IS DISPLAYED.
;
MST:LD C,B  ;SAVE THE MAXIMUM COUNT
MTEST:CP (HL)  ;DOES IT MATCH?
JR Z,ME01  ;JUMP IF SO
INC HL  ;POINT TO NEXT ONE
DJNZ MTEST  ;DONE?
LD HL,(STDIS) ;GET INSTRUCTION ADDRESS
LD A,1  ;CLEAR THE "Z" FLAG
OR A
RET
ME01:LD A,C  ;FIND WHICH NUMBER IN THE
;LIST THE MATCH WAS
SUB B
INC A
EX DE,HL  ;PUT TEXT LOCATION IN HL
LD E,A  ;SAVE MATCH NUMBER IN E
LD A,3  ;SEARCH FOR A "3"
LD BC,0  ;SEARCH THROUGH 65536 BYTES
ME02:CPIR   ;FIND A "03" BYTE
DEC E  ;REACHED THE TEXT YET?
JR NZ,ME02  ;DO ANOTHER IF NOT
CALL W0  ;DISPLAY THE TEXT
LD HL,(STDIS) ;GET INSTRUCTION ADDRESS
XOR A  ;SET THE "Z" FLAG
RET
                                       